/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.changecase.DimScope;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Triple;

public class InvChangeCaseEntryService {
    public static final String ENTITY_NAME = "bcm_invchangecaseentry";
    Map<Long, Set<Pair<Long, String>>> caseScenarioCache;
    private static final String SYSTEM_TYPE = "fi-bcm-business";
    public static final String INV_CHANGE_CASE = "invchangecase";
    public static final String SORT = "sort";
    public static final String COMPUTE_TYPE = "computetype";
    public static final String IS_SINGLE_MAP_ENTRY = "issinglemapentry";
    public static final String IS_SRC = "issrc";
    public static final String CASE_ID = "invchangecase.id";
    public static final String MEM_ID = "membid";
    public static final String DIM_ID = "dimid";
    public static final String SELECT_PROPERTIES = "invchangecase,computetype,sort,issinglemapentry,issinglemapentry.membid,issinglemapentry.dimid,issinglemapentry.dimnumber,issinglemapentry.memnumber,issinglemapentry.issrc";

    public InvChangeCaseEntryService(Map<Long, Set<Pair<Long, String>>> caseScenarioCache) {
        this.caseScenarioCache = caseScenarioCache;
    }

    public StringJoiner enableCheck(Set<Long> checkCaseIds, Set<Long> ableCaseIds, Map<Long, Map<Long, List<DimScope>>> case2Scope, Map<Long, DynamicObject> dimId2Dy) {
        List dimIds;
        HashSet<Long> allCaseIds = new HashSet<Long>(checkCaseIds.size() + ableCaseIds.size());
        allCaseIds.addAll(checkCaseIds);
        allCaseIds.addAll(ableCaseIds);
        QFBuilder qfBuilder = new QFBuilder(INV_CHANGE_CASE, "in", allCaseIds);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])qfBuilder.toArray(), (String)SORT);
        HashMap<Long, DynamicObject> id2Dim = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        HashMap<Long, List<Long>> case2Dim = new HashMap<Long, List<Long>>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong("id");
            id2Dim.put(id, dynamicObject);
            dimIds = case2Dim.computeIfAbsent(dynamicObject.getLong(CASE_ID), v -> new ArrayList());
            dimIds.add(id);
        }
        Map<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> dataModel = this.buildData(dynamicObjects, case2Scope, dimId2Dy);
        if (!dataModel.keySet().containsAll(checkCaseIds)) {
            return new StringJoiner("\n\r").add(ResManager.loadKDString((String)"\u5c06\u542f\u7528\u7684\u65b9\u6848\u6e90\u548c\u76ee\u6807\u7ef4\u5ea6\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ef4\u5ea6\u4fe1\u606f\uff01", (String)"InvChangeCaseEntryService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        HashMap<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> ableData = new HashMap<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>>(dataModel.size() - checkCaseIds.size());
        dataModel.entrySet().stream().filter(entry -> !checkCaseIds.contains(entry.getKey())).forEach(entry -> {
            List cfr_ignored_0 = (List)ableData.put((Long)entry.getKey(), (List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>)entry.getValue());
        });
        StringJoiner msg = new StringJoiner("\n\r");
        for (Long caseId : checkCaseIds) {
            List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>> dims = dataModel.get(caseId);
            dimIds = (List)case2Dim.get(caseId);
            if (dimIds == null) continue;
            Set<Long> scenarios = this.caseScenarioCache.get(caseId).stream().map(p -> (Long)p.p1).collect(Collectors.toSet());
            DynamicObject dimDy = (DynamicObject)id2Dim.get(dimIds.get(0));
            for (Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>> dim : dims) {
                String result = this.doCheck(id2Dim, case2Dim, ableData, dimDy, dim, scenarios);
                if (!Objects.nonNull(result)) continue;
                msg.add(result);
                return msg;
            }
        }
        return msg;
    }

    private List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>> getDims(Map<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> collector, DynamicObject caseEntryDy) {
        long caseId = caseEntryDy.getLong(CASE_ID);
        return collector.computeIfAbsent(caseId, v -> new ArrayList(16));
    }

    private Map<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> buildData(DynamicObject[] caseEntryDys, Map<Long, Map<Long, List<DimScope>>> case2Scope, Map<Long, DynamicObject> dimId2Dy) {
        HashMap<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> data = new HashMap<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>>(caseEntryDys.length);
        HashBasedTable calTable = HashBasedTable.create();
        Set<Long> dimIds = dimId2Dy.keySet();
        for (DynamicObject caseEntry : caseEntryDys) {
            List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>> dims = this.getDims(data, caseEntry);
            String computeType = caseEntry.getString(COMPUTE_TYPE);
            DynamicObjectCollection dimEntry = caseEntry.getDynamicObjectCollection(IS_SINGLE_MAP_ENTRY);
            List<DynamicObject> srcEntry = dimEntry.stream().filter(e -> e.getBoolean(IS_SRC)).collect(Collectors.toList());
            HashMap srcMap = new HashMap(srcEntry.size());
            this.dimAndMem(srcEntry, (arg_0, arg_1) -> this.lambda$buildData$6((Table)calTable, dimIds, srcMap, arg_0, arg_1));
            List<DynamicObject> trgEntry = dimEntry.stream().filter(e -> !e.getBoolean(IS_SRC)).collect(Collectors.toList());
            HashMap tarMap = new HashMap(trgEntry.size());
            this.dimAndMem(trgEntry, (arg_0, arg_1) -> this.lambda$buildData$8((Table)calTable, dimIds, tarMap, arg_0, arg_1));
            Map<Long, List> scopeDim = case2Scope.getOrDefault(caseEntry.getLong(CASE_ID), Collections.emptyMap());
            scopeDim.forEach((arg_0, arg_1) -> this.lambda$buildData$10(srcMap, tarMap, (Table)calTable, dimIds, arg_0, arg_1));
            Triple triple = Triple.of((Object)computeType, srcMap, tarMap);
            dims.add((Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>)triple);
        }
        Set dimRows = calTable.rowKeySet();
        for (Long dimRow : dimRows) {
            Map rows = calTable.row((Object)dimRow);
            Set memIds = rows.keySet();
            DynamicObject dimDy = dimId2Dy.get(dimRow);
            String entryNumber = dimDy.getString("membermodel");
            DynamicObjectCollection memDys = QueryServiceHelper.query((String)entryNumber, (String)"id,longnumber", (QFilter[])new QFilter("id", "in", memIds).toArray());
            for (DynamicObject memDy : memDys) {
                long id = memDy.getLong("id");
                String longNumber = memDy.getString("longnumber");
                Set dimScopes = (Set)rows.get(id);
                dimScopes.forEach(dimScope -> dimScope.setLongNumber(longNumber));
            }
        }
        return data;
    }

    private void scope2Table(Table<Long, Long, Set<DimScope>> calTable, Set<Long> dimIds, Long dimId, DimScope dimScope) {
        if (!dimIds.contains(dimId)) {
            return;
        }
        HashSet<DimScope> dimScopes = (HashSet<DimScope>)calTable.get((Object)dimId, (Object)dimScope.getMemId());
        if (Objects.isNull(dimScopes)) {
            dimScopes = new HashSet<DimScope>(16);
        }
        dimScopes.add(dimScope);
        calTable.put((Object)dimId, (Object)dimScope.getMemId(), dimScopes);
    }

    private void dimAndMem(List<DynamicObject> entries, BiConsumer<Long, DimScope> action) {
        for (DynamicObject object : entries) {
            long dimId = object.getLong(DIM_ID);
            long memId = object.getLong(MEM_ID);
            if (dimId == 0L || memId == 0L) continue;
            action.accept(dimId, new DimScope(memId, RangeEnum.VALUE_10));
        }
    }

    private String doCheck(Map<Long, DynamicObject> id2Dim, Map<Long, List<Long>> case2Dim, Map<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> data, DynamicObject checkDy, Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>> checkingRow, Set<Long> scenarios) {
        String computeType = (String)checkingRow.getLeft();
        Map srcMap = (Map)checkingRow.getMiddle();
        Map tarMap = (Map)checkingRow.getRight();
        List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>> dims = this.getDims(data, checkDy);
        for (Map.Entry<Long, List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>>> listEntry : data.entrySet()) {
            Long caseId = listEntry.getKey();
            Set dataScenarios = this.caseScenarioCache.get(caseId).stream().map(p -> (Long)p.p1).collect(Collectors.toSet());
            List<Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>>> tripleList = listEntry.getValue();
            for (int i = 0; i < tripleList.size(); ++i) {
                Triple<String, Map<Long, List<DimScope>>, Map<Long, List<DimScope>>> checkedRow = tripleList.get(i);
                String left = (String)checkedRow.getLeft();
                Map middle = (Map)checkedRow.getMiddle();
                Map right = (Map)checkedRow.getRight();
                if (CollectionUtils.isEmpty((Collection)Sets.intersection(scenarios, dataScenarios)) || !computeType.equals(left) || !this.isContain(srcMap, middle) || !this.isContain(tarMap, right)) continue;
                List<Long> ids = case2Dim.get(caseId);
                DynamicObject dynamicObject = id2Dim.get(ids.get(0));
                String caseNumber = dynamicObject.getString("invchangecase.number");
                String caseName = dynamicObject.getString("invchangecase.name");
                int row = i + 1;
                String caseNumberCheck = checkDy.getString("invchangecase.number");
                String caseNameCheck = checkDy.getString("invchangecase.name");
                int rowCheck = dims.size() + 1;
                if (caseNumber.equals(caseNumberCheck)) {
                    return String.format(ResManager.loadKDString((String)"\u65b9\u6848\u3010%1$s-%2$s\u3011\u7b2c%3$s\u6761\u914d\u7f6e\u4e0e\u7b2c%4$s\u6761\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7684\u6e90\u6307\u5411\u76f8\u540c\u7684\u76ee\u6807\uff0c\u4e0d\u80fd\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvChangeCaseEntryService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), caseNameCheck, caseNumberCheck, rowCheck, row);
                }
                return String.format(ResManager.loadKDString((String)"\u65b9\u6848\u3010%1$s-%2$s\u3011\u7b2c%3$s\u6761\u914d\u7f6e\u4e0e\u5df2\u542f\u7528\u7684\u65b9\u6848\u3010%4$s-%5$s\u3011\u7b2c%6$s\u6761\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7684\u6e90\u6307\u5411\u76f8\u540c\u7684\u76ee\u6807\uff0c\u4e0d\u80fd\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvChangeCaseEntryService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), caseNameCheck, caseNumberCheck, rowCheck, caseName, caseNumber, row);
            }
        }
        dims.add(checkingRow);
        return null;
    }

    private boolean isContain(Map<Long, List<DimScope>> checkMap, Map<Long, List<DimScope>> comparedMap) {
        Map<Long, List<DimScope>> shortMap = checkMap.size() < comparedMap.size() ? checkMap : comparedMap;
        Map<Long, List<DimScope>> longMap = checkMap.size() < comparedMap.size() ? comparedMap : checkMap;
        for (Map.Entry<Long, List<DimScope>> entry : shortMap.entrySet()) {
            List longDimScope;
            Long dimId = entry.getKey();
            List<DimScope> shortDimScope = entry.getValue();
            if (this.isIntersection(shortDimScope, longDimScope = (List)longMap.getOrDefault(dimId, new ArrayList()))) continue;
            return false;
        }
        return true;
    }

    private boolean isIntersection(List<DimScope> shortDimScope, List<DimScope> longDimScope) {
        HashSet<Long> shortMemIds = new HashSet<Long>(shortDimScope.size());
        HashSet<String> short110Numbers = new HashSet<String>(16);
        this.collectMemIdsAndRootNumbers(shortDimScope, shortMemIds, short110Numbers);
        HashSet<Long> longMemIds = new HashSet<Long>(longDimScope.size());
        HashSet<String> long110Numbers = new HashSet<String>(16);
        this.collectMemIdsAndRootNumbers(longDimScope, longMemIds, long110Numbers);
        Sets.SetView difference = Sets.intersection(shortMemIds, longMemIds);
        if (!difference.isEmpty()) {
            return true;
        }
        return this.isHaveSon(longDimScope, short110Numbers) || this.isHaveSon(shortDimScope, long110Numbers);
    }

    private boolean isHaveSon(List<DimScope> dimScopeList, Set<String> rootNumbers) {
        for (String number : rootNumbers) {
            for (DimScope dimScope : dimScopeList) {
                if (!dimScope.getLongNumber().startsWith(number)) continue;
                return true;
            }
        }
        return false;
    }

    private void collectMemIdsAndRootNumbers(List<DimScope> dimScopes, Set<Long> memIds, Set<String> rootNumbers) {
        for (DimScope dimScope : dimScopes) {
            long memId = dimScope.getMemId();
            if (dimScope.getScope() != RangeEnum.VALUE_10) {
                rootNumbers.add(dimScope.getLongNumber());
            }
            memIds.add(memId);
        }
    }

    private /* synthetic */ void lambda$buildData$10(Map srcMap, Map tarMap, Table calTable, Set dimIds, Long k, List v) {
        srcMap.put(k, v);
        tarMap.put(k, v);
        v.forEach(dimScope -> this.scope2Table((Table<Long, Long, Set<DimScope>>)calTable, dimIds, k, (DimScope)dimScope));
    }

    private /* synthetic */ void lambda$buildData$8(Table calTable, Set dimIds, Map tarMap, Long dimId, DimScope dimScope) {
        this.scope2Table((Table<Long, Long, Set<DimScope>>)calTable, dimIds, dimId, dimScope);
        tarMap.put(dimId, Lists.newArrayList((Object[])new DimScope[]{dimScope}));
    }

    private /* synthetic */ void lambda$buildData$6(Table calTable, Set dimIds, Map srcMap, Long dimId, DimScope dimScope) {
        this.scope2Table((Table<Long, Long, Set<DimScope>>)calTable, dimIds, dimId, dimScope);
        srcMap.put(dimId, Lists.newArrayList((Object[])new DimScope[]{dimScope}));
    }
}

