/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.invest.changecase.DimScope;
import kd.fi.bcm.business.invest.changecase.InvChangeCaseEntryService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.QFBuilder;

public class InvChangeCaseService {
    public static final String ENTITY_NAME = "bcm_invchangecaseentity";
    private long modelId;
    private Map<Long, Set<Pair<Long, String>>> caseScenarioCache = new HashMap<Long, Set<Pair<Long, String>>>(16);
    public static final String MODEL = "model";
    public static final String SCENARIO = "scenario";
    public static final String CHANGE_TYPE = "changetype";
    public static final String STATUS = "status";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String CHARGE_AGAINST = "chargeagainst";
    public static final String DIM_SCOPE = "dimscope";
    public static final String DIMENSION = "dimension";
    public static final String MEMBER_ID = "memberid";
    public static final String SCOPE = "scope";
    public static final String SCENARIOS = "scenarios";

    public InvChangeCaseService(long modelId) {
        this.modelId = modelId;
    }

    public StringJoiner enableCheck(Collection<DynamicObject> cases) {
        DynamicObject[] allCase = this.querySameTypeAbleCases(cases);
        HashMap dimId2Dy = new HashMap();
        Map<Long, Map<Long, List<DimScope>>> case2Scope = this.getCase2Scope(allCase, dimIds -> BusinessDataServiceHelper.loadFromCache((Object[])dimIds.toArray(), (String)"bcm_dimension").forEach((k, v) -> dimId2Dy.put((Long)k, v)));
        Collector groupingBy = Collectors.groupingBy(this::buildKey, Collectors.mapping(dy -> dy.getLong("id"), Collectors.toSet()));
        Map allAbleCase = Arrays.stream(allCase).filter(dy -> dy.getBoolean(STATUS)).collect(groupingBy);
        Map checkDisableCase = cases.stream().filter(dy -> !dy.getBoolean(STATUS)).collect(groupingBy);
        StringJoiner msg = new StringJoiner("\r\n");
        checkDisableCase.forEach((key, checkCaseIds) -> {
            Set<Long> ableCaseIds = allAbleCase.getOrDefault(key, Collections.emptySet());
            checkCaseIds.removeAll(ableCaseIds);
            InvChangeCaseEntryService entryService = new InvChangeCaseEntryService(this.caseScenarioCache);
            StringJoiner stringJoiner = entryService.enableCheck((Set<Long>)checkCaseIds, ableCaseIds, case2Scope, dimId2Dy);
            msg.merge(stringJoiner);
        });
        return msg;
    }

    private Map<Long, Map<Long, List<DimScope>>> getCase2Scope(DynamicObject[] allCase, Consumer<Collection<Long>> after) {
        HashMap<Long, Map<Long, List<DimScope>>> case2Scope = new HashMap<Long, Map<Long, List<DimScope>>>();
        ArrayList<Long> dimIds = new ArrayList<Long>();
        for (DynamicObject dynamicObject : allCase) {
            long id = dynamicObject.getLong("id");
            Map dim2members = case2Scope.computeIfAbsent(id, v -> new HashMap());
            DynamicObjectCollection scopes = dynamicObject.getDynamicObjectCollection(DIM_SCOPE);
            for (DynamicObject scope : scopes) {
                long dimension = scope.getLong("dimension.id");
                dimIds.add(dimension);
                List memberList = dim2members.computeIfAbsent(dimension, v -> new ArrayList());
                long memberId = scope.getLong(MEMBER_ID);
                int scopeValue = scope.getInt(SCOPE);
                DimScope dimScope = new DimScope();
                dimScope.setScope(scopeValue);
                dimScope.setMemId(memberId);
                memberList.add(dimScope);
            }
        }
        after.accept(dimIds);
        return case2Scope;
    }

    private DynamicObject[] querySameTypeAbleCases(Collection<DynamicObject> cases) {
        HashSet changeTypes = new HashSet(cases.size());
        HashSet caseIds = new HashSet(cases.size());
        HashSet chargeAgainst = new HashSet(1);
        DynamicObjectCollection scenarios = new DynamicObjectCollection();
        cases.forEach(dynamicObject -> {
            Long caseId = dynamicObject.getLong("id");
            caseIds.add(caseId);
            changeTypes.add(dynamicObject.getString(CHANGE_TYPE));
            chargeAgainst.add(dynamicObject.getBoolean(CHARGE_AGAINST));
            scenarios.addAll((Collection)dynamicObject.getDynamicObjectCollection(SCENARIOS));
        });
        HashMap<String, Set<Pair<Long, String>>> membRangeItemCache = new HashMap<String, Set<Pair<Long, String>>>(16);
        Set<Pair<Long, String>> scenarioPairs = CheckUtil.analyzingScenariosPair(this.modelId, (Collection<DynamicObject>)scenarios, membRangeItemCache, "");
        Set scenarioSet = scenarioPairs.stream().map(p -> (Long)p.p1).collect(Collectors.toSet());
        HashSet ableCaseIds = new HashSet(16);
        scenarioSet.stream().map(scenario -> ableCaseIds.addAll(CheckUtil.getApplySceneTmpls(this.modelId, scenario, ENTITY_NAME))).collect(Collectors.toSet());
        QFilter ableCaseFilter = new QFilter(MODEL, "=", (Object)this.modelId).and(CHANGE_TYPE, "in", changeTypes).and(CHARGE_AGAINST, "in", chargeAgainst).and(STATUS, "=", (Object)true);
        ableCaseFilter.and("id", "in", ableCaseIds);
        QFBuilder qfBuilder = new QFBuilder("id", "in", caseIds).or(ableCaseFilter);
        String selectFields = "id,status,changetype,chargeagainst,dimscope,dimscope.dimension,dimscope.memberid,dimscope.scope,scenarios,scenarios.isexcept,scenarios.scenariomeb,scenarios.scenarioscope";
        DynamicObject[] allCase = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectFields, (QFilter[])qfBuilder.toArray());
        Arrays.stream(allCase).forEach(checkCase -> {
            Long caseId = checkCase.getLong("id");
            this.caseScenarioCache.computeIfAbsent(caseId, v -> CheckUtil.analyzingScenariosPair(this.modelId, (Collection<DynamicObject>)checkCase.getDynamicObjectCollection(SCENARIOS), membRangeItemCache, ""));
        });
        return allCase;
    }

    public static Map<String, String> getChangeTypesByRel(Long modelId, Set<String> changeTypes) {
        String key = String.join((CharSequence)"_", "getChangeTypesByRel", String.valueOf(modelId));
        return (Map)ThreadCache.get((Object)key, () -> {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_invchangetype", (String)"id,number,relatedchangetype.number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId).and("isdefault", "=", (Object)"0").and("relatedchangetype.number", "in", (Object)changeTypes)});
            return dynamicObjects.stream().collect(Collectors.toMap(k -> k.getString(NUMBER), v -> v.getString("relatedchangetype.number"), (v1, v2) -> v1));
        });
    }

    private String buildKey(DynamicObject caseDy) {
        return caseDy.getString(CHANGE_TYPE) + "@" + caseDy.getString(CHARGE_AGAINST);
    }
}

