/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.invest.changecase.InvCasePageDimRunService;
import kd.fi.bcm.business.invest.changecase.InvCasePageDimService;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.invest.InvCaseHandleRunStatusEnum;

public class InvChangeHandleServiceHelper {
    public static Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> getDim2CaseMap(Object[] selectedKey) {
        DynamicObject[] dims = BusinessDataServiceHelper.load((Object[])selectedKey, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_invcasepagedim"));
        return InvChangeHandleServiceHelper.buildPageDimAndCase(dims);
    }

    public static void handleAfterMerge(ExecuteContext ctx) {
        InvChangeHandleServiceHelper.doHandleAfterMerge(ctx, filter -> {});
    }

    public static void handleAfterMerge(ExecuteContext ctx, Collection<String> processes) {
        InvChangeHandleServiceHelper.doHandleAfterMerge(ctx, filter -> filter.and("case.process.number", "in", (Object)processes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doHandleAfterMerge(ExecuteContext ctx, Consumer<QFilter> otherQFilter) {
        QFilter filter = new QFilter("model", "=", ctx.getModel().id);
        filter.and("scenario", "=", ctx.getScenario().id);
        filter.and("year", "=", ctx.getFy().id);
        filter.and("tarparentorg", "=", ctx.getOrg().id);
        filter.and("tarperiod", "=", ctx.getPeriod().id);
        filter.and("status", "!=", (Object)InvCaseHandleRunStatusEnum.RECALL.getIndex());
        otherQFilter.accept(filter);
        try (DLock lock = DLock.create((String)InvChangeHandleServiceHelper.getLockKey(ctx));){
            try {
                lock.lock();
                DynamicObject[] dimPages = BusinessDataServiceHelper.load((String)"bcm_invcasepagedim", (String)InvCasePageDimService.allProperties(), (QFilter[])filter.toArray());
                if (dimPages == null || dimPages.length == 0) {
                    return;
                }
                Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase = InvChangeHandleServiceHelper.buildPageDimAndCase(dimPages);
                InvCasePageDimRunService invCasePageDimRunService = new InvCasePageDimRunService(ctx);
                invCasePageDimRunService.reRunAfterMerge(dimAndCase);
                lock.unlock();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static String getLockKey(ExecuteContext ctx) {
        String model = ctx.getModel().getId().toString();
        String scenario = ctx.getScenario().getId().toString();
        String fy = ctx.getFy().getId().toString();
        return model + scenario + fy;
    }

    public static String tranCurrency(String modelNum, Long orgid, String currency, String process) {
        IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((String)modelNum, (String)"bcm_entitymembertree", (Long)orgid);
        long modelId = numberTreeNode.getModelId();
        return (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)numberTreeNode, (long)modelId, (String)process, (String)currency).p2;
    }

    public static void buildLog(Long dimPageId, Long caseId, InvCaseHandleRunStatusEnum resultType, String reason, DynamicObject dimPageObject) {
        DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangehandlelog");
        logObject.set("casepagedim", (Object)dimPageId);
        logObject.set("case", (Object)caseId);
        logObject.set("status", (Object)resultType.getIndex());
        logObject.set("reason", (Object)reason);
        logObject.set("user", (Object)RequestContext.get().getUserId());
        logObject.set("handledate", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
    }

    public static DynamicObject buildLogDynamicObject(Long dimPageId, Long caseId, InvCaseHandleRunStatusEnum resultType, String reason) {
        DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangehandlelog");
        logObject.set("casepagedim", (Object)dimPageId);
        logObject.set("case", (Object)caseId);
        logObject.set("status", (Object)resultType.getIndex());
        logObject.set("reason", (Object)reason);
        logObject.set("user", (Object)RequestContext.get().getUserId());
        logObject.set("handledate", (Object)TimeServiceHelper.now());
        return logObject;
    }

    public static Map<String, IDNumberTreeNode> tranEntryToNode(List<DynamicObject> entry, String modelNumber) {
        HashMap<String, IDNumberTreeNode> result = new HashMap<String, IDNumberTreeNode>(10);
        InvChangeHandleServiceHelper.dimAndMem(entry, (dimNumber, memNumber) -> {
            IDNumberTreeNode tempNode = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memNumber);
            result.put((String)dimNumber, tempNode);
        });
        return result;
    }

    public static void dimAndMem(List<DynamicObject> entry, BiConsumer<String, String> action) {
        for (DynamicObject object : entry) {
            String dimNumber = object.getString("dimnumber");
            String memNumber = object.getString("memnumber");
            if ("EIRpt".equals(memNumber)) {
                memNumber = "IRpt";
            }
            if ("EIRpt".equals(memNumber)) {
                memNumber = "IRpt";
            }
            if ("ERpt".equalsIgnoreCase(memNumber)) {
                memNumber = "Rpt";
            } else if ("EIRpt".equalsIgnoreCase(memNumber)) {
                memNumber = "IRpt";
            } else if ("ERAdj".equalsIgnoreCase(memNumber)) {
                memNumber = "RAdj";
            }
            if (StringUtils.isEmpty((CharSequence)dimNumber) || StringUtils.isEmpty((CharSequence)memNumber)) continue;
            action.accept(dimNumber, memNumber);
        }
    }

    private static Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> buildPageDimAndCase(DynamicObject[] dims) {
        DynamicObject[] cases;
        ArrayListMultimap caseId2Dim = ArrayListMultimap.create();
        HashMap dim2Case = Maps.newHashMap();
        HashMap<Long, DynamicObject> id2DyDims = new HashMap<Long, DynamicObject>(dims.length);
        for (DynamicObject invCasePageDim : dims) {
            long caseId = invCasePageDim.getLong("case.id");
            long dimId = invCasePageDim.getLong("id");
            id2DyDims.put(dimId, invCasePageDim);
            caseId2Dim.put((Object)caseId, (Object)dimId);
        }
        for (DynamicObject aCase : cases = BusinessDataServiceHelper.load((Object[])caseId2Dim.keys().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_invchangecaseentity"))) {
            long id = aCase.getLong("id");
            List dimList = caseId2Dim.get((Object)id);
            for (Long dimId : dimList) {
                dim2Case.put(dimId, aCase);
            }
        }
        return new Pair(id2DyDims, (Object)dim2Case);
    }
}

