/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LanguageTranslateUtil;
import kd.fi.bcm.common.util.UserUtils;

public class InvChangeTypeServiceHelper {
    public static final List<Tuple<String, MultiLangEnumBridge, String>> DEFAULT_DATA_MAPPER = new ArrayList<Tuple<String, MultiLangEnumBridge, String>>();

    public static List<Object[]> setDefaultChangeType(Long modelid) {
        return InvChangeTypeServiceHelper.setDefaultChangeType(Collections.singletonList(modelid));
    }

    public static List<Object[]> setDefaultChangeType(Collection<Long> modelids) {
        Date now = new Date();
        Long userid = UserUtils.getUserId();
        ArrayList<Object[]> allInsertChangeType = new ArrayList<Object[]>(16);
        modelids.forEach(mid -> allInsertChangeType.addAll(InvChangeTypeServiceHelper.insertChangeType(mid, now, userid, DEFAULT_DATA_MAPPER)));
        return allInsertChangeType;
    }

    public static List<Object[]> setDefaultChangeTypeNew(Collection<Long> modelIds) {
        Date now = new Date();
        Long userid = UserUtils.getUserId();
        ArrayList<Object[]> allInsertChangeType = new ArrayList<Object[]>(16);
        ArrayList<Tuple<String, MultiLangEnumBridge, String>> resMap = new ArrayList<Tuple<String, MultiLangEnumBridge, String>>(DEFAULT_DATA_MAPPER);
        modelIds.forEach(mid -> allInsertChangeType.addAll(InvChangeTypeServiceHelper.insertChangeType(mid, now, userid, resMap)));
        return allInsertChangeType;
    }

    public static void getTranslateMap(List<Tuple<String, MultiLangEnumBridge, String>> resMap, BiConsumer<String, Map<Lang, String>> func) {
        resMap.forEach(tuple -> {
            MultiLangEnumBridge p2 = (MultiLangEnumBridge)tuple.p2;
            String description = p2.getDescription();
            String resourceID = p2.getResourceID();
            String systemType = p2.getSystemType();
            Map translate = LanguageTranslateUtil.getTranslate((String)description, (String)resourceID, (String)systemType);
            func.accept((String)tuple.p1, translate);
        });
    }

    private static List<Object[]> insertChangeType(Long modelId, Date time, Long userid, List<Tuple<String, MultiLangEnumBridge, String>> defaultDataMapper) {
        String insertChangeTypeSql = "INSERT into t_bcm_invchangetype(fid,fnumber,fname,fmodelid,fchange,fisdefault,fmodifierid,fmodifytime,fcreatorid,fcreatetime) values (?,?,?,?,?,?,?,?,?,?)";
        String insertChangeTypeMutiLangeSql = "INSERT into t_bcm_invchangetype_l(fid,fpkid,flocaleid,fname) values (?,?,?,?)";
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(defaultDataMapper.size());
        ArrayList valueMutiLangeList = new ArrayList(defaultDataMapper.size() * 3);
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)defaultDataMapper.size());
        for (int i = 0; i < defaultDataMapper.size(); ++i) {
            Tuple<String, MultiLangEnumBridge, String> item = defaultDataMapper.get(i);
            long id = genGlobalLongIds[i];
            Object[] value = new Object[]{id, item.p1, ((MultiLangEnumBridge)item.p2).loadKDString(), modelId, item.p3, Character.valueOf('1'), userid, time, userid, time};
            valueList.add(value);
            ((MultiLangEnumBridge)item.p2).getLocaleString().forEach((localeId, val) -> {
                Object[] val1 = new Object[]{id, GlobalIdUtil.genStringId(), localeId, val};
                valueMutiLangeList.add(val1);
            });
        }
        if (!valueList.isEmpty()) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertChangeTypeSql, valueList);
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertChangeTypeMutiLangeSql, valueMutiLangeList);
        }
        return valueList;
    }

    private static Map<String, String> getResIdMapper() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("BD001", "InvChangeTypeUpgradeService_0");
        map.put("BD002", "InvChangeTypeUpgradeService_1");
        map.put("BD003", "InvChangeTypeUpgradeService_2");
        map.put("BD004", "InvChangeTypeUpgradeService_3");
        map.put("BD005", "InvChangeTypeUpgradeService_4");
        map.put("BD006", "InvChangeTypeUpgradeService_5");
        map.put("BD007", "InvChangeTypeUpgradeService_6");
        map.put("BD008", "InvChangeTypeUpgradeService_7");
        map.put("BD009", "InvChangeTypeUpgradeService_8");
        map.put("BD010", "InvChangeTypeUpgradeService_9");
        map.put("BD011", "InvChangeTypeUpgradeService_10");
        map.put("BD012", "InvChangeTypeUpgradeService_11");
        map.put("BD013", "InvChangeTypeUpgradeService_12");
        map.put("BD014", "InvChangeTypeUpgradeService_13");
        return map;
    }

    public static boolean isDefaultNumber(String number) {
        HashSet numbers = Sets.newHashSet(InvChangeTypeServiceHelper.getResIdMapper().keySet());
        numbers.add("BD998");
        numbers.add("BD999");
        return numbers.contains(number);
    }

    public static DynamicObjectCollection findChangeType(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"bcm_invchangetype", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
    }

    public static QFilter modelChangeTypeFilter(Object modelId) {
        return InvChangeTypeServiceHelper.modelChangeTypeFilter(modelId, (Consumer<QFilter>)((Consumer)filter -> {}));
    }

    public static QFilter invShareRelaF7ChangeTypeFilter(Object modelId) {
        return InvChangeTypeServiceHelper.modelChangeTypeFilter(modelId, (Consumer<QFilter>)((Consumer)filter -> filter.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"BD998", "BD999"}))));
    }

    private static QFilter modelChangeTypeFilter(Object modelId, Consumer<QFilter> func) {
        QFilter filter = new QFilter("model", "=", modelId).and("enable", "=", (Object)"1");
        func.accept((Object)filter);
        return filter;
    }

    static {
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD001", (Object)new MultiLangEnumBridge("\u7cfb\u7edf\u4e0a\u7ebf\u521d\u59cb\u5316\u65b0\u589e", "InvChangeTypeUpgradeService_0", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD002", (Object)new MultiLangEnumBridge("\u65b0\u8bbe\u5b50\u516c\u53f8", "InvChangeTypeUpgradeService_1", "fi-bcm-business"), (Object)"1"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD003", (Object)new MultiLangEnumBridge("\u5e76\u8d2d\u5b50\u516c\u53f8\uff08\u975e\u540c\u63a7\uff09\u65b0\u589e", "InvChangeTypeUpgradeService_2", "fi-bcm-business"), (Object)"1"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD004", (Object)new MultiLangEnumBridge("\u5e76\u8d2d\u5b50\u516c\u53f8\uff08\u540c\u63a7\uff09\u65b0\u589e", "InvChangeTypeUpgradeService_3", "fi-bcm-business"), (Object)"1"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD005", (Object)new MultiLangEnumBridge("\u5b50\u516c\u53f8\uff08\u540c\u63a7\uff09\u5904\u7f6e", "InvChangeTypeUpgradeService_4", "fi-bcm-business"), (Object)"2"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD006", (Object)new MultiLangEnumBridge("\u5b50\u516c\u53f8\uff08\u975e\u540c\u63a7\uff09\u5904\u7f6e", "InvChangeTypeUpgradeService_5", "fi-bcm-business"), (Object)"2"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD007", (Object)new MultiLangEnumBridge("\u6e05\u7b97\u540e\u91cd\u65b0\u56de\u8d2d\u65b0\u589e", "InvChangeTypeUpgradeService_6", "fi-bcm-business"), (Object)"1"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD008", (Object)new MultiLangEnumBridge("\u65b0\u8bbe\u5408\u5e76\u53d8\u66f4\u542f\u7528", "InvChangeTypeUpgradeService_7", "fi-bcm-business"), (Object)"1"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD009", (Object)new MultiLangEnumBridge("\u65b0\u8bbe\u5408\u5e76\u53d8\u66f4\u7981\u7528", "InvChangeTypeUpgradeService_8", "fi-bcm-business"), (Object)"3"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD010", (Object)new MultiLangEnumBridge("\u63a7\u5236\u6743\u4e0d\u53d8\u589e\u8d44", "InvChangeTypeUpgradeService_9", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD011", (Object)new MultiLangEnumBridge("\u63a7\u5236\u6743\u4e0d\u53d8\u8d2d\u4e70\u5c11\u6570\u80a1\u6743", "InvChangeTypeUpgradeService_10", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD012", (Object)new MultiLangEnumBridge("\u63a7\u5236\u6743\u4e0d\u53d8\u5904\u7f6e\u5c11\u6570\u80a1\u6743", "InvChangeTypeUpgradeService_11", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD013", (Object)new MultiLangEnumBridge("\u63a7\u5236\u6743\u4e0d\u53d8\u51cf\u8d44", "InvChangeTypeUpgradeService_12", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD014", (Object)new MultiLangEnumBridge("\u63a7\u5236\u6743\u4e0d\u53d8\u5c11\u6570\u80a1\u4e1c\u589e\u8d44\u5bfc\u81f4\u80a1\u6743\u53d8\u52a8", "InvChangeTypeUpgradeService_13", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD998", (Object)new MultiLangEnumBridge("\u540c\u63a7\u5904\u7f6e\u7684\u5171\u540c\u7236\u7ea7", "InvChangeTypeUpgradeService_14", "fi-bcm-business"), (Object)"0"));
        DEFAULT_DATA_MAPPER.add((Tuple<String, MultiLangEnumBridge, String>)Tuple.create((Object)"BD999", (Object)new MultiLangEnumBridge("\u540c\u63a7\u65b0\u589e\u7684\u5171\u540c\u7236\u7ea7", "InvChangeTypeUpgradeService_15", "fi-bcm-business"), (Object)"0"));
    }
}

