/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.changecase.SameControlPairArrayStack;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.util.PeriodUtils;

public class OrgBizTypeArrayModel {
    private final AbstractContext ctx;
    private final Long periodId;
    private Date[] periodScope;
    private Set<Long> efftiveOrgSet;
    private final Stack<Pair<Long, String>> orgBizTypeStack;
    private final Map<Long, Date> noCurPeriodMap = new HashMap<Long, Date>();
    private final Map<String, SameControlPairArrayStack> num2OrgBizPairMap = new LinkedHashMap<String, SameControlPairArrayStack>(16);

    public OrgBizTypeArrayModel(AbstractContext ctx, Long periodId) {
        this.ctx = ctx;
        this.orgBizTypeStack = new Stack();
        this.periodId = periodId;
    }

    public void setEfftiveOrgSet(Set<Long> efftiveOrgSet) {
        this.efftiveOrgSet = efftiveOrgSet;
    }

    private boolean isEfftiveOrg(Long orgId) {
        return this.efftiveOrgSet == null || this.efftiveOrgSet.contains(orgId);
    }

    public void addOrgBizTypeRecord(Long bizOrgId, String bizType, Date occurrDate) {
        if (occurrDate == null) {
            return;
        }
        boolean isCurPeriod = InvDynamicStockRatioHelper.isCurPeriod(this.getPeriodScope(), occurrDate);
        ChangeTypeModel changeType = InvestServiceHelper.getInvChangetypeModel(this.ctx.getModelId()).get(bizType);
        if (changeType != null && this.isEfftiveOrg(bizOrgId)) {
            IDNumberTreeNode orgNode;
            String realBizType = changeType.getRealChangeType();
            if ((OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue().equals(realBizType) || OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(realBizType)) && this.num2OrgBizPairMap.computeIfAbsent((orgNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)bizOrgId)).getNumber(), a -> new SameControlPairArrayStack(this.ctx)).push(bizOrgId, realBizType, occurrDate, isCurPeriod) && !isCurPeriod) {
                this.noCurPeriodMap.put(bizOrgId, occurrDate);
            }
            if (isCurPeriod) {
                this.orgBizTypeStack.push((Pair<Long, String>)Pair.onePair((Object)bizOrgId, (Object)realBizType));
            }
        }
    }

    public void forEachBizType(BiConsumer<Long, String> action) {
        this.orgBizTypeStack.forEach((Consumer<Pair<Long, String>>)((Consumer<Pair>)p -> action.accept((Long)p.p1, (String)p.p2)));
    }

    public void forEachSameControlPair(long cslId, BiConsumer<Long, Long> action) {
        this.num2OrgBizPairMap.values().forEach(p -> p.forEach(cslId, action));
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public Date[] getPeriodScope() {
        if (this.periodScope == null) {
            this.periodScope = PeriodUtils.calcStartAndEndDate((long)this.ctx.getModelId(), (long)this.ctx.getFyId(), (long)this.periodId);
        }
        return this.periodScope;
    }

    public Map<Long, Date> getNoCurPeriodMap() {
        return this.noCurPeriodMap;
    }
}

