/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgPathNode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;

public class SameControlPairArrayStack {
    private final AbstractContext ctx;
    private Pair<Date, List<Long>> curDisposalPair;
    private Pair<Date, List<Long>> curNewlyAddPair;
    private final ArrayDeque<List<Long>> newlyAddQueue = new ArrayDeque(2);
    private final ArrayDeque<List<Long>> disposalQueue = new ArrayDeque(2);
    private final Stack<Pair<List<Long>, List<Long>>> sameControlPairStack = new Stack();

    public SameControlPairArrayStack(AbstractContext ctx) {
        this.ctx = ctx;
    }

    public boolean push(Long orgBizId, String bizType, Date changeDate, boolean isCurPeriod) {
        boolean isNewlyAdd = OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue().equals(bizType);
        if (!isCurPeriod && isNewlyAdd) {
            return false;
        }
        ArrayList orgDayChangeList = this.getCurChangeDateDeque(isNewlyAdd, changeDate);
        if (orgDayChangeList == null) {
            if (!isCurPeriod && this.isCompleted()) {
                return false;
            }
            orgDayChangeList = Lists.newArrayList();
            if (isNewlyAdd) {
                this.curNewlyAddPair = Pair.onePair((Object)changeDate, (Object)orgDayChangeList);
                if (this.disposalQueue.isEmpty()) {
                    this.newlyAddQueue.push(orgDayChangeList);
                } else {
                    this.sameControlPairStack.push((Pair<List<Long>, List<Long>>)Pair.onePair(this.disposalQueue.pop(), (Object)orgDayChangeList));
                }
            } else {
                this.curDisposalPair = Pair.onePair((Object)changeDate, (Object)orgDayChangeList);
                if (!this.newlyAddQueue.isEmpty()) {
                    this.sameControlPairStack.push((Pair<List<Long>, List<Long>>)Pair.onePair((Object)orgDayChangeList, this.newlyAddQueue.pop()));
                }
            }
        }
        orgDayChangeList.add((Long)orgBizId);
        return true;
    }

    private List<Long> getCurChangeDateDeque(boolean isNewlyAdd, Date changeDate) {
        if (isNewlyAdd) {
            return this.curNewlyAddPair != null && ((Date)this.curNewlyAddPair.p1).equals(changeDate) ? (List)this.curNewlyAddPair.p2 : null;
        }
        return this.curDisposalPair != null && ((Date)this.curDisposalPair.p1).equals(changeDate) ? (List)this.curDisposalPair.p2 : null;
    }

    public void forEach(long cslId, BiConsumer<Long, Long> action) {
        this.sameControlPairStack.forEach((Consumer<Pair<List<Long>, List<Long>>>)((Consumer<Pair>)p -> {
            OrgPathNode disposalPathNode = new OrgPathNode().mergeAllOrgNode(((List)p.p1).stream().map(orgId -> BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)orgId)).collect(Collectors.toSet()));
            OrgPathNode newlyAddPathNode = new OrgPathNode().mergeAllOrgNode(((List)p.p2).stream().map(orgId -> BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)orgId)).collect(Collectors.toSet()));
            disposalPathNode.getCommonPathList(newlyAddPathNode).forEach((csl, pathList) -> {
                if (csl == cslId) {
                    for (IDNumberTreeNode maxLevelNode : InvDynamicStockRatioHelper.findHighLevel(pathList)) {
                        long disposalId = ((List)p.p1).stream().filter(orgId -> BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)orgId).getLongNumber().startsWith(maxLevelNode.getLongNumber() + "!")).findFirst().orElse(0L);
                        long newlyAddId = ((List)p.p2).stream().filter(orgId -> BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)orgId).getLongNumber().startsWith(maxLevelNode.getLongNumber() + "!")).findFirst().orElse(0L);
                        action.accept(disposalId, newlyAddId);
                    }
                }
            });
        }));
    }

    public boolean isEmpty() {
        return this.sameControlPairStack.isEmpty();
    }

    public boolean isCompleted() {
        return this.newlyAddQueue.isEmpty();
    }
}

