/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.componet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class OrgF7Com {
    private final IFormView view;
    private final Collection<String> signs;
    private Collection<Supplier<QFilter>> qFilterSuppliers;

    public OrgF7Com(IFormView view, Collection<String> signs) {
        this.view = view;
        this.signs = signs;
        this.qFilterSuppliers = new ArrayList<Supplier<QFilter>>(16);
    }

    public void registerFilters() {
        if (!this.qFilterSuppliers.isEmpty()) {
            for (String sign : this.signs) {
                BasedataEdit control = (BasedataEdit)this.view.getControl(sign);
                control.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    List listenerFilters = this.qFilterSuppliers.stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList());
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    showParameter.setListFilterParameter(new ListFilterParameter(listenerFilters, null));
                });
            }
        }
    }

    public OrgF7Com addModelFilter(String modelSign) {
        this.f7ToFilter(modelSign, "model");
        return this;
    }

    public OrgF7Com addCslSchemeFilter(String cslSchemeSign, long orDefaultSchemeId) {
        long id = this.getId(cslSchemeSign);
        if (id == 0L) {
            this.qFilterSuppliers.add(() -> new QFilter("cslscheme", "=", (Object)orDefaultSchemeId));
        } else {
            this.f7ToFilter(cslSchemeSign, "cslscheme");
        }
        return this;
    }

    public OrgF7Com addPermFilter(String modelF7Sign) {
        this.qFilterSuppliers.add(() -> {
            long modelId = this.getId(modelF7Sign);
            String dimNumber = DimTypesEnum.ENTITY.getNumber();
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNumber);
            return PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(dimensionId, DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), "id");
        });
        return this;
    }

    public OrgF7Com addSonFilter(long parentOrgId) {
        long modelId = this.getId("model");
        if (parentOrgId == 0L) {
            this.qFilterSuppliers.add(() -> new QFilter("1", "!=", (Object)1));
            return this;
        }
        IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)parentOrgId);
        if (entity.getStorageType() == StorageTypeEnum.SHARE) {
            Long entityStorage = entity.getCopyfromId();
            entity = MemberReader.findEntityMemberById((Long)modelId, (Long)entityStorage);
        }
        String longNumber = entity.getLongNumber();
        this.qFilterSuppliers.add(() -> new QFilter("longnumber", "like", (Object)(longNumber + "!%")));
        return this;
    }

    public OrgF7Com addExchangeRateFilter() {
        this.qFilterSuppliers.add(() -> new QFilter("isexchangerate", "=", (Object)"0"));
        return this;
    }

    public OrgF7Com addIndependentFilter() {
        this.qFilterSuppliers.add(() -> new QFilter("isindependentorg", "=", (Object)"1").or("isleaf", "=", (Object)"1"));
        return this;
    }

    public OrgF7Com addMergeFilter() {
        this.qFilterSuppliers.add(() -> new QFilter("isleaf", "!=", (Object)"1"));
        return this;
    }

    private void f7ToFilter(String f7Sign, String propName) {
        long id = this.getId(f7Sign);
        this.qFilterSuppliers.add(() -> new QFilter(propName, "=", (Object)id));
    }

    private long getId(String f7Sign) {
        Object value = this.view.getModel().getValue(f7Sign);
        long id = 0L;
        if (Objects.nonNull(value) && value instanceof DynamicObject) {
            id = ((DynamicObject)value).getLong("id");
        }
        return id;
    }
}

