/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.elimination;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.AdjustCheckBalanceContext;
import kd.fi.bcm.business.adjust.model.CalcLinePool;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.elimination.InvElimRecorderGenHelper;
import kd.fi.bcm.business.invest.elimination.InvestDefaultFormulaValueHandler;
import kd.fi.bcm.business.invest.elimination.model.GenerateContext;
import kd.fi.bcm.business.invest.elimination.model.InvElimTemplateEntry;
import kd.fi.bcm.business.invest.elimination.model.InvElimTemplateModel;
import kd.fi.bcm.business.invest.elimination.model.RelaModel;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.model.InvestFormulaLog;
import kd.fi.bcm.business.invest.model.PChildFormulaLogInfo;
import kd.fi.bcm.business.invest.model.PFormulaLogInfo;
import kd.fi.bcm.business.invest.sheet.InvTemplateDistributionService;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestCalContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetEntryConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.enums.invest.InvProcessEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.formula.expr.Expression;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class InvElimGenerateService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvElimGenerateService.class);
    private GenerateContext ctx;
    private List<InvElimTemplateModel> templates;
    private List<RelaModel> relaModels;
    private HashMultimap<String, RelaModel> relaTypeAndModelMap;
    private CalcLinePool<InvCalcLine> calcPool = new CalcLinePool();
    private CalculateService calcService;
    private int generatCount = 0;
    private Collection<Long> templateIds;
    private Set<String> errMsg = new HashSet<String>();
    private int elimTemplateType = 1;
    private Set<String> invCompanyNumSet = new HashSet<String>(16);
    private List<String> specifiedProcess = null;
    private Set<String> adjustPerStaSet;
    private Set<String> templateNum2RelaSet = new HashSet<String>(2);
    Set<String> noMerge;
    protected static final Map<String, String> processMap = new HashMap<String, String>(16);
    private final Map<ExpressStatus, PFormulaLogInfo> pFormulaLogInfoMap = new HashMap<ExpressStatus, PFormulaLogInfo>(16);
    private Set<String> periodStatusOrgSet = new HashSet<String>();

    public InvElimGenerateService(long modelId, long scenarioId, long fyId, long periodId, long unitId, long cslId, boolean isNeedMonitorDataStatus) {
        this.ctx = new GenerateContext(modelId, scenarioId, fyId, periodId, unitId, cslId);
        this.templates = new ArrayList<InvElimTemplateModel>();
        this.relaModels = new ArrayList<RelaModel>();
    }

    public InvElimGenerateService(long modelId, long scenarioId, long fyId, long periodId, long unitId, long cslId, boolean isNeedMonitorDataStatus, Collection<Long> templateIds) {
        this(modelId, scenarioId, fyId, periodId, unitId, cslId, isNeedMonitorDataStatus);
        this.templateIds = templateIds;
    }

    public InvElimGenerateService addUnitCurrency(String number, long id) {
        this.ctx.setCurrencyInfo(number, id);
        return this;
    }

    private void addtemplateNum2Rela(InvElimTemplateModel templateModel, RelaModel relaModel) {
        if (this.elimTemplateType == 2) {
            if (relaModel.dispenseTmplIds.isEmpty() && templateModel.isOnlyLinked()) {
                return;
            }
            this.templateNum2RelaSet.add(this.packExtendFromKey(templateModel, relaModel));
        }
    }

    public void setElimTemplateType(int type) {
        this.elimTemplateType = type;
    }

    public void setSpecifiedProcess(List<String> process) {
        this.specifiedProcess = process;
    }

    public void setDetailEntity(Pair<Long, String> detailEntity) {
        this.ctx.setDetailEntity(detailEntity);
    }

    public void setDetailEntityCurrency(Pair<Long, String> detailEntityCurrency) {
        this.ctx.setDetailEntityCurrency(detailEntityCurrency);
    }

    public Pair<Integer, String> generate() {
        this.initAdjustPeriodStatus();
        this.buildRelaModel();
        this.buildElimTemplateModel();
        this.initInvRelaCurrency();
        this.initCalService();
        this.ctx.setInvestCompanyMap(this.queryHoldingCompany());
        this.buildCalcExpression();
        this.buildElimRecord();
        this.dealErrorMsg();
        return Pair.onePair((Object)this.generatCount, this.errMsg == null || this.errMsg.isEmpty() ? null : Joiner.on((String)"\n").join(this.errMsg));
    }

    private void dealErrorMsg() {
        if (this.errMsg == null) {
            this.errMsg = new HashSet<String>();
        }
        if (!this.periodStatusOrgSet.isEmpty()) {
            this.errMsg.add(String.format(ResManager.loadKDString((String)"\uff08\u7ec4\u7ec7%s\u671f\u95f4\u672a\u5f00\u542f\uff0c\u76f8\u5173\u5206\u5f55\u65e0\u6cd5\u751f\u6210\u3002\uff09", (String)"InvElimGenerateService_1", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", this.periodStatusOrgSet.toArray(new String[0]))));
        }
    }

    private void initCalService() {
        InvestCalContext calContext = new InvestCalContext(this.ctx.getModelNum(), this.ctx.getOrgUnitNumber(), this.ctx.getFyNum(), this.ctx.getPeriodNum(), this.ctx.getScenariodNum(), this.elimTemplateType == 2 ? (String)this.ctx.getDetailEntityCurrency().p2 : this.getUnitCurrency());
        calContext.setProperty("cslscheme", this.getInvestFormulaContext().getCslschemeId());
        calContext.setProperty("model", this.ctx.getModelId());
        calContext.setProperty("modelId", this.ctx.getModelId());
        calContext.setProperty("yearId", this.ctx.getFyId());
        calContext.setProperty("periodId", this.ctx.getPeriodId());
        calContext.setProperty("scenarioId", this.ctx.getScenarioId());
        calContext.setProperty("orgId", this.ctx.getOrgUnitId());
        calContext.setProperty("orgUnitNumber", this.ctx.getOrgUnitNumber());
        calContext.setProperty("calcPool", this.calcPool);
        calContext.setDefaultParamHandle(new InvestDefaultFormulaValueHandler(calContext, this.calcPool));
        this.calcService = new CalculateService(calContext);
    }

    private String getUnitCurrency() {
        return this.ctx.getUnitCurrency();
    }

    private void buildCalcExpression() {
        this.buildCrossCalcModel();
        this.parseCalcExpression();
        this.doCalculate();
    }

    private void initAdjustPeriodStatus() {
        if (ConfigServiceHelper.getBoolParam(this.ctx.getModelId(), "CM012")) {
            Set<String> orgNums = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", this.ctx.getOrgUnitId(), this.ctx.getOrgUnitNumber(), 50, Long.toString(this.ctx.getModelId()), DetailTypeEnum.MEMBERPERM);
            this.adjustPerStaSet = PeriodSettingHelper.batchSelectPeriodStatusOpen(this.ctx.getModelId(), orgNums, this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), "entrystatus");
        }
    }

    private boolean checkAdjustPeriodStatus(String orgNum) {
        if (this.adjustPerStaSet == null || this.adjustPerStaSet.contains(orgNum)) {
            return true;
        }
        this.periodStatusOrgSet.add(orgNum);
        return false;
    }

    private Map<Boolean, Set<String>> collectNotCreateTemplateData() {
        QFilter auditQf = new QFilter("adjust.sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.MANUAL.getValue() + ""));
        auditQf.and("entrysource", "=", (Object)"5");
        if (this.elimTemplateType == 3) {
            auditQf.and(AdjustmentServiceHelper.getAdjustDataQFByProcess(this.getProcesses(), this.invCompanyNumSet, Sets.newHashSet((Object[])new String[]{this.ctx.getOrgUnitNumber()})));
        } else if (this.elimTemplateType == 2) {
            auditQf.and(AdjustmentServiceHelper.getAdjustDataQFByProcess(this.getProcesses(), Collections.singleton(this.ctx.getDetailEntity().p2), null));
        } else if (this.elimTemplateType == 1) {
            auditQf.and(AdjustmentServiceHelper.getAdjustDataQFByProcess(this.getProcesses(), null, Sets.newHashSet((Object[])new String[]{this.ctx.getOrgUnitNumber()})));
        }
        Set<Long> adjustIdSet = AdjustQueryServiceHelper.queryAdjustIds(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), null, Collections.singletonList(auditQf));
        HashMap<Boolean, Set<String>> templateNum2RelaMap = new HashMap<Boolean, Set<String>>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryNoCreateInvAdj", (String)"bcm_rptadjust", (String)"id,extendfrom,process", (QFilter[])new QFilter("id", "in", adjustIdSet).toArray(), null);){
            ds.forEachRemaining(row -> {
                String extendfrom = row.getString("extendfrom");
                if (!StringUtils.isEmpty((CharSequence)extendfrom)) {
                    templateNum2RelaMap.computeIfAbsent(OrgRelaProcessMembPool.isRelaProcess((String)row.getString("process")), e -> new HashSet(16)).add(extendfrom);
                }
            });
        }
        return templateNum2RelaMap;
    }

    private void buildElimRecord() {
        HashSet<String> companyNums = new HashSet<String>();
        this.relaModels.forEach(r -> {
            companyNums.add(r.holdCompanyNum);
            companyNums.add(r.invCompanyNum);
        });
        this.ctx.initMyOrICCompany(companyNums);
        ArrayList<DynamicObject> elims = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> elimEntries = new ArrayList<DynamicObject>();
        ArrayList<Long> notBalanceElimIds = new ArrayList<Long>(16);
        LinkedList<Long> templateUnbalanceElimIds = new LinkedList<Long>();
        HashSet<String> relaMap = new HashSet<String>();
        HashSet<Long> noCreate = new HashSet<Long>();
        boolean isDebugModel = DebugServiceHelper.isDebugInvElim();
        Map<Boolean, Set<String>> filterTempateMap = this.collectNotCreateTemplateData();
        for (InvElimTemplateModel template : this.templates) {
            boolean isMerge = OrgRelaProcessMembPool.isRelaProcess((String)template.getProcess());
            if (isMerge && filterTempateMap.getOrDefault(true, Collections.emptySet()).contains(this.packExtendFromKey(template, null))) continue;
            ArrayList groupElimEntries = new ArrayList();
            List<InvCalcLine> entries = this.calcPool.searchByTmpId(template.getTemplateId());
            if (CollectionUtil.isEmpty(entries)) continue;
            InvestFormulaLog.createLogPoint(InvFormulaLogTypeEnum.InvTemplateFormulaLog.getLogType(), this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), this.ctx.getOrgUnitId(), template.getTemplateId());
            entries.forEach(l -> {
                if (l.hasError) {
                    InvestFormulaLog.addErrorLog(l.relaModel.getCategorized(), l.relaModel.getRelationType(), l.relaModel.holdCompanyNum, l.relaModel.invCompanyNum, "", "#" + l.seq, l.ruleExpr, l.debugFormula);
                } else if (DebugServiceHelper.isDebugModel() && (l.value == null || BCMConstant.Zero.compareTo(l.value) == 0)) {
                    InvestFormulaLog.addTipLog(l.relaModel.getCategorized(), l.relaModel.getRelationType(), l.relaModel.holdCompanyNum, l.relaModel.invCompanyNum, "", "#" + l.seq, l.ruleExpr, l.debugFormula);
                }
            });
            InvestFormulaLog.removeLogPoint();
            if (isDebugModel || entries.stream().anyMatch(l -> l.value != null && l.value.compareTo(BCMConstant.Zero) != 0)) {
                InvCalcLine balanceLine = null;
                InvCalcLine debitBalanceLine = null;
                InvCalcLine creditBalanceLine = null;
                BigDecimal debitSum = BCMConstant.Zero;
                BigDecimal creditSum = BCMConstant.Zero;
                DynamicObject elim = null;
                BalanceTypeEnum balanceType = template.getBalanceType();
                if (!template.isUsedInvAdjElimTmpl()) {
                    elim = this.createElimDyAndCollect(elims, templateUnbalanceElimIds, template, balanceType);
                }
                int groupNum = 1;
                int seq = 1;
                boolean isValidated = false;
                relaMap.clear();
                for (InvCalcLine line : entries) {
                    if (!isMerge && filterTempateMap.getOrDefault(false, Collections.emptySet()).contains(this.packExtendFromKey(template, line.relaModel))) continue;
                    if (relaMap.add(line.relaModel.holdCompanyNum + "|" + line.relaModel.invCompanyNum)) {
                        seq = this.handleBalanceLine(balanceLine, debitSum, creditSum, notBalanceElimIds, elim, groupElimEntries, template, seq, groupNum, template.isUsedInvAdjElimTmpl());
                        if (template.isUsedInvAdjElimTmpl()) {
                            elim = this.createElimDyAndCollect(elims, templateUnbalanceElimIds, template, balanceType);
                            if (InvProcessEnum.getAllADJNumber().contains(template.getProcess())) {
                                elim.set("entity", (Object)this.ctx.getInvestCompanyMap().get(line.relaModel.holdCompanyNum));
                                elim.set("belongorg", (Object)this.ctx.getInvestCompanyMap().get(line.relaModel.holdCompanyNum));
                            }
                            groupNum = 1;
                        } else if (isValidated) {
                            ++groupNum;
                            if (!CollectionUtils.isEmpty((Collection)groupElimEntries)) {
                                this.dealGroupElimEntriesOrder(groupElimEntries);
                                elimEntries.addAll(groupElimEntries);
                                groupElimEntries.clear();
                            }
                        }
                        seq = 1;
                        isValidated = false;
                        debitSum = BCMConstant.Zero;
                        creditSum = BCMConstant.Zero;
                    }
                    if (elim != null) {
                        elim.set("extendfrom", (Object)this.packExtendFromKey(template, line.relaModel));
                        boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)elim.getString("process"));
                        if (line.value != null && (line.value.compareTo(BCMConstant.Zero) != 0 || isDebugModel)) {
                            DynamicObject entry2;
                            isValidated = true;
                            if (!hasMerge && !this.checkAdjustPeriodStatus(line.getEntry().isFillInvestCompany() ? line.getRelaModel().getHoldCompanyNum() : line.getRelaModel().getInvCompanyNum())) {
                                noCreate.add(elim.getLong("id"));
                                continue;
                            }
                            if ((entry2 = InvElimRecorderGenHelper.genInvElimEntryDyna(this.ctx, line, template, elim, seq++, String.valueOf(groupNum))) != null && LongUtil.isvalidLong((Object)entry2.get("entity"))) {
                                entry2.set("merge", elim.get("entity"));
                                groupElimEntries.add(entry2);
                                if (line.entry.getDc() == 0) {
                                    debitSum = debitSum.add(line.value);
                                } else {
                                    creditSum = creditSum.add(line.value);
                                }
                            }
                        }
                    }
                    if (line.entry.isBalanceLine()) {
                        balanceLine = line;
                        if (line.entry.getDc() == 0) {
                            debitBalanceLine = line;
                        } else {
                            creditBalanceLine = line;
                        }
                    }
                    if (debitBalanceLine == null || creditBalanceLine == null) continue;
                    BigDecimal diff = creditSum.subtract(debitSum);
                    if (diff.compareTo(BCMConstant.Zero) > 0) {
                        balanceLine = debitBalanceLine;
                        continue;
                    }
                    balanceLine = creditBalanceLine;
                }
                seq = this.handleBalanceLine(balanceLine, debitSum, creditSum, notBalanceElimIds, elim, groupElimEntries, template, seq, groupNum, true);
                this.deleteInvalidateElimRecord(template, elims, isValidated);
            }
            if (CollectionUtils.isEmpty((Collection)groupElimEntries)) continue;
            this.dealGroupElimEntriesOrder(groupElimEntries);
            elimEntries.addAll(groupElimEntries);
        }
        if (!isDebugModel) {
            elimEntries.removeIf(e -> BCMConstant.Zero.compareTo(e.getBigDecimal("debit")) == 0 && BCMConstant.Zero.compareTo(e.getBigDecimal("credit")) == 0);
        }
        int size = String.valueOf(elimEntries.size()).length();
        HashSet<Long> hasEntryHeaderIds = new HashSet<Long>(16);
        for (DynamicObject elimEntry2 : elimEntries) {
            hasEntryHeaderIds.add(elimEntry2.getLong("adjust"));
            elimEntry2.set("dseq", (Object)InvElimGenerateService.formatSeq(size, elimEntry2.getInt("dseq")));
        }
        hasEntryHeaderIds.addAll(noCreate);
        elims.removeIf(e -> !hasEntryHeaderIds.contains(e.getLong("id")));
        elimEntries.removeIf(elimEntry -> noCreate.contains(elimEntry.getLong("adjust")));
        this.generatCount = elims.size();
        try (TXHandle x = TX.required();){
            try {
                Map<String, String> noNeedCreateSet = this.deleteOldRecord();
                HashSet<Long> noNeedCreatePkSet = new HashSet<Long>(16);
                AdjustCheckBalanceContext adjustCheckBalanceContext = new AdjustCheckBalanceContext(this.ctx.getModelId(), elims, elimEntries);
                if (!elims.isEmpty() && !elimEntries.isEmpty()) {
                    for (DynamicObject elim : elims) {
                        if (noNeedCreateSet.containsKey(elim.getString("extendfrom"))) {
                            noNeedCreatePkSet.add(elim.getLong("id"));
                            continue;
                        }
                        AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)elim, (Collection)adjustCheckBalanceContext.getAdjustDataDys().get(elim.getLong("id")), (boolean)false);
                        AdjustConvertUtil.resetSeq(adjustCheckBalanceContext.getAdjustDataDys().get(elim.getLong("id")));
                    }
                }
                if (!elimEntries.isEmpty()) {
                    elimEntries.removeIf(entry -> noNeedCreatePkSet.contains(entry.getLong("adjust")));
                    SaveServiceHelper.save((DynamicObject[])elimEntries.toArray(new DynamicObject[0]));
                }
                elims.removeIf(e -> noNeedCreatePkSet.contains(e.getLong("id")));
                if (!elims.isEmpty()) {
                    AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", elims);
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)elims.get(0)).getDataEntityType(), (Object[])elims.toArray());
                    List<Long> auditElimIds = elims.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                    List<Long> autoCreateAdjust = elims.stream().filter(dy -> InvSheetEntryConstant.LinkCreateTypeEnum.AUTOCREATEADJUST.getValue().equals(dy.getString("linkcreatetype"))).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    Map<Object, Object> src2LinkIdMap = new HashMap(16);
                    if (!autoCreateAdjust.isEmpty()) {
                        LinkageDataCollector collector = new LinkageMappingService((Long)this.ctx.getModelId(), (Long)this.ctx.getFyId(), (Long)this.ctx.getScenarioId(), (Long)this.ctx.getPeriodId(), autoCreateAdjust, EntrySourceEnum.INVLINKAGECREATE).buildAutoElimLinkage();
                        src2LinkIdMap = collector.getSourceId2LinkageIdMap();
                        elimEntries.addAll(collector.getCreateLinkageDatas());
                        if (collector.getRetainHistoryLinkDatas() != null) {
                            elimEntries.addAll(Arrays.asList(collector.getRetainHistoryLinkDatas()));
                        }
                    }
                    HashBasedTable<Long, Long, List<String>> newLockScope = AdjustOperationHelper.batchCheckOlapDataLock(ResManager.loadKDString((String)"\u6743\u76ca\u6a21\u677f\uff08\u751f\u6210\u65b0\u5206\u5f55\uff09", (String)"InvElimGenerateService_11", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, elimEntries, null);
                    HashSet<DynamicObject> toSaveStatusSet = new HashSet<DynamicObject>(16);
                    HashSet<String> lockExtendfromSet = new HashSet<String>(16);
                    for (DynamicObject elim : elims) {
                        if (BalanceTypeEnum.UNBALANCE.index == elim.getInt("balancetype")) continue;
                        long cvtBeforeCurrency = elim.getLong("cvtbeforecurrency.id");
                        boolean isMutifiCurr = "1".equals(elim.getString("multiplecurrency"));
                        long elimId = elim.getLong("id");
                        boolean isBalance = AdjustOperationHelper.checkAdjustDataBalance(this.ctx.getModelId(), elim.getString("balancetype"), adjustCheckBalanceContext.getAdjustDatas().get(elim.getLong("id")), cvtBeforeCurrency, isMutifiCurr);
                        if (isBalance) {
                            long linkId = src2LinkIdMap.getOrDefault(elimId, 0L);
                            if (newLockScope.containsRow((Object)elimId)) {
                                elim.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
                                toSaveStatusSet.add(elim);
                                auditElimIds.remove(elimId);
                                lockExtendfromSet.add(String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"InvElimGenerateService_15", (String)"fi-bcm-business", (Object[])new Object[0]), elim.getString("extendfrom"), newLockScope.row((Object)elimId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                                continue;
                            }
                            if (newLockScope.containsRow((Object)linkId)) {
                                elim.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
                                toSaveStatusSet.add(elim);
                                auditElimIds.remove(elimId);
                                lockExtendfromSet.add(String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8)%1$s[%2$s]", (String)"InvElimGenerateService_16", (String)"fi-bcm-business", (Object[])new Object[0]), elim.getString("extendfrom"), newLockScope.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                                continue;
                            }
                            if (!LongUtil.isvalidLong((Object)linkId)) continue;
                            auditElimIds.remove(linkId);
                            continue;
                        }
                        auditElimIds.remove(elim.getLong("id"));
                    }
                    if (!lockExtendfromSet.isEmpty()) {
                        this.errMsg.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u6570\u636e\u5df2\u7ecf\u5206\u9636\u6bb5\u9501\u5b9a\uff0c\u5df2\u81ea\u52a8\u8f6c\u4e3a\u4fdd\u5b58\uff0c\u5982\u4e0b\u6240\u793a : %s", (String)"InvElimGenerateService_22", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", lockExtendfromSet)));
                    }
                    if (!toSaveStatusSet.isEmpty()) {
                        SaveServiceHelper.update((DynamicObject[])toSaveStatusSet.toArray(new DynamicObject[0]));
                    }
                    if (!auditElimIds.isEmpty()) {
                        AdjustCheckServiceHelper.doSysToMdd(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), auditElimIds, true);
                    }
                }
            }
            catch (Exception e2) {
                x.markRollback();
                throw e2;
            }
        }
    }

    private DynamicObject createElimDyAndCollect(List<DynamicObject> elims, List<Long> templateUnbalanceElimIds, InvElimTemplateModel template, BalanceTypeEnum balanceType) {
        DynamicObject elim = InvElimRecorderGenHelper.genInvElimHeadDyna(template, null, this.ctx);
        elims.add(elim);
        if (balanceType == BalanceTypeEnum.UNBALANCE) {
            templateUnbalanceElimIds.add(elim.getLong("id"));
        }
        return elim;
    }

    private String packExtendFromKey(InvElimTemplateModel template, RelaModel relaModel) {
        if (OrgRelaProcessMembPool.isRelaProcess((String)template.getProcess())) {
            return template.getNumber().concat("(").concat(template.getProcess()).concat(")");
        }
        return template.getNumber().concat("(").concat(relaModel.holdCompanyNum).concat("->").concat(relaModel.invCompanyNum).concat(")");
    }

    private void dealGroupElimEntriesOrder(List<DynamicObject> tempElimEntries) {
        tempElimEntries.sort(Comparator.comparingInt(e -> e.getInt("dseq")));
        for (int i = 0; i < tempElimEntries.size(); ++i) {
            DynamicObject elimEntry = tempElimEntries.get(i);
            elimEntry.set("dseq", (Object)(i + 1));
        }
    }

    private static String formatSeq(int size, int seq) {
        return String.format("%0" + size + "d", seq);
    }

    private void deleteInvalidateElimRecord(InvElimTemplateModel template, List<DynamicObject> elims, boolean isValidated) {
        if (template.isUsedInvAdjElimTmpl() && elims.size() > 0 && !isValidated) {
            elims.remove(elims.size() - 1);
        }
    }

    private int handleBalanceLine(InvCalcLine balanceLine, BigDecimal debitSum, BigDecimal creditSum, List<Long> notBalanceElimIds, DynamicObject elim, List<DynamicObject> elimEntries, InvElimTemplateModel template, int seq, int groupNum, boolean isElimEnd) {
        if (balanceLine == null && isElimEnd && debitSum.compareTo(creditSum) != 0) {
            notBalanceElimIds.add(elim.getLong("id"));
        }
        if (balanceLine != null) {
            DynamicObject bl;
            BigDecimal bigDecimal = balanceLine.value = balanceLine.entry.getDc() == 0 ? creditSum.subtract(debitSum) : debitSum.subtract(creditSum);
            if (balanceLine.value.compareTo(BCMConstant.Zero) != 0 && (bl = InvElimRecorderGenHelper.genInvElimEntryDyna(this.ctx, balanceLine, template, elim, seq++, String.valueOf(groupNum))) != null) {
                elimEntries.add(bl);
            }
        }
        return seq;
    }

    private List<String> getProcesses() {
        List process;
        if (this.specifiedProcess != null) {
            return new ArrayList<String>(this.specifiedProcess);
        }
        if (this.elimTemplateType == 1) {
            process = InvProcessEnum.getAllNumber();
            process.removeAll(InvProcessEnum.getAllADJNumber());
        } else {
            process = this.elimTemplateType == 2 ? Lists.newArrayList((Object[])new String[]{"RAdj", "ERAdj"}) : Lists.newArrayList((Object[])new String[]{"IRpt", "ADJ", "EJE", "EOE", "EOther"});
        }
        return process;
    }

    private Map<String, String> deleteOldRecord() {
        QFilter auditQf = new QFilter("entrysource", "=", (Object)"5");
        if (this.elimTemplateType == 3) {
            auditQf.and(AdjustmentServiceHelper.getAdjustDataQFByProcess(this.getProcesses(), this.invCompanyNumSet, Sets.newHashSet((Object[])new String[]{this.ctx.getOrgUnitNumber()})));
        } else if (this.elimTemplateType == 2) {
            auditQf.and(AdjustmentServiceHelper.getAdjustDataQFByProcess(this.getProcesses(), Collections.singleton(this.ctx.getDetailEntity().p2), null));
        } else if (this.elimTemplateType == 1) {
            auditQf.and(AdjustmentServiceHelper.getAdjustDataQFByProcess(this.getProcesses(), null, Sets.newHashSet((Object[])new String[]{this.ctx.getOrgUnitNumber()})));
        }
        Set<Long> adjustIdSet = AdjustQueryServiceHelper.queryAdjustIds(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), null, Collections.singletonList(auditQf));
        if (WatchLoggerUtil.isDebug()) {
            log.error("elimTemplateType :" + this.elimTemplateType + ";qf : " + auditQf + ";rela : " + this.relaModels + ";templateNum2RelaSet : " + this.templateNum2RelaSet);
        }
        ArrayList<Long> allAdjustids = new ArrayList<Long>();
        QFilter qFilter = new QFilter("id", "in", adjustIdSet);
        if (!CollectionUtil.isEmpty(this.templateIds)) {
            qFilter.and("checkrecord", "in", this.templateIds);
        }
        HashMap extendfromMap = new HashMap(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryInvDeleteAdj", (String)"bcm_rptadjust", (String)"id,extendfrom,linkagelinksource,status,sourcetype", (QFilter[])qFilter.toArray(), null);){
            ds.forEachRemaining(row -> {
                if (ElimRptAdjSourceTypeEnum.MANUAL.getValue() != row.getInteger("sourcetype").intValue() && (this.templateNum2RelaSet.isEmpty() || StringUtils.isEmpty((CharSequence)row.getString("extendfrom")) || this.templateNum2RelaSet.contains(row.getString("extendfrom")))) {
                    allAdjustids.add(row.getLong("id"));
                    if (RptAdjustStatusEnum.AUDIT.status().equals(row.getString("status"))) {
                        extendfromMap.put(row.getLong("id"), row.getString("extendfrom"));
                    }
                }
            });
        }
        HashMap<String, String> noNeedCreateSet = new HashMap<String, String>(16);
        if (!allAdjustids.isEmpty()) {
            Map<Long, HashBasedTable<Long, Long, List<String>>> delLockScope = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(ResManager.loadKDString((String)"\u6743\u76ca\u6a21\u677f\uff08\u5220\u9664\u5386\u53f2\u5206\u5f55\uff09", (String)"InvElimGenerateService_10", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, extendfromMap.keySet(), null);
            for (Long adjustId : new ArrayList(allAdjustids)) {
                HashBasedTable<Long, Long, List<String>> detailTable = delLockScope.get(adjustId);
                String extendfrom = (String)extendfromMap.get(adjustId);
                if (detailTable == null || extendfrom == null) continue;
                allAdjustids.remove(adjustId);
                if (detailTable.containsRow((Object)adjustId)) {
                    noNeedCreateSet.put(extendfrom, String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"InvElimGenerateService_15", (String)"fi-bcm-business", (Object[])new Object[0]), extendfrom, detailTable.row((Object)adjustId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                    continue;
                }
                noNeedCreateSet.put(extendfrom, String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8/\u5171\u4eab)%1$s[%2$s]", (String)"InvElimGenerateService_20", (String)"fi-bcm-business", (Object[])new Object[0]), extendfrom, detailTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
            }
            if (!noNeedCreateSet.isEmpty()) {
                this.errMsg.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6a21\u677f%s\u5bf9\u5e94\u7684\u5386\u53f2\u5206\u5f55\u5df2\u7ecf\u5206\u9636\u6bb5\u6570\u636e\u9501\u5b9a\uff0c\u65e0\u6cd5\u6253\u56de", (String)"InvElimGenerateService_23", (String)"fi-bcm-business", (Object[])new Object[0]), noNeedCreateSet.values()));
            }
            AdjustClearServiceHelper.batchDeleteAutoAdjust("InvElimGenerateService.deleteOldRecord", this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), allAdjustids);
        }
        return noNeedCreateSet;
    }

    private Map<String, Long> queryHoldingCompany() {
        HashMap<String, Long> map = new HashMap<String, Long>(this.relaModels.size() * 2);
        for (RelaModel rela : this.relaModels) {
            Long orgId = InvestServiceHelper.queryEffectiveOrg(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), this.ctx.getOrgUnitId(), rela.holdCompanyNum);
            if (orgId != 0L) {
                map.put(rela.holdCompanyNum, orgId);
            }
            if ((orgId = InvestServiceHelper.queryEffectiveOrg(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), this.ctx.getOrgUnitId(), rela.invCompanyNum)) == 0L) continue;
            map.put(rela.invCompanyNum, orgId);
        }
        return map;
    }

    private void doCalculate() {
        HashMap<ExpressStatus, PChildFormulaLogInfo> pChildFormulaLogInfoMap = new HashMap<ExpressStatus, PChildFormulaLogInfo>();
        this.pFormulaLogInfoMap.values().forEach(p -> p.getChildExpressMap().values().forEach(childExpress -> pChildFormulaLogInfoMap.put(this.calcService.addCalculateExpress(childExpress.getFormula()), (PChildFormulaLogInfo)childExpress)));
        this.calcService.batchCalculate();
        pChildFormulaLogInfoMap.forEach((expressStatus, pFormulaLogInfo) -> {
            pFormulaLogInfo.setFormula(this.calcService.trans2FormulaEexprss((ExpressStatus)expressStatus));
            pFormulaLogInfo.setEvalExpress(this.calcService.trans2EvalExpress((ExpressStatus)expressStatus));
            pFormulaLogInfo.setVal(this.calcService.evalExpress((ExpressStatus)expressStatus));
        });
        pChildFormulaLogInfoMap.clear();
        long modelId = this.ctx.getModelId();
        Map<String, Integer> accountScale = CurrencyScaleHandler.getAccountScale(modelId);
        int precision = this.getCurrencyPrecision();
        this.calcPool.forEach(line -> {
            try {
                if (line.entry.isBalanceLine()) {
                    return;
                }
                int linePrecision = precision;
                String accountNumber = line.getEntry().getAcct();
                if (accountScale.get(accountNumber) != null) {
                    linePrecision = (Integer)accountScale.get(accountNumber);
                }
                if (ObjectUtils.isEmpty((Object)line.status)) {
                    return;
                }
                Object value = this.calcService.evalExpress(line.status);
                if (line.status.hasException()) {
                    line.setHasError(true);
                    line.value = BigDecimal.ZERO;
                    line.debugFormula = this.calcService.trans2FormulaEexprss(line.status) + "=" + AdjustmentServiceHelper.toString_Adj(line.status.getException());
                } else if (value instanceof Exception) {
                    line.setHasError(true);
                    log.error(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6570\u636e[%1$s]\u5931\u8d25\uff01", (String)"InvElimGenerateService_5", (String)"fi-bcm-business", (Object[])new Object[0]), line.ruleExpr), (Throwable)((Exception)value));
                    String temp = ThrowableHelper.toString((Exception)((Exception)value));
                    line.debugFormula = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6570\u636e[%1$s]\u5931\u8d25,param[\u6295\u8d44\u516c\u53f8:%2$s,\u88ab\u6295\u8d44\u516c\u53f8:%3$s,\u6301\u80a1\u7c7b\u578b:%4$s],cause:%5$s", (String)"InvElimGenerateService_3", (String)"fi-bcm-business", (Object[])new Object[0]), line.ruleExpr, line.relaModel.holdCompanyNum, line.relaModel.invCompanyNum, line.relaType.p2, temp.substring(0, Math.min(temp.length(), 400)));
                    line.value = BigDecimal.ZERO;
                } else {
                    line.value = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(StringUtils.isBlank((CharSequence)String.valueOf(value)) ? "0" : String.valueOf(value));
                    line.value = line.value.setScale(linePrecision, RoundingMode.HALF_UP);
                    line.debugFormula = "\n=" + this.calcService.trans2FormulaEexprss(line.status) + "\n=" + this.calcService.trans2EvalExpress(line.status);
                    PFormulaLogInfo pFormulaLogInfo = this.pFormulaLogInfoMap.remove(line.status);
                    line.debugFormula = pFormulaLogInfo != null ? "=" + pFormulaLogInfo.getSpecialShowStyle() + line.debugFormula + "\n=" + InvestFormulaParseHelper.plantPFormulaLogInfoString(Collections.singleton(pFormulaLogInfo)) : "=" + this.calcService.trans2FormulaEexprss(line.status) + "\n=" + this.calcService.trans2EvalExpress(line.status);
                }
            }
            catch (KDBizException e) {
                line.setHasError(true);
                String temp = ThrowableHelper.toString((Exception)((Object)e));
                temp = temp == null ? "" : temp;
                this.errMsg.add(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6570\u636e[%1$s]\u5931\u8d25,param[\u6295\u8d44\u516c\u53f8:%2$s,\u88ab\u6295\u8d44\u516c\u53f8:%3$s,\u6301\u80a1\u7c7b\u578b:%4$s],cause:%5$s", (String)"InvElimGenerateService_3", (String)"fi-bcm-business", (Object[])new Object[0]), line.ruleExpr, line.relaModel.holdCompanyNum, line.relaModel.invCompanyNum, line.relaType.p2, temp.substring(0, Math.min(temp.length(), 400))));
                log.error(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6570\u636e[%1$s]\u5931\u8d25\uff01", (String)"InvElimGenerateService_5", (String)"fi-bcm-business", (Object[])new Object[0]), line.ruleExpr), (Throwable)e);
            }
        });
    }

    private int getCurrencyPrecision() {
        QFilter currencyFilter;
        QFilter scenarioFilter;
        String selectFields = "scaleentry.scale as scale";
        QFilter modelFilter = new QFilter("model.id", "=", (Object)this.ctx.getModelId());
        QFilter[] filters = new QFilter[]{modelFilter, scenarioFilter = new QFilter("id", "=", (Object)this.ctx.getScenarioId()), currencyFilter = new QFilter("scaleentry.currency.number", "=", (Object)this.getUnitCurrency())};
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)selectFields, (QFilter[])filters);
        if (dimObj == null || dimObj.get("scale") == null) {
            return 2;
        }
        return dimObj.getInt("scale");
    }

    private void parseCalcExpression() {
        InvestFormulaContext _ctx = this.getInvestFormulaContext();
        this.calcPool.forEach(line -> {
            if (line.entry.isBalanceLine()) {
                return;
            }
            try {
                if (ObjectUtils.isEmpty((Object)line.ruleExpr)) {
                    return;
                }
                if (line.entry.isSection()) {
                    Pair<String, PFormulaLogInfo> resultPair = InvestFormulaParseHelper.buildWholePChildFormula(this.getInvestFormulaContext(), line, l -> InvestFormulaParseHelper.walkExpress(_ctx, InvestFormulaParseHelper.parseFormula(line.ruleExpr), line));
                    line.status = this.calcService.addCalculateExpress4Book((String)resultPair.p1, line.getLineId());
                    this.pFormulaLogInfoMap.put(line.status, (PFormulaLogInfo)resultPair.p2);
                } else {
                    Expression expr = InvestFormulaParseHelper.walkExpress(_ctx, InvestFormulaParseHelper.parseFormula(line.ruleExpr), line);
                    line.status = this.calcService.addCalculateExpress4Book(expr.toString(), line.getLineId());
                }
            }
            catch (Exception e) {
                line.status = new ExpressStatus(line.ruleExpr, e);
            }
        });
    }

    private InvestFormulaContext getInvestFormulaContext() {
        return (InvestFormulaContext)ThreadCache.get((Object)("InvestFormulaContext_" + this.ctx.hashCode()), () -> {
            InvestFormulaContext context = new InvestFormulaContext(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
            context.setCslschemeId(OrgServiceHelper.getCslSchemeId(this.ctx.getOrgUnitId()));
            context.setMergeOrgId(this.ctx.getOrgUnitId());
            context.setExecuteOrgId(this.ctx.getDetailEntity() != null ? ((Long)this.ctx.getDetailEntity().p1).longValue() : this.ctx.getOrgUnitId());
            return context;
        });
    }

    private void buildCrossCalcModel() {
        for (InvElimTemplateModel template : this.templates) {
            if (OrgRelaProcessMembPool.isRelaProcess((String)template.getProcess()) && !this.checkAdjustPeriodStatus(this.ctx.getOrgUnitNumber())) continue;
            for (RelaModel relaModel : this.relaTypeAndModelMap.get((Object)((String)template.getRelaType().p1 + "_" + (String)template.getRelaType().p2))) {
                if (!this.checkBindTemplate(template, relaModel)) continue;
                this.addtemplateNum2Rela(template, relaModel);
                int seq = 1;
                for (InvElimTemplateEntry entry : template.getEntries()) {
                    InvCalcLine line = new InvCalcLine();
                    line.setUnitId(this.ctx.getOrgUnitId());
                    line.setExcuteOrgId(this.ctx.getDetailEntity() == null ? LongUtil.toLong((Object)this.ctx.getOrgUnitId()) : (Long)this.ctx.getDetailEntity().p1);
                    line.setCatalog((String)template.getRelaType().p1);
                    line.setRelationType((String)template.getRelaType().p2);
                    line.setProcess(template.getProcess());
                    line.setRuleExpr(entry.getRuleExpression());
                    line.setHolderId(relaModel.holdCompanyId);
                    line.setInvestId(relaModel.invCompanyId);
                    line.setHolder(relaModel.holdCompanyNum);
                    line.setInvest(relaModel.invCompanyNum);
                    line.setLineId(Integer.toString(line.hashCode()));
                    line.setUnitNum(this.ctx.getOrgUnitNumber());
                    line.entryId = entry.getEntryId();
                    line.relaModel = relaModel;
                    line.relaType = template.getRelaType();
                    line.entry = entry;
                    line.isCvtAlone = template.isCvtAlone();
                    line.seq = seq++;
                    this.calcPool.add(template.getTemplateId(), line);
                }
            }
        }
    }

    private boolean checkBindTemplate(InvElimTemplateModel template, RelaModel relaModel) {
        Set dispenseTmplIds = relaModel.getDispenseTmpls().stream().map(p -> p.getLong("temp.id")).collect(Collectors.toSet());
        dispenseTmplIds.remove(0L);
        if (!dispenseTmplIds.isEmpty() && !dispenseTmplIds.contains(template.getTemplateId())) {
            return false;
        }
        if (dispenseTmplIds.isEmpty()) {
            boolean isOnlyLinked = template.isOnlyLinked();
            if (isOnlyLinked) {
                return false;
            }
            if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(relaModel.getCategorized()) && InvRelaTypeEnum.DirectRelaType.getType().equals(relaModel.getRelationType())) {
                boolean isUsedInvRule = (Boolean)relaModel.get("isUsedInvRule");
                boolean isConfirmedInv = (Boolean)relaModel.get("isConfirmedInv");
                return template.isUsedInvAdjElimTmpl() == isUsedInvRule && !isConfirmedInv;
            }
        }
        return true;
    }

    private boolean buildRelaModel() {
        this.relaTypeAndModelMap = HashMultimap.create();
        this.noMerge = MergeControlHelper.getNoMergeByNumber(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.ctx.getModelId());
        qf.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qf.add("year", "=", (Object)this.ctx.getFyId());
        qf.add("period", "=", (Object)this.ctx.getPeriodId());
        qf.add("orgunit.number", "=", (Object)this.ctx.getOrgUnitNumber());
        if (this.elimTemplateType == 2) {
            qf.add("shareholder.number", "=", this.ctx.getDetailEntity().p2);
            qf.add("invrelatype", "=", (Object)InvRelaTypeEnum.DirectRelaType.getType());
        }
        qf.add("isdelete", "=", (Object)"0");
        this.buildRelationMaps(qf);
        this.buildChangeRelaMaps(this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
        return this.relaModels.isEmpty();
    }

    private void buildChangeRelaMaps(long scenarioId, long yearId, long periodId) {
        Long selectedBaseOrgId = TreeStructureServiceHelper.getEntityBaseMemberId(this.ctx.getOrgUnitId());
        DynamicObjectCollection dynamicObjects = InvDynamicStockRatioHelper.loadGroupChangeTypeRelation(scenarioId, yearId, periodId, (Collection<String>)Lists.newArrayList((Object[])new String[]{"0"}), selectedBaseOrgId, InvDynamicStockRatioConstant.getSelectFields());
        dynamicObjects.stream().forEach(dy -> {
            String relaType = dy.getString("invchangetype.number");
            DynamicObjectCollection tmplEntries = dy.getDynamicObjectCollection("effecttemp");
            this.buildRelaModels(relaType, InvRelationTypeConstant.CatalogEnum.change_type.getCode(), tmplEntries, (DynamicObject)dy, false);
        });
    }

    private void buildRelationMaps(QFBuilder qf) {
        Collection<DynamicObject> coll = BusinessDataServiceHelper.loadFromCache((String)"bcm_invrelation", (QFilter[])qf.toArray()).values();
        Map<String, DynamicObject> temMap = this.checkRepeat(coll);
        for (DynamicObject dyna : temMap.values()) {
            boolean isUsedInvAdjElimTmpl = false;
            boolean isConfirmedInv = dyna.getBoolean("isconfirmed");
            String relaType = dyna.getString("invrelatype");
            boolean isUsedInvRule = dyna.getBoolean("isusedinvrule");
            DynamicObjectCollection tmplEntries = dyna.getDynamicObjectCollection("effecttemp");
            if (InvRelaTypeEnum.DirectRelaType.getType().equals(relaType)) {
                if (isConfirmedInv) continue;
                isUsedInvAdjElimTmpl = isUsedInvRule;
            } else if (InvRelaTypeEnum.INDirectRelaType.getType().equals(relaType) || InvRelaTypeEnum.MultiRelaType.getType().equals(relaType)) {
                IDNumberTreeNode node = MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)dyna.getLong("investeecompany_id"));
                String pNumber = node.getParent().getNumber();
                String key = pNumber + "!" + node.getNumber();
                if ((tmplEntries == null || tmplEntries.isEmpty()) && this.noMerge.contains(key)) continue;
            }
            this.buildRelaModels(relaType, InvRelationTypeConstant.CatalogEnum.relation.getCode(), tmplEntries, dyna, isUsedInvAdjElimTmpl);
        }
    }

    private void buildRelaModels(String relaType, String categoried, DynamicObjectCollection tmplEntries, DynamicObject dyna, boolean isUsedInvAdjElimTmpl) {
        RelaModel model = new RelaModel();
        model.isUsedInvAdjElimTmpl = isUsedInvAdjElimTmpl;
        model.holdCompanyId = dyna.getLong("shareholder_id");
        model.holdCompanyNum = dyna.getString("shareholder.number");
        model.holdCompanyName = dyna.getString("shareholder.name");
        model.invCompanyId = dyna.getLong("investeecompany_id");
        model.invCompanyNum = dyna.getString("investeecompany.number");
        model.invCompanyName = dyna.getString("investeecompany.name");
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categoried)) {
            model.put("isUsedInvRule", dyna.getBoolean("isusedinvrule"));
            model.put("isConfirmedInv", dyna.getBoolean("isconfirmed"));
            model.put("minConfirmScale", dyna.getBigDecimal("minconfirmscale"));
        }
        model.setRelationType(relaType);
        model.setCategorized(categoried);
        this.invCompanyNumSet.add(model.holdCompanyNum);
        if (tmplEntries != null) {
            tmplEntries.forEach(e -> {
                if (!PaperTemplateScenarioSettingConstant.ExceptEnum.NOT_APPLICABLE.getCode().equals(e.getString("isexcept")) && "bcm_invelimtemplatebase".equals(e.getString("temtype"))) {
                    model.dispenseTmpls.add((DynamicObject)e);
                }
            });
        }
        this.relaModels.add(model);
        this.relaTypeAndModelMap.put((Object)(categoried + "_" + relaType), (Object)model);
    }

    private void initInvRelaCurrency() {
    }

    private boolean buildElimTemplateModel() {
        QFilter newQF;
        QFilter oldQF;
        Set<String> tplNumbers = InvTemplateDistributionService.queryTemplateByEntityId(this.ctx.getModelId(), this.ctx.getOrgUnitId(), "bcm_invelimtplassign");
        if (CollectionUtils.isEmpty(tplNumbers)) {
            return true;
        }
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.ctx.getModelId());
        qf.add("billstatus", "=", (Object)"C");
        Set<Long> applySceneTmpls = CheckUtil.getApplySceneTmpls(this.ctx.getModelId(), this.ctx.getScenarioId(), "bcm_invelimtemplate");
        if (!CollectionUtil.isEmpty(this.templateIds)) {
            applySceneTmpls.retainAll(this.templateIds);
        }
        qf.add("id", "in", applySceneTmpls);
        List<String> process = this.getProcesses();
        if (this.elimTemplateType == 1) {
            process.retainAll(Lists.newArrayList((Object[])new String[]{"ADJ", "EJE", "EOE", "EOther", "CCADJ", "CADJ"}));
            oldQF = new QFilter("adjustment", "=", (Object)"0").and("process", "=", (Object)0L).or("process.number", "in", process);
            newQF = new QFilter("adjustment", "=", (Object)"1").and("process.number", "in", this.getProcesses());
            qf.add(oldQF.or(newQF));
        } else if (this.elimTemplateType == 2) {
            process.retainAll(Lists.newArrayList((Object[])new String[]{"IRpt"}));
            oldQF = new QFilter("adjustment", "=", (Object)"1").and("process", "=", (Object)0L).or("process.number", "in", process);
            newQF = new QFilter("process.number", "in", this.getProcesses());
            qf.add(oldQF.or(newQF));
        }
        qf.add("billno", "in", tplNumbers);
        Collection coll = BusinessDataServiceHelper.loadFromCache((String)"bcm_invelimtemplate", (QFilter[])qf.toArray()).values();
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(this.ctx.getModelId());
        for (DynamicObject dyna : coll) {
            if (!ConvertDifferenceHandle.isApply(this.ctx.getFyId(), this.ctx.getPeriodId(), dyna.getDynamicObjectCollection("effective"), yearIdsList)) continue;
            this.templates.add(InvElimTemplateModel.load2Model(dyna));
        }
        return this.templates.isEmpty();
    }

    private Map<String, DynamicObject> checkRepeat(Collection<DynamicObject> coll) {
        HashMap<String, DynamicObject> temMap = new HashMap<String, DynamicObject>(coll.size());
        for (DynamicObject dyna : coll) {
            String invkey = dyna.getString("invrelatype") + "->" + dyna.getString("orgunit.number") + "->" + dyna.getString("shareholder.number") + "->" + dyna.getString("investeecompany.number");
            DynamicObject v = (DynamicObject)temMap.get(invkey);
            if (v != null) {
                if (this.checkModify(dyna)) {
                    v.set("confirmscale", (Object)dyna.getBigDecimal("confirmscale"));
                    v.set("minconfirmscale", (Object)dyna.getBigDecimal("minconfirmscale"));
                    v.set("ismodified", dyna.get("ismodified"));
                    continue;
                }
                v.set("equvscale", (Object)dyna.getBigDecimal("equvscale"));
                continue;
            }
            temMap.put(invkey, dyna);
        }
        return temMap;
    }

    private boolean checkModify(DynamicObject v) {
        BigDecimal equvscale = v.getBigDecimal("equvscale");
        BigDecimal confirmScale = v.getInt("invrelatype") > 3 ? v.getBigDecimal("minconfirmscale") : v.getBigDecimal("confirmscale");
        return v.getBoolean("ismodified") || equvscale.compareTo(confirmScale) != 0;
    }

    private String getRealOrgNumber(String orgNumber, InvCalcLine line, String defaultNumber) {
        if (Objects.equals("HOLDER", orgNumber)) {
            return line.relaModel.holdCompanyNum;
        }
        if (Objects.equals("INVESTORG", orgNumber)) {
            return line.relaModel.invCompanyNum;
        }
        if (StringUtils.isEmpty((CharSequence)orgNumber)) {
            return this.getRealOrgNumber(defaultNumber, line, "");
        }
        return orgNumber;
    }

    private Date[] getStartAndEndDate(long modelId, long fyId, long periodId) {
        return (Date[])ThreadCache.get((Object)("StartAndEndDate" + modelId + fyId + periodId), () -> PeriodUtils.calcStartAndEndDate((long)modelId, (long)fyId, (long)periodId));
    }

    private DynamicObject getModel(long modelId) {
        return (DynamicObject)ThreadCache.get((Object)("model" + modelId), () -> BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model"));
    }

    static {
        processMap.put("EIRpt", "IRpt");
        processMap.put("ERAdj", "RAdj");
        processMap.put("ERpt", "Rpt");
        processMap.put("CS", "Rpt");
    }

    private static class CvtSplitItem {
        private String entity;
        private String fy;
        private String period;
        private String cvtCurrency;
        private String scenario;

        private CvtSplitItem() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append((Object)this.entity).append((Object)this.fy).append((Object)this.period).append((Object)this.cvtCurrency).append((Object)this.scenario).toString();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.entity).append((Object)this.fy).append((Object)this.period).append((Object)this.cvtCurrency).append((Object)this.scenario).hashCode();
        }

        public boolean equals(Object oth) {
            if (!(oth instanceof CvtSplitItem)) {
                return false;
            }
            CvtSplitItem item = (CvtSplitItem)oth;
            return new EqualsBuilder().append((Object)this.entity, (Object)item.entity).append((Object)this.fy, (Object)item.fy).append((Object)this.period, (Object)item.period).append((Object)this.cvtCurrency, (Object)item.cvtCurrency).append((Object)this.scenario, (Object)item.scenario).isEquals();
        }
    }
}

