/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.elimination;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.elimination.model.GenerateContext;
import kd.fi.bcm.business.invest.elimination.model.InvElimTemplateModel;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class InvElimRecorderGenHelper {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvElimRecorderGenHelper.class);

    public static DynamicObject genInvElimHeadDyna(InvElimTemplateModel template, String number, GenerateContext ctx) {
        DynamicObject elimInfo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
        elimInfo.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        elimInfo.set("linkagelinksource", (Object)0L);
        elimInfo.set("name", (Object)(template.getName() + "_" + ctx.getFyName() + "_" + ctx.getPeriodName()));
        elimInfo.set("model", (Object)ctx.getModelId());
        elimInfo.set("scenario", (Object)ctx.getScenarioId());
        elimInfo.set("year", (Object)ctx.getFyId());
        elimInfo.set("period", (Object)ctx.getPeriodId());
        elimInfo.set("modifier", (Object)ctx.getUser());
        elimInfo.set("modifytime", (Object)ctx.getNowTime());
        elimInfo.set("creator", (Object)ctx.getUser());
        elimInfo.set("createtime", (Object)ctx.getNowTime());
        elimInfo.set("spreadjson", null);
        elimInfo.set("data", null);
        elimInfo.set("iscontinuous", null);
        String process = template.getProcess();
        elimInfo.set("process", (Object)process);
        elimInfo.set("bussnesstype", (Object)AdjustBusinessTypeUtil.getBusinessTypeByProcess(process));
        elimInfo.set("belongorg", (Object)ctx.getOrgUnitId());
        elimInfo.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
        elimInfo.set("journaltype", (Object)template.getJournaltype());
        elimInfo.set("balancetype", (Object)template.getBalanceType().getIndex());
        elimInfo.set("linkcreatetype", (Object)template.getLinkCreateType().getValue());
        elimInfo.set("templatecatalog", (Object)template.getTemplatecatalog());
        elimInfo.set("description", (Object)ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210-\u6743\u76ca\u62b5\u9500", (String)"InvElimRecorderGenHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        elimInfo.set("entity", (Object)ctx.getOrgUnitId());
        elimInfo.set("extend", null);
        elimInfo.set("checkrecord", (Object)template.getTemplateId());
        elimInfo.set("number", (Object)number);
        elimInfo.set("entrysource", (Object)"0");
        elimInfo.set("multiplecurrency", (Object)"0");
        elimInfo.set("cvtbeforecurrency", (Object)0L);
        elimInfo.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.AUTO.getValue());
        DynamicObjectCollection commembentry = elimInfo.getDynamicObjectCollection("commembentry");
        int seq = 1;
        DynamicObjectType type = commembentry.getDynamicObjectType();
        for (Map.Entry<Long, Long> entry : ctx.getCommDimMap().entrySet()) {
            commembentry.add((Object)InvElimRecorderGenHelper.getCommonDimDynamicObject(type, entry.getKey(), entry.getValue(), seq++));
        }
        InvElimRecorderGenHelper.dealProcessCY(ctx, process, commembentry, type);
        DynamicObjectCollection spreadmembentry = elimInfo.getDynamicObjectCollection("spreadmembentry");
        type = spreadmembentry.getDynamicObjectType();
        seq = 1;
        for (Long dim : ctx.getSpreadDefaultDim()) {
            spreadmembentry.add((Object)InvElimRecorderGenHelper.getSpreadDimDynamicObject(type, dim, null, seq++));
        }
        for (Long dim : ctx.getSpreadUserDefineDim()) {
            spreadmembentry.add((Object)InvElimRecorderGenHelper.getSpreadDimDynamicObject(type, dim, null, seq++));
        }
        return elimInfo;
    }

    private static void dealProcessCY(GenerateContext ctx, String process, DynamicObjectCollection commembentry, DynamicObjectType type) {
        String comDimension = "comdimension";
        for (DynamicObject entry : commembentry) {
            long dimIdCurrency;
            long dimIdProcess = ctx.getDimIdByNumber(PresetConstant.PROCESS_DIM);
            if (dimIdProcess == entry.getLong(comDimension)) {
                int dimSeq = entry.getInt("seq");
                DynamicObject processDy = InvElimRecorderGenHelper.getCommonDimDynamicObject(type, dimIdProcess, ctx.getMembId("bcm_processmembertree", process), dimSeq);
                InvElimRecorderGenHelper.setCommonDimDynamicObject(entry, processDy);
            }
            if (!"RAdj".equals(process) || (dimIdCurrency = ctx.getDimIdByNumber(PresetConstant.CURRENCY_DIM)) != entry.getLong(comDimension)) continue;
            int dimSeq = entry.getInt("seq");
            DynamicObject cyDy = InvElimRecorderGenHelper.getCommonDimDynamicObject(type, dimIdCurrency, ctx.getMembId("bcm_currencymembertree", ctx.getUnitCurrency()), dimSeq);
            InvElimRecorderGenHelper.setCommonDimDynamicObject(entry, cyDy);
        }
    }

    private static void dealEntryProcessCY(String process, GenerateContext ctx, DynamicObject dynaObj) {
        if ("RAdj".equals(process)) {
            dynaObj.set("currency", (Object)ctx.getMembId("bcm_currencymembertree", ctx.getUnitCurrency()));
        }
    }

    private static DynamicObject getCommonDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("comdimension", (Object)dimid);
        dynaObj.set("commembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private static void setCommonDimDynamicObject(DynamicObject modify, DynamicObject value) {
        modify.set("comdimension", value.get("comdimension"));
        modify.set("commembid", value.get("commembid"));
        modify.set("seq", value.get("seq"));
    }

    private static DynamicObject getSpreadDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("spreaddimension", (Object)dimid);
        dynaObj.set("spreadmembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private static long getProcessId(InvElimTemplateModel template, GenerateContext ctx) {
        return (Long)ThreadCache.get((Object)("template-" + template.getTemplateId()), () -> {
            if (StringUtils.isNotEmpty((String)template.getProcess())) {
                return MemberReader.findMemberByNumber((String)ctx.getModelNum(), (String)PresetConstant.PROCESS_DIM, (String)template.getProcess()).getId();
            }
            return template.isUsedInvAdjElimTmpl() ? ctx.getMembId("bcm_processmembertree", "IRpt") : ctx.getMembId("bcm_processmembertree", InvElimRecorderGenHelper.processEJEIsLeaf(ctx.getModelId()) ? ElimTypeEnum.EJE.getNumber() : ElimTypeEnum.EOE.getNumber());
        });
    }

    public static DynamicObject genInvElimEntryDyna(GenerateContext ctx, InvCalcLine line, InvElimTemplateModel template, DynamicObject parent, int seq, String groupNumber) {
        String entityNum;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata");
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)entityType, (Object)GlobalIdUtil.genGlobalLongId());
        dynaObj.set("dseq", (Object)line.getSeq());
        dynaObj.set("adjust", (Object)parent.getLong("id"));
        dynaObj.set("model", (Object)ctx.getModelId());
        dynaObj.set("scenario", (Object)ctx.getScenarioId());
        dynaObj.set("year", (Object)ctx.getFyId());
        dynaObj.set("period", (Object)ctx.getPeriodId());
        dynaObj.set("process", (Object)InvElimRecorderGenHelper.getProcessId(template, ctx));
        dynaObj.set("merge", (Object)ctx.getOrgUnitId());
        long entityId = 0L;
        String string = entityNum = line.getEntry().isFillInvestCompany() ? line.getRelaModel().getHoldCompanyNum() : line.getRelaModel().getInvCompanyNum();
        if (ConfigServiceHelper.getBoolParam(ctx.getModelId(), "isNeedCheckMergeStruct") || OrgRelaProcessMembPool.isRelaProcess((String)template.getProcess())) {
            entityId = InvestServiceHelper.queryEffectiveOrg(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId(), ctx.getOrgUnitId(), entityNum);
        } else {
            IDNumberTreeNode entityNode = BcmThreadCache.findMemberByNum((String)ctx.getModelNum(), (String)"Entity", (String)entityNum);
            long l = entityId = entityNode == IDNumberTreeNode.NotFoundTreeNode ? 0L : entityNode.getId();
        }
        if (!LongUtil.isvalidLong((Object)entityId)) {
            WatchLoggerUtil.debug(log, String.format(ResManager.loadKDString((String)"---invest--\u751f\u6210\u5206\u5f55\u627e\u4e0d\u5230\u53ef\u7528\u660e\u7ec6\u7ec4\u7ec7%1$s\uff0c\u6392\u67e5\u4ee5\u4e0b\u53ef\u80fd\uff1a1.\u662f\u5426\u7ec4\u7ec7\u6709\u6548;2.\u662f\u5426\u5230\u7236\u7ea7\u8def\u5f84\u6709\u4e0d\u53c2\u4e0e\u5408\u5e76\u8282\u70b9;3.\u7ec4\u7ec7\u6210\u5458\u662f\u5426\u5b58\u5728", (String)"InvElimRecorderGenHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), line.getEntry().isFillInvestCompany() ? line.getRelaModel().getHoldCompanyNum() : line.getRelaModel().getInvCompanyNum()));
            return null;
        }
        dynaObj.set("entity", (Object)entityId);
        dynaObj.set("mycompany", (Object)InvElimRecorderGenHelper.transInvDataFromValue(ctx, line, false));
        dynaObj.set("internalcompany", (Object)InvElimRecorderGenHelper.transInvDataFromValue(ctx, line, true));
        dynaObj.set("account", (Object)ctx.getMembId(DimensionServiceHelper.getDimMembEntityNumByDimNum("account"), line.getEntry().getAcct()));
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)ctx.getModelId()))) {
            dynaObj.set("changetype", (Object)ctx.getMembId(DimensionServiceHelper.getDimMembEntityNumByDimNum("changetype"), line.getEntry().getChangeType()));
        }
        if (MemberReader.isExistAuditTrailDimension((String)MemberReader.findModelNumberById((Object)ctx.getModelId()))) {
            dynaObj.set("audittrail", (Object)ctx.getMembId(DimensionServiceHelper.getDimMembEntityNumByDimNum("audittrail"), line.getEntry().getAudittrail()));
        }
        dynaObj.set("currency", (Object)(template.isUsedInvAdjElimTmpl() ? ctx.getMembId("bcm_currencymembertree", ctx.getDetailEntityCurrency() == null ? ctx.getUnitCurrency() : (String)ctx.getDetailEntityCurrency().p2) : ctx.getMembId("bcm_currencymembertree", ctx.getUnitCurrency())));
        InvElimRecorderGenHelper.dealEntryProcessCY(template.getProcess(), ctx, dynaObj);
        dynaObj.set("multigaap", line.getEntry().getOtherDimSetting().getOrDefault((Object)PresetConstant.RULE_DIM, (Pair<Long, String>)Pair.onePair((Object)Long.valueOf((long)0L), (Object)"")).p1);
        dynaObj.set("datasort", line.getEntry().getOtherDimSetting().getOrDefault((Object)PresetConstant.DATASORT_DIM, (Pair<Long, String>)Pair.onePair((Object)Long.valueOf((long)0L), (Object)"")).p1);
        ctx.getUserDefineDimFieldMapped().forEach((dimNumber, value) -> {
            Map<String, Pair<Long, String>> otherDimSetting = line.getEntry().getOtherDimSetting();
            Pair defDim = otherDimSetting.get(dimNumber);
            if (defDim == null || (Long)defDim.p1 == 0L) {
                IDNumberTreeNode member = MemberReader.findMemberByNumber((String)ctx.getModelNum(), (String)dimNumber, (String)(dimNumber + "None"));
                defDim = member != null && IDNumberTreeNode.NotFoundTreeNode != member ? Pair.onePair((Object)member.getId(), (Object)member.getNumber()) : Pair.onePair((Object)0L, (Object)"");
            }
            dynaObj.set(value, defDim.p1);
        });
        dynaObj.set("description", (Object)(String.format("%s\uff08%s->%s\uff09", template.getName(), line.getRelaModel().getHoldCompanyName(), line.getRelaModel().getInvCompanyName()) + line.getEntry().getDescription()));
        dynaObj.set("calculatecontent", (Object)line.getDebugFormula());
        dynaObj.set("entrysource", (Object)5);
        dynaObj.set("checkrecordentry", null);
        dynaObj.set("groupnum", (Object)groupNumber);
        dynaObj.set("debit", (Object)(line.getEntry().getDc() == 0 ? line.getValue() : Long.valueOf(0L)));
        dynaObj.set("credit", (Object)(line.getEntry().getDc() == 0 ? Long.valueOf(0L) : line.getValue()));
        dynaObj.set("summoney", (Object)AdjustOperationUtils.handleSummoney((BigDecimal)dynaObj.getBigDecimal("debit"), (BigDecimal)dynaObj.getBigDecimal("credit")));
        dynaObj.set("differ", (Object)0.0);
        dynaObj.set("isdefaultcurrency", (Object)"1");
        AdjustOperationHelper.fillAdjustDataOfOlapOrg(ctx.getModelNum(), parent.getString("process"), dynaObj);
        return dynaObj;
    }

    private static BigDecimal handelSummoney(InvCalcLine line) {
        if (line.getEntry().getDrcrdirect() == 1) {
            return line.getEntry().getDc() == 0 ? line.getValue() : line.getValue().negate();
        }
        if (line.getEntry().getDrcrdirect() == 2) {
            return line.getEntry().getDc() == 1 ? line.getValue() : line.getValue().negate();
        }
        return line.getValue();
    }

    private static long transInvDataFromValue(GenerateContext ctx, InvCalcLine line, boolean isIC) {
        boolean isExistDim = ctx.isExistDim(isIC ? PresetConstant.INTERNALCOMPANY_DIM : PresetConstant.MYCOMPANY_DIM);
        if (isExistDim) {
            Long df;
            Long l = df = isIC ? line.getEntry().getIcCompanyId() : line.getEntry().getMycompanyId();
            if (Objects.nonNull(df)) {
                if (LongUtil.toLong((Object)SystemVarsEnum.MC_INV_UNIT.getId()).compareTo(df) == 0) {
                    return isIC ? ctx.getICCompanyMap().getOrDefault(line.getRelaModel().getHoldCompanyNum(), 0L).longValue() : ctx.getMyCompanyMap().getOrDefault(line.getRelaModel().getHoldCompanyNum(), 0L).longValue();
                }
                if (LongUtil.toLong((Object)SystemVarsEnum.MC_SUB_UNIT.getId()).compareTo(df) == 0) {
                    return isIC ? ctx.getICCompanyMap().getOrDefault(line.getRelaModel().getInvCompanyNum(), 0L).longValue() : ctx.getMyCompanyMap().getOrDefault(line.getRelaModel().getInvCompanyNum(), 0L).longValue();
                }
                String dfnumber = isIC ? line.getEntry().getIcCompany() : line.getEntry().getMycompany();
                return ctx.getMembId(isIC ? DimensionServiceHelper.getDimMembEntityNumByDimNum(PresetConstant.INTERNALCOMPANY_DIM.toLowerCase(Locale.ROOT)) : DimensionServiceHelper.getDimMembEntityNumByDimNum(PresetConstant.MYCOMPANY_DIM.toLowerCase(Locale.ROOT)), dfnumber);
            }
        }
        return 0L;
    }

    public static boolean processEJEIsLeaf(long modelId) {
        String key = "ejeIsLeaf|" + modelId;
        if (ThreadCache.exists((Object)key)) {
            return (Boolean)ThreadCache.get((Object)key);
        }
        boolean ejeIsLeaf = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"isleaf", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)ElimTypeEnum.EJE.getNumber()).toArray()).getBoolean("isleaf");
        ThreadCache.put((Object)key, (Object)ejeIsLeaf);
        return ejeIsLeaf;
    }
}

