/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.elimination.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.invest.model.CtrlHoldingCompanyScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CommonModelEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class GenerateContext
extends AbstractContext {
    private Map<String, Long> membMapIds = new HashMap<String, Long>();
    private long userId = Long.parseLong(RequestContext.get().getUserId());
    private Date now = TimeServiceHelper.now();
    private long orgUnitId;
    private String orgUnitNumber;
    private Map<String, Long> dimIdMap;
    private String unitCurrencyNum;
    private long unitCurrencyId;
    private long cslId;
    private Set<String> commDimNumSet = new LinkedHashSet<String>();
    private Set<String> spreadDefaultDimNumSet = new LinkedHashSet<String>();
    private Map<String, Long> myCompanyMap = new HashMap<String, Long>();
    private Map<String, Long> ICCompanyMap = new HashMap<String, Long>();
    private Map<String, String> userDefineFieldMapped;
    private Map<String, Long> investCompanyMap;
    private CtrlHoldingCompanyScheme ctrlHoldingCompanyScheme;
    private List<DynamicObject> sheets;
    private Pair<Long, String> detailEntity;
    private Pair<Long, String> detailEntityCurrency;
    private String modelShowNumber;
    private String yearName;
    private String periodName;

    public GenerateContext(long modelId, long scenarioId, long fyId, long periodId, long orgUnitId) {
        super(modelId, scenarioId, fyId, periodId);
        this.init(orgUnitId, false);
    }

    public GenerateContext(long modelId, long scenarioId, long fyId, long periodId) {
        super(modelId, scenarioId, fyId, periodId);
    }

    public GenerateContext(long modelId, long scenarioId, long fyId, long periodId, long orgUnitId, boolean currencyInSpread) {
        super(modelId, scenarioId, fyId, periodId);
        this.init(orgUnitId, currencyInSpread);
    }

    public GenerateContext(long modelId, long scenarioId, long fyId, long periodId, long orgUnitId, List<DynamicObject> sheets) {
        super(modelId, scenarioId, fyId, periodId);
        this.sheets = sheets;
        this.init(orgUnitId, false);
    }

    public GenerateContext(long modelId, long scenarioId, long fyId, long periodId, long orgUnitId, long cslId) {
        super(modelId, scenarioId, fyId, periodId);
        this.cslId = cslId;
        this.init(orgUnitId, false);
    }

    private void init(long orgUnitId, boolean currencyInSpread) {
        this.orgUnitId = orgUnitId;
        this.commDimNumSet.add(PresetConstant.FY_DIM);
        this.commDimNumSet.add(PresetConstant.PERIOD_DIM);
        this.commDimNumSet.add(PresetConstant.SCENE_DIM);
        this.commDimNumSet.add(PresetConstant.PROCESS_DIM);
        this.spreadDefaultDimNumSet.add(PresetConstant.ENTITY_DIM);
        this.spreadDefaultDimNumSet.add(PresetConstant.ACCOUNT_DIM);
        if (currencyInSpread) {
            this.spreadDefaultDimNumSet.add(PresetConstant.CURRENCY_DIM);
        } else {
            this.commDimNumSet.add(PresetConstant.CURRENCY_DIM);
        }
        if (MemberReader.isExistAuditTrailDimension((long)this.getModelId())) {
            this.spreadDefaultDimNumSet.add(PresetConstant.AUDITTRIAL_DIM);
        }
        if (MemberReader.isExistChangeTypeDimension((long)this.getModelId())) {
            this.spreadDefaultDimNumSet.add(PresetConstant.CHANGETYPE_DIM);
        }
        this.spreadDefaultDimNumSet.add(PresetConstant.INTERNALCOMPANY_DIM);
        if (this.isExistDim(PresetConstant.MYCOMPANY_DIM)) {
            this.spreadDefaultDimNumSet.add(PresetConstant.MYCOMPANY_DIM);
        }
        if (this.isExistDim(PresetConstant.RULE_DIM)) {
            this.spreadDefaultDimNumSet.add(PresetConstant.RULE_DIM);
        }
        if (this.isExistDim(PresetConstant.DATASORT_DIM)) {
            this.spreadDefaultDimNumSet.add(PresetConstant.DATASORT_DIM);
        }
    }

    public Map<Long, Long> getCommDimMap() {
        LinkedHashMap<Long, Long> map = new LinkedHashMap<Long, Long>();
        map.put(this.getDimIdByNumber(PresetConstant.FY_DIM), this.getFyId());
        map.put(this.getDimIdByNumber(PresetConstant.PERIOD_DIM), this.getPeriodId());
        map.put(this.getDimIdByNumber(PresetConstant.SCENE_DIM), this.getScenarioId());
        if (DimensionServiceHelper.isCM02Model(this.getModelId())) {
            map.put(this.getDimIdByNumber(PresetConstant.PROCESS_DIM), this.getMembId("bcm_processmembertree", ElimTypeEnum.EJE.getNumber()));
        } else {
            map.put(this.getDimIdByNumber(PresetConstant.PROCESS_DIM), this.getMembId("bcm_processmembertree", ElimTypeEnum.EOE.getNumber()));
        }
        if (this.commDimNumSet.contains(PresetConstant.CURRENCY_DIM)) {
            map.put(this.getDimIdByNumber(PresetConstant.CURRENCY_DIM), this.getMembId("bcm_currencymembertree", this.detailEntityCurrency != null ? (String)this.detailEntityCurrency.p2 : this.getUnitCurrency()));
        }
        return map;
    }

    public List<Long> getSpreadDefaultDim() {
        ArrayList<Long> list = new ArrayList<Long>(this.spreadDefaultDimNumSet.size());
        for (String dim : this.spreadDefaultDimNumSet) {
            list.add(this.getDimIdByNumber(dim));
        }
        return list;
    }

    public List<Long> getSpreadUserDefineDim() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Map.Entry<String, Long> entry : this.dimIdMap.entrySet()) {
            if (this.commDimNumSet.contains(entry.getKey()) || this.spreadDefaultDimNumSet.contains(entry.getKey())) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public Map<String, String> getUserDefineDimFieldMapped() {
        if (this.userDefineFieldMapped == null) {
            this.userDefineFieldMapped = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel(this.getModelId(), false);
        }
        return this.userDefineFieldMapped;
    }

    public void genMemberId(Map<String, Set<String>> entityMemNums) {
        for (Map.Entry<String, Set<String>> entry : entityMemNums.entrySet()) {
            DynamicObjectCollection members = MemberServiceHelper.queryBaseMember(entry.getKey(), "id,number", new QFilter[]{new QFilter("number", "in", entry.getValue()), new QFilter("model", "=", (Object)this.getModelId())});
            for (DynamicObject member : members) {
                this.membMapIds.put(entry.getKey() + member.getString("number"), member.getLong("id"));
            }
        }
    }

    public Long getMembId(String entity, String number) {
        return this.membMapIds.computeIfAbsent(entity + number, k -> {
            DynamicObject baseMember = MemberServiceHelper.getBaseMember(entity, "id", new QFilter("number", "=", (Object)number).and("model", "=", (Object)this.getModelId()));
            return baseMember == null ? 0L : baseMember.getLong("id");
        });
    }

    public long getUser() {
        return this.userId;
    }

    public Date getNowTime() {
        return this.now;
    }

    public long getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(Long orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public String getOrgUnitNumber() {
        if (this.orgUnitNumber == null) {
            IDNumberTreeNode member = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)this.orgUnitId);
            this.orgUnitNumber = member.getNumber();
        }
        return this.orgUnitNumber;
    }

    public long getDimIdByNumber(String number) {
        if (this.dimIdMap == null) {
            this.initAllDimMap();
        }
        return this.dimIdMap.get(number);
    }

    public void initMyOrICCompany(Set<String> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return;
        }
        QFBuilder qf = new QFBuilder();
        qf.add("number", "in", numbers);
        qf.add("model", "=", (Object)this.getModelId());
        qf.or(new QFilter("model", "=", (Object)CommonModelEnum.DIMENSION_VAR.getModelId()).and("number", "in", (Object)SystemVarsEnum.getInvDimVars()));
        if (this.isExistDim(PresetConstant.MYCOMPANY_DIM)) {
            MemberServiceHelper.queryBaseMember("bcm_mycompanymembertree", "id,number", qf.toArray()).forEach(dyna -> this.myCompanyMap.put(dyna.getString("number"), dyna.getLong("id")));
        }
        MemberServiceHelper.queryBaseMember("bcm_icmembertree", "id,number", qf.toArray()).forEach(dyna -> this.ICCompanyMap.put(dyna.getString("number"), dyna.getLong("id")));
    }

    public Map<String, Long> getMyCompanyMap() {
        return this.myCompanyMap;
    }

    public Map<String, Long> getICCompanyMap() {
        return this.ICCompanyMap;
    }

    private void initAllDimMap() {
        if (this.dimIdMap == null) {
            this.dimIdMap = new LinkedHashMap<String, Long>(16);
            SchemeContext.getInstance(this.getModelId()).getDimensions().forEach(dim -> this.dimIdMap.put(dim.getNumber(), dim.getId()));
        }
    }

    public Map<String, Long> getAllDimMap() {
        if (this.dimIdMap == null) {
            this.initAllDimMap();
        }
        return this.dimIdMap;
    }

    public boolean isExistDim(String dimNum) {
        return this.getAllDimMap().containsKey(dimNum);
    }

    public String getUnitCurrency() {
        if (StringUtils.isEmpty((CharSequence)this.unitCurrencyNum)) {
            this.initCurrency();
        }
        return this.unitCurrencyNum;
    }

    public long getUnitCurrencyId() {
        if (StringUtils.isEmpty((CharSequence)this.unitCurrencyNum)) {
            this.initCurrency();
        }
        return this.unitCurrencyId;
    }

    public void setCurrencyInfo(String number, long id) {
        this.unitCurrencyNum = number;
        this.unitCurrencyId = id;
    }

    private void initCurrency() {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgUnitId, (String)"bcm_entitymembertree", (String)"currency.number");
        this.unitCurrencyNum = org.getString("currency.number");
        this.unitCurrencyId = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFBuilder().add("model", "=", (Object)this.getModelId()).add("number", "=", (Object)this.unitCurrencyNum).toArray()).getLong("id");
    }

    public CtrlHoldingCompanyScheme getCtrlHoldingCompanyScheme() {
        if (this.ctrlHoldingCompanyScheme == null) {
            this.ctrlHoldingCompanyScheme = new CtrlHoldingCompanyScheme(this.getModelId(), this.getCslId(), this.getScenarioId(), this.getFyId(), this.getPeriodId());
        }
        return this.ctrlHoldingCompanyScheme;
    }

    public Map<String, Long> getInvestCompanyMap() {
        return this.investCompanyMap;
    }

    public void setInvestCompanyMap(Map<String, Long> investCompanyMap) {
        this.investCompanyMap = investCompanyMap;
    }

    public Pair<Long, String> getDetailEntity() {
        return this.detailEntity;
    }

    public void setDetailEntity(Pair<Long, String> detailEntity) {
        this.detailEntity = detailEntity;
    }

    public Pair<Long, String> getDetailEntityCurrency() {
        return this.detailEntityCurrency;
    }

    public void setDetailEntityCurrency(Pair<Long, String> detailEntityCurrency) {
        this.detailEntityCurrency = detailEntityCurrency;
    }

    public List<DynamicObject> getSheets() {
        return this.sheets;
    }

    public long getCslId() {
        return this.cslId;
    }

    public String getModelShowNum() {
        if (kd.bos.util.StringUtils.isEmpty((String)this.modelShowNumber)) {
            this.modelShowNumber = MemberServiceHelper.queryMemberFromCache("bcm_model", "number,shownumber", this.getModelId()).getString("shownumber");
        }
        return this.modelShowNumber;
    }

    public String getFyName() {
        if (StringUtils.isEmpty((CharSequence)this.yearName)) {
            this.yearName = MemberReader.findFyMemberById((String)this.getModelNum(), (Long)this.getFyId()).getName();
        }
        return this.yearName;
    }

    public String getPeriodName() {
        if (StringUtils.isEmpty((CharSequence)this.periodName)) {
            this.periodName = MemberReader.findPeriodMemberById((String)this.getModelNum(), (Long)this.getPeriodId()).getName();
        }
        return this.periodName;
    }
}

