/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.elimination.model;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fs.util.StringUtils;
import kd.fi.bcm.business.invest.elimination.model.ITransfer;
import kd.fi.bcm.common.Pair;

public class InvElimTemplateEntry
implements ITransfer {
    private static List<String> otherDimKeys = Lists.newArrayList((Object[])new String[]{"datasource", "multigaap", "userdefine1", "userdefine2", "userdefine3", "userdefine4", "userdefine5", "userdefine6"});
    private String acct;
    private long acctId;
    private String changeType;
    private long changeTypeId;
    private String audittrail;
    private long audittrailId;
    private String mycompany;
    private Long mycompanyId;
    private String IcCompany;
    private Long IcCompanyId;
    private int dc = 0;
    private String ruleExpression;
    private Map<String, Pair<Long, String>> otherDimSetting = new HashMap<String, Pair<Long, String>>();
    private boolean isSection = false;
    private long entryId;
    private boolean isBalanceLine = false;
    private int drcrdirect = 0;
    private int entityType = 1;
    private int seq = 0;
    private String description;

    private InvElimTemplateEntry() {
    }

    public String getAcct() {
        return this.acct;
    }

    public Long getMycompanyId() {
        return this.mycompanyId;
    }

    public void setMycompanyId(Long mycompanyId) {
        this.mycompanyId = mycompanyId;
    }

    public Long getIcCompanyId() {
        return this.IcCompanyId;
    }

    public void setIcCompanyId(Long icCompanyId) {
        this.IcCompanyId = icCompanyId;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public String getMycompany() {
        return this.mycompany;
    }

    public String getAudittrail() {
        return this.audittrail;
    }

    public void setAudittrail(String audittrail) {
        this.audittrail = audittrail;
    }

    public long getAudittrailId() {
        return this.audittrailId;
    }

    public void setAudittrailId(long audittrailId) {
        this.audittrailId = audittrailId;
    }

    public boolean isFillInvestCompany() {
        return this.entityType == 1;
    }

    public String getIcCompany() {
        return this.IcCompany;
    }

    public long getAcctId() {
        return this.acctId;
    }

    public long getChangeTypeId() {
        return this.changeTypeId;
    }

    public int getDc() {
        return this.dc;
    }

    public boolean isSection() {
        return this.isSection;
    }

    public int getDrcrdirect() {
        return this.drcrdirect;
    }

    public String getRuleExpression() {
        return this.ruleExpression;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public Map<String, Pair<Long, String>> getOtherDimSetting() {
        return this.otherDimSetting;
    }

    public boolean isBalanceLine() {
        return this.isBalanceLine;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void trans2Model(DynamicObject entry) {
        this.entryId = entry.getLong("id");
        this.acct = entry.getString("account.number");
        this.acctId = entry.getLong("account_id");
        this.drcrdirect = entry.getInt("account.drcrdirect");
        this.changeType = entry.getString("changetype.number");
        this.changeTypeId = entry.getLong("changetype_id");
        this.audittrail = entry.getString("audittrail.number");
        this.audittrailId = entry.getLong("audittrail_id");
        this.mycompany = entry.getString("mycompany.number");
        this.mycompanyId = entry.getLong("mycompany_id");
        this.IcCompany = entry.getString("internalcompany.number");
        this.IcCompanyId = entry.getLong("internalcompany_id");
        this.dc = StringUtils.isNotEmpty((String)entry.getString("ruleexpr")) ? 0 : 1;
        this.ruleExpression = entry.getString("ruleexprsource");
        this.isBalanceLine = this.ruleExpression.trim().toLowerCase(Locale.ENGLISH).startsWith("bn");
        this.isSection = entry.getBoolean("segcalculate");
        this.entityType = entry.get("entitycomb") == null ? 1 : entry.getInt("entitycomb");
        this.seq = entry.get("seq") == null ? 1 : entry.getInt("seq");
        this.description = entry.getString("description");
        this.transOtherDimensionInfo(entry);
    }

    public void trans2ModelFromSheetSet(DynamicObject entry) {
        this.entryId = entry.getLong("id");
        this.acct = entry.getString("account.number");
        this.acctId = entry.getLong("account_id");
        this.drcrdirect = entry.getInt("account.drcrdirect");
        this.changeType = entry.getString("changetype.number");
        this.changeTypeId = entry.getLong("changetype_id");
        this.audittrail = entry.getString("audittrail.number");
        this.audittrailId = entry.getLong("audittrail_id");
        this.mycompany = entry.getString("mycompany.number");
        this.mycompanyId = entry.getLong("mycompany_id");
        this.IcCompany = entry.getString("internalcompany.number");
        this.IcCompanyId = entry.getLong("internalcompany_id");
        this.dc = StringUtils.isNotEmpty((String)entry.getString("ruleexpr")) ? 0 : 1;
        this.ruleExpression = this.dc == 0 ? entry.getString("ruleexpr") : entry.getString("ruleexprdept");
        this.isBalanceLine = this.ruleExpression.trim().toLowerCase(Locale.ENGLISH).startsWith("bn");
        this.entityType = entry.get("entitycomb") == null ? 1 : entry.getInt("entitycomb");
        this.seq = entry.get("seq") == null ? 1 : entry.getInt("seq");
        this.description = entry.getString("description");
        this.transOtherDimensionInfo(entry);
    }

    private void transOtherDimensionInfo(DynamicObject entry) {
        DynamicObject dyna = null;
        for (String dim : otherDimKeys) {
            if (entry.get(dim) == null) continue;
            dyna = entry.getDynamicObject(dim);
            this.otherDimSetting.put(dyna.getString("dimension.number"), (Pair<Long, String>)Pair.onePair((Object)dyna.getLong("id"), (Object)dyna.getString("number")));
        }
    }

    public static InvElimTemplateEntry load2ModelFromSheetSet(DynamicObject dyna) {
        InvElimTemplateEntry entry = new InvElimTemplateEntry();
        entry.trans2ModelFromSheetSet(dyna);
        return entry;
    }

    public static InvElimTemplateEntry load2Model(DynamicObject dyna) {
        InvElimTemplateEntry entry = new InvElimTemplateEntry();
        entry.trans2Model(dyna);
        return entry;
    }
}

