/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.elimination.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.invest.elimination.model.ITransfer;
import kd.fi.bcm.business.invest.elimination.model.InvElimTemplateEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetEntryConstant;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class InvElimTemplateModel
implements ITransfer {
    private Pair<String, String> relaType;
    private String number;
    private String name;
    private String desc;
    private long templateId;
    private boolean isUsedInvAdjElimTmpl = false;
    private boolean isCvtAlone = false;
    private boolean isOnlyLinked = false;
    private String process;
    private String journaltype;
    private BalanceTypeEnum balanceType;
    private Long templatecatalog;
    private InvSheetEntryConstant.LinkCreateTypeEnum linkCreateType;
    private List<InvElimTemplateEntry> entries = new ArrayList<InvElimTemplateEntry>();
    private Map<String, Object> property = new HashMap<String, Object>();

    private InvElimTemplateModel() {
    }

    public Long getTemplatecatalog() {
        return this.templatecatalog;
    }

    public void setTemplatecatalog(Long templatecatalog) {
        this.templatecatalog = templatecatalog;
    }

    public BalanceTypeEnum getBalanceType() {
        if (Objects.isNull(this.balanceType)) {
            return BalanceTypeEnum.BALANCE;
        }
        return this.balanceType;
    }

    public void setBalanceType(int enumByIndex) {
        BalanceTypeEnum balanceType = BalanceTypeEnum.getEnumByIndex((int)enumByIndex);
        if (balanceType == null) {
            balanceType = BalanceTypeEnum.BALANCE;
        }
        this.balanceType = balanceType;
    }

    public InvSheetEntryConstant.LinkCreateTypeEnum getLinkCreateType() {
        if (Objects.isNull(this.linkCreateType)) {
            return InvSheetEntryConstant.LinkCreateTypeEnum.AUTOCREATEADJUST;
        }
        return this.linkCreateType;
    }

    public void setLinkCreateType(String value) {
        InvSheetEntryConstant.LinkCreateTypeEnum linkCreateType = InvSheetEntryConstant.LinkCreateTypeEnum.getEnumByValue((String)value);
        if (linkCreateType == null) {
            linkCreateType = InvSheetEntryConstant.LinkCreateTypeEnum.AUTOCREATEADJUST;
        }
        this.linkCreateType = linkCreateType;
    }

    public Pair<String, String> getRelaType() {
        return this.relaType;
    }

    public void setRelaType(Pair relaType) {
        this.relaType = relaType;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isUsedInvAdjElimTmpl() {
        return this.isUsedInvAdjElimTmpl;
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public boolean isOnlyLinked() {
        return this.isOnlyLinked;
    }

    public List<InvElimTemplateEntry> getEntries() {
        return this.entries;
    }

    public boolean isCvtAlone() {
        return this.isCvtAlone;
    }

    public String getProcess() {
        return this.process;
    }

    public String setProcess(String process) {
        this.process = process;
        return this.process;
    }

    public String getJournaltype() {
        return this.journaltype;
    }

    public void setJournaltype(String journaltype) {
        this.journaltype = journaltype;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setProperty(String key, Object value) {
        this.property.put(key, value);
    }

    public <T> T getProperty(String key) {
        return (T)this.property.get(key);
    }

    public Object clearProperty(String key) {
        return this.property.remove(key);
    }

    @Override
    public void trans2Model(DynamicObject dyna) {
        this.templateId = dyna.getLong("id");
        this.name = dyna.getString("name");
        this.number = dyna.getString("billno");
        this.desc = dyna.getString("remark");
        this.isUsedInvAdjElimTmpl = dyna.getBoolean("adjustment");
        this.relaType = Pair.onePair((Object)dyna.getString("invrelatypebase.categorized"), (Object)dyna.getString("invrelatypebase.number"));
        this.isCvtAlone = dyna.getBoolean("iscvtalone");
        this.isOnlyLinked = dyna.getBoolean("isonlylinked");
        this.process = dyna.getString("process.number");
        this.journaltype = dyna.getString("journaltype");
        this.templatecatalog = dyna.getLong("adjustcatalog.id");
        this.balanceType = BalanceTypeEnum.getEnumByIndex((int)dyna.getInt("balancetype"));
        this.setLinkCreateType(dyna.getString("linkcreatetype"));
        DynamicObjectCollection coll = dyna.getDynamicObjectCollection("invelimtplentry");
        for (DynamicObject entry : coll) {
            this.entries.add(InvElimTemplateEntry.load2Model(entry));
        }
    }

    public static InvElimTemplateModel load2Model(DynamicObject dyna) {
        InvElimTemplateModel elim = new InvElimTemplateModel();
        elim.trans2Model(dyna);
        return elim;
    }

    public SpreadManager getSpreadManger() {
        String data = (String)this.getProperty("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return JsonSerializerUtil.toSpreadManager((String)data);
    }

    public void trans2ModelFromSheet(DynamicObject dyna) {
        this.templateId = dyna.getLong("id");
        this.name = dyna.getString("name");
        this.number = dyna.getString("number");
        this.desc = dyna.getString("remark");
        this.isUsedInvAdjElimTmpl = false;
        this.isOnlyLinked = dyna.getBoolean("isonlylinked");
        this.journaltype = dyna.getString("journaltype");
        this.templatecatalog = dyna.getLong("adjustcatalog.id");
        this.setBalanceType(dyna.getInt("balancetype"));
        this.setLinkCreateType(dyna.getString("linkcreatetype"));
        DynamicObjectCollection coll = dyna.getDynamicObjectCollection("invelimtplentry");
        for (DynamicObject entry : coll) {
            this.entries.add(InvElimTemplateEntry.load2ModelFromSheetSet(entry));
        }
    }

    public static InvElimTemplateModel trans2ModelFromSheetSet(DynamicObject dyna) {
        InvElimTemplateModel elim = new InvElimTemplateModel();
        elim.trans2ModelFromSheet(dyna);
        return elim;
    }
}

