/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;

public class InvExtDataQueryService {
    public DynamicObject[] populate(EdQueryComInfo edQueryComInfo) {
        DynamicObject[] querys = this.query(edQueryComInfo);
        DynamicObject[] orderByRows = this.orderRowById(querys);
        return orderByRows;
    }

    private DynamicObject[] query(EdQueryComInfo edQueryComInfo) {
        String selectCols = this.getSelectCols(edQueryComInfo);
        QFilter qFilter = this.setFilter(edQueryComInfo);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"bcm_extenddata_inv", (String)selectCols, (QFilter[])new QFilter[]{qFilter});
        return (DynamicObject[])datas.toArray(datas.toArray((Object[])new DynamicObject[0]));
    }

    private QFilter setFilter(EdQueryComInfo edQueryComInfo) {
        QFilter qFilter = new QFilter("modelnumber", "=", (Object)edQueryComInfo.getShowNumber()).and("extendsgroup", "=", (Object)edQueryComInfo.getExtGroup()).and("datamodel", "=", (Object)edQueryComInfo.getDatamodel());
        Map<String, Object[]> filter = edQueryComInfo.getFilter();
        Map<String, String[]> dimFilter = edQueryComInfo.getDimFilter();
        Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(dimFilter.keySet().toArray(new String[0]));
        if (filter.size() != 0) {
            filter.forEach((dimNumber, filterValue) -> qFilter.and(dimNumber, "in", filterValue));
        }
        if (fieldMappedForDims.size() != 0) {
            dimFilter.forEach((dimNumber, filterValue) -> {
                String mapped = (String)fieldMappedForDims.get(dimNumber);
                qFilter.and(mapped, "in", filterValue);
            });
        }
        if (edQueryComInfo.getCustomFilter() != null) {
            qFilter.and(edQueryComInfo.getCustomFilter());
        }
        return qFilter;
    }

    private String getSelectCols(EdQueryComInfo edQueryComInfo) {
        String[] extselects;
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("id").add("sid").add("modelnumber").add("extendsgroup").add("datamodel");
        String[] dimselects = edQueryComInfo.getDimselects();
        if (dimselects != null) {
            Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(dimselects);
            Arrays.stream(dimselects).forEach(dimSelect -> stringJoiner.add((CharSequence)fieldMappedForDims.get(dimSelect)));
        }
        if ((extselects = edQueryComInfo.getExtselects()) != null) {
            Arrays.stream(extselects).forEach(extSelect -> stringJoiner.add((CharSequence)extSelect));
        }
        stringJoiner.add("numext").add("dateext").add("textext");
        return stringJoiner.toString();
    }

    private DynamicObject[] orderRowById(DynamicObject[] mergeRows) {
        DynamicObject[] orderRows = mergeRows;
        if (mergeRows != null && mergeRows.length != 0) {
            orderRows = Arrays.stream(mergeRows).sorted(Comparator.comparing(dynamicObject -> dynamicObject.getLong("id"))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        }
        return orderRows;
    }
}

