/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.exception.EDSaveException;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import org.apache.commons.lang.StringUtils;

public class InvExtDataSaveService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(InvExtDataSaveService.class);

    public Object[] saveData(InvEDSaveComInfo saveComInfo) {
        Map<Long, EDColumn> updateValues;
        DynamicObject[] dys;
        ArrayList<DynamicObject> extendDatas = new ArrayList<DynamicObject>(16);
        EDColumn[] cols = saveComInfo.getCols();
        ArrayList<Long> deleteIds = new ArrayList<Long>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        if (cols != null && cols.length > 0) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)cols.length);
            String ownedOrg = saveComInfo.getBelongOrg();
            String mergeOrg = saveComInfo.getMerge();
            String sharehold = saveComInfo.getSharehold();
            String investOrg = saveComInfo.getInvestOrg();
            String templateNumber = saveComInfo.getTemplateNumber();
            String relationType = saveComInfo.getRelationType();
            String categorized = saveComInfo.getCategorized();
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] == null) continue;
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extenddata_inv");
                long id = ids[i];
                deleteIds.add(id);
                data.set("id", (Object)id);
                data.set("modelnumber", (Object)saveComInfo.getShowNumber());
                data.set("extendsgroup", (Object)saveComInfo.getExtGroup());
                data.set("datamodel", (Object)saveComInfo.getDatamodel());
                data.set("org", (Object)ownedOrg);
                data.set("merge", (Object)mergeOrg);
                data.set("internalcompany", (Object)sharehold);
                data.set("entity", (Object)investOrg);
                data.set("templatenumber", (Object)templateNumber);
                data.set("relationtype", (Object)relationType);
                data.set("categorized", (Object)categorized);
                data.set("exttype", (Object)"0");
                this.fillFixedDimensionData(data, saveComInfo);
                data.set("account", (Object)cols[i].getMdName());
                data.set("datatype", (Object)cols[i].getDataType());
                data.set("modifierid", (Object)currUserId);
                data.set("modifydate", (Object)now);
                data.set(InvExtDataSaveService.getValueField(cols[i].getDataType()), cols[i].getValue());
                extendDatas.add(data);
            }
        }
        if ((dys = BusinessDataServiceHelper.load((Object[])(updateValues = saveComInfo.getUpdateValues()).keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_extenddata_inv"))) != null && dys.length > 0) {
            Map<Long, DynamicObject> id2Dys = Arrays.stream(dys).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (Map.Entry<Long, EDColumn> rowEntry : updateValues.entrySet()) {
                DynamicObject data = id2Dys.get(rowEntry.getKey());
                deleteIds.add(data.getLong("id"));
                data.set("account", (Object)rowEntry.getValue().getMdName());
                data.set("datatype", (Object)rowEntry.getValue().getDataType());
                data.set("modifierid", (Object)currUserId);
                data.set("modifydate", (Object)now);
                data.set(InvExtDataSaveService.getValueField(rowEntry.getValue().getDataType()), rowEntry.getValue().getValue());
                extendDatas.add(data);
            }
        }
        return this.save(deleteIds, extendDatas.toArray(new DynamicObject[0]));
    }

    public Object[] saveData(List<InvEDSaveComInfo> saveComInfos) {
        ArrayList extendDatas = new ArrayList(16);
        ArrayList<Long> deleteIds = new ArrayList<Long>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        saveComInfos.forEach(saveComInfo -> {
            EDColumn[] cols = saveComInfo.getCols();
            if (cols != null && cols.length > 0) {
                long[] ids = GlobalIdUtil.genGlobalLongIds((int)cols.length);
                String ownedOrg = saveComInfo.getBelongOrg();
                String mergeOrg = saveComInfo.getMerge();
                String sharehold = saveComInfo.getSharehold();
                String investOrg = saveComInfo.getInvestOrg();
                String templateNumber = saveComInfo.getTemplateNumber();
                String relationType = saveComInfo.getRelationType();
                String categorized = saveComInfo.getCategorized();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] == null) continue;
                    DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extenddata_inv");
                    long id = cols[i].getId() == 0L ? ids[i] : cols[i].getId();
                    deleteIds.add(id);
                    data.set("id", (Object)id);
                    data.set("modifierid", (Object)currUserId);
                    data.set("modifydate", (Object)now);
                    data.set("modelnumber", (Object)saveComInfo.getShowNumber());
                    data.set("extendsgroup", (Object)saveComInfo.getExtGroup());
                    data.set("datamodel", (Object)saveComInfo.getDatamodel());
                    data.set("org", (Object)ownedOrg);
                    data.set("merge", (Object)mergeOrg);
                    data.set("internalcompany", (Object)sharehold);
                    data.set("entity", (Object)investOrg);
                    data.set("templatenumber", (Object)templateNumber);
                    data.set("relationtype", (Object)relationType);
                    data.set("categorized", (Object)categorized);
                    data.set("exttype", (Object)"0");
                    this.fillFixedDimensionData(data, (InvEDSaveComInfo)saveComInfo);
                    data.set("account", (Object)cols[i].getMdName());
                    data.set("datatype", (Object)cols[i].getDataType());
                    Object value = this.checkDataType(InvExtDataSaveService.getValueField(cols[i].getDataType()), cols[i].getValue());
                    if (value == null) continue;
                    if (cols[i].getDataType().equals(DataTypeEnum.DATETP.getOIndex())) {
                        String dateStr = value.toString();
                        try {
                            value = this.parseDate(dateStr, new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}, TimeZone.getTimeZone("GMT"));
                        }
                        catch (ParseException e) {
                            continue;
                        }
                    }
                    data.set(InvExtDataSaveService.getValueField(cols[i].getDataType()), value);
                    extendDatas.add(data);
                }
            }
        });
        return this.save(deleteIds, extendDatas.toArray(new DynamicObject[0]));
    }

    private Object parseDate(String str, String[] parsePatterns, TimeZone timeZone) throws ParseException {
        if (str != null && parsePatterns != null) {
            SimpleDateFormat parser = new SimpleDateFormat();
            if (timeZone != null) {
                parser.setTimeZone(timeZone);
            }
            parser.setLenient(true);
            ParsePosition pos = new ParsePosition(0);
            for (int i = 0; i < parsePatterns.length; ++i) {
                Date date;
                String pattern = parsePatterns[i];
                if (parsePatterns[i].endsWith("ZZ")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                parser.applyPattern(pattern);
                pos.setIndex(0);
                String str2 = str;
                if (parsePatterns[i].endsWith("ZZ")) {
                    int signIdx = InvExtDataSaveService.indexOfSignChars(str, 0);
                    while (signIdx >= 0) {
                        str2 = InvExtDataSaveService.reformatTimezone(str2, signIdx);
                        ++signIdx;
                        signIdx = InvExtDataSaveService.indexOfSignChars(str2, signIdx);
                    }
                }
                if ((date = parser.parse(str2, pos)) == null || pos.getIndex() != str2.length()) continue;
                return date;
            }
            throw new ParseException("Unable to parse the date: " + str, -1);
        }
        throw new IllegalArgumentException("Date and Patterns must not be null");
    }

    private static int indexOfSignChars(String str, int startPos) {
        int idx = StringUtils.indexOf((String)str, (char)'+', (int)startPos);
        if (idx < 0) {
            idx = StringUtils.indexOf((String)str, (char)'-', (int)startPos);
        }
        return idx;
    }

    private static String reformatTimezone(String str, int signIdx) {
        String str2 = str;
        if (signIdx >= 0 && signIdx + 5 < str.length() && Character.isDigit(str.charAt(signIdx + 1)) && Character.isDigit(str.charAt(signIdx + 2)) && str.charAt(signIdx + 3) == ':' && Character.isDigit(str.charAt(signIdx + 4)) && Character.isDigit(str.charAt(signIdx + 5))) {
            str2 = str.substring(0, signIdx + 3) + str.substring(signIdx + 4);
        }
        return str2;
    }

    private Object checkDataType(String valueField, Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (valueField.equals("numext")) {
            try {
                return new BigDecimal(value.toString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return value.toString();
    }

    public int deleteDataBySaveInfo(InvEDSaveComInfo saveComInfo) {
        String unitOrg = saveComInfo.getBelongOrg();
        QFilter qFilter = new QFilter("modelnumber", "=", (Object)saveComInfo.getShowNumber()).and("datamodel", "=", (Object)saveComInfo.getDatamodel()).and("extendsgroup", "=", (Object)saveComInfo.getExtGroup());
        if (!kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)unitOrg)) {
            qFilter.and("org", "=", (Object)unitOrg);
        }
        if (!kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)saveComInfo.getTemplateNumber())) {
            qFilter.and("templatenumber", "=", (Object)saveComInfo.getTemplateNumber());
        }
        saveComInfo.getfixedDimension().forEach((number, value) -> qFilter.and(SysDimensionEnum.getEnumByNumber((String)number).getSign(), "=", value));
        return this.delete("bcm_extenddata_inv", new QFilter[]{qFilter});
    }

    public int deleteDataBySaveInfo(Collection<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds);
        return this.delete("bcm_extenddata_inv", new QFilter[]{qFilter});
    }

    private void fillFixedDimensionData(DynamicObject data, InvEDSaveComInfo saveComInfo) {
        saveComInfo.getfixedDimension().forEach((number, value) -> data.set(SysDimensionEnum.getEnumByNumber((String)number).getSign(), value));
    }

    public static String getValueField(String dataType) {
        switch (dataType) {
            case "0": 
            case "1": 
            case "2": 
            case "5": {
                return "numext";
            }
            case "3": {
                return "textext";
            }
            case "4": {
                return "dateext";
            }
        }
        return "textext";
    }

    private Object[] save(List<Long> deleteIds, DynamicObject[] extendDatas) {
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extenddata_inv").getDynamicObjectType();
        Throwable throwable = null;
        try (TXHandle th = TX.required();){
            DeleteServiceHelper.delete((IDataEntityType)dynamicObjectType, (Object[])deleteIds.toArray());
            BusinessDataWriter.clearDataEntityCache((IDataEntityType)dynamicObjectType);
            Object[] objectArray = BusinessDataWriter.save((IDataEntityType)dynamicObjectType, (Object[])extendDatas);
            return objectArray;
        }
        catch (Exception e) {
            try {
                th.markRollback();
                String message = "Extend Data Save Error.";
                logger.error(message, (Throwable)e);
                throw new EDSaveException(new ErrorCode("", "Extend Data Save Error."), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private int delete(String extendEntity, QFilter[] qFilters) {
        Throwable throwable = null;
        try (TXHandle th = TX.required();){
            int n = BusinessDataWriter.delete((String)extendEntity, (QFilter[])qFilters);
            return n;
        }
        catch (Exception e) {
            try {
                th.markRollback();
                String message = "Extend Data Delete Error.";
                logger.error(message, (Throwable)e);
                throw new EDSaveException(new ErrorCode("", "Extend Data Delete Error."), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

