/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.invest.extdim.InvExtDataSaveService;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultCellTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultSet;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invlimsheet.InvExtDataConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang.StringUtils;

public class InvExtDataServiceHelper {
    public static Map<Long, DynamicObject> getSheetExtMemberByExtModel(long modelId, Long extModelId) {
        return (Map)BcmThreadCache.get((Object)"getSheetExtMemberByTemplate", (Object)modelId, (Object)extModelId, () -> ExtDimensionHelper.getSheetExtMemberByExtModel(modelId, null, extModelId).stream().collect(Collectors.toMap(p -> p.getLong("id"), p -> p, (v1, v2) -> v1)));
    }

    public static Map<String, DynamicObject> getSheetExtMemberByExtModelByNumber(long modelId, Long extModelId) {
        return (Map)BcmThreadCache.get((Object)"getSheetExtMemberByExtModelByNumber", (Object)modelId, (Object)extModelId, () -> ExtDimensionHelper.getSheetExtMemberByExtModel(modelId, null, extModelId).stream().collect(Collectors.toMap(p -> p.getString("number"), p -> p, (v1, v2) -> v1)));
    }

    public static InvEDResultSet queryData(EdQueryComInfo edCommandInfo) {
        InvEDResultSet re = new InvEDResultSet();
        re.populate(edCommandInfo);
        return re;
    }

    public static Object[] saveData(InvEDSaveComInfo saveComInfo) {
        InvExtDataServiceHelper.cvtRelationType(saveComInfo);
        InvExtDataSaveService extDataSaveService = new InvExtDataSaveService();
        return extDataSaveService.saveData(saveComInfo);
    }

    private static void cvtRelationType(InvEDSaveComInfo saveComInfo) {
        String relationType = saveComInfo.getRelationType();
        String categorized = saveComInfo.getCategorized();
        StringBuilder msgSb = new StringBuilder();
        if (!StringUtils.isBlank((String)relationType) || !StringUtils.isBlank((String)categorized)) {
            Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
            if (code2InvRelaTypeEnum.containsKey(relationType) && InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
                saveComInfo.setRelationType(((InvRelaTypeEnum)code2InvRelaTypeEnum.get(relationType)).getType());
            } else {
                Long modelId = MemberReader.findModelIdByNum((String)saveComInfo.getModelNum());
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                qFilter.and("number", "=", (Object)relationType);
                qFilter.and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
                if (!QueryServiceHelper.exists((String)"bcm_invrelatype", (QFilter[])new QFilter[]{qFilter})) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5305\u542b%s\u80a1\u6bd4\u7c7b\u578b!", (String)"InvExtDataServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), relationType));
                }
            }
        } else {
            msgSb.append(ResManager.loadKDString((String)"\u80a1\u6bd4\u7c7b\u578b\u6216\u7c7b\u578b\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvExtDataServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!StringUtils.isBlank((String)msgSb.toString())) {
            throw new KDBizException(msgSb.toString());
        }
    }

    public static Object[] saveData(List<InvEDSaveComInfo> saveComInfos) {
        saveComInfos.forEach(saveComInfo -> {
            InvExtDataServiceHelper.cvtRelationType(saveComInfo);
            InvExtDataServiceHelper.updateExtDataId(saveComInfo, InvExtDataServiceHelper.getCalValueTable(saveComInfo));
        });
        InvExtDataSaveService extDataSaveService = new InvExtDataSaveService();
        return extDataSaveService.saveData(saveComInfos);
    }

    private static void updateExtDataId(InvEDSaveComInfo saveComInfo, InvEDResultCellTable calValueTable) {
        String ownedOrg = saveComInfo.getBelongOrg();
        String mergeOrg = saveComInfo.getMerge();
        String holdCompanyNum = saveComInfo.getSharehold();
        String invCompanyNum = saveComInfo.getInvestOrg();
        String relationType = saveComInfo.getRelationType();
        String categorized = saveComInfo.getCategorized();
        EDColumn[] cols = saveComInfo.getCols();
        Arrays.stream(cols).forEach(col -> {
            Long pkId = calValueTable.getPkId(new ExtendExtUniqueKey(col.getMdName(), ownedOrg, mergeOrg, holdCompanyNum, invCompanyNum, relationType, categorized));
            if (Objects.nonNull(pkId)) {
                col.setId(pkId);
            }
        });
    }

    public static InvEDResultCellTable getCalValueTable(InvEDSaveComInfo saveComInfo) {
        String dataModel = saveComInfo.getDatamodel();
        String extGroup = saveComInfo.getExtGroup();
        String showNumber = saveComInfo.getShowNumber();
        String belongOrg = saveComInfo.getBelongOrg();
        String scenario = saveComInfo.getfixedDimension().get("Scenario");
        String year = saveComInfo.getfixedDimension().get("Year");
        String period = saveComInfo.getfixedDimension().get("Period");
        String key = showNumber + "_" + dataModel + "_" + scenario + "_" + year + "_" + period + "_" + belongOrg;
        return (InvEDResultCellTable)ThreadCache.get((Object)key, () -> {
            EdQueryComInfo edQueryComInfo = new EdQueryComInfo(showNumber, extGroup, dataModel);
            edQueryComInfo.setExtselects(InvExtDataConstant.getSelectField());
            edQueryComInfo.addDimFilter("Scenario", scenario);
            edQueryComInfo.addDimFilter("Year", year);
            edQueryComInfo.addDimFilter("Period", period);
            edQueryComInfo.addFilter("org", belongOrg);
            return InvExtDataServiceHelper.getCalValueTable(edQueryComInfo);
        });
    }

    public static InvEDResultCellTable getCalValueTable(EdQueryComInfo edQueryComInfo) {
        InvEDResultCellTable cellTable = new InvEDResultCellTable();
        cellTable.populate(InvExtDataServiceHelper.queryData(edQueryComInfo));
        return cellTable;
    }

    public static int deleteDataBySaveInfo(InvEDSaveComInfo saveComInfo) {
        InvExtDataSaveService extDataSaveService = new InvExtDataSaveService();
        return extDataSaveService.deleteDataBySaveInfo(saveComInfo);
    }

    public static int deleteDataBySaveInfo(Collection<Long> pkIds) {
        InvExtDataSaveService extDataSaveService = new InvExtDataSaveService();
        return extDataSaveService.deleteDataBySaveInfo(pkIds);
    }

    public static Boolean isExtModelExistData(String modelNum, List<String> extModelNums) {
        QFBuilder qb = new QFBuilder("modelnumber", "=", (Object)modelNum).add("datamodel", "in", extModelNums);
        return QueryServiceHelper.exists((String)"bcm_extenddata_inv", (QFilter[])qb.toArray());
    }
}

