/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.invest.extdim.InvExtDataSaveService;
import kd.fi.bcm.business.invest.extdim.InvExtDataServiceHelper;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKeyTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultCellTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.invest.sheet.InvPaperSheetIteratorService;
import kd.fi.bcm.business.invest.sheet.InvShareRelationInfo;
import kd.fi.bcm.business.invest.sheet.InvSheetDeleteInfo;
import kd.fi.bcm.business.invest.sheet.log.IInvLimSheetLogServer;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invlimsheet.InvExtDataConstant;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;

public class InvExtDataSpreadServiceHelper {
    public static String clearSpreadJsonFontFormula(String spreadJson) {
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str(spreadJson))));
        JSONObject ssjsonObject = JSON.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
        Optional.ofNullable(ssjsonObject.getJSONObject("sheets")).ifPresent(sheetsOld -> sheetsOld.forEach((name, sheetObj) -> {
            JSONObject sheet = (JSONObject)sheetObj;
            Optional.ofNullable(sheet.getJSONObject("data")).map(data -> data.getJSONObject("dataTable")).ifPresent(table -> table.values().forEach(colObj -> {
                JSONObject col = (JSONObject)colObj;
                col.forEach((colNum, cellObj) -> {
                    JSONObject cell = (JSONObject)cellObj;
                    if (Objects.nonNull(cell.getString("formula"))) {
                        cell.remove((Object)"value");
                    }
                    cell.remove((Object)"formula");
                });
            }));
        }));
        return "base64" + new String(Base64.getEncoder().encode(GZIPUtils.compress((String)JSON.toJSONString((Object)ssjsonObject))));
    }

    public static ExtendExtUniqueKeyTable collectExtDataUniqueKey(long templateId, String belongOrg, SpreadManager spreadManager, Predicate<Cell> test) {
        Sheet sheet = spreadManager.getBook().getSheet(0);
        String defaultRelationTypeNumber = PaperTemplateService.getDefaultRelationTypeNumber(templateId);
        String spreadType = InvExtDataSpreadServiceHelper.getSpreadType(sheet, templateId);
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        ExtendExtUniqueKeyTable extendExtUniqueKeyTable = new ExtendExtUniqueKeyTable();
        invPaperSheetIteratorService.iterationValueCellAxis((rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell) -> {
            String shareholder = (String)shareholderCell.getUserObject("number");
            String investOrg = (String)investedCell.getUserObject("number");
            String unitOrg = (String)orgCell.getUserObject("number");
            String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName(), (Object)defaultRelationTypeNumber);
            String categorized = InvElimSpreadGenerateService.getCategorized(rltCell);
            String accountNum = (String)accCell.getUserObject("number");
            if (Objects.nonNull(unitOrg) && Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.nonNull(accountNum) && (test == null || test.test((Cell)valueCell))) {
                extendExtUniqueKeyTable.add(accountNum, new InvShareRelationInfo(belongOrg, unitOrg, shareholder, investOrg, relationType, categorized));
            }
        });
        return extendExtUniqueKeyTable;
    }

    public static Set<Long> collectExtMemIdBySpreadManager(long templateId, SpreadManager spreadManager) {
        Sheet sheet = spreadManager.getBook().getSheet(0);
        HashSet<Long> extMemSet = new HashSet<Long>(16);
        String spreadType = InvExtDataSpreadServiceHelper.getSpreadType(sheet, templateId);
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        invPaperSheetIteratorService.iterationValueCellAxis((rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell) -> {
            long accId = LongUtil.toLong((Object)accCell.getUserObject("id"));
            if (LongUtil.isvalidLong((Object)accId)) {
                extMemSet.add(accId);
            }
        });
        return extMemSet;
    }

    public static void saveSpreadManagerExtData(long modelId, String sceneNum, String yearNum, String periodNum, String belongorg, DynamicObject tmp, SpreadManager spreadManager, InvSheetDeleteInfo deleteInfo, IInvLimSheetLogServer logServer) {
        String modelNum = MemberReader.findModelSNumberById((Object)modelId);
        long extModelId = tmp.getLong("extdimid");
        DynamicObject extModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.id,extendsgroup.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)extModelId)});
        if (extModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e95\u7a3f\u5bf9\u5e94\u6a21\u677f\u6ca1\u6709\u5173\u8054\u6570\u636e\u6a21\u578b\u3002", (String)"InvExtDataSpreadServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String dataModel = extModel.getString("number");
        String extGroup = extModel.getString("extendsgroup.number");
        Sheet sheet = spreadManager.getBook().getSheet(0);
        InvExtDataSpreadServiceHelper.updateSheetExtMember(spreadManager, modelId, tmp.getLong("id"));
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(modelNum, extGroup, dataModel);
        edQueryComInfo.setExtselects(InvExtDataConstant.getSelectField());
        edQueryComInfo.addDimFilter("Scenario", sceneNum);
        edQueryComInfo.addDimFilter("Year", yearNum);
        edQueryComInfo.addDimFilter("Period", periodNum);
        edQueryComInfo.addFilter("org", belongorg);
        InvEDResultCellTable calValueTable = InvExtDataServiceHelper.getCalValueTable(edQueryComInfo);
        PlatUtil.executeWithTX(tx -> {
            try {
                Set<InvEDSaveComInfo> invEDSaveComInfos = InvExtDataSpreadServiceHelper.saveExtData(modelId, sceneNum, yearNum, periodNum, belongorg, tmp, extModel, sheet, calValueTable, logServer);
                if (deleteInfo != null && deleteInfo.isClearExtData()) {
                    InvExtDataSpreadServiceHelper.dealDeleteDatas(modelId, spreadManager, calValueTable, invEDSaveComInfos, deleteInfo, extModel, tmp, logServer);
                }
                if (logServer != null) {
                    logServer.successLogAsync();
                }
            }
            catch (Throwable t) {
                if (logServer != null) {
                    logServer.failLogAsync();
                }
                throw t;
            }
        });
    }

    private static Set<InvEDSaveComInfo> saveExtData(Long modelId, String sceneNum, String yearNum, String periodNum, String belongOrgNum, DynamicObject tmp, DynamicObject extModel, Sheet sheet, InvEDResultCellTable calValueTable, IInvLimSheetLogServer logServer) {
        GlobalIdDistributer idDistribute = new GlobalIdDistributer();
        String modelNum = MemberReader.findModelSNumberById((Object)modelId);
        long templateId = tmp.getLong("id");
        String tplNumber = tmp.getString("number");
        String extGroup = extModel.getString("extendsgroup.number");
        String dataModel = extModel.getString("number");
        HashMap pos2SaveInfoMap = new HashMap(16);
        HashMap<InvEDSaveComInfo, List> info2ColsMap = new HashMap<InvEDSaveComInfo, List>(16);
        String spreadType = InvExtDataSpreadServiceHelper.getSpreadType(sheet, templateId);
        Map<String, DynamicObject> extMembers = InvExtDataServiceHelper.getSheetExtMemberByExtModelByNumber(modelId, extModel.getLong("id"));
        new InvPaperSheetIteratorService(sheet, spreadType).iterationValueCellAxis((rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell) -> {
            String unitOrg = (String)orgCell.getUserObject("number");
            String shareholder = (String)shareholderCell.getUserObject("number");
            String investOrg = (String)investedCell.getUserObject("number");
            if (Objects.nonNull(unitOrg) && Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.isNull(valueCell.getUserObject("formula_fail"))) {
                DynamicObject accDy;
                String relationType = InvExtDataSpreadServiceHelper.getRelationType(templateId, rltCell, shareholder, investOrg);
                String categorized = InvElimSpreadGenerateService.getCategorized(rltCell);
                String accNum = (String)accCell.getUserObject("number");
                if (accNum != null && (accDy = (DynamicObject)extMembers.get(accNum)) != null) {
                    InvEDSaveComInfo invEDSaveComInfo = pos2SaveInfoMap.computeIfAbsent(ExcelUtils.xy2Pos((int)rltCell.getCol(), (int)rltCell.getRow()), a -> {
                        InvEDSaveComInfo tempEDSaveComInfo = new InvEDSaveComInfo(modelNum, extGroup, dataModel);
                        tempEDSaveComInfo.addfixedDimension("Scenario", sceneNum);
                        tempEDSaveComInfo.addfixedDimension("Year", yearNum);
                        tempEDSaveComInfo.addfixedDimension("Period", periodNum);
                        tempEDSaveComInfo.setRelationType(relationType);
                        tempEDSaveComInfo.setCategorized(categorized);
                        tempEDSaveComInfo.setBelongOrg(belongOrgNum);
                        tempEDSaveComInfo.setMerge(unitOrg);
                        tempEDSaveComInfo.setSharehold(shareholder);
                        tempEDSaveComInfo.setInvestOrg(investOrg);
                        tempEDSaveComInfo.setTemplateNumber(tplNumber);
                        return tempEDSaveComInfo;
                    });
                    Object value = valueCell.getValue();
                    if (value != null) {
                        String accDatatype = accDy.getString("datatype");
                        if ("numext".equals(InvExtDataSaveService.getValueField(accDatatype))) {
                            BigDecimal newVal = InvestUtils.convertToBigDecimal((Object)value);
                            if (newVal == null) {
                                value = null;
                            } else {
                                int precision = InvestUtils.getIntegerDigits((BigDecimal)newVal);
                                if (precision > 19) {
                                    newVal = BigDecimal.ZERO;
                                } else if (newVal.scale() > 15) {
                                    newVal = newVal.setScale(15, RoundingMode.HALF_UP);
                                }
                                value = newVal.stripTrailingZeros();
                            }
                        }
                        EDColumn edColumn = new EDColumn(accNum, accDatatype, value);
                        Long pkId = calValueTable.getPkId(new ExtendExtUniqueKey(accNum, belongOrgNum, unitOrg, shareholder, investOrg, relationType, categorized));
                        if (!LongUtil.isvalidLong((Object)pkId)) {
                            pkId = idDistribute.getLongId();
                        }
                        edColumn.setId(pkId);
                        valueCell.setUserObject("eid", (Object)pkId);
                        info2ColsMap.computeIfAbsent(invEDSaveComInfo, a -> Lists.newArrayList()).add(edColumn);
                        if (logServer != null) {
                            logServer.logSheetDataSave(invEDSaveComInfo, edColumn, (Cell)valueCell);
                        }
                    }
                }
            }
        });
        info2ColsMap.forEach((invEDSaveComInfo, cols) -> invEDSaveComInfo.setCols(cols.toArray(new EDColumn[0])));
        PlatUtil.executeWithTX(tx -> new InvExtDataSaveService().saveData(Lists.newArrayList(info2ColsMap.keySet())));
        return new HashSet<InvEDSaveComInfo>(info2ColsMap.keySet());
    }

    private static void dealDeleteDatas(long modelId, SpreadManager spreadManager, InvEDResultCellTable calValueTable, Set<InvEDSaveComInfo> invEDSaveComInfos, InvSheetDeleteInfo deleteInfo, DynamicObject extModel, DynamicObject tmp, IInvLimSheetLogServer logServer) {
        String tempNumber = tmp.getString("number");
        Map<Long, DynamicObject> extMembers = InvExtDataServiceHelper.getSheetExtMemberByExtModel(modelId, extModel.getLong("id"));
        HashSet deleteIds = new HashSet(16);
        deleteInfo.getDeleteCells().forEach(uniqueKey -> {
            Long id = calValueTable.getPkId((ExtendExtUniqueKey)uniqueKey);
            if (LongUtil.isvalidLong((Object)id)) {
                deleteIds.add(id);
                if (logServer != null) {
                    logServer.logPageDataRemove(tempNumber, extModel.getString("number"), (ExtendExtUniqueKey)uniqueKey);
                }
            }
        });
        deleteInfo.getDeleteExts().forEach(accountId -> {
            DynamicObject accDy = (DynamicObject)extMembers.get(LongUtil.toLong((Object)accountId));
            invEDSaveComInfos.forEach(rela -> {
                Long id = calValueTable.getPkId(new ExtendExtUniqueKey(accDy.getString("number"), rela.getEdColumn()));
                if (LongUtil.isvalidLong((Object)id)) {
                    deleteIds.add(id);
                }
            });
        });
        Set<Long> extMemSet = InvExtDataSpreadServiceHelper.collectExtMemIdBySpreadManager(tmp.getLong("id"), spreadManager);
        extMemSet.addAll(deleteInfo.getDeleteExts());
        deleteInfo.getDeleteRelas().forEach(rela -> {
            ExtendExtUniqueKey uniqueKey = new ExtendExtUniqueKey("", rela.getBelongOrg(), rela.getMerge(), rela.getSharehold(), rela.getInvestOrg(), rela.getRelationType(), rela.getCategorized());
            extMemSet.forEach(accountId -> {
                DynamicObject accDy = (DynamicObject)extMembers.get(LongUtil.toLong((Object)accountId));
                if (accDy != null) {
                    uniqueKey.setExtendsNumber(accDy.getString("number"));
                    Long id = calValueTable.getPkId(uniqueKey);
                    if (LongUtil.isvalidLong((Object)id)) {
                        deleteIds.add(id);
                        if (logServer != null) {
                            logServer.logPageDataRemove(tempNumber, extModel.getString("number"), uniqueKey);
                        }
                    }
                }
            });
        });
        invEDSaveComInfos.forEach(info -> {
            if (info.getCols() != null) {
                Arrays.stream(info.getCols()).forEach(col -> deleteIds.remove(col.getId()));
            }
        });
        if (!deleteIds.isEmpty()) {
            PlatUtil.executeWithTX(tx -> InvExtDataServiceHelper.deleteDataBySaveInfo(deleteIds));
        }
    }

    public static String getRelationType(long templateId, Cell rltCell, String shareholder, String investOrg) {
        String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName());
        if (Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.isNull(relationType)) {
            relationType = PaperTemplateService.getDefaultRelationTypeNumber(templateId);
            rltCell.setUserObject(InvRelaTypeEnum.class.getSimpleName(), (Object)relationType);
        }
        return relationType;
    }

    public static void updateSheetExtMember(SpreadManager spreadManager, long modelId, long templateId) {
        Sheet sheet = spreadManager.getBook().getSheet(0);
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", "extdimid"), (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
        Map<String, DynamicObject> extMembers = InvExtDataServiceHelper.getSheetExtMemberByExtModelByNumber(modelId, template == null ? 0L : template.getLong("extdimid"));
        String spreadType = InvExtDataSpreadServiceHelper.getSpreadType(sheet, templateId);
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        invPaperSheetIteratorService.iterationAccCell(accCell -> {
            DynamicObject extDy;
            String number = (String)accCell.getUserObject("number");
            Long extId = (Long)accCell.getUserObject("id");
            if (StringUtils.isNotEmpty((CharSequence)number) && extId != null && (extDy = (DynamicObject)extMembers.get(number)) != null) {
                accCell.setUserObject("id", (Object)extDy.getLong("id"));
            }
        });
    }

    public static String getSpreadType(Sheet sheet, long templateId) {
        if (Objects.isNull(sheet.getUserObject("spreadtype"))) {
            return PaperTemplateService.querySpreadType(templateId);
        }
        return (String)sheet.getUserObject("spreadtype");
    }
}

