/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim.model;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.sheet.InvShareRelationInfo;

public class ExtendExtUniqueKeyTable {
    private final Set<String> extMemSet = new LinkedHashSet<String>(16);
    private final Set<InvShareRelationInfo> relaInfoSet = new LinkedHashSet<InvShareRelationInfo>(16);

    public void add(String extMem, InvShareRelationInfo relationInfo) {
        this.extMemSet.add(extMem);
        this.relaInfoSet.add(relationInfo);
    }

    public void forEach(Consumer<ExtendExtUniqueKey> action) {
        Objects.requireNonNull(action);
        for (String extMem : this.extMemSet) {
            for (InvShareRelationInfo relationInfo : this.relaInfoSet) {
                action.accept(new ExtendExtUniqueKey(extMem, relationInfo));
            }
        }
    }

    public Set<InvShareRelationInfo> getRelaInfoSet() {
        return this.relaInfoSet;
    }

    public Set<String> getExtMemSet() {
        return this.extMemSet;
    }
}

