/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultSet;
import kd.fi.bcm.business.invest.sheet.InvShareRelationInfo;
import kd.fi.bcm.common.Pair;

public class InvEDResultCellTable {
    private final Table<String, InvShareRelationInfo, Long> model2PackKey2Table = HashBasedTable.create();
    private final Map<Long, Object> id2ValueMap = new HashMap<Long, Object>();

    public void populate(InvEDResultSet resultSet) {
        try (InvEDResultSet re = resultSet;){
            while (re.next()) {
                String extendsNumber = re.getExtendMember();
                String holdCompanyNum = re.getHoldCompany();
                String belongOrg = re.getBelongOrg();
                String mergeOrg = re.getMergeNum();
                String invCompanyNum = re.getInvCompany();
                String relationType = re.getRelationType();
                String categorized = re.getCategorized();
                Object value = re.getValue();
                long pkId = re.getId();
                this.putValue(new ExtendExtUniqueKey(extendsNumber, belongOrg, mergeOrg, holdCompanyNum, invCompanyNum, relationType, categorized), pkId, value);
            }
        }
    }

    public void putValue(ExtendExtUniqueKey uniqueKey, Long pkId, Object value) {
        this.model2PackKey2Table.put((Object)uniqueKey.getExtendsNumber(), (Object)uniqueKey.getEdColumn(), (Object)pkId);
        if (value != null) {
            this.id2ValueMap.put(pkId, value);
        }
    }

    public Pair<Long, Object> getValuePair(ExtendExtUniqueKey uniqueKey) {
        Long pkId = this.getPkId(uniqueKey);
        return pkId == null ? null : Pair.onePair((Object)pkId, (Object)this.id2ValueMap.get(pkId));
    }

    public Long getPkId(ExtendExtUniqueKey uniqueKey) {
        return (Long)this.model2PackKey2Table.get((Object)uniqueKey.getExtendsNumber(), (Object)uniqueKey.getEdColumn());
    }

    public boolean contains(ExtendExtUniqueKey uniqueKey) {
        return this.model2PackKey2Table.contains((Object)uniqueKey.getExtendsNumber(), (Object)uniqueKey.getEdColumn());
    }

    public boolean isEmpty() {
        return this.model2PackKey2Table.isEmpty();
    }
}

