/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.extdim.model;

import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.extdata.sql.exception.EDQueryException;
import kd.fi.bcm.business.invest.extdim.InvExtDataQueryService;

public class InvEDResultSet
implements AutoCloseable {
    private int cursorPos = 0;
    private int numRows = 0;
    private DynamicObject[] rows;

    public boolean next() {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new EDQueryException("Invalid Cursor position");
        }
        return this.internalNext();
    }

    private boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        return flag;
    }

    public void beforeFirst() {
        this.cursorPos = 0;
    }

    public int getFetchSize() {
        return this.rows == null ? 0 : this.rows.length;
    }

    protected void checkCursor() {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new EDQueryException("Invalid cursor position");
        }
    }

    private boolean isAfterLast() {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    private boolean isBeforeFirst() {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    public Object getValue() {
        String dataType;
        this.checkCursor();
        DynamicObject row = this.getRow();
        switch (dataType = row.getString("datatype")) {
            case "0": 
            case "1": 
            case "2": 
            case "5": {
                return row.get("numext");
            }
            case "3": {
                return row.get("textext");
            }
            case "4": {
                return row.get("dateext");
            }
        }
        return null;
    }

    public DynamicObject getRow() {
        return this.rows[this.cursorPos - 1];
    }

    @Override
    public void close() {
        this.rows = null;
    }

    public boolean isEmpty() {
        return this.rows == null || this.rows.length == 0;
    }

    public void populate(EdQueryComInfo edQueryComInfo) {
        InvExtDataQueryService extDataQueryService = new InvExtDataQueryService();
        this.rows = extDataQueryService.populate(edQueryComInfo);
        this.numRows = this.rows.length;
    }

    public void iteratorRows(Consumer<DynamicObject> consumer) {
        this.beforeFirst();
        while (this.next()) {
            consumer.accept(this.getRow());
        }
        this.beforeFirst();
    }

    public long getId() {
        DynamicObject row = this.getRow();
        return row.getLong("id");
    }

    public String getExtendMember() {
        DynamicObject row = this.getRow();
        return row.getString("account");
    }

    public String getMergeNum() {
        DynamicObject row = this.getRow();
        return row.getString("merge");
    }

    public String getHoldCompany() {
        DynamicObject row = this.getRow();
        return row.getString("internalcompany");
    }

    public String getBelongOrg() {
        DynamicObject row = this.getRow();
        return row.getString("org");
    }

    public String getInvCompany() {
        DynamicObject row = this.getRow();
        return row.getString("entity");
    }

    public String getRelationType() {
        DynamicObject row = this.getRow();
        return row.getString("relationtype");
    }

    public String getCategorized() {
        DynamicObject row = this.getRow();
        return row.getString("categorized");
    }
}

