/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.DynamicStockNode;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class InvDynamicStockRatioHelper {
    public static boolean isCurPeriod(Date[] periodScope, Date occurrDate) {
        if (periodScope == null || periodScope.length != 2 || occurrDate == null) {
            return false;
        }
        return occurrDate.compareTo(periodScope[0]) >= 0 && occurrDate.compareTo(periodScope[1]) <= 0;
    }

    public static Set<String> resolveBizTypeScope(Long modelId, Set<String> defaultChangeTypeSet) {
        return InvestServiceHelper.getInvChangetypeModel(modelId).values().stream().filter(p -> defaultChangeTypeSet.contains(p.getRealChangeType())).map(ChangeTypeModel::number).collect(Collectors.toSet());
    }

    public static void updateDynStockRadioStatus(Set<Long> ids, String status) {
        if (ids.isEmpty()) {
            return;
        }
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("yyyy-MM-dd HH:mm:ss");
        ArrayList<String> updateParams = new ArrayList<String>(5);
        updateParams.add("fstatus = " + status);
        updateParams.add("fmodifierid = " + RequestContext.get().getUserId());
        updateParams.add(String.format("fmodifytime = {ts'%s'}", df.format(TimeServiceHelper.now())));
        CharSequence[] succids = ids.stream().map(p -> p.toString()).collect(Collectors.toSet()).toArray(new String[0]);
        String sql = "update t_bcm_dynamicstockratio set " + String.join((CharSequence)",", updateParams) + " where fid in (%s)";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(sql, String.join((CharSequence)",", succids)));
        SaveServiceHelper.clearDataEntityCache((String)"bcm_dynamicstockratio");
    }

    public static void updateDynStockRadioInfo(Collection<DynamicObject> needUpdateData) {
        if (needUpdateData.isEmpty()) {
            return;
        }
        String updateSql = "update t_bcm_dynamicstockratio set fshareholderid = ?,finvesteecompanyid =?,finvchangetypeid =?,fconfirmopenscale=?,fconfirmchangescale=?,fconfirmsharescale=?,fstatus=?,fmodifierid=?,fmodifytime=?,fseq=?,fopenscale=?, fchangescale=?, fsharescale=?,fsharecaseid=? where fid =?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(16);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        for (DynamicObject dyn : needUpdateData) {
            Object[] params = new Object[]{dyn.getLong("shareholder"), dyn.getLong("investeecompany"), dyn.getLong("invchangetype"), dyn.getBigDecimal("confirmopenscale"), dyn.getBigDecimal("confirmchangescale"), dyn.getBigDecimal("confirmsharescale"), dyn.get("status"), dyn.get("modifierid"), dyn.get("modifytime"), dyn.get("seqnum"), dyn.get("openscale"), dyn.get("changescale"), dyn.get("sharescale"), DynUtils.getBaseId((DynamicObject)dyn, (String)"sharecase"), dyn.get("id")};
            paramsList.add(params);
            DynamicObjectCollection effectTemp = dyn.getDynamicObjectCollection("effecttemp");
            int i = 0;
            for (DynamicObject dynamicObject : effectTemp) {
                Object[] insertParams = new Object[]{dyn.getLong("id"), idDistributor.getLongId(), i++, dynamicObject.get("temtype"), dynamicObject.get("temp"), dynamicObject.get("isexcept"), dynamicObject.get("group"), dynamicObject.get("number")};
                insertParamsList.add(insertParams);
            }
        }
        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
        String rltIds = String.join((CharSequence)",", needUpdateData.stream().map(e -> e.getString("id")).collect(Collectors.toSet()));
        String deleteTemplateSql = "delete from t_bcm_dynstockratiotemp where fid in (%s)";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(deleteTemplateSql, rltIds));
        String deleteNewTemplateSql = "DELETE FROM t_bcm_invrlteffecttemp WHERE fid in (%s)";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(deleteNewTemplateSql, rltIds));
        if (!insertParamsList.isEmpty()) {
            String insetTemplate = "INSERT INTO t_bcm_invrlteffecttemp (fid, fentryid, fseq, ftemtype, ftempid, fisexcept, fgroupid, fnumber) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insetTemplate, insertParamsList);
        }
    }

    public static void newAddSave(Collection<DynamicObject> dynamicObjects) {
        if (dynamicObjects.isEmpty()) {
            return;
        }
        DynamicObject stockRatio = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dynamicstockratio");
        SaveServiceHelper.save((IDataEntityType)stockRatio.getDynamicObjectType(), (Object[])dynamicObjects.toArray(new Object[0]));
    }

    public static DynamicObjectCollection loadGroupChangeTypeRelation(long scenarioId, long yearId, long periodId, Collection<String> status, Long selectedOrgId, String selectFields) {
        return InvDynamicStockRatioHelper.loadGroupChangeTypeRelation(scenarioId, yearId, periodId, status, Lists.newArrayList((Object[])new Long[]{selectedOrgId}), selectFields);
    }

    public static DynamicObjectCollection loadGroupChangeTypeRelation(long scenarioId, long yearId, long periodId, Collection<String> status, Collection<Long> selectedOrgId, String selectFields) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        QFBuilder qfBuilder = InvDynamicStockRatioHelper.getQfBuilder(scenarioId, yearId, periodId, status, selectedOrgId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_dynamicstockratio", (String)selectFields, (QFilter[])qfBuilder.toArray());
        if (load != null && load.length > 0) {
            result.addAll(Arrays.asList(load));
        }
        return result;
    }

    public static QFBuilder qfBuilderQueryEffectiveList(long scenarioId, long yearId, long periodId, Collection<Long> selectOrgRanges) {
        return InvDynamicStockRatioHelper.getQfBuilder(scenarioId, yearId, periodId, Lists.newArrayList((Object[])new String[]{InvDynamicStockRatioConstant.StatusEnum.ENABLE.getCode()}), selectOrgRanges);
    }

    public static void iteratorDynamicStockNode(DynamicStockNode stockNode, BiConsumer<String, DynamicObject> action) {
        if (stockNode == null || stockNode.getChildStockNodeMap().isEmpty()) {
            return;
        }
        for (Map.Entry<String, DynamicStockNode> childStockNodeEntry : stockNode.getChildStockNodeMap().entrySet()) {
            childStockNodeEntry.getValue().genDynamicObject().forEach(p -> action.accept((String)childStockNodeEntry.getKey(), (DynamicObject)p));
        }
    }

    public static Set<IDNumberTreeNode> findHighLevel(List<IDNumberTreeNode> patchList) {
        int maxLevel = -1;
        HashSet<IDNumberTreeNode> result = new HashSet<IDNumberTreeNode>(2);
        for (IDNumberTreeNode node : patchList) {
            if (maxLevel < node.getLevel()) {
                maxLevel = node.getLevel();
                result.clear();
            }
            if (maxLevel != node.getLevel()) continue;
            result.add(node);
        }
        return result;
    }

    public static Set<String> getInvShareRelaSelectField() {
        HashSet<String> fields = new HashSet<String>(7);
        fields.add("id");
        fields.add("shareholder.number");
        fields.add("investeecompany.number");
        fields.add("invchangetype.number");
        fields.add("invchangetype.id");
        fields.add("changescale");
        fields.add("sharescale");
        fields.add("investdate");
        fields.add("investamount");
        fields.add("invchangetype.change");
        return fields;
    }

    public static Set<String> getChangeTypeBizSelectField() {
        HashSet<String> fields = new HashSet<String>(7);
        fields.add("id");
        fields.add("number");
        fields.add("bizchangerds.bizeffdate as bizeffdate");
        fields.add("bizchangerds.changetype as changetype");
        return fields;
    }

    public static String getBizTypeScopeFieldStr(Long modelId, String orginalField, String relatedField) {
        Set bizTypeScopeCopy = (Set)ThreadCache.get((Object)"getBizTypeScopeFieldStr", () -> InvestServiceHelper.getInvChangetypeModel(modelId).values().stream().filter(p -> "BD004".equals(p.number()) || "BD004".equals(p.relatedChangeType())).map(inv -> String.format("'%s'", inv.number())).collect(Collectors.toSet()));
        return new StringJoiner(" ").add("case when ").add(orginalField).add(" in (").add(String.join((CharSequence)",", bizTypeScopeCopy)).add(")").add("then CONVERT(VARCHAR(50),'BD004')").add("else CONVERT(VARCHAR(50),'BD005') end as").add(relatedField).toString();
    }

    public static String packKey(String merge, String shareholder, String investeecompany, String invchangetype) {
        return String.format("%s_%s_%s_%s", merge, shareholder, investeecompany, invchangetype);
    }

    private static QFBuilder getQfBuilder(long scenarioId, long yearId, long periodId, Collection<String> status, Collection<Long> selectOrgRanges) {
        QFBuilder qfBuilder = new QFBuilder("scenario", "=", (Object)scenarioId).add("year", "=", (Object)yearId).add("period", "=", (Object)periodId).add("merge", "in", selectOrgRanges).add("level", "=", (Object)InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode());
        if (!status.isEmpty()) {
            qfBuilder.add("status", "in", status);
        }
        return qfBuilder;
    }
}

