/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import com.google.common.collect.Sets;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.upgrade.InvRelationTypeCombo2BaseDataUpgradeService;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang.StringUtils;

public class InvRelationSetHelper {
    public static void saveRelationParam(long modelId) {
        DynamicObject inv = InvRelationSetHelper.saveParamData(modelId, true, true, false, false, true, false, false, false);
        PlatUtil.executeWithTXNew(txHandle -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inv});
            new InvRelationTypeCombo2BaseDataUpgradeService().doInit(Sets.newHashSet((Object[])new Long[]{modelId}));
        });
    }

    public static DynamicObject saveParamData(long modelId, Boolean directeown, Boolean indireownsum, Boolean indireownmul, Boolean inshareeown, Boolean intrashareeown, Boolean showinvalidentity, Boolean supportruleexc, Boolean includesameparent) {
        DynamicObject invParam = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invrelationset");
        invParam.set("model", (Object)modelId);
        invParam.set("directeown", (Object)directeown);
        invParam.set("indireownsum", (Object)indireownsum);
        invParam.set("indireownmul", (Object)indireownmul);
        invParam.set("inshareeown", (Object)inshareeown);
        invParam.set("intrashareeown", (Object)intrashareeown);
        invParam.set("showinvalidentity", (Object)showinvalidentity);
        invParam.set("supportruleexc", (Object)supportruleexc);
        invParam.set("includesameparent", (Object)includesameparent);
        return invParam;
    }

    public static void consumeBy(long modelId, Consumer<DynamicObject> consumer) {
        DynamicObject invParams = QueryServiceHelper.queryOne((String)"bcm_invrelationset", (String)"directeown,indireownsum,indireownmul,inshareeown,intrashareeown,showinvalidentity,totalscore,accuracy,supportruleexc,includesameparent", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        consumer.accept(invParams);
    }

    public static void doSave(long modelId, Supplier<DynamicObject> supplier) {
        DynamicObject invParam = supplier.get();
        DeleteServiceHelper.delete((String)"bcm_invrelationset", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        SaveServiceHelper.save((IDataEntityType)invParam.getDataEntityType(), (Object[])new DynamicObject[]{invParam});
    }

    public static String queryAccuracy(long modelId) {
        DynamicObject config = QueryServiceHelper.queryOne((String)"bcm_invrelationset", (String)"accuracy", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        return !StringUtils.isBlank((String)config.getString("accuracy")) ? config.getString("accuracy").trim() : "2";
    }

    public static DynamicObject queryRelationSet(long modelId) {
        DynamicObject invParams = QueryServiceHelper.queryOne((String)"bcm_invrelationset", (String)"directeown,indireownsum,indireownmul,inshareeown,intrashareeown,showinvalidentity,totalscore,accuracy,supportruleexc,includesameparent", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        return invParams;
    }

    public static boolean isTotalScore(long modelId) {
        return (Boolean)ThreadCache.get((Object)(modelId + "_CtrlHoldingCompanyPeekSetting"), () -> {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_invrelationset", (String)"totalscore", (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArray());
            return dynamicObject != null && dynamicObject.getBoolean("totalscore");
        });
    }

    public static void checkShareholderHasEntityPerm(Long modelId, String shareholderNum) {
        PermissionService instance;
        if (ConfigServiceHelper.getBoolParam(modelId, "isValidateEntityPermForShareHolder") && !(instance = PermissionServiceImpl.getInstance(modelId)).isAdmin()) {
            Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
            IDNumberTreeNode entityMember = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)shareholderNum);
            if (entityMember != IDNumberTreeNode.NotFoundTreeNode && instance.hasNoPerm(entityDimId, (entityMember = entityMember.getBaseTreeNode()).getId())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d%s\u65e0\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"CalculateShareRelaService_6", (String)"fi-bcm-business", (Object[])new Object[0]), shareholderNum));
            }
        }
    }
}

