/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.function.QuadraConsumer;
import kd.fi.bcm.business.invest.function.TripleConsumer;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class InvRelationTypeHelper {
    public static Set<String> getEnableStaticTypeNumbers(long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode()).add("status", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])qfBuilder.toArray());
        return query.stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
    }

    public static void consumeStaticRelationsType(long modelId, TripleConsumer<String, ILocaleString, Boolean> consumer) {
        DynamicObject[] config;
        for (DynamicObject dynamicObject : config = InvRelationTypeHelper.getStaticRelationsTypeBy(modelId)) {
            String number = dynamicObject.getString("number");
            ILocaleString name = dynamicObject.getLocaleString("name");
            boolean isUse = dynamicObject.getBoolean("status");
            consumer.accept(number, name, isUse);
        }
    }

    public static void consumeStaticRelationsType(long modelId, QuadraConsumer<String, ILocaleString, Boolean, Integer> consumer) {
        List collect = Arrays.stream(InvRelationTypeHelper.getStaticRelationsTypeBy(modelId)).filter(dy -> dy.getInt("seqfield") > 5).sorted(Comparator.comparingInt(p -> p.getInt("seqfield"))).collect(Collectors.toList());
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collect.get(i);
            String number = dynamicObject.getString("number");
            ILocaleString name = dynamicObject.getLocaleString("name");
            boolean isUse = dynamicObject.getBoolean("status");
            consumer.accept(number, name, isUse, i);
        }
    }

    public static void updateStaticRelationsType(long modelId, Consumer<Map<String, DynamicObject>> consumer) {
        DynamicObject[] staticRelationsTypeBy = InvRelationTypeHelper.getStaticRelationsTypeBy(modelId);
        Map<String, DynamicObject> collect = Arrays.stream(staticRelationsTypeBy).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        consumer.accept(collect);
        SaveServiceHelper.save((DynamicObject[])collect.values().toArray(new DynamicObject[0]));
    }

    public static Map<Long, String> getIdsByNumber(long modelId, Collection<String> numbers) {
        DynamicObject[] query = InvRelationTypeHelper.getDynamicObjects(modelId, numbers);
        return Arrays.stream(query).collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getString("number")));
    }

    public static List<ComboItem> getComboItems(Long modelId, Consumer<QFBuilder> otherQf) {
        DynamicObject[] load;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(32);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
        otherQf.accept((Object)qfBuilder);
        String order = String.join((CharSequence)",", "categorized", "seqfield", "number");
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])qfBuilder.toArray(), (String)order)) {
            items.add(new ComboItem(new LocaleString(dynamicObject.getLocaleString("name").getLocaleValue()), dynamicObject.getString("number")));
        }
        return items;
    }

    public static void addRelationType(long modelId, Map<String, Object> number2Name) {
        ArrayList dynamicObjectList = new ArrayList(16);
        DynamicObject[] dynamicObjects = InvRelationTypeHelper.getDynamicObjects(modelId, number2Name.keySet());
        Arrays.stream(dynamicObjects).forEach(dy -> {
            String relaNumber = dy.getString("number");
            if (number2Name.containsKey(relaNumber)) {
                Object name = number2Name.remove(relaNumber);
                dy.set("name", name);
                dynamicObjectList.add(dy);
            }
        });
        number2Name.keySet().stream().forEach(number -> {
            Object name = number2Name.get(number);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invrelatype");
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("number", number);
            dynamicObject.set("name", name);
            dynamicObject.set("status", (Object)true);
            dynamicObject.set("seqfield", (Object)0);
            dynamicObject.set("categorized", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            dynamicObjectList.add(dynamicObject);
        });
        SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
    }

    public static void deleteRelationType(long changeTypeId, List<String> numbers) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_invchangetype", (String)"model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)changeTypeId)});
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)dy.getLong("model")).add("number", "in", numbers).add("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
        DeleteServiceHelper.delete((String)"bcm_invrelatype", (QFilter[])qfBuilder.toArray());
    }

    public static void foreachRelationType(Collection<DynamicObject> queryFromTemplate, Consumer<String> consumer) {
        for (DynamicObject dynamicObject : queryFromTemplate) {
            String number = dynamicObject.getString("fbasedataid.number");
            String categorized = dynamicObject.getString("fbasedataid.categorized");
            if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
                Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
                number = InvRelationTypeHelper.findUnitNumber(number, code2InvRelaTypeEnum);
            }
            consumer.accept((Object)number);
        }
    }

    public static String findUnitNumber(String number, Map<String, InvRelaTypeEnum> code2InvRelaTypeEnum) {
        for (Map.Entry<String, InvRelaTypeEnum> entry : code2InvRelaTypeEnum.entrySet()) {
            if (!entry.getValue().getType().equals(number)) continue;
            number = entry.getKey();
            break;
        }
        return number;
    }

    public static boolean exists(long id, String number, String categorized) {
        return (Boolean)ThreadCache.get((Object)String.join((CharSequence)"@", String.valueOf(id), number, categorized), () -> {
            QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)id).add("number", "=", (Object)number).add("categorized", "=", (Object)categorized);
            return QueryServiceHelper.exists((String)"bcm_invrelatype", (QFilter[])qfBuilder.toArray());
        });
    }

    private static DynamicObject[] getStaticRelationsTypeBy(Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
        return BusinessDataServiceHelper.load((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])qfBuilder.toArray(), (String)"seqfield");
    }

    private static DynamicObject[] getDynamicObjects(long modelId, Collection<String> numbers) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("number", "in", numbers);
        return BusinessDataServiceHelper.load((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])qfBuilder.toArray());
    }

    public static boolean haveUsingStaticRlt(long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("status", "=", (Object)true).add("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
        return QueryServiceHelper.exists((String)"bcm_invrelatype", (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject getDefaultRltType(long modelId) {
        return BusinessDataServiceHelper.loadSingle((String)"bcm_invrelatype", (String)"id,number,name", (QFilter[])new QFBuilder("model", "=", (Object)modelId).and("number", "=", (Object)InvRelaTypeEnum.INDirectRelaType.getType()).toArray());
    }

    public static DynamicObjectCollection categorizedRelationDysInIds(Collection<DynamicObject> collection, InvRelationTypeConstant.CatalogEnum categorized, Function<DynamicObject, Long> func) {
        if (collection == null || collection.isEmpty()) {
            return new DynamicObjectCollection();
        }
        Set ids = collection.stream().map(func::apply).collect(Collectors.toSet());
        return QueryServiceHelper.query((String)"bcm_invrelatype", (String)"id,number,name", (QFilter[])new QFBuilder("id", "in", ids).and("categorized", "=", (Object)categorized.getCode()).toArray());
    }

    public static List<ValueMapItem> getInvRelaType(long modelId) {
        return (List)ThreadCache.get((Object)("getInvRelaType" + modelId), () -> {
            ArrayList items = new ArrayList(16);
            InvRelationTypeHelper.consumeStaticRelationsType(modelId, (String number, ILocaleString name, Boolean isUse) -> items.add(new ValueMapItem(null, number, new LocaleString(name.getLocaleValue()))));
            return items;
        });
    }

    public static Map<Object, Object> queryRelationType(Set<Object> changeTypeIds) {
        String number;
        DynamicObjectCollection changeTypeDys = QueryServiceHelper.query((String)"bcm_invchangetype", (String)"id,number,model", (QFilter[])new QFilter[]{new QFilter("id", "in", changeTypeIds)});
        HashBasedTable table = HashBasedTable.create();
        for (Object changeTypeDy : changeTypeDys) {
            long model = changeTypeDy.getLong("model");
            long id = changeTypeDy.getLong("id");
            number = changeTypeDy.getString("number");
            table.put((Object)number, (Object)model, (Object)id);
        }
        QFilter orFilter = null;
        for (Long modelId : table.columnKeySet()) {
            Map column = table.column((Object)modelId);
            Set numbers = column.keySet();
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("number", "in", numbers);
            if (orFilter == null) {
                orFilter = qFilter;
                continue;
            }
            orFilter.or(qFilter);
        }
        if (orFilter == null) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> rs = new HashMap<Object, Object>(changeTypeIds.size());
        QFBuilder qfBuilder = new QFBuilder("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode()).and(orFilter);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invrelatype", (String)"id,number,model", (QFilter[])qfBuilder.toArray());
        for (DynamicObject dynamicObject : query) {
            number = dynamicObject.getString("number");
            long id = dynamicObject.getLong("id");
            long modelId = dynamicObject.getLong("model");
            Long changeTypeId = (Long)table.get((Object)number, (Object)modelId);
            rs.put(id, changeTypeId);
        }
        return rs;
    }

    public static boolean allPkExists(Set<Object> ids) {
        if (ids.isEmpty()) {
            return false;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invrelatype", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return query.size() == ids.size();
    }
}

