/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.model.InvShareCase;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.upgrade.InvShareCaseUpgradeService;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class InvShareCaseHelper {
    public static boolean isReadOnly(InvShareCase invShareCase) {
        return invShareCase.getPermEnum() != PermEnum.READWRITE;
    }

    public static InvShareCase getInvShareCaseById(long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_invsharecase");
        return InvShareCase.genEntityBy(dynamicObject);
    }

    public static DynamicObjectCollection queryBy(Collection<Long> ids) {
        return QueryServiceHelper.query((String)"bcm_invsharecase", (String)String.join((CharSequence)",", InvShareCase.ALL_FIELD), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static QFilter getScopeFilter(long modelId) {
        long currUserId = RequestContext.get().getCurrUserId();
        if (MemberPermHelper.ifUserHasRootPermByModel(currUserId, String.valueOf(modelId))) {
            return InvShareCaseHelper.getModelFilter(modelId);
        }
        ArrayListMultimap<String, Long> permissionMap = PermClassEntityHelper.getPermissionMap("bcm_invsharecase", String.valueOf(modelId), String.valueOf(currUserId));
        List noPermBill = permissionMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
        QFilter allUserFilter = new QFilter("scope", "=", (Object)InvShareCase.ScopeEnum.ALL_USER.getValue());
        QFilter selfFilter = new QFilter("scope", "=", (Object)InvShareCase.ScopeEnum.SELF.getValue()).and("modifier", "=", (Object)currUserId);
        QFilter permFilter = new QFilter("id", "not in", (Object)noPermBill).and("scope", "=", (Object)InvShareCase.ScopeEnum.PERM_CLASS.getValue());
        QFilter modelFilter = InvShareCaseHelper.getModelFilter(modelId);
        return modelFilter.and(allUserFilter.or(selfFilter).or(permFilter));
    }

    public static QFilter getModelFilter(long modelId) {
        return new QFilter("model", "=", (Object)modelId);
    }

    public static InvShareCase getDefaultCaseBy(long modelId) {
        return (InvShareCase)ThreadCache.get((Object)String.join((CharSequence)"_", "DefaultCase", String.valueOf(modelId)), () -> {
            QFilter filter = InvShareCaseHelper.getModelFilter(modelId);
            filter.and("number", "=", (Object)"defaultInvest");
            String selectFields = InvShareCase.genCommSelectFields();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_invsharecase", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (Objects.isNull(dynamicObject)) {
                InvShareCaseUpgradeService invShareCaseUpgradeService = new InvShareCaseUpgradeService();
                long shareCaseId = GlobalIdUtil.genGlobalLongId();
                HashMap<Long, Long> model2Setting = new HashMap<Long, Long>(1);
                model2Setting.put(modelId, shareCaseId);
                invShareCaseUpgradeService.upgradeStockData(Collections.emptyMap(), model2Setting);
                return new InvShareCase(QueryServiceHelper.queryOne((String)"bcm_invsharecase", (String)selectFields, (QFilter[])new QFilter[]{filter}));
            }
            return new InvShareCase(dynamicObject);
        });
    }
}

