/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.invest.model.InvShareCase;
import kd.fi.bcm.business.invest.model.InvShareCaseSet;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invtemplate.InvDistributeConstant;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.util.set.Sets;

public class InvShareCaseSetHelper {
    public static List<InvShareCaseSet> queryBy(long modelId) {
        return InvShareCaseSetHelper.queryBy(modelId, new QFBuilder());
    }

    public static List<InvShareCaseSet> queryBy(long modelId, QFBuilder qfBuilder) {
        QFilter modelFilter = InvShareCaseSetHelper.getModelFilter(modelId);
        qfBuilder.add(modelFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_invsharecaseset", (String)String.join((CharSequence)",", InvShareCaseSet.FIELDS), (QFilter[])qfBuilder.toArray());
        return InvShareCaseSet.genInvShareCaseSet((Collection<DynamicObject>)dynamicObjects);
    }

    public static QFilter getModelFilter(long modelId) {
        return new QFilter("model", "=", (Object)modelId);
    }

    public static void saveBatch(Collection<DynamicObject> dynamicObjects, long modelId) {
        InvShareCaseSet invShareCaseSet = new InvShareCaseSet();
        AtomicInteger index = new AtomicInteger();
        List toAddNewList = dynamicObjects.stream().map(dynamicObject -> {
            DynamicObject invShareCaseDy = BusinessDataServiceHelper.newDynamicObject((String)invShareCaseSet.getDataEntityNumber());
            for (String field : InvShareCaseSet.FIELDS) {
                Object o;
                if ("model".equals(field) || !Objects.nonNull(o = dynamicObject.get(field))) continue;
                invShareCaseDy.set(field, o);
            }
            invShareCaseDy.set("dseq", (Object)index.incrementAndGet());
            invShareCaseDy.set("model", (Object)modelId);
            return invShareCaseDy;
        }).collect(Collectors.toList());
        PlatUtil.executeWithTX(tx -> {
            QFilter modelFilter = InvShareCaseSetHelper.getModelFilter(modelId);
            DeleteServiceHelper.delete((String)invShareCaseSet.getDataEntityNumber(), (QFilter[])new QFilter[]{modelFilter});
            if (!toAddNewList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])toAddNewList.toArray(new DynamicObject[0]));
            }
        });
    }

    public static long findShareCase(long modelId, long scenarioId) {
        QFilter modelFilter = InvShareCaseSetHelper.getModelFilter(modelId);
        modelFilter.and("scenario", "=", (Object)scenarioId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_invsharecaseset", (String)"sharecase", (QFilter[])modelFilter.toArray());
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject.getLong("sharecase");
        }
        InvShareCase defaultCase = InvShareCaseHelper.getDefaultCaseBy(modelId);
        return defaultCase.getId();
    }

    public static List<InvShareCaseSet> findShareCaseList(long modelId, long scenarioId) {
        return (List)ThreadCache.get((Object)String.join((CharSequence)"_", "findShareCaseList", String.valueOf(modelId), String.valueOf(scenarioId)), () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("scenario", "=", (Object)scenarioId));
            return InvShareCaseSetHelper.queryBy(modelId, qfBuilder);
        });
    }

    public static Map<Long, Long> findShareCaseByOrg(long modelId, long scenarioId, Set<Long> orgSet) {
        List<InvShareCaseSet> shareCaseList = InvShareCaseSetHelper.findShareCaseList(modelId, scenarioId);
        Set caseOrgList = shareCaseList.stream().map(sharecase -> (Long)sharecase.get("entity")).collect(Collectors.toSet());
        HashSet orgIds = Sets.newHashSet(orgSet);
        orgIds.addAll(caseOrgList);
        ArrayList entityMemberList = new ArrayList(16);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        HashMap nodeMap = new HashMap(16);
        orgIds.forEach(orgId -> {
            IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            nodeMap.put(orgId, numberTreeNode);
            if (numberTreeNode != IDNumberTreeNode.NotFoundTreeNode) {
                List entityMembers = MemberReader.findEntityMemberByPredicate((String)modelNumber, (String)numberTreeNode.getNumber(), p -> true);
                entityMemberList.addAll(entityMembers);
            }
        });
        HashMap longNumberMap = new HashMap(16);
        entityMemberList.forEach(ent -> {
            if (ent.isLeaf()) {
                return;
            }
            String number = ent.getNumber();
            String longnumber = ent.getLongNumber();
            if (CollectionUtils.isEmpty((Collection)((Collection)longNumberMap.get(number)))) {
                HashSet<String> longnumberList = new HashSet<String>(16);
                longnumberList.add(longnumber);
                longNumberMap.put(number, longnumberList);
            } else {
                ((Set)longNumberMap.get(number)).add(longnumber);
            }
        });
        HashMap<Long, Long> orgToCaseMap = new HashMap<Long, Long>(16);
        InvShareCase defaultCase = InvShareCaseHelper.getDefaultCaseBy(modelId);
        orgSet.forEach(org -> {
            IDNumberTreeNode orgNode = (IDNumberTreeNode)nodeMap.get(org);
            Set<String> orgLongNumbers = longNumberMap.getOrDefault(orgNode.getNumber(), Collections.emptySet());
            for (InvShareCaseSet sharecase : shareCaseList) {
                String rang = (String)sharecase.get("range");
                Long caseOrg = (Long)sharecase.get("entity");
                Long caseId = (Long)sharecase.get("sharecase");
                IDNumberTreeNode caseOrgNode = (IDNumberTreeNode)nodeMap.get(caseOrg);
                if (caseOrgNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                Set<String> caseorgLongNumbers = longNumberMap.getOrDefault(caseOrgNode.getNumber(), Collections.emptySet());
                if ((!String.valueOf(InvDistributeConstant.MemRangeComboEnum.ONLY_SELF.getCode()).equals(rang) || !CollectionUtils.isNotEmpty((Collection)Sets.intersection(orgLongNumbers, caseorgLongNumbers))) && (!String.valueOf(InvDistributeConstant.MemRangeComboEnum.ALL_SUB_NONBASE.getCode()).equals(rang) || !InvShareCaseSetHelper.matchRang(orgLongNumbers, caseorgLongNumbers))) continue;
                orgToCaseMap.put((Long)org, caseId);
                break;
            }
            if (!orgToCaseMap.containsKey(org)) {
                orgToCaseMap.put((Long)org, defaultCase.getId());
            }
        });
        return orgToCaseMap;
    }

    private static boolean matchRang(Set<String> orgLongNumbers, Set<String> caseorgLongNumbers) {
        AtomicBoolean flag = new AtomicBoolean(false);
        orgLongNumbers.forEach(org -> {
            if (flag.get()) {
                return;
            }
            for (String caseorg : caseorgLongNumbers) {
                if (!org.contains(caseorg)) continue;
                flag.set(true);
                break;
            }
        });
        return flag.get();
    }
}

