/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.QFBuilder;

public class InvStaticStockRatioHelper {
    public static DynamicObjectCollection loadRelationByF7(long modelId, long scenarioId, long yearId, long periodId, Collection<Long> baseIds, String selectFields) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("scenario", "=", (Object)scenarioId).add("year", "=", (Object)yearId).add("period", "=", (Object)periodId).add("orgunit", "in", baseIds);
        return QueryServiceHelper.query((String)"bcm_invrelation", (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    public static void newAddSave(Set<DynamicObject> dynamicObjects) {
        if (dynamicObjects.isEmpty()) {
            return;
        }
        DynamicObject stockRatio = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invrelation");
        SaveServiceHelper.save((IDataEntityType)stockRatio.getDynamicObjectType(), (Object[])dynamicObjects.toArray(new Object[0]));
    }

    public static void updateStockRadioInfo(Set<DynamicObject> needUpdateData) {
        if (needUpdateData.isEmpty()) {
            return;
        }
        String updateSql = "UPDATE t_bcm_invrelation SET fmodelid=?, fscenarioid=?, ffyid=?, fperiodid=?, forgunitid=?, fshareholderid=?, finvesteecompanyid=?, fequvscale=?, fconfirmscale=?, fminconfirmscale=?, fisusedinvrule=?, fmodifierid=?, fmodifytime=?, fisconfirmed=?, fisdelete=?, fseq=?, finvrelatype=?,fsharecaseid=? WHERE fid=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(16);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        for (DynamicObject dyn : needUpdateData) {
            Object[] params = new Object[]{dyn.getLong("model"), dyn.getLong("scenario"), dyn.getLong("year"), dyn.getLong("period"), dyn.getLong("orgunit"), dyn.getLong("shareholder"), dyn.getLong("investeecompany"), dyn.getBigDecimal("equvscale"), dyn.getBigDecimal("confirmscale"), dyn.getBigDecimal("minconfirmscale"), dyn.get("isusedinvrule"), dyn.get("modifier"), dyn.get("modifytime"), dyn.get("isconfirmed"), dyn.get("isdelete"), dyn.get("relaseq"), dyn.get("invrelatype"), 0L, dyn.get("id")};
            paramsList.add(params);
            DynamicObjectCollection invElimTemplate = dyn.getDynamicObjectCollection("effecttemp");
            int i = 0;
            for (DynamicObject d : invElimTemplate) {
                Object[] insertParams = new Object[]{dyn.getLong("id"), idDistributor.getLongId(), i++, d.get("temtype"), d.get("temp"), d.get("isexcept"), d.get("group"), d.get("number")};
                insertParamsList.add(insertParams);
            }
        }
        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
        String deleteTemplateSql = "delete from t_bcm_invrelation_temp where fid in (%s)";
        String rltIds = String.join((CharSequence)",", needUpdateData.stream().map(e -> e.getString("id")).collect(Collectors.toSet()));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(deleteTemplateSql, rltIds));
        String deleteNewTemplateSql = "DELETE FROM t_bcm_invrlteffecttemp WHERE fid in (%s)";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(deleteNewTemplateSql, rltIds));
        if (!insertParamsList.isEmpty()) {
            String insetTemplate = "INSERT INTO t_bcm_invrlteffecttemp (fid, fentryid, fseq, ftemtype, ftempid, fisexcept, fgroupid, fnumber) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insetTemplate, insertParamsList);
        }
    }
}

