/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.invest.model.InvSheetEntry;
import kd.fi.bcm.business.invest.model.InvSheetRow;
import kd.fi.bcm.business.invest.model.InvTemplate;
import kd.fi.bcm.business.papertemplate.PaperTmplExpImpHelper;
import kd.fi.bcm.business.papertemplate.PaperTmplImportInfo;
import kd.fi.bcm.business.papertemplate.PaperTmplImportResult;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.invest.InvCaseProcessEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class InvTmplImportExportHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, InvTmplImportExportHelper.class);

    public static String exportTmpls(long modelId, Set<Long> tmplIds) throws IOException {
        DynamicObject[] cslDyns;
        DynamicObject[] relationTypeDyns;
        ArrayList<InvTemplate> tmpls = new ArrayList<InvTemplate>(16);
        String selectFields = "id,number,name,versionnumber,showtype,versiondescription,count,extdimid.number,spreadtype,spreadjson,data,process.number";
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("id", "in", tmplIds);
        DynamicObjectCollection tmplDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])qf.toArray(), (String)"versionnumber asc");
        if (tmplDoc == null || tmplDoc.isEmpty()) {
            return null;
        }
        HashMap<Long, Set> relationTypeMap = new HashMap<Long, Set>(16);
        for (DynamicObject dyn : relationTypeDyns = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)"id,invrelationtype,invrelationtype.number", (QFilter[])qf.toArray())) {
            DynamicObjectCollection doc = dyn.getDynamicObjectCollection("invrelationtype");
            for (DynamicObject typeDyn : doc) {
                if (typeDyn.getDynamicObject("fbasedataid") == null) continue;
                relationTypeMap.computeIfAbsent(dyn.getLong("id"), k -> new HashSet(16)).add(typeDyn.getDynamicObject("fbasedataid").getString("number"));
            }
        }
        HashMap<Long, List> cslMap = new HashMap<Long, List>(16);
        for (DynamicObject dyn : cslDyns = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)"id,relacslscheme,relacslscheme.number", (QFilter[])qf.toArray())) {
            DynamicObjectCollection doc = dyn.getDynamicObjectCollection("relacslscheme");
            for (DynamicObject typeDyn : doc) {
                if (typeDyn.getDynamicObject("fbasedataid") == null) continue;
                cslMap.computeIfAbsent(dyn.getLong("id"), k -> Lists.newArrayList()).add(typeDyn.getDynamicObject("fbasedataid").getString("number"));
            }
        }
        Map<Long, List<DynamicObject>> fieldLayoutMap = QueryServiceHelper.query((String)"bcm_invsheetacclayout", (String)"id,template,position,extdimid.number", (QFilter[])new QFilter[]{new QFilter("template", "in", tmplIds)}).stream().collect(Collectors.groupingBy(e -> e.getLong("template")));
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_invsheetttplentrys").getAllFields().keySet();
        Map<Long, List<DynamicObject>> entryMaps = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_invsheetttplentrys", (String)("id," + String.join((CharSequence)",", fields)), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("sheettemplate", "in", tmplIds)})).collect(Collectors.groupingBy(e -> e.getLong("sheettemplate.id")));
        for (DynamicObject dyn : tmplDoc) {
            long tmplId = dyn.getLong("id");
            InvTemplate tmpl = InvTmplImportExportHelper.convertToTemplate(dyn);
            tmpl.setFieldLayout(InvTmplImportExportHelper.convertToLayout(fieldLayoutMap.get(tmplId)));
            tmpl.setInvSheetEntryList(InvTmplImportExportHelper.convertToEntry(modelId, entryMaps.get(tmplId)));
            tmpl.setInvrelationTypeNumbers((Set)relationTypeMap.get(tmplId));
            tmpl.setRelationCslList((List)cslMap.get(tmplId));
            tmpls.add(tmpl);
        }
        return InvTmplImportExportHelper.createJsonFile(ObjectSerialUtil.toByteSerialized(tmpls), InvTmplImportExportHelper.getFileName());
    }

    private static String getFileName() {
        String fileName = ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500\u6a21\u677f\u5bfc\u51fa", (String)"InvestTemplateHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()) + ".json";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createJsonFile(String jsonString, String fileName) throws IOException {
        try (ByteArrayInputStream inStream = null;){
            inStream = new ByteArrayInputStream(jsonString.getBytes(Charset.forName("UTF-8")));
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
    }

    private static List<Pair<String, String>> convertToLayout(List<DynamicObject> dyns) {
        ArrayList<Pair<String, String>> layoutList = new ArrayList<Pair<String, String>>(16);
        if (CollectionUtils.isEmpty(dyns)) {
            return layoutList;
        }
        for (DynamicObject dyn : dyns) {
            layoutList.add((Pair<String, String>)Pair.onePair((Object)dyn.getString("extdimid.number"), (Object)dyn.getString("position")));
        }
        return layoutList;
    }

    private static List<DynamicObject> convertToLayoutDyn(Long extGroupId, long tmplId, Long modelId, List<Pair<String, String>> fieldLayout) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (CollectionUtils.isEmpty(fieldLayout)) {
            return result;
        }
        for (Pair<String, String> pair : fieldLayout) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsheetacclayout");
            dyn.set("template", (Object)tmplId);
            dyn.set("extdimid", (Object)InvTmplImportExportHelper.getRuleExtFieldIdByNum(modelId, extGroupId, (String)pair.p1));
            dyn.set("position", pair.p2);
            result.add(dyn);
        }
        return result;
    }

    private static List<InvSheetEntry> convertToEntry(long modelId, List<DynamicObject> dyns) {
        ArrayList<InvSheetEntry> entryList = new ArrayList<InvSheetEntry>(16);
        if (CollectionUtils.isEmpty(dyns)) {
            return entryList;
        }
        for (DynamicObject dyn : dyns) {
            InvSheetEntry entry = new InvSheetEntry();
            entry.setNumber(dyn.getString("number"));
            entry.setName(dyn.getString("name"));
            entry.setJournalType(dyn.getString("journaltype"));
            entry.setLinkCreateType(dyn.getString("linkcreatetype"));
            entry.setBalanceType(dyn.getString("balancetype"));
            entry.setAdjustCatalogNumber(dyn.getString("adjustcatalog.number"));
            entry.setRelationTypeNumber(dyn.getString("relationtype.number"));
            entry.setRemark(dyn.getString("remark"));
            entry.setBillStatus(dyn.getString("billstatus"));
            DynamicObjectCollection invelimtplentry = dyn.getDynamicObjectCollection("invelimtplentry");
            ArrayList<InvSheetRow> rows = new ArrayList<InvSheetRow>(16);
            for (DynamicObject elimDyn : invelimtplentry) {
                InvSheetRow row = new InvSheetRow();
                row.setDescriction(elimDyn.getString("description"));
                row.setAccountNumber(elimDyn.getString("account.number"));
                row.setChangTpyeNumber(elimDyn.getString("changetype.number"));
                row.setEntity(elimDyn.getString("entitycomb"));
                row.setMycompany(elimDyn.getString("mycompany.number"));
                row.setIntercompany(elimDyn.getString("internalcompany.number"));
                row.setAudittrailNumber(elimDyn.getString("audittrail.number"));
                row.setDatasortNumber(elimDyn.getString("datasource.number"));
                row.setMultigaapNumber(elimDyn.getString("multigaap.number"));
                row.setUserdefined1Number((Pair<String, String>)Pair.onePair((Object)elimDyn.getString("userdefine1.dimension.number"), (Object)elimDyn.getString("userdefine1.number")));
                row.setUserdefined2Number((Pair<String, String>)Pair.onePair((Object)elimDyn.getString("userdefine2.dimension.number"), (Object)elimDyn.getString("userdefine2.number")));
                row.setUserdefined3Number((Pair<String, String>)Pair.onePair((Object)elimDyn.getString("userdefine3.dimension.number"), (Object)elimDyn.getString("userdefine3.number")));
                row.setUserdefined4Number((Pair<String, String>)Pair.onePair((Object)elimDyn.getString("userdefine4.dimension.number"), (Object)elimDyn.getString("userdefine4.number")));
                row.setUserdefined5Number((Pair<String, String>)Pair.onePair((Object)elimDyn.getString("userdefine5.dimension.number"), (Object)elimDyn.getString("userdefine5.number")));
                row.setUserdefined6Number((Pair<String, String>)Pair.onePair((Object)elimDyn.getString("userdefine6.dimension.number"), (Object)elimDyn.getString("userdefine6.number")));
                row.setRuleExprNumber(InvTmplImportExportHelper.getExtFieldNumberById(modelId, elimDyn.getString("ruleexpr")));
                row.setRuleExprDeptNumber(InvTmplImportExportHelper.getExtFieldNumberById(modelId, elimDyn.getString("ruleexprdept")));
                rows.add(row);
            }
            entry.setRowList(rows);
            entryList.add(entry);
        }
        return entryList;
    }

    private static List<DynamicObject> convertToEntryDyn(Long extGroupId, Map<String, String> dimFieldMapped, List<InvSheetEntry> invSheetEntryList, long tmplId, Long modelId, Long sceneId) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (CollectionUtils.isEmpty(invSheetEntryList)) {
            return result;
        }
        HashSet<String> adjustCatalogNumbers = new HashSet<String>(16);
        HashSet<String> relationtypeNumbers = new HashSet<String>(16);
        HashMap<String, DynamicObject> entryMaps = new HashMap<String, DynamicObject>(16);
        for (InvSheetEntry entry : invSheetEntryList) {
            DynamicObject entryDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsheetttplentrys");
            long entryId = GlobalIdUtil.genGlobalLongId();
            adjustCatalogNumbers.add(entry.getAdjustCatalogNumber());
            relationtypeNumbers.add(entry.getRelationTypeNumber());
            entryDyn.set("id", (Object)entryId);
            String number = entry.getNumber();
            entryDyn.set("number", (Object)number);
            entryDyn.set("name", (Object)entry.getName());
            entryDyn.set("model", (Object)modelId);
            entryDyn.set("scenario", (Object)sceneId);
            entryDyn.set("sheettemplate", (Object)tmplId);
            entryDyn.set("journaltype", (Object)entry.getJournalType());
            entryDyn.set("linkcreatetype", (Object)entry.getLinkCreateType());
            entryDyn.set("balancetype", (Object)entry.getBalanceType());
            entryDyn.set("remark", (Object)entry.getRemark());
            entryDyn.set("billstatus", (Object)entry.getBillStatus());
            String userId = RequestContext.get().getUserId();
            entryDyn.set("creator", (Object)userId);
            entryDyn.set("modifier", (Object)userId);
            Date now = new Date();
            entryDyn.set("createtime", (Object)now);
            entryDyn.set("modifytime", (Object)now);
            DynamicObjectCollection doc = entryDyn.getDynamicObjectCollection("invelimtplentry");
            int seq = 1;
            for (InvSheetRow row : entry.getRowList()) {
                DynamicObject rowDyn = new DynamicObject(doc.getDynamicObjectType());
                rowDyn.set("seq", (Object)seq);
                rowDyn.set("description", (Object)row.getDescriction());
                rowDyn.set("account", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.ACCOUNT_DIM, row.getAccountNumber()));
                rowDyn.set("changetype", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.CHANGETYPE_DIM, row.getChangTpyeNumber()));
                rowDyn.set("entitycomb", (Object)row.getEntity());
                rowDyn.set("mycompany", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey(PresetConstant.MYCOMPANY_DIM), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.MYCOMPANY_DIM, row.getMycompany()), "MCNone"));
                rowDyn.set("internalcompany", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.INTERNALCOMPANY_DIM, row.getIntercompany()));
                rowDyn.set("audittrail", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.AUDITTRIAL_DIM, row.getAudittrailNumber()));
                rowDyn.set("datasource", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey(PresetConstant.DATASORT_DIM), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.DATASORT_DIM, row.getDatasortNumber()), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.DATASORT_DIM, "Actual")));
                rowDyn.set("multigaap", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey(PresetConstant.RULE_DIM), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.RULE_DIM, row.getMultigaapNumber()), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.RULE_DIM, "PRCGAAP")));
                rowDyn.set("userdefine1", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim1"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined1Number().p1, (String)row.getUserdefined1Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim1"), dimFieldMapped.get("dim1") + "None")));
                rowDyn.set("userdefine2", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim2"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined2Number().p1, (String)row.getUserdefined2Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim2"), dimFieldMapped.get("dim2") + "None")));
                rowDyn.set("userdefine3", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim3"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined3Number().p1, (String)row.getUserdefined3Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim3"), dimFieldMapped.get("dim3") + "None")));
                rowDyn.set("userdefine4", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim4"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined4Number().p1, (String)row.getUserdefined4Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim4"), dimFieldMapped.get("dim4") + "None")));
                rowDyn.set("userdefine5", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim5"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined5Number().p1, (String)row.getUserdefined5Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim5"), dimFieldMapped.get("dim5") + "None")));
                rowDyn.set("userdefine6", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim6"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined6Number().p1, (String)row.getUserdefined6Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim6"), dimFieldMapped.get("dim6") + "None")));
                rowDyn.set("ruleexpr", (Object)InvTmplImportExportHelper.getRuleExtFieldIdByNum(modelId, extGroupId, row.getRuleExprNumber()));
                rowDyn.set("ruleexprdept", (Object)InvTmplImportExportHelper.getRuleExtFieldIdByNum(modelId, extGroupId, row.getRuleExprDeptNumber()));
                doc.add((Object)rowDyn);
                ++seq;
            }
            result.add(entryDyn);
            entryMaps.put(number, entryDyn);
        }
        Map<String, Long> relationTypeMaps = InvTmplImportExportHelper.getRelationTypeByNum(modelId, relationtypeNumbers);
        Map<String, Long> adjustCatalogMaps = InvTmplImportExportHelper.getAdjustCatalogByNum(modelId, adjustCatalogNumbers);
        invSheetEntryList.forEach(sheetEntry -> {
            String number = sheetEntry.getNumber();
            DynamicObject dy = (DynamicObject)entryMaps.get(number);
            String relationTypeNumber = sheetEntry.getRelationTypeNumber();
            String adjustCatalogNumber = sheetEntry.getAdjustCatalogNumber();
            if (Optional.ofNullable(relationTypeNumber).isPresent()) {
                dy.set("relationtype", relationTypeMaps.get(relationTypeNumber));
            }
            if (Optional.ofNullable(adjustCatalogNumber).isPresent()) {
                dy.set("adjustcatalog", adjustCatalogMaps.get(adjustCatalogNumber));
            }
        });
        return result;
    }

    private static String getExtFieldNumberById(long modelId, String extFieldId) {
        if ("bn".equals(extFieldId)) {
            return extFieldId;
        }
        IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)"bcm_structofextend", (Long)LongUtil.toLong((Object)extFieldId));
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return "";
        }
        return node.getNumber();
    }

    private static String getRuleExtFieldIdByNum(long modelId, Long extGroupId, String extFieldNum) {
        if (extGroupId == null) {
            return null;
        }
        if ("bn".equals(extFieldNum)) {
            return extFieldNum;
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)DimEntityNumEnum.EXTENDS.getNumber(), (String)extFieldNum);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return null;
        }
        IDNumberTreeNode fieldNode = null;
        if (extGroupId.equals(node.getParent().getId())) {
            fieldNode = node;
        } else if (!CollectionUtils.isEmpty((Collection)node.getShareNodes())) {
            for (IDNumberTreeNode shareNode : node.getShareNodes()) {
                if (!extGroupId.equals(shareNode.getParent().getId())) continue;
                fieldNode = shareNode;
                break;
            }
        }
        if (fieldNode != null) {
            return fieldNode.getId().toString();
        }
        return null;
    }

    private static InvTemplate convertToTemplate(DynamicObject dyn) {
        InvTemplate tmpl = new InvTemplate();
        tmpl.setNumber(dyn.getString("number"));
        tmpl.setName(dyn.getString("name"));
        BigDecimal versionnumber = dyn.getBigDecimal("versionnumber");
        tmpl.setVersionNumber(versionnumber != null ? versionnumber.setScale(1, RoundingMode.HALF_UP).toPlainString() : "");
        tmpl.setVersiondescriction(dyn.getString("versiondescription"));
        tmpl.setCount(dyn.getInt("count"));
        tmpl.setExtmodelNumber(dyn.getString("extdimid.number"));
        tmpl.setSpreadType(dyn.getString("spreadtype"));
        tmpl.setSpreadJson(dyn.getString("spreadjson"));
        tmpl.setData(dyn.getString("data"));
        tmpl.setProcessNumber(dyn.getString("process.number"));
        tmpl.setShowType(dyn.getString("showtype"));
        return tmpl;
    }

    private static DynamicObject convertToTmplDyn(InvTemplate tmpl, Long modelId, Long sceneid, Long catalogId, Integer version, Long groupId, Date modelBeginDate) {
        DynamicObject tmplDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_papertemplate");
        tmplDyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        tmplDyn.set("number", (Object)tmpl.getNumber());
        tmplDyn.set("name", tmpl.getName());
        tmplDyn.set("group", (Object)groupId);
        tmplDyn.set("versionnumber", (Object)BigDecimal.valueOf(version.intValue()));
        tmplDyn.set("versiondescription", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u751f\u6210", (String)"InvTmplImportExportHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        tmplDyn.set("count", (Object)tmpl.getCount());
        tmplDyn.set("extdimid", (Object)PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getExtmodelNumber()));
        tmplDyn.set("spreadtype", (Object)tmpl.getSpreadType());
        tmplDyn.set("spreadjson", (Object)tmpl.getSpreadJson());
        tmplDyn.set("data", (Object)tmpl.getData());
        tmplDyn.set("process", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.PROCESS_DIM, tmpl.getProcessNumber()));
        tmplDyn.set("templatecatalog", (Object)catalogId);
        tmplDyn.set("model", (Object)modelId);
        tmplDyn.set("scenario", (Object)sceneid);
        tmplDyn.set("showtype", (Object)tmpl.getShowType());
        String userId = RequestContext.get().getUserId();
        tmplDyn.set("creator", (Object)userId);
        tmplDyn.set("modifier", (Object)userId);
        Date now = new Date();
        tmplDyn.set("createtime", (Object)now);
        tmplDyn.set("modifytime", (Object)now);
        tmplDyn.set("effectivedate", (Object)modelBeginDate);
        tmplDyn.set("executeorder", (Object)new BigDecimal("99999"));
        tmplDyn.set("status", (Object)InvSheetTemplateConstant.BillStatusEnum.DISABLE.getCode());
        Map number2CslDyMap = (Map)ThreadCache.get((Object)"CslSchemeServiceHelper.queryAllSchemes", () -> CslSchemeServiceHelper.queryAllSchemes(null, modelId).stream().collect(Collectors.toMap(p -> p.getString("number"), p -> p.getLong("id"), (e1, e2) -> e2)));
        if (!CollectionUtils.isEmpty(tmpl.getRelationCslList())) {
            DynamicObjectCollection relaCsl = tmplDyn.getDynamicObjectCollection("relacslscheme");
            for (String cslNum : tmpl.getRelationCslList()) {
                if (!number2CslDyMap.containsKey(cslNum)) continue;
                relaCsl.addNew().set("fbasedataid", number2CslDyMap.get(cslNum));
            }
        }
        Map number2RelaDyMap = (Map)ThreadCache.get((Object)"CslSchemeServiceHelper.getInvrelationTypeNumbers", () -> QueryServiceHelper.query((String)"bcm_invrelatype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}).stream().collect(Collectors.toMap(p -> p.getString("number"), p -> p.getLong("id"), (e1, e2) -> e2)));
        DynamicObjectCollection relaTypeDyns = tmplDyn.getDynamicObjectCollection("invrelationtype");
        for (String relaType : tmpl.getInvrelationTypeNumbers()) {
            if (!number2RelaDyMap.containsKey(relaType)) continue;
            relaTypeDyns.addNew().set("fbasedataid", number2RelaDyMap.get(relaType));
        }
        return tmplDyn;
    }

    private static Map<String, Long> getRelationTypeByNum(Long modelId, Set<String> typeNums) {
        DynamicObjectCollection relationtypes = QueryServiceHelper.query((String)"bcm_invrelatype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "in", typeNums)});
        Map<String, Long> typeMap = relationtypes.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        return typeMap;
    }

    private static Map<String, Long> getAdjustCatalogByNum(Long modelId, Set<String> catalogNums) {
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter2 = new QFilter("catalogtype", "=", (Object)(TemplateCatalogTypeEnum.ADJCATALOG.getType() + "")).or("parent.id", "=", (Object)0);
        QFilter qFilter = qFilter1.and(qFilter2);
        DynamicObjectCollection adjustCatalogs = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,number", (QFilter[])new QFilter[]{qFilter, new QFilter("number", "in", catalogNums)});
        Map<String, Long> catalogMap = adjustCatalogs.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        return catalogMap;
    }

    public static PaperTmplImportResult importTmpls(Long modelId, Long sceneid, Long catalog, String jsonString, Map<String, String> numberMap) {
        PaperTmplImportResult result = new PaperTmplImportResult();
        List tmpls = new ArrayList(16);
        try {
            tmpls = (List)ObjectSerialUtil.deSerializedBytes((String)jsonString);
        }
        catch (Exception e2) {
            log.error("invest template import error.", (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvTmplImportExportHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (numberMap != null && !numberMap.isEmpty()) {
            for (InvTemplate tmpl : tmpls) {
                tmpl.setNumber(numberMap.getOrDefault(String.format("%s_%s", tmpl.getNumber(), tmpl.getVersionNumber()), tmpl.getNumber()));
            }
        }
        ArrayList<PaperTmplImportInfo> successTmpls = new ArrayList<PaperTmplImportInfo>(16);
        ArrayList<PaperTmplImportInfo> needUpdateTmpls = new ArrayList<PaperTmplImportInfo>(16);
        ArrayList<PaperTmplImportInfo> failTmpls = new ArrayList<PaperTmplImportInfo>(16);
        result.setSuccessTmpls(successTmpls);
        result.setNeedUpdateTmpls(needUpdateTmpls);
        result.setFailTmpls(failTmpls);
        HashMap<String, List> successImportMap = new HashMap<String, List>(16);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (InvTemplate tmpl : tmpls) {
            String failMsg = InvTmplImportExportHelper.validateTmpl(modelId, modelNum, tmpl);
            if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
                failTmpls.add(new PaperTmplImportInfo(tmpl.getNumber(), tmpl.getLocalName(), tmpl.getVersionNumber(), failMsg));
                continue;
            }
            successTmpls.add(new PaperTmplImportInfo(tmpl.getNumber(), tmpl.getLocalName(), tmpl.getVersionNumber()));
            successImportMap.computeIfAbsent(tmpl.getNumber(), k -> new ArrayList(16)).add(tmpl);
        }
        if (CollectionUtils.isEmpty(successTmpls)) {
            return result;
        }
        Date modelBeginDate = EntityVersioningUtil.getModelBeginDate(modelId);
        Map<String, FourTuple<Integer, Long, Long, Long>> updateTmplVersionMap = PaperTmplExpImpHelper.getTmplMaxVersion(modelId, TemplateCatalogEnum.INVELIM, successTmpls.stream().map(PaperTmplImportInfo::getNumber).collect(Collectors.toSet()));
        ArrayList tmplDynList = new ArrayList(16);
        ArrayList layoutDynList = new ArrayList(16);
        ArrayList adjustDynList = new ArrayList(16);
        ArrayList tmplSceneDynList = new ArrayList(16);
        ArrayList distributionDynList = new ArrayList(16);
        for (Map.Entry kv : successImportMap.entrySet()) {
            List tmplList = (List)kv.getValue();
            if (updateTmplVersionMap.containsKey(kv.getKey()) || tmplList.size() > 1) {
                needUpdateTmpls.addAll(tmplList.stream().map(e -> new PaperTmplImportInfo(e.getNumber(), e.getLocalName(), e.getVersionNumber())).collect(Collectors.toList()));
            }
            Map<String, List<DynamicObject>> saveMap = InvTmplImportExportHelper.buildSaveDocMap(tmplList, modelId, sceneid, catalog, updateTmplVersionMap.get(kv.getKey()), modelBeginDate);
            tmplDynList.addAll(saveMap.get("tmpl"));
            layoutDynList.addAll(saveMap.get("layout"));
            adjustDynList.addAll(saveMap.get("adjust"));
            tmplSceneDynList.addAll(saveMap.get("tmplScene"));
            distributionDynList.addAll(saveMap.get("distribution"));
        }
        try (TXHandle tx = TX.required((String)"saveInvTemplate");){
            try {
                SaveServiceHelper.save((DynamicObject[])tmplDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])layoutDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])adjustDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])tmplSceneDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])distributionDynList.toArray(new DynamicObject[0]));
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("saveInvTemplate error", t);
                throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
            }
        }
        return result;
    }

    private static Map<String, List<DynamicObject>> buildSaveDocMap(List<InvTemplate> tmplList, Long modelId, Long sceneid, Long catalogId, FourTuple<Integer, Long, Long, Long> versionGroupId, Date modelBeginDate) {
        ArrayList<DynamicObject> tmplDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> layoutDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> adjustDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> tmplSceneDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> distributionDynList = new ArrayList<DynamicObject>(16);
        int version = 0;
        Long groupId = 0L;
        if (versionGroupId != null) {
            version = (Integer)versionGroupId.item1;
            groupId = (Long)versionGroupId.item2;
        }
        if (groupId == 0L) {
            groupId = GlobalIdUtil.genGlobalLongId();
            if (sceneid != null) {
                tmplSceneDynList.add(PaperTmplExpImpHelper.createTmplSceneDyn(modelId, sceneid, groupId, PaperTemplateTypeEnum.INVELIM));
            }
        }
        Map<String, String> dimFieldMapped = PaperTmplExpImpHelper.getDimFieldMapped(modelId);
        for (int i = 0; i < tmplList.size(); ++i) {
            ++version;
            InvTemplate tmpl = tmplList.get(i);
            if (versionGroupId != null || i != 0) {
                modelBeginDate = null;
            }
            Long newCatalodId = versionGroupId != null ? (Long)versionGroupId.item4 : catalogId;
            DynamicObject tmplDyn = InvTmplImportExportHelper.convertToTmplDyn(tmpl, modelId, sceneid, newCatalodId, version, groupId, modelBeginDate);
            tmplDynList.add(tmplDyn);
            if (versionGroupId != null) {
                distributionDynList.addAll(PaperTmplExpImpHelper.createDistributionDyn(modelId, tmplDyn.getLong("id"), (Long)versionGroupId.item3));
            }
            Long extGroupId = IntrTemplateHelper.getGroupIdByExtModelId(PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getExtmodelNumber()));
            layoutDynList.addAll(InvTmplImportExportHelper.convertToLayoutDyn(extGroupId, tmplDyn.getLong("id"), modelId, tmpl.getFieldLayout()));
            adjustDynList.addAll(InvTmplImportExportHelper.convertToEntryDyn(extGroupId, dimFieldMapped, tmpl.getInvSheetEntryList(), tmplDyn.getLong("id"), modelId, sceneid));
        }
        return MapInitHelper.ofMap((Object)"tmpl", tmplDynList, (Object)"layout", layoutDynList, (Object)"adjust", adjustDynList, (Object)"tmplScene", tmplSceneDynList, (Object)"distribution", distributionDynList);
    }

    private static String validateTmpl(Long modelId, String modelNum, InvTemplate tmpl) {
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        if (!QueryServiceHelper.exists((String)"bcm_extendsmodel", (QFilter[])new QFilter[]{modelQf, new QFilter("number", "=", (Object)tmpl.getExtmodelNumber())})) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u3002", (String)"InvTemplateHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getExtmodelNumber());
        }
        String notExistInvRelationType = InvTmplImportExportHelper.getNotExistNumber("bcm_invrelatype", new QFilter[]{modelQf, new QFilter("number", "in", tmpl.getInvrelationTypeNumbers())}, "number", tmpl.getInvrelationTypeNumbers());
        if (!StringUtils.isBlank((CharSequence)notExistInvRelationType)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u6301\u80a1\u7c7b\u578b\u3002", (String)"InvTemplateHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), notExistInvRelationType);
        }
        String notExistProcess = PaperTmplExpImpHelper.getNotExistNumber(modelNum, PresetConstant.PROCESS_DIM, Sets.newHashSet((Object[])new String[]{tmpl.getProcessNumber()}));
        if (!StringUtils.isBlank((CharSequence)notExistProcess)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u8fc7\u7a0b\u3002", (String)"InvTemplateHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), notExistProcess);
        }
        if (!InvCaseProcessEnum.getInvNumber().contains(tmpl.getProcessNumber())) {
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u7f16\u7801\u4e3a[%s]\u8fc7\u7a0b\u7684\u5e95\u7a3f\u6a21\u677f\u3002", (String)"InvTmplImportExportHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), notExistProcess);
        }
        if ("ERAdj".equals(tmpl.getProcessNumber()) && CollectionUtils.isEmpty(tmpl.getRelationCslList())) {
            return ResManager.loadKDString((String)"\u5173\u8054\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvTmplImportExportHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        if (!CollectionUtils.isEmpty(tmpl.getFieldLayout())) {
            Set<String> fieldNumSet = tmpl.getFieldLayout().stream().map(e -> (String)e.p1).collect(Collectors.toSet());
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{modelQf, new QFilter("number", "=", (Object)tmpl.getExtmodelNumber())});
            String string = InvTmplImportExportHelper.getNotExistNumber("bcm_extmodelfield", new QFilter[]{new QFilter("extmodelid", "=", (Object)dyn.getLong("id")), new QFilter("extfield.number", "in", fieldNumSet)}, "extfield.number", fieldNumSet);
            if (!StringUtils.isBlank((CharSequence)string)) {
                return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b[%1$s]\u4e2d\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u62d3\u5c55\u7ef4\u5b57\u6bb5\u3002", (String)"InvTemplateHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getExtmodelNumber(), string);
            }
        }
        if (!CollectionUtils.isEmpty(tmpl.getInvSheetEntryList())) {
            HashMap<String, Set> memberNumMap = new HashMap<String, Set>(16);
            for (InvSheetEntry invSheetEntry : tmpl.getInvSheetEntryList()) {
                for (InvSheetRow row : invSheetEntry.getRowList()) {
                    memberNumMap.computeIfAbsent(PresetConstant.ACCOUNT_DIM, k -> new HashSet(16)).add(row.getAccountNumber());
                    memberNumMap.computeIfAbsent(PresetConstant.CHANGETYPE_DIM, k -> new HashSet(16)).add(row.getChangTpyeNumber());
                    memberNumMap.computeIfAbsent(PresetConstant.AUDITTRIAL_DIM, k -> new HashSet(16)).add(row.getAudittrailNumber());
                    memberNumMap.computeIfAbsent(PresetConstant.DATASORT_DIM, k -> new HashSet(16)).add(row.getDatasortNumber());
                    memberNumMap.computeIfAbsent(PresetConstant.RULE_DIM, k -> new HashSet(16)).add(row.getMultigaapNumber());
                    memberNumMap.computeIfAbsent(PresetConstant.MYCOMPANY_DIM, k -> new HashSet(16)).add(row.getMycompany());
                    memberNumMap.computeIfAbsent(PresetConstant.INTERNALCOMPANY_DIM, k -> new HashSet(16)).add(row.getIntercompany());
                    memberNumMap.computeIfAbsent((String)row.getUserdefined1Number().p1, k -> new HashSet(16)).add(row.getUserdefined1Number().p2);
                    memberNumMap.computeIfAbsent((String)row.getUserdefined2Number().p1, k -> new HashSet(16)).add(row.getUserdefined2Number().p2);
                    memberNumMap.computeIfAbsent((String)row.getUserdefined3Number().p1, k -> new HashSet(16)).add(row.getUserdefined3Number().p2);
                    memberNumMap.computeIfAbsent((String)row.getUserdefined4Number().p1, k -> new HashSet(16)).add(row.getUserdefined4Number().p2);
                    memberNumMap.computeIfAbsent((String)row.getUserdefined5Number().p1, k -> new HashSet(16)).add(row.getUserdefined5Number().p2);
                    memberNumMap.computeIfAbsent((String)row.getUserdefined6Number().p1, k -> new HashSet(16)).add(row.getUserdefined6Number().p2);
                }
            }
            for (Map.Entry entry : memberNumMap.entrySet()) {
                String errorMsg;
                if (entry.getKey() == null || StringUtils.isBlank((CharSequence)(errorMsg = PaperTmplExpImpHelper.getErrorMsg(modelNum, (String)entry.getKey(), (Set)entry.getValue())))) continue;
                return errorMsg;
            }
        }
        return null;
    }

    private static String getNotExistNumber(String entityName, QFilter[] qFilters, String numberField, Collection<String> numbers) {
        if (numbers != null) {
            numbers.removeIf(Objects::isNull);
        }
        if (numbers == null || numbers.isEmpty()) {
            return "";
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityName, (String)("id," + numberField), (QFilter[])qFilters);
        Set numberSet = doc.stream().map(e -> e.getString(numberField)).collect(Collectors.toSet());
        return String.join((CharSequence)",", numbers.stream().filter(e -> !numberSet.contains(e)).collect(Collectors.toSet()));
    }
}

