/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.service.InvShareholdingValidator;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;

public class InvDynamicStockRadioService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvDynamicStockRadioService.class);
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-business";
    private static Map<String, Long> limTempNumber2Dy;
    private static Map<String, Long> tempNumberToGroup;
    private static final Table<String, String, Long> sheetEntryTable;
    private int seq;

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public static InvValidateHelper<JSONObject> jsonObjectValidateHelper(Long modelId) {
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String confirmOpen = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b", (String)"InvDynamicStockRadioService_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String confirmShare = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u672b\u6301\u80a1\u6bd4\u4f8b", (String)"InvDynamicStockRadioService_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String confirmchange = ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvDynamicStockRadioService_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvDynamicStockRadioService_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String shareholderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvDynamicStockRadioService_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        return new InvValidateHelper(validator).add(() -> validator.notNull("confirmopenscale", confirmOpen)).add(() -> validator.notNull("confirmsharescale", confirmShare)).add(() -> validator.notNull("confirmchangescale", confirmchange)).add(() -> validator.ratioBetween0To100("confirmopenscale", confirmOpen)).add(() -> validator.ratioBetween0To100("confirmsharescale", confirmShare)).add(() -> validator.ratioBetween0To100("confirmchangescale", confirmchange)).add(() -> validator.independentOrg("shareholder", shareholderPropName)).add(() -> validator.independentOrg("investeecompany", investedCompanyPropName)).add(() -> validator.notEquals("shareholder", "investeecompany")).add(() -> validator.uniqueComboByKey("invchangetype", "merge", "shareholder", "investeecompany"));
    }

    public static InvValidateHelper<DynamicObject> dynObjectValidateHelper(Long modelId) {
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvDynamicStockRadioService_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String merge = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvDynamicStockRadioService_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        return new InvValidateHelper(validator).add(() -> validator.baseDataNotNull("shareholder", ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvDynamicStockRadioService_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("investeecompany", investedCompanyPropName)).add(() -> validator.baseDataNotNull("invchangetype", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"InvDynamicStockRadioService_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.entHavePerm("investeecompany", permissionService, dimensionId, investedCompanyPropName));
    }

    public static String generateKey(DynamicObject dynamicObject) {
        return InvDynamicStockRadioService.generateKey(dynamicObject.getString("merge"), dynamicObject.getString("shareholder"), dynamicObject.getString("investeecompany"), dynamicObject.getString("invchangetype"));
    }

    public static String generateKey(JSONObject dynamicObject) {
        return InvDynamicStockRadioService.generateKey(dynamicObject.getString("merge"), dynamicObject.getString("shareholder"), dynamicObject.getString("investeecompany"), dynamicObject.getString("invchangetype"));
    }

    public static String generateKey(String merge, String shareholder, String investedCompany, String changeType) {
        return String.join((CharSequence)"&", merge, shareholder, investedCompany, changeType);
    }

    public Pair<Set<String>, Set<String>> importTemplate(JSONObject data, DynamicObjectCollection limTemplate) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getString("invelimtemplatenumbers")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            Long id;
            String isExcept = InvDynamicStockRatioConstant.ExceptEnum.APPLICABLE.getCode();
            if (number.contains("@")) {
                String[] split = number.split("@");
                number = split[0];
                isExcept = split[1];
            }
            if ((id = limTempNumber2Dy.get(number)) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            if (InvDynamicStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = limTemplate.addNew();
            configRow.set("temtype", (Object)"bcm_invelimtemplatebase");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    public Pair<Set<String>, Set<String>> importNewTemplate(JSONObject data, DynamicObjectCollection effectTemps) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getString("effectnewtempnumbers")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            String sheetEntryNumber;
            String tempNumber;
            Long id;
            String[] tempNumbers;
            String[] numberAndIsExceptConfig = number.split("@");
            if (numberAndIsExceptConfig.length < 2 || (tempNumbers = numberAndIsExceptConfig[0].split("\\|")).length < 2 || (id = (Long)sheetEntryTable.get((Object)(tempNumber = tempNumbers[0]), (Object)(sheetEntryNumber = tempNumbers[1]))) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            String isExcept = numberAndIsExceptConfig[1];
            if (InvDynamicStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = effectTemps.addNew();
            Long group = tempNumberToGroup.getOrDefault(tempNumber, 0L);
            configRow.set("temtype", (Object)"bcm_invsheetttplentrys");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
            configRow.set("group", (Object)group);
            configRow.set("number", (Object)sheetEntryNumber);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    private void effectTempCanUse(long modelId, long yearId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId)};
        DynamicObjectCollection limTempDys = QueryServiceHelper.query((String)"bcm_invelimtemplatebase", (String)"id,number", (QFilter[])filters);
        limTempNumber2Dy = limTempDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (v1, v2) -> v1));
        DynamicObjectCollection sheetTemp = InvSheetTemplateService.querySheetTemp(modelId, yearId, periodId);
        tempNumberToGroup = sheetTemp.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("group"), (v1, v2) -> v1));
        List sheetTempIds = sheetTemp.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFBuilder qfSheetEntryBuilder = new QFBuilder("sheettemplate", "in", sheetTempIds);
        String selectFields = "id,number,sheettemplate.number";
        DynamicObjectCollection sheetEntries = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)selectFields, (QFilter[])qfSheetEntryBuilder.toArray());
        for (DynamicObject dy2 : sheetEntries) {
            long sheetEntryId = dy2.getLong("id");
            String sheetEntryNumber = dy2.getString("number");
            String tempNumber = dy2.getString("sheettemplate.number");
            sheetEntryTable.put((Object)tempNumber, (Object)sheetEntryNumber, (Object)sheetEntryId);
        }
    }

    public Map<String, DynamicObject> collectRelation(long modelId, long yearId, long scenarioId, long periodId, Collection<Long> baseIds) {
        AtomicInteger seq = new AtomicInteger();
        DynamicObjectCollection dynamicObjects = InvDynamicStockRatioHelper.loadGroupChangeTypeRelation(scenarioId, yearId, periodId, Collections.emptyList(), baseIds, InvDynamicStockRatioConstant.getSelectFields((String[])new String[]{"shareholder.number", "investeecompany.number", "invchangetype.number", "invchangetype.name"}));
        Map<String, DynamicObject> collect = dynamicObjects.stream().peek(dy -> seq.set(Math.max(seq.get(), dy.getInt("seqnum")))).collect(Collectors.toMap(InvDynamicStockRadioService::generateKey, e -> e, (v1, v2) -> v1));
        this.effectTempCanUse(modelId, yearId, periodId);
        this.seq = seq.get();
        return collect;
    }

    public static String getNumberFromJson(JSONObject data, String key) {
        return data.getJSONObject(key).getString("number");
    }

    static {
        sheetEntryTable = HashBasedTable.create();
    }
}

