/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.invratio.model.InvRelationRuleContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import org.apache.commons.collections.CollectionUtils;

public class InvRelationExcRuleService {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvRelationExcRuleService.class);
    protected InvRelationRuleContext ctx;

    public InvRelationExcRuleService(InvRelationRuleContext context) {
        this.ctx = context;
    }

    private BizRuleExecParam getBizRuleExecParam(String process) {
        BizRuleExecParam p = new BizRuleExecParam(this.ctx.getModelNum());
        IDNumberTreeNode orgnode = MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)this.ctx.getOrgUnitNumber());
        IDNumberTreeNode curnode = MemberReader.findCurrencyMemberByNum((String)this.ctx.getModelNum(), (String)orgnode.getCurrency());
        p.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, orgnode.getId(), this.ctx.getOrgUnitNumber());
        p.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, Long.valueOf(this.ctx.getFyId()), this.ctx.getFyNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, Long.valueOf(this.ctx.getPeriodId()), this.ctx.getPeriodNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, Long.valueOf(this.ctx.getScenarioId()), this.ctx.getScenariodNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, curnode.getId(), curnode.getNumber());
        p.getCommonParam().addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findMemberByNumber((String)this.ctx.getModelNum(), (String)PresetConstant.PROCESS_DIM, (String)process).getId(), process);
        return p;
    }

    public Object[] excBizRule() {
        BizRuleExecParam param = this.getBizRuleExecParam("EIRpt");
        Collection allocateRecords = BizRuleServiceHelper.getBizRule((String)this.ctx.getModelNum(), f -> f.add("bizrule.executetype", "in", (Object)BizRuleExecuteTypeEnum.INVEST_ONLY.getCode()), (String[])new String[]{"EIRpt"});
        ArrayList bizRuleList = new ArrayList();
        allocateRecords.forEach(e -> {
            String content = e.getString("bizrule.content");
            if (StringUtils.isNotEmpty((String)content)) {
                bizRuleList.add(Pair.onePair((Object)e.getLong("bizrule.id"), (Object)content));
            }
        });
        if (CollectionUtils.isEmpty((Collection)allocateRecords)) {
            return Collections.emptyList().toArray();
        }
        Object[] records = BizRuleExecStarter.createExecRecord(allocateRecords.toArray(new DynamicObject[0]), param, this.ctx.getModelId());
        param.setBizRuleList(bizRuleList);
        param.setExecuteType(BizRuleExecuteTypeEnum.INVEST_ONLY);
        int calcTypeWay = this.getCalcTypeWay();
        param.setCalcTypeWay(String.valueOf(calcTypeWay));
        ArrayList<BizRuleExecParam> excuteParams = new ArrayList<BizRuleExecParam>();
        excuteParams.add(param);
        InvestServiceHelper.excRule(param, (DynamicObject[])records, excuteParams);
        return records;
    }

    private int getCalcTypeWay() {
        boolean calcStaticstock = this.ctx.isCalcStaticstock();
        boolean calcdynamicStock = this.ctx.isCalcdynamicStock();
        if (calcStaticstock && !calcdynamicStock) {
            return CalcTypeWayEnum.STATICSTOCK.getCode();
        }
        if (!calcStaticstock && calcdynamicStock) {
            return CalcTypeWayEnum.DYNAMICSTOCK.getCode();
        }
        return CalcTypeWayEnum.ALL.getCode();
    }

    public static enum CalcTypeWayEnum {
        STATICSTOCK(0, new MultiLangEnumBridge("\u9759\u6001\u80a1\u6bd4", "InvRelationExcRuleService_1", "fi-bcm-common")),
        DYNAMICSTOCK(1, new MultiLangEnumBridge("\u52a8\u6001\u80a1\u6bd4", "InvRelationExcRuleService_2", "fi-bcm-common")),
        ALL(2, new MultiLangEnumBridge("\u5168\u90e8", "InvRelationExcRuleService_3", "fi-bcm-common"));

        private int code;
        private MultiLangEnumBridge name;

        private CalcTypeWayEnum(int code, MultiLangEnumBridge name) {
            this.code = code;
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name.loadKDString();
        }
    }
}

