/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.invest.invratio.InvRelationScaleService;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.invratio.model.InvRelationScaleInfo;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class InvRelationScaleHelper {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvElimPaperGenerateService.class);

    public static void saveScale(InvRelationScaleInfo invRelationRatio) {
        String categorized = invRelationRatio.getCategorized();
        String accuracy = InvRelationSetHelper.queryAccuracy(invRelationRatio.getModel());
        InvRelationScaleService invRelationExcRuleService = new InvRelationScaleService();
        invRelationExcRuleService.setAccuracy(Integer.parseInt(accuracy));
        invRelationExcRuleService.checkRelationType(invRelationRatio);
        invRelationExcRuleService.cvtInvrelationId(invRelationRatio);
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
            invRelationExcRuleService.saveStaticSale(invRelationRatio);
        } else {
            invRelationExcRuleService.savedynamicScale(invRelationRatio);
        }
    }

    public static void deleteScale(InvRelationScaleInfo invRelationRatio) {
        String categorized = invRelationRatio.getCategorized();
        InvRelationScaleService invRelationExcRuleService = new InvRelationScaleService();
        invRelationExcRuleService.checkRelationType(invRelationRatio);
        invRelationExcRuleService.cvtInvrelationId(invRelationRatio);
        invRelationExcRuleService.checkDimWritePerm(invRelationRatio);
        if (!InvRelationSearchService.checkModelPermission(invRelationRatio.getModel(), "bcm_invrelation_search", "4715a0df000000ac")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u3010\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u3011-\u3010\u4fdd\u5b58\u3011\u4f53\u7cfb\u529f\u80fd\u6743\u9650\u3002", (String)"InvRelationScaleHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
            invRelationExcRuleService.deleteStaticSaleLogic(invRelationRatio);
        } else {
            invRelationExcRuleService.deleteDynamicScaleLogic(invRelationRatio);
        }
    }
}

