/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.invratio.InvConfirmScaleEnum;
import kd.fi.bcm.business.invest.invratio.InvRelationScaleValidator;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.invratio.model.InvRelationScaleInfo;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvRelationScaleService {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvElimPaperGenerateService.class);
    private static int accuracy = 2;

    public void setAccuracy(int accuracy) {
        InvRelationScaleService.accuracy = accuracy;
    }

    public void checkRelationType(InvRelationScaleInfo invRelationRatio) {
        String categorized = invRelationRatio.getCategorized();
        String relationType = invRelationRatio.getRelationType();
        StringBuilder msgSb = new StringBuilder();
        if (!StringUtils.isBlank((String)relationType) || !StringUtils.isBlank((String)categorized)) {
            Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
            if (code2InvRelaTypeEnum.containsKey(relationType) && InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
                invRelationRatio.setRelationType(((InvRelaTypeEnum)code2InvRelaTypeEnum.get(relationType)).getType());
            } else {
                QFilter qFilter = new QFilter("model", "=", (Object)invRelationRatio.getModel());
                qFilter.and("number", "=", (Object)relationType);
                qFilter.and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
                if (!QueryServiceHelper.exists((String)"bcm_invrelatype", (QFilter[])new QFilter[]{qFilter})) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5305\u542b%s\u80a1\u6bd4\u7c7b\u578b!", (String)"InvExtDataServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), relationType));
                }
            }
        } else {
            msgSb.append(ResManager.loadKDString((String)"\u80a1\u6bd4\u7c7b\u578b\u6216\u7c7b\u578b\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvExtDataServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!StringUtils.isBlank((String)msgSb.toString())) {
            throw new KDBizException(msgSb.toString());
        }
    }

    public void saveStaticSale(InvRelationScaleInfo invRelationRatio) {
        DynamicObject staticSale;
        DynamicObjectCollection staticSales = this.getStaticScaleDy(invRelationRatio);
        int maxRelaseq = CollectionUtils.isNotEmpty((Collection)staticSales) ? ((DynamicObject)staticSales.get(0)).getInt("relaseq") : 0;
        Optional<DynamicObject> scale = staticSales.stream().filter(dy -> dy.getString("shareholder.number").equals(invRelationRatio.getShareholder()) && dy.getString("investeecompany.number").equals(invRelationRatio.getInvestCompany())).findFirst();
        if (!scale.isPresent()) {
            staticSale = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invrelation");
            this.createScaleDy(staticSale, invRelationRatio, maxRelaseq);
            List<String> checkRs = InvRelationScaleValidator.validateStaticStockRadio(staticSale);
            if (!checkRs.isEmpty()) {
                throw new KDBizException(String.join((CharSequence)"\n", checkRs));
            }
        } else {
            staticSale = BusinessDataServiceHelper.loadSingle((Object)scale.get().getLong("id"), (String)"bcm_invrelation");
            this.updateScaleDy(staticSale, invRelationRatio);
            List<String> checkRs = InvRelationScaleValidator.validateStaticStockRadioFromLoad(staticSale);
            if (!checkRs.isEmpty()) {
                throw new KDBizException(String.join((CharSequence)"\n", checkRs));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{staticSale});
    }

    public void deleteStaticScale(InvRelationScaleInfo invRelationScaleInfo) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)invRelationScaleInfo.getModel());
        qfBuilder.add("scenario", "=", (Object)invRelationScaleInfo.getScenario());
        qfBuilder.add("year", "=", (Object)invRelationScaleInfo.getYear());
        qfBuilder.add("period", "=", (Object)invRelationScaleInfo.getPeriod());
        qfBuilder.add("orgunit.number", "=", (Object)invRelationScaleInfo.getOrgUnit());
        qfBuilder.add("shareholder.number", "=", (Object)invRelationScaleInfo.getShareholder());
        qfBuilder.add("investeecompany.number", "=", (Object)invRelationScaleInfo.getInvestCompany());
        qfBuilder.add("invrelatype", "=", (Object)invRelationScaleInfo.getRelationType());
        DeleteServiceHelper.delete((String)"bcm_invrelation", (QFilter[])qfBuilder.toArray());
    }

    private DynamicObjectCollection getStaticScaleDy(InvRelationScaleInfo invRelationRatio) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)invRelationRatio.getModel());
        qfBuilder.add("scenario", "=", (Object)invRelationRatio.getScenario());
        qfBuilder.add("year", "=", (Object)invRelationRatio.getYear());
        qfBuilder.add("period", "=", (Object)invRelationRatio.getPeriod());
        qfBuilder.add("orgunit.number", "=", (Object)invRelationRatio.getOrgUnit());
        qfBuilder.add("invrelatype", "=", (Object)invRelationRatio.getRelationType());
        ArrayList selectFields = Lists.newArrayList((Object[])new String[]{"id", "invrelatype", "shareholder", "shareholder.number", "shareholder.name", "investeecompany", "investeecompany.number", "investeecompany.name", "confirmscale", "minconfirmscale", "equvscale", "isdelete", "relaseq"});
        DynamicObjectCollection staticSales = QueryServiceHelper.query((String)"bcm_invrelation", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray(), (String)"relaseq desc");
        return staticSales;
    }

    private void updateScaleDy(DynamicObject staticSale, InvRelationScaleInfo invRelationRatio) {
        String relationType = invRelationRatio.getRelationType();
        BigDecimal confirmscale = invRelationRatio.getConfirmScaleMap().get(InvConfirmScaleEnum.FINPOWN.getCode());
        confirmscale = confirmscale.setScale(accuracy, RoundingMode.HALF_UP);
        staticSale.set("confirmscale", (Object)confirmscale);
        if (InvRelaTypeEnum.MinRelaType.getType().equals(relationType) || InvRelaTypeEnum.SameLevelRelaType.getType().equals(relationType)) {
            staticSale.set("minconfirmscale", (Object)confirmscale);
        } else {
            staticSale.set("minconfirmscale", (Object)BigDecimal.valueOf(100L).subtract(confirmscale));
        }
        staticSale.set("isdelete", (Object)"0");
    }

    private void createScaleDy(DynamicObject staticSale, InvRelationScaleInfo invRelationRatio, int maxRelaseq) {
        staticSale.set("scenario", (Object)invRelationRatio.getScenario());
        staticSale.set("year", (Object)invRelationRatio.getYear());
        staticSale.set("period", (Object)invRelationRatio.getPeriod());
        staticSale.set("model", (Object)invRelationRatio.getModel());
        staticSale.set("orgunit", (Object)invRelationRatio.getOrgUnitId());
        staticSale.set("shareholder", (Object)invRelationRatio.getShareholderId());
        staticSale.set("investeecompany", (Object)invRelationRatio.getInvestCompanyId());
        staticSale.set("invrelatype", (Object)invRelationRatio.getRelationType());
        staticSale.set("creator", (Object)RequestContext.get().getUserId());
        staticSale.set("createtime", (Object)new Date());
        staticSale.set("modifier", (Object)RequestContext.get().getUserId());
        staticSale.set("modifytime", (Object)new Date());
        staticSale.set("equvscale", (Object)new BigDecimal(0));
        staticSale.set("isusedinvrule", (Object)false);
        staticSale.set("isconfirmed", (Object)false);
        staticSale.set("relaseq", (Object)(++maxRelaseq));
        this.updateScaleDy(staticSale, invRelationRatio);
    }

    private void createDynamicDy(DynamicObject dynamicScale, InvRelationScaleInfo invRelationRatio, int maxRelaseq) {
        String relationType = invRelationRatio.getRelationType();
        Map<String, ChangeTypeModel> invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(invRelationRatio.getModel());
        ChangeTypeModel changeTypeModel = invChangetypeModel.get(relationType);
        Long userId = LongUtil.toLong((Object)RequestContext.getOrCreate().getUserId());
        Date now = TimeServiceHelper.now();
        dynamicScale.set("model", (Object)invRelationRatio.getModel());
        dynamicScale.set("scenario", (Object)invRelationRatio.getScenario());
        dynamicScale.set("year", (Object)invRelationRatio.getYear());
        dynamicScale.set("period", (Object)invRelationRatio.getPeriod());
        dynamicScale.set("merge", (Object)invRelationRatio.getOrgUnitId());
        dynamicScale.set("shareholder", (Object)invRelationRatio.getShareholderId());
        dynamicScale.set("investeecompany", (Object)invRelationRatio.getInvestCompanyId());
        dynamicScale.set("invchangetype", (Object)changeTypeModel.getId());
        dynamicScale.set("modifierid", (Object)userId);
        dynamicScale.set("modifytime", (Object)now);
        dynamicScale.set("level", (Object)2);
        dynamicScale.set("seqnum", (Object)(++maxRelaseq));
        this.updateDynamicDy(dynamicScale, invRelationRatio);
    }

    public void savedynamicScale(InvRelationScaleInfo invRelationScaleInfo) {
        DynamicObject dynamicScale;
        DynamicObjectCollection dynamicObjects = InvDynamicStockRatioHelper.loadGroupChangeTypeRelation((long)invRelationScaleInfo.getScenario(), (long)invRelationScaleInfo.getYear(), (long)invRelationScaleInfo.getPeriod(), (Collection<String>)Lists.newArrayList((Object[])new String[]{"0", "1"}), invRelationScaleInfo.getOrgUnitId(), InvDynamicStockRatioConstant.getSelectFields());
        List sorts = dynamicObjects.stream().sorted(Comparator.comparing(dy -> ((DynamicObject)dy).getInt("seqnum")).reversed()).collect(Collectors.toList());
        int maxRelaseq = CollectionUtils.isNotEmpty(sorts) ? ((DynamicObject)sorts.get(0)).getInt("seqnum") : 0;
        Optional<DynamicObject> first = dynamicObjects.stream().filter(dy -> dy.getString("shareholder.number").equals(invRelationScaleInfo.getShareholder()) && dy.getString("investeecompany.number").equals(invRelationScaleInfo.getInvestCompany()) && dy.getString("invchangetype.number").equals(invRelationScaleInfo.getRelationType())).findFirst();
        if (!first.isPresent()) {
            dynamicScale = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dynamicstockratio");
            this.createDynamicDy(dynamicScale, invRelationScaleInfo, maxRelaseq);
            List<String> checkRs = InvRelationScaleValidator.validateDynamicStockRadio(dynamicScale);
            if (!checkRs.isEmpty()) {
                throw new KDBizException(String.join((CharSequence)"\n", checkRs));
            }
        } else {
            dynamicScale = BusinessDataServiceHelper.loadSingle((Object)first.get().getLong("id"), (String)"bcm_dynamicstockratio");
            this.updateDynamicDy(dynamicScale, invRelationScaleInfo);
            List<String> checkRs = InvRelationScaleValidator.validateDynamicStockRadioFromLoad(dynamicScale);
            if (!checkRs.isEmpty()) {
                throw new KDBizException(String.join((CharSequence)"\n", checkRs));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicScale});
    }

    public void deleteDynamicScale(InvRelationScaleInfo invRelationScaleInfo) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)invRelationScaleInfo.getModel());
        qfBuilder.add("scenario", "=", (Object)invRelationScaleInfo.getScenario());
        qfBuilder.add("year", "=", (Object)invRelationScaleInfo.getYear());
        qfBuilder.add("period", "=", (Object)invRelationScaleInfo.getPeriod());
        qfBuilder.add("orgunit.number", "=", (Object)invRelationScaleInfo.getOrgUnit());
        qfBuilder.add("shareholder.number", "=", (Object)invRelationScaleInfo.getShareholder());
        qfBuilder.add("investeecompany.number", "=", (Object)invRelationScaleInfo.getInvestCompany());
        qfBuilder.add("invrelatype", "=", (Object)invRelationScaleInfo.getRelationType());
        DeleteServiceHelper.delete((String)"bcm_invrelation", (QFilter[])qfBuilder.toArray());
    }

    private void updateDynamicDy(DynamicObject dynamicScale, InvRelationScaleInfo invRelationScaleInfo) {
        BigDecimal confirmopenscale = invRelationScaleInfo.getConfirmScaleMap().get(InvConfirmScaleEnum.FINBEGPOWN.getCode());
        BigDecimal confirmchangescale = invRelationScaleInfo.getConfirmScaleMap().get(InvConfirmScaleEnum.FINMOVPOWN.getCode());
        BigDecimal confirmsharescale = invRelationScaleInfo.getConfirmScaleMap().get(InvConfirmScaleEnum.FINENDPOWN.getCode());
        if (Objects.nonNull(confirmopenscale)) {
            confirmopenscale = confirmopenscale.setScale(accuracy, RoundingMode.HALF_UP);
            dynamicScale.set("confirmopenscale", (Object)confirmopenscale);
        }
        if (Objects.nonNull(confirmchangescale)) {
            confirmchangescale = confirmchangescale.setScale(accuracy, RoundingMode.HALF_UP);
            dynamicScale.set("confirmchangescale", (Object)confirmchangescale);
        }
        if (Objects.nonNull(confirmsharescale)) {
            confirmsharescale = confirmsharescale.setScale(accuracy, RoundingMode.HALF_UP);
            dynamicScale.set("confirmsharescale", (Object)confirmsharescale);
        }
        dynamicScale.set("status", (Object)"0");
    }

    public void cvtInvrelationId(InvRelationScaleInfo invRelationRatio) {
        String modelNumber = MemberReader.findModelNumberById((Object)invRelationRatio.getModel());
        IDNumberTreeNode orgnode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)invRelationRatio.getOrgUnit());
        IDNumberTreeNode investeecompany = MemberReader.findEntityMemberByNum((String)modelNumber, (String)invRelationRatio.getInvestCompany());
        Long investeecompanyId = investeecompany.getId();
        IDNumberTreeNode shareHolderMember = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)invRelationRatio.getModel()), (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)invRelationRatio.getShareholder());
        invRelationRatio.setOrgUnitId(orgnode.getId());
        invRelationRatio.setInvestCompanyId(investeecompanyId);
        invRelationRatio.setShareholderId(shareHolderMember.getId());
    }

    public void deleteStaticSaleLogic(InvRelationScaleInfo invRelationScaleInfo) {
        DynamicObject[] load;
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)invRelationScaleInfo.getModel());
        qfBuilder.add("scenario", "=", (Object)invRelationScaleInfo.getScenario());
        qfBuilder.add("year", "=", (Object)invRelationScaleInfo.getYear());
        qfBuilder.add("period", "=", (Object)invRelationScaleInfo.getPeriod());
        qfBuilder.add("orgunit.number", "=", (Object)invRelationScaleInfo.getOrgUnit());
        this.addQfIfNotNull(qfBuilder, "shareholder.number", invRelationScaleInfo.getShareholder());
        this.addQfIfNotNull(qfBuilder, "investeecompany.number", invRelationScaleInfo.getInvestCompany());
        qfBuilder.add("invrelatype", "=", (Object)invRelationScaleInfo.getRelationType());
        qfBuilder.add("isdelete", "!=", (Object)"1");
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bcm_invrelation", (String)"id,isdelete", (QFilter[])qfBuilder.toArray())) {
            dynamicObject.set("isdelete", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])load);
        log.info(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664\u9759\u6001\u80a1\u6bd4%1$s\u6761\u3002", (String)"InvRelationScaleService_1", (String)"fi-bcm-business", (Object[])new Object[0]), load.length));
    }

    public void deleteDynamicScaleLogic(InvRelationScaleInfo invRelationScaleInfo) {
        DynamicObject[] load;
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)invRelationScaleInfo.getModel());
        qfBuilder.add("scenario", "=", (Object)invRelationScaleInfo.getScenario());
        qfBuilder.add("year", "=", (Object)invRelationScaleInfo.getYear());
        qfBuilder.add("period", "=", (Object)invRelationScaleInfo.getPeriod());
        qfBuilder.add("merge.number", "=", (Object)invRelationScaleInfo.getOrgUnit());
        this.addQfIfNotNull(qfBuilder, "shareholder.number", invRelationScaleInfo.getShareholder());
        this.addQfIfNotNull(qfBuilder, "investeecompany.number", invRelationScaleInfo.getInvestCompany());
        qfBuilder.add("invchangetype.number", "=", (Object)invRelationScaleInfo.getRelationType());
        qfBuilder.add("status", "!=", (Object)InvDynamicStockRatioConstant.StatusEnum.DISABLE.getCode());
        String selectProperties = String.join((CharSequence)",", "id", "status");
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bcm_dynamicstockratio", (String)selectProperties, (QFilter[])qfBuilder.toArray())) {
            dynamicObject.set("status", (Object)InvDynamicStockRatioConstant.StatusEnum.DISABLE.getCode());
        }
        SaveServiceHelper.save((DynamicObject[])load);
        log.info(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664\u52a8\u6001\u80a1\u6bd4%1$s\u6761\u3002", (String)"InvRelationScaleService_2", (String)"fi-bcm-business", (Object[])new Object[0]), load.length));
    }

    public void checkDimWritePerm(InvRelationScaleInfo invRelationRatio) {
        Class<?> ratioClass = invRelationRatio.getClass();
        Map<Class<? extends Annotation>, List<Field>> annotation2FieldMap = InvRelationSearchService.getAnnotation2FieldMap(ratioClass);
        try {
            Map<String, String> maps = InvRelationSearchService.nullAndExistsCheck(invRelationRatio, invRelationRatio.getModel(), annotation2FieldMap);
            maps.putAll(InvRelationSearchService.memberPermCheck(invRelationRatio, invRelationRatio.getModel(), annotation2FieldMap));
            if (!maps.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7:%1$S", (String)"InvRelationScaleService_3", (String)"fi-bcm-business", (Object[])new Object[0]), JSONUtils.toString(maps)));
            }
        }
        catch (IOException | IllegalAccessException e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void addQfIfNotNull(QFBuilder qfBuilder, String field, String investCompany) {
        if (Objects.nonNull(investCompany)) {
            qfBuilder.add(field, "=", (Object)investCompany);
        }
    }
}

