/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.service.InvShareholdingValidator;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class InvRelationScaleValidator {
    private InvRelationScaleValidator() {
    }

    public static List<String> validateDynamicStockRadio(DynamicObject dynamicObject) {
        long modelId = dynamicObject.getLong("model");
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvRelationScaleValidator_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        String merge = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvRelationScaleValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        String confirmOpen = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]);
        String confirmShare = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u672b\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        String shareHolderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvRelationScaleValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]);
        PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        InvValidateHelper<DynamicObject> validate = new InvValidateHelper(validator).add(() -> validator.baseDataNotNull("model", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"InvRelationScaleValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("scenario", ResManager.loadKDString((String)"\u60c5\u666f", (String)"InvRelationScaleValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("year", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"InvRelationScaleValidator_7", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvRelationScaleValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("merge", merge)).add(() -> validator.baseDataNotNull("shareholder", shareHolderPropName)).add(() -> validator.baseDataNotNull("investeecompany", investedCompanyPropName)).add(() -> validator.baseDataNotNull("invchangetype", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"InvRelationScaleValidator_9", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.notNull("confirmopenscale", confirmOpen)).add(() -> validator.notNull("confirmsharescale", confirmShare)).add(() -> validator.notNull("confirmchangescale", ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_10", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.ratioBetween0To100("confirmopenscale", confirmOpen)).add(() -> validator.ratioBetween0To100("confirmsharescale", confirmShare)).add(() -> validator.independentOrgIC("shareholder", shareHolderPropName)).add(() -> validator.independentOrgEnt("investeecompany", investedCompanyPropName)).add(() -> validator.notEqualsOrg("investeecompany", "shareholder")).add(() -> validator.entHaveReadwritePerm("merge", permissionService, dimensionId, merge)).add(() -> validator.entHavePerm("investeecompany", permissionService, dimensionId, investedCompanyPropName));
        return validate.doValidate(dynamicObject);
    }

    public static List<String> validateStaticStockRadio(DynamicObject dynamicObject) {
        String minConfirmScale = "minconfirmscale";
        long modelId = dynamicObject.getLong("model");
        String invRelaType = "invrelatype";
        String relaType = dynamicObject.getString(invRelaType);
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvRelationScaleValidator_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        String merge = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvRelationScaleValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        String shareHolderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvRelationScaleValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]);
        String investedCompanyKey = "investeecompany";
        String orgUnit = "orgunit";
        String shareholder = "shareholder";
        String confirmScale = "confirmscale";
        String comfirmScalePropName = ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_12", (String)"fi-bcm-business", (Object[])new Object[0]);
        PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        InvValidateHelper<DynamicObject> validate = new InvValidateHelper(validator).add(() -> validator.baseDataNotNull("model", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"InvRelationScaleValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("scenario", ResManager.loadKDString((String)"\u60c5\u666f", (String)"InvRelationScaleValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("year", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"InvRelationScaleValidator_7", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvRelationScaleValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.baseDataNotNull(orgUnit, merge)).add(() -> validator.baseDataNotNull(shareholder, shareHolderPropName)).add(() -> validator.baseDataNotNull(investedCompanyKey, investedCompanyPropName)).add(() -> validator.notNull(invRelaType, ResManager.loadKDString((String)"\u80a1\u6bd4\u7c7b\u578b", (String)"InvRelationScaleValidator_11", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.notNull(confirmScale, comfirmScalePropName)).add(() -> validator.notNull(minConfirmScale, ResManager.loadKDString((String)"\u5c11\u6570\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_13", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.independentOrgIC(shareholder, shareHolderPropName)).add(() -> validator.independentOrgEnt(investedCompanyKey, investedCompanyPropName)).add(() -> validator.notEqualsOrg(investedCompanyKey, shareholder)).add(() -> validator.entHaveReadwritePerm(orgUnit, permissionService, dimensionId, merge)).add(() -> validator.entHavePerm(investedCompanyKey, permissionService, dimensionId, investedCompanyPropName));
        if (Integer.parseInt(relaType) < 3) {
            validate.add(() -> validator.stockRadioSumLessThen100(ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b+\u5c11\u6570\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_14", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScale, minConfirmScale)).add(() -> validator.notNull(confirmScale, comfirmScalePropName));
        } else {
            validate.add(() -> validator.stockRadioSumLessThen100(ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_15", (String)"fi-bcm-business", (Object[])new Object[0]), minConfirmScale));
        }
        return validate.doValidate(dynamicObject);
    }

    private static DynamicObjectCollection queryAllDirectRela(QFBuilder qfBuilder, long modelId) {
        qfBuilder.and("model", "=", (Object)modelId).and("invrelatype", "=", (Object)InvRelaTypeEnum.DirectRelaType.getType());
        return QueryServiceHelper.query((String)"bcm_invrelation", (String)"investeecompany.number,shareholder.number,confirmscale", (QFilter[])qfBuilder.toArray());
    }

    public static List<String> validateDynamicStockRadioFromLoad(DynamicObject dynamicObject) {
        Object model = dynamicObject.get("model");
        long modelId = model instanceof DynamicObject ? ((DynamicObject)model).getLong("id") : ((Long)model).longValue();
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String confirmOpen = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]);
        String confirmShare = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u672b\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        InvValidateHelper<DynamicObject> validate = new InvValidateHelper(validator).add(() -> validator.notNull("confirmopenscale", confirmOpen)).add(() -> validator.notNull("confirmsharescale", confirmShare)).add(() -> validator.notNull("confirmchangescale", ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_10", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.ratioBetween0To100("confirmopenscale", confirmOpen)).add(() -> validator.ratioBetween0To100("confirmsharescale", confirmShare));
        return validate.doValidate(dynamicObject);
    }

    public static List<String> validateStaticStockRadioFromLoad(DynamicObject dynamicObject) {
        String minConfirmScale = "minconfirmscale";
        Object model = dynamicObject.get("model");
        long modelId = model instanceof DynamicObject ? ((DynamicObject)model).getLong("id") : ((Long)model).longValue();
        String invRelaType = "invrelatype";
        String relaType = dynamicObject.getString(invRelaType);
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String confirmScale = "confirmscale";
        String comfirmScalePropName = ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_12", (String)"fi-bcm-business", (Object[])new Object[0]);
        InvValidateHelper<DynamicObject> validate = new InvValidateHelper(validator).add(() -> validator.notNull(invRelaType, ResManager.loadKDString((String)"\u80a1\u6bd4\u7c7b\u578b", (String)"InvRelationScaleValidator_11", (String)"fi-bcm-business", (Object[])new Object[0]))).add(() -> validator.notNull(confirmScale, comfirmScalePropName)).add(() -> validator.notNull(minConfirmScale, ResManager.loadKDString((String)"\u5c11\u6570\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_13", (String)"fi-bcm-business", (Object[])new Object[0])));
        if (Integer.parseInt(relaType) < 3) {
            validate.add(() -> validator.stockRadioSumLessThen100(ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b+\u5c11\u6570\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_14", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScale, minConfirmScale)).add(() -> validator.notNull(confirmScale, comfirmScalePropName));
        } else {
            validate.add(() -> validator.stockRadioSumLessThen100(ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationScaleValidator_15", (String)"fi-bcm-business", (Object[])new Object[0]), minConfirmScale));
        }
        return validate.doValidate(dynamicObject);
    }
}

