/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.api.dto.MemberCheckEnum;
import kd.fi.bcm.business.invest.api.validator.EnumRange;
import kd.fi.bcm.business.invest.api.validator.IntRange;
import kd.fi.bcm.business.invest.api.validator.MemberExists;
import kd.fi.bcm.business.invest.api.validator.MemberPerm;
import kd.fi.bcm.business.invest.api.validator.NotNull;
import kd.fi.bcm.business.invest.api.validator.OrgIsLeaf;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;

public class InvRelationSearchService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvRelationSearchService.class);

    public static void orgIsLeafCheck(Object dto, Long modelId, Map<Class<? extends Annotation>, List<Field>> annotation2FieldMap, Map<String, String> maps) throws IllegalAccessException {
        List fieldList = annotation2FieldMap.getOrDefault(OrgIsLeaf.class, Collections.emptyList());
        for (Field field : fieldList) {
            IDNumberTreeNode entityMember;
            Object orgId = field.get(dto);
            if (!Objects.nonNull(orgId) || !Objects.nonNull(maps) || !Objects.nonNull(modelId) || IDNumberTreeNode.NotFoundTreeNode == (entityMember = MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)orgId))) || !entityMember.isLeaf()) continue;
            String msg = ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5408\u5e76\u8282\u70b9\u3002", (String)"InvRelationSearchService_1", (String)"fi-bcm-business", (Object[])new Object[0]);
            maps.compute(field.getName(), (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
        }
    }

    public static Map<String, String> nullAndExistsCheck(Object dto, Long modelId, Map<Class<? extends Annotation>, List<Field>> annotation2FieldMap) throws IllegalAccessException {
        List fieldList = annotation2FieldMap.getOrDefault(NotNull.class, Collections.emptyList());
        HashMap<String, String> maps = new HashMap<String, String>(16);
        for (Field field : fieldList) {
            Object o = field.get(dto);
            if (o != null) continue;
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvRelationSearchService_2", (String)"fi-bcm-business", (Object[])new Object[0]);
            maps.compute(field.getName(), (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
        }
        List memberExistsList = annotation2FieldMap.getOrDefault(MemberExists.class, Collections.emptyList());
        for (Field field : memberExistsList) {
            Object u;
            MemberExists annotation = field.getAnnotation(MemberExists.class);
            MemberCheckEnum value = annotation.value();
            BiPredicate<Long, Object> predicate = value.getPredicate();
            boolean test = predicate.test(modelId, u = field.get(dto));
            if (test) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u6210\u5458id\u3010%1$s\u3011 \u5728\u4f53\u7cfb%2$s\u4e2d\u4e0d\u5b58\u3002", (String)"InvRelationSearchService_3", (String)"fi-bcm-business", (Object[])new Object[0]), u, modelId);
            maps.compute(field.getName(), (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
        }
        return maps;
    }

    public static Map<String, String> memberPermCheck(Object dto, Long modelId, Map<Class<? extends Annotation>, List<Field>> annotation2FieldMap) throws IllegalAccessException {
        List memberPermList = annotation2FieldMap.getOrDefault(MemberPerm.class, Collections.emptyList());
        HashMap<String, String> maps = new HashMap<String, String>(16);
        for (Field field : memberPermList) {
            Object u;
            MemberPerm annotation = field.getAnnotation(MemberPerm.class);
            MemberCheckEnum value = annotation.value();
            BiPredicate<Long, Object> predicate = value.getPredicate();
            boolean test = predicate.test(modelId, u = field.get(dto));
            if (test) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u4f60\u65e0%1$s\u5199\u5165\u6743\u9650", (String)"InvRelationSearchService_4", (String)"fi-bcm-business", (Object[])new Object[0]), u);
            maps.compute(field.getName(), (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
        }
        return maps;
    }

    public static Map<String, String> rangeCheck(Object dto, Map<Class<? extends Annotation>, List<Field>> annotation2FieldMap) throws IllegalAccessException {
        String msg;
        int u;
        List intRangeList = annotation2FieldMap.getOrDefault(IntRange.class, Collections.emptyList());
        HashMap<String, String> maps = new HashMap<String, String>(16);
        for (Field field : intRangeList) {
            IntRange annotation = field.getAnnotation(IntRange.class);
            int min = annotation.min();
            int max = annotation.max();
            u = (Integer)field.get(dto);
            if (u >= min && u <= max) continue;
            msg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u503c%1$s\u8d85\u51fa\u6570\u503c\u8303\u56f4\u3010%2$s,%3$s\u3011", (String)"InvRelationSearchService_5", (String)"fi-bcm-business", (Object[])new Object[0]), u, min, max);
            maps.compute(field.getName(), (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
        }
        List enumRangeList = annotation2FieldMap.getOrDefault(EnumRange.class, Collections.emptyList());
        for (Field field : enumRangeList) {
            EnumRange annotation = field.getAnnotation(EnumRange.class);
            int[] value = annotation.value();
            u = (Integer)field.get(dto);
            if (!Arrays.stream(value).noneMatch(i -> i == u)) continue;
            msg = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u503c%1$s\u8d85\u51fa\u53d6\u503c\u8303\u56f4%2$s", (String)"InvRelationSearchService_6", (String)"fi-bcm-business", (Object[])new Object[0]), u, Arrays.toString(value));
            maps.compute(field.getName(), (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
        }
        return maps;
    }

    public static Map<Class<? extends Annotation>, List<Field>> getAnnotation2FieldMap(Class<?> dtoClass) {
        Field[] fields = dtoClass.getDeclaredFields();
        HashMap<Class<? extends Annotation>, List<Field>> annotation2Field = new HashMap<Class<? extends Annotation>, List<Field>>(16);
        for (Field field : fields) {
            Annotation[] annotations = field.getDeclaredAnnotations();
            ReflectionUtils.makeAccessible((Field)field);
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> aClass = annotation.annotationType();
                List fieldList = annotation2Field.computeIfAbsent(aClass, key -> Lists.newArrayList());
                fieldList.add(field);
            }
        }
        return annotation2Field;
    }

    public static String modelExists(Long modelId) {
        if (modelId != null && !QueryServiceHelper.exists((String)"bcm_model", (Object)modelId)) {
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728id\u4e3a%1$s\u7684\u4f53\u7cfb\u3002", (String)"InvRelationSearchService_7", (String)"fi-bcm-business", (Object[])new Object[0]), modelId);
        }
        return null;
    }

    public static boolean checkModelPermission(long modelId, String entityNum, String permItemId) {
        int permission = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (long)modelId, (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        return permission != 0 || MemberPermHelper.ifUserHasRootPermByModel(RequestContext.get().getCurrUserId(), String.valueOf(modelId));
    }

    public static Set<Long> dealNoPermOrg(Set<Long> resSet, long modelId) {
        if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
            Set<Long> writePermissionIds = PermissionServiceImpl.getInstance(modelId).matchWritePermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", resSet);
            HashSet noWritePermSet = new HashSet(resSet.size());
            resSet.removeIf(org -> {
                if (!writePermissionIds.contains(org)) {
                    noWritePermSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)org).getNumber());
                    return true;
                }
                return false;
            });
            if (!noWritePermSet.isEmpty()) {
                log.warn(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u65e0\u7ec4\u7ec7\u6210\u5458%s\u5199\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvRelationSearchService_8", (String)"fi-bcm-business", (Object[])new Object[0]), noWritePermSet));
            }
        }
        return resSet;
    }

    public static Set<Long> dealPeriodOpen(long modelId, Set<Long> resSet, Long scenario, Long year, Long period) {
        return InvRelationSearchService.dealPeriodOpen(modelId, resSet, scenario, year, period, (orgId, orgNum) -> {});
    }

    public static Set<Long> dealPeriodOpen(long modelId, Set<Long> resSet, Long scenario, Long year, Long period, BiConsumer<Long, String> dealPeriodNotOpen) {
        if (!ConfigServiceHelper.getBoolParam(modelId, "CM012")) {
            return resSet;
        }
        HashMap orgId2Number = new HashMap(resSet.size());
        resSet.forEach(s -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)s);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                orgId2Number.put(s, node.getNumber());
            }
        });
        HashSet noOpenSet = new HashSet(resSet.size());
        Set<String> result = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, new HashSet<String>(orgId2Number.values()), scenario, year, period, "datastatus");
        resSet.removeIf(orgId -> {
            String orgNum = (String)orgId2Number.get(orgId);
            if (!result.contains(orgNum)) {
                noOpenSet.add(orgNum);
                dealPeriodNotOpen.accept((Long)orgId, orgNum);
                return true;
            }
            return false;
        });
        if (!noOpenSet.isEmpty()) {
            log.warn(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvRelationSearchService_9", (String)"fi-bcm-business", (Object[])new Object[0]), noOpenSet));
        }
        return resSet;
    }

    public static Set<String> batchSelectPeriodStatusOpen(Long model, Set<String> orgNumbers, Long scenario, Long year, Long period, String statusField) {
        if (!ConfigServiceHelper.getBoolParam(model, "CM012")) {
            return orgNumbers;
        }
        return PeriodSettingHelper.batchSelectPeriodStatusOpen(model, orgNumbers, scenario, year, period, statusField);
    }

    public static Set<Long> getEffectiveEntity(Set<Long> resSet, long modelId, long scenarioId, long yearId, long periodId) {
        IDNumberTreeNode fyMember = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        Set<Long> saveRes = InvRelationSearchService.getResSave(modelId, scenarioId, fyMember.getNumber(), periodId);
        HashSet<Long> res = new HashSet<Long>();
        HashSet noEffectiveSet = new HashSet();
        HashSet effectiveSet = new HashSet();
        resSet.forEach(e -> {
            if (saveRes.contains(e)) {
                res.add((Long)e);
                effectiveSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)e).getNumber());
            } else {
                noEffectiveSet.add(MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)e).getNumber());
            }
        });
        noEffectiveSet.removeAll(effectiveSet);
        if (!noEffectiveSet.isEmpty()) {
            log.warn(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458%s\u5728\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u5df2\u88ab\u5904\u7f6e/\u7981\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\u3002", (String)"InvRelationSearchService_10", (String)"fi-bcm-business", (Object[])new Object[0]), noEffectiveSet));
        }
        return res;
    }

    private static Set<Long> getResSave(long modelId, long scenarioId, String yearNumber, long periodId) {
        HashSet<Long> res = new HashSet<Long>();
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection orgsSave = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)InvRelationSearchService.getSelector(), (QFilter[])new QFilter[]{modelQf}, (String)"level, dseq");
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, scenarioId, yearNumber, periodId);
        ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(orgsSave.size());
        orgList.addAll((Collection<DynamicObject>)orgsSave);
        EntityVersioningUtil.filterOrgsByMergeStruct(param, orgList);
        orgList.forEach(e -> res.add(e.getLong("id")));
        return res;
    }

    private static String getSelector() {
        return "id,name,number,member,parent.id,dseq,level,longnumber,storageType,share,isleaf";
    }
}

