/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invratio;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.invest.helper.InvStaticStockRatioHelper;
import kd.fi.bcm.business.invest.service.InvShareholdingValidator;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvStaticStockRatioConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;

public class InvStaticRadioService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvStaticRadioService.class);
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-business";
    private static Map<String, Long> limTempNumber2Dy = new HashMap<String, Long>(16);
    private static Map<String, Long> tempNumberToGroup = new HashMap<String, Long>(16);
    private static final Table<String, String, Long> sheetEntryTable = HashBasedTable.create();
    private static Map<String, Integer> relationType2Seq = new HashMap<String, Integer>(16);
    private static Map<String, String> relationTypeNumber2Name = new HashMap<String, String>(16);

    public Map<String, Integer> getRelationType2Seq() {
        return relationType2Seq;
    }

    public Map<String, String> getRelationTypeNumber2Name() {
        return relationTypeNumber2Name;
    }

    private void effectTempCanUse(long modelId, long yearId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId)};
        DynamicObjectCollection limTempDys = QueryServiceHelper.query((String)"bcm_invelimtemplatebase", (String)"id,number", (QFilter[])filters);
        limTempNumber2Dy = limTempDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (v1, v2) -> v1));
        DynamicObjectCollection sheetTemp = InvSheetTemplateService.querySheetTemp(modelId, yearId, periodId);
        tempNumberToGroup = sheetTemp.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("group"), (v1, v2) -> v1));
        List sheetTempIds = sheetTemp.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFBuilder qfSheetEntryBuilder = new QFBuilder("sheettemplate", "in", sheetTempIds);
        String selectFields = "id,number,sheettemplate.number";
        DynamicObjectCollection sheetEntries = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)selectFields, (QFilter[])qfSheetEntryBuilder.toArray());
        for (DynamicObject dy2 : sheetEntries) {
            long sheetEntryId = dy2.getLong("id");
            String sheetEntryNumber = dy2.getString("number");
            String tempNumber = dy2.getString("sheettemplate.number");
            sheetEntryTable.put((Object)tempNumber, (Object)sheetEntryNumber, (Object)sheetEntryId);
        }
    }

    private String generateKey(DynamicObject dynamicObject) {
        return InvStaticRadioService.generateKey(dynamicObject.getString("orgunit"), dynamicObject.getString("shareholder"), dynamicObject.getString("investeecompany"), dynamicObject.getString("invrelatype"));
    }

    public static String generateKey(JSONObject jsonObject) {
        return InvStaticRadioService.generateKey(jsonObject.getString("orgunit"), jsonObject.getString("shareholder"), jsonObject.getString("investeecompany"), jsonObject.getString("invrelatype"));
    }

    private static String generateKey(String merge, String shareholder, String investedCompany, String changeType) {
        return String.join((CharSequence)"&", merge, shareholder, investedCompany, changeType);
    }

    public static InvValidateHelper<JSONObject> jsonObjectValidateHelper(Long modelId) {
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvStaticRadioService_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String shareholderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvStaticRadioService_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        return new InvValidateHelper(validator).add(() -> validator.ratioBetween0To100("confirmscale", ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b", (String)"InvStaticRadioService_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.independentOrg("shareholder", shareholderPropName)).add(() -> validator.independentOrg("investeecompany", investedCompanyPropName)).add(() -> validator.notEquals("shareholder", "investeecompany")).add(() -> validator.uniqueComboByKey("invrelatype", "orgunit", "shareholder", "investeecompany"));
    }

    public static InvValidateHelper<DynamicObject> dynObjectValidateHelper(Long modelId) {
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvStaticRadioService_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String shareholderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvStaticRadioService_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        return new InvValidateHelper(validator).add(() -> validator.baseDataNotNull("shareholder", shareholderPropName)).add(() -> validator.staticStockInvestedCompanyNotNull("invrelatype", "investeecompany")).add(() -> validator.entHavePerm("investeecompany", permissionService, dimensionId, investedCompanyPropName));
    }

    public Map<String, DynamicObject> collectRelation(Long modelId, Long yearId, Long scenarioId, Long periodId, List<Long> baseIds) {
        InvRelationTypeHelper.consumeStaticRelationsType((long)modelId, (number, name, isUse) -> relationTypeNumber2Name.put((String)number, name.getLocaleValue()));
        DynamicObjectCollection dynamicObjects = InvStaticStockRatioHelper.loadRelationByF7(modelId, scenarioId, yearId, periodId, baseIds, InvStaticStockRatioConstant.selectFields((String[])new String[]{"orgunit.number", "shareholder.number", "investeecompany.number"}));
        Map<String, DynamicObject> collect = dynamicObjects.stream().peek(dy -> {
            int seq;
            String relationType = dy.getString("invrelatype");
            Integer integer = relationType2Seq.computeIfPresent(relationType, (arg_0, arg_1) -> InvStaticRadioService.lambda$null$16(seq = dy.getInt("relaseq"), arg_0, arg_1));
            if (Objects.isNull(integer)) {
                relationType2Seq.put(relationType, seq);
            }
        }).collect(Collectors.toMap(this::generateKey, e -> e, (v1, v2) -> v1));
        this.effectTempCanUse(modelId, yearId, periodId);
        return collect;
    }

    public Pair<Set<String>, Set<String>> importNewTemplate(JSONObject data, DynamicObjectCollection effectTemps) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getString("effectnewtempnumbers")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            String sheetEntryNumber;
            String tempNumber;
            Long id;
            String[] tempNumbers;
            String[] numberAndIsExceptConfig = number.split("@");
            if (numberAndIsExceptConfig.length < 2 || (tempNumbers = numberAndIsExceptConfig[0].split("\\|")).length < 2 || (id = (Long)sheetEntryTable.get((Object)(tempNumber = tempNumbers[0]), (Object)(sheetEntryNumber = tempNumbers[1]))) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            String isExcept = numberAndIsExceptConfig[1];
            if (InvStaticStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = effectTemps.addNew();
            Long group = tempNumberToGroup.getOrDefault(tempNumber, 0L);
            configRow.set("temtype", (Object)"bcm_invsheetttplentrys");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
            configRow.set("group", (Object)group);
            configRow.set("number", (Object)sheetEntryNumber);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    public Pair<Set<String>, Set<String>> importTemplate(JSONObject data, DynamicObjectCollection limTemplate) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getJSONObject("invelimtemplate")).map(jsonObject -> jsonObject.getString("number")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            Long id;
            String isExcept = InvStaticStockRatioConstant.ExceptEnum.APPLICABLE.getCode();
            if (number.contains("@")) {
                String[] split = number.split("@");
                number = split[0];
                isExcept = split[1];
            }
            if ((id = limTempNumber2Dy.get(number)) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            if (InvStaticStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = limTemplate.addNew();
            configRow.set("temtype", (Object)"bcm_invelimtemplatebase");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    private static /* synthetic */ Integer lambda$null$16(int seq, String k, Integer v) {
        return Math.max(v, seq);
    }
}

