/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.invstructuretable.AbstractDynamicStockCalculate;
import kd.fi.bcm.business.invest.invstructuretable.model.DynamicStockNode;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgBizTypeSameControlPairModel;
import kd.fi.bcm.business.invest.invstructuretable.model.ShareRelaPair;
import kd.fi.bcm.business.invest.model.CtrlHoldingCompanyScheme;
import kd.fi.bcm.business.invest.model.CtrlOrgPeekPool;
import kd.fi.bcm.business.invest.model.InvDynamicStockParam;
import kd.fi.bcm.business.invest.model.MergeOrgNode;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

class CommonParentDynamicStockCalculate
extends AbstractDynamicStockCalculate {
    private final CtrlHoldingCompanyScheme ctrlHoldingScheme;
    private final Map<String, ShareRelaPair> num2ShareRelaPairMap = new HashMap<String, ShareRelaPair>(16);
    private final Map<String, OrgBizTypeSameControlPairModel> num2OrgBizPairMap = new HashMap<String, OrgBizTypeSameControlPairModel>(16);
    private final Map<String, Table<String, String, DynamicStockNode>> merge2relaKey2NodeMap = new HashMap<String, Table<String, String, DynamicStockNode>>(16);

    public CommonParentDynamicStockCalculate(InvStructureContext ctx, InvDynamicStockParam param) {
        super(ctx, param);
        this.ctrlHoldingScheme = new CtrlHoldingCompanyScheme(this.getCtx().getModelId(), 0L, this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId());
    }

    @Override
    public List<DynamicObject> calculateResult() {
        this.getCtx().addTag(ResManager.loadKDString((String)"\u540c\u63a7\u5171\u540c\u7236\u7ea7\u5f00\u59cb\u8ba1\u7b97", (String)"InvDynamicStockService_17", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "start");
        HashSet<String> defaultBizTypes = new HashSet<String>(2);
        defaultBizTypes.add(OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue());
        defaultBizTypes.add(OrgBizChangeTypeEnum.sameControlDisposal.getValue());
        Set<String> bizTypeScope = InvDynamicStockRatioHelper.resolveBizTypeScope(this.getCtx().getModelId(), defaultBizTypes);
        this.getCtx().addTag(ResManager.loadKDString((String)"\u67e5\u8be2\u53d8\u66f4\u8bb0\u5f55\u8303\u56f4", (String)"InvDynamicStockService_18", (String)"fi-bcm-business", (Object[])new Object[0]), () -> bizTypeScope);
        this.sortInvestBizRecord(bizTypeScope);
        this.sortChangeTypeRecord(bizTypeScope);
        this.collectOrgSameControlPath();
        return this.buildResult();
    }

    public Set<String> getNumbers(List<IDNumberTreeNode> nodes) {
        Set<Long> effectiveOrg = this.getCtx().getEffectiveOrg();
        HashSet<String> numbers = new HashSet<String>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                if (!effectiveOrg.contains(node.getId())) continue;
                numbers.add(node.getNumber());
            }
        }
        return numbers;
    }

    private void sortInvestBizRecord(Set<String> bizTypeScope) {
        this.getCtx().addTag(ResManager.loadKDString((String)"\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4\u8bb0\u5f55\u5206\u7c7b", (String)"InvDynamicStockService_19", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "start");
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.getCtx().getModelId());
        qf.add("sharecase", "=", (Object)this.getCtx().getShareCaseId());
        qf.add("investeecompany.number", "in", this.getNumbers(this.getCtx().queryMergeOrg().getAllChildren(0)));
        qf.add("invchangetype.number", "in", bizTypeScope);
        qf.add("investdate", "<=", (Object)this.getCtx().getEndDate());
        Set<String> invSelectFieldSet = InvDynamicStockRatioHelper.getInvShareRelaSelectField();
        invSelectFieldSet.add(InvDynamicStockRatioHelper.getBizTypeScopeFieldStr(this.getCtx().getModelId(), "invchangetype.number", "relatedBizType"));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_invsharerela", (String)String.join((CharSequence)",", invSelectFieldSet), (QFilter[])qf.toArray(), null).orderBy(new String[]{"investdate desc", "relatedBizType asc"});
        DynamicObjectCollection shareRelaDyList = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"bcm_invsharerela");
        shareRelaDyList.forEach(shareRelaDy -> {
            this.getCtx().addTag(ResManager.loadKDString((String)"\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4\u8bb0\u5f55\u904d\u5386\u914d\u5bf9", (String)"InvDynamicStockService_20", (String)"fi-bcm-business", (Object[])new Object[0]), () -> ((DynamicObject)shareRelaDy).toString());
            String investeecompany = shareRelaDy.getString("investeecompany.number");
            boolean isCurPeriod = this.getCtx().getStartDate().compareTo(shareRelaDy.getDate("investdate")) <= 0;
            ShareRelaPair sameControlPath = this.num2ShareRelaPairMap.computeIfAbsent(investeecompany, path -> isCurPeriod ? new ShareRelaPair(this.getCtx()) : null);
            if (sameControlPath != null) {
                sameControlPath.addShareRelaDy((DynamicObject)shareRelaDy, shareRelaDy.getString("relatedBizType"), isCurPeriod);
            }
        });
        this.getCtx().addTag(ResManager.loadKDString((String)"\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4\u8bb0\u5f55\u914d\u5bf9\u7ed3\u679c\u5982\u4e0b", (String)"InvDynamicStockService_21", (String)"fi-bcm-business", (Object[])new Object[0]), () -> this.num2ShareRelaPairMap);
        this.getCtx().addTag(ResManager.loadKDString((String)"\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4\u8bb0\u5f55\u5206\u7c7b", (String)"InvDynamicStockService_19", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "end");
    }

    private void sortChangeTypeRecord(Set<String> bizTypeScope) {
        this.getCtx().addTag(ResManager.loadKDString((String)"\u7ef4\u5ea6\u53d8\u66f4\u8bb0\u5f55\u5206\u7c7b", (String)"InvDynamicStockService_22", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "start");
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)this.getCtx().getModelId());
        qb.add("number", "in", this.resolveCtrlHolderSet(this.num2ShareRelaPairMap.keySet()));
        qb.add("bizchangerds.changetype", "in", bizTypeScope);
        qb.add("bizchangerds.bizeffdate", "<=", (Object)this.getCtx().getEndDate());
        Set<String> bizSelectFieldSet = InvDynamicStockRatioHelper.getChangeTypeBizSelectField();
        bizSelectFieldSet.add("longnumber");
        bizSelectFieldSet.add(InvDynamicStockRatioHelper.getBizTypeScopeFieldStr(this.getCtx().getModelId(), "bizchangerds.changetype", "relatedChangetype"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_entitymembertree", (String)String.join((CharSequence)",", bizSelectFieldSet), (QFilter[])qb.toArray(), null).orderBy(new String[]{"bizeffdate desc", "relatedChangetype asc"});){
            ds.forEachRemaining(p -> {
                this.getCtx().addTag(ResManager.loadKDString((String)"\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4\u8bb0\u5f55\u904d\u5386\u914d\u5bf9", (String)"InvDynamicStockService_20", (String)"fi-bcm-business", (Object[])new Object[0]), () -> String.format(ResManager.loadKDString((String)"\u7f16\u7801%1$s\u957f\u7f16\u7801%2$s\u53d8\u66f4\u65e5\u671f%3$s\u53d8\u52a8\u7c7b\u578b%4$s", (String)"InvDynamicStockService_23", (String)"fi-bcm-business", (Object[])new Object[0]), p.getString("number"), p.getString("longnumber"), p.get("bizeffdate"), p.get("relatedChangetype")));
                boolean isCurPeriod = this.getCtx().getStartDate().compareTo(p.getDate("bizeffdate")) <= 0;
                this.num2OrgBizPairMap.computeIfAbsent(p.getString("number"), a -> new OrgBizTypeSameControlPairModel(this.getCtx())).addOrgBizTypeRecord(p.getLong("id"), p.getString("relatedChangetype"), isCurPeriod);
            });
        }
        this.getCtx().addTag(ResManager.loadKDString((String)"\u7ef4\u5ea6\u53d8\u66f4\u8bb0\u5f55\u5206\u7c7b", (String)"InvDynamicStockService_22", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "end");
    }

    private Set<String> resolveCtrlHolderSet(Set<String> orgNums) {
        HashSet<String> ctrlHolderSet = new HashSet<String>(orgNums.size());
        for (String orgNum : orgNums) {
            CtrlOrgPeekPool ctrlPool = this.ctrlHoldingScheme.getCtrlPeekConfigSetting().get(orgNum);
            if (ctrlPool != null) {
                ctrlPool.getMergeOrgNodeList().forEach(p -> ctrlHolderSet.add(p.getNumber()));
                CtrlOrgPeekPool finalCtrlPool = ctrlPool;
                this.getCtx().addTag(ResManager.loadKDString((String)"\u89e3\u6790\u63a7\u80a1\u7ec4\u7ec7\u5bf9\u5e94\u7684\u5408\u5e76\u8282\u70b9", (String)"InvDynamicStockService_24", (String)"fi-bcm-business", (Object[])new Object[0]), () -> String.format("%s -> %s", orgNum, finalCtrlPool.getMergeOrgNodeList().stream().map(MergeOrgNode::getNumber).collect(Collectors.toList())));
            }
            ctrlHolderSet.add(orgNum);
        }
        return ctrlHolderSet;
    }

    private void collectOrgSameControlPath() {
        for (Map.Entry<String, ShareRelaPair> p : this.num2ShareRelaPairMap.entrySet()) {
            String investNum = p.getKey();
            ShareRelaPair shareRelaPair = p.getValue();
            shareRelaPair.addOrgBizTypePair(this.num2OrgBizPairMap.get(investNum));
            CtrlOrgPeekPool ctrlPool = this.ctrlHoldingScheme.getCtrlPeekConfigSetting().get(investNum);
            if (ctrlPool != null) {
                for (MergeOrgNode mergeOrgNode : ctrlPool.getMergeOrgNodeList()) {
                    shareRelaPair.addOrgBizTypePair(this.num2OrgBizPairMap.get(mergeOrgNode.getNumber()));
                }
            }
            shareRelaPair.forEach((recordPair, mergeNum) -> {
                if (this.getParam().getOrgUnitNumLists().contains(mergeNum)) {
                    DynamicObject disposalRecord = (DynamicObject)recordPair.p1;
                    String disShareHolder = disposalRecord.getString("shareholder.number");
                    String disInvest = disposalRecord.getString("investeecompany.number");
                    this.queryDynamicStockNode((String)mergeNum, disShareHolder, disInvest).addChildDynamicStockInfo(disposalRecord, OrgBizChangeTypeEnum.sameControlParentDisposal.getValue());
                    DynamicObject addNewRecord = (DynamicObject)recordPair.p2;
                    String addShareHolder = addNewRecord.getString("shareholder.number");
                    String addInvest = addNewRecord.getString("investeecompany.number");
                    this.queryDynamicStockNode((String)mergeNum, addShareHolder, addInvest).addChildDynamicStockInfo(addNewRecord, OrgBizChangeTypeEnum.sameControlParentNewlyAdded.getValue());
                }
            });
        }
        this.num2ShareRelaPairMap.clear();
    }

    private List<DynamicObject> buildResult() {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        this.merge2relaKey2NodeMap.forEach((mergeNum, stockNodeTable) -> {
            IDNumberTreeNode mergeNode = MemberReader.findEntityMemberByNum((String)this.getCtx().getModelNum(), (String)mergeNum);
            Long storgeId = mergeNode.getBaseTreeNode().getId();
            if (!this.getParam().shareCaseId().equals(this.getParam().getOrgToCaseMap().get(storgeId))) {
                return;
            }
            for (Table.Cell cell : stockNodeTable.cellSet()) {
                IDNumberTreeNode shareholder = BcmThreadCache.findMemberByNum((String)this.getCtx().getModelNum(), (String)"InternalCompany", (String)((String)cell.getRowKey()));
                IDNumberTreeNode investeecompany = BcmThreadCache.findMemberByNum((String)this.getCtx().getModelNum(), (String)"Entity", (String)((String)cell.getColumnKey()));
                InvDynamicStockRatioHelper.iteratorDynamicStockNode((DynamicStockNode)cell.getValue(), (changeType, tempDy) -> {
                    tempDy.set("model", (Object)this.getCtx().getModelId());
                    tempDy.set("scenario", (Object)this.getCtx().getScenarioId());
                    tempDy.set("year", (Object)this.getCtx().getFyId());
                    tempDy.set("period", (Object)this.getCtx().getPeriodId());
                    tempDy.set("status", (Object)"0");
                    tempDy.set("modifytime", (Object)this.getCtx().curDate());
                    tempDy.set("modifierid", (Object)RequestContext.getOrCreate().getCurrUserId());
                    tempDy.set("sharecase", (Object)this.getCtx().getShareCaseId());
                    tempDy.set("shareholder", (Object)shareholder.getId());
                    tempDy.set("investeecompany", (Object)investeecompany.getId());
                    tempDy.set("merge", (Object)mergeNode.getId());
                    if (this.getParam().calType() == 2 && tempDy.getInt("level") == 2) {
                        this.keepModifyDynamicStock(mergeNode.getNumber(), shareholder.getNumber(), investeecompany.getNumber(), (String)changeType, (DynamicObject)tempDy);
                    }
                    result.add((DynamicObject)tempDy);
                });
            }
        });
        this.getCtx().addTag(ResManager.loadKDString((String)"\u540c\u63a7\u5171\u540c\u7236\u7ea7\u7ed3\u675f\u8ba1\u7b97", (String)"InvDynamicStockService_25", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "end");
        return result;
    }

    private DynamicStockNode queryDynamicStockNode(String mergeNum, String shareholder, String investeecompany) {
        Table table = this.merge2relaKey2NodeMap.computeIfAbsent(mergeNum, a -> HashBasedTable.create());
        DynamicStockNode stockNode = (DynamicStockNode)table.get((Object)shareholder, (Object)investeecompany);
        if (stockNode == null) {
            stockNode = new DynamicStockNode(this.getCtx(), this.scale());
            table.put((Object)shareholder, (Object)investeecompany, (Object)stockNode);
        }
        return stockNode;
    }
}

