/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.invest.invstructuretable.AbstractDynamicStockCalculate;
import kd.fi.bcm.business.invest.invstructuretable.CommonParentDynamicStockCalculate;
import kd.fi.bcm.business.invest.invstructuretable.MinParentDynamicStockCalculate;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.model.BusinessResult;
import kd.fi.bcm.business.invest.model.InvDynamicStockParam;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class InvDynamicStockService {
    private final InvStructureContext ctx;
    private final InvDynamicStockParam param;
    private Integer scale;
    private final BusinessResult resultMsg = new BusinessResult();

    public InvDynamicStockService(InvStructureContext ctx, InvDynamicStockParam param) {
        this.ctx = ctx;
        this.ctx.setMergeOrgId(param.mergeId());
        this.ctx.setShareCaseId(param.shareCaseId());
        ctx.addTag(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6295\u8d44\u65b9\u6848", (String)"ShareHoldingCalcService_11", (String)"fi-bcm-business", (Object[])new Object[0]), () -> param.shareCaseId());
        this.param = param;
    }

    public BusinessResult calcShareHolding() {
        this.ctx.addTag("start", () -> ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4\u5f00\u59cb\u8ba1\u7b97", (String)"InvDynamicStockService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (CollectionUtil.isEmpty(this.param.getOrgUnitNumLists())) {
            this.ctx.addTag("end", () -> ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4\u8ba1\u7b97\u7ed3\u675f - \u6ca1\u6709\u8981\u751f\u6210\u7684\u7ec4\u7ec7\u8282\u70b9", (String)"InvDynamicStockService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return this.resultMsg;
        }
        this.prepareData();
        this.buildDynamicStockResult();
        this.ctx.addTag("end", () -> ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4\u8ba1\u7b97\u7ed3\u675f", (String)"InvDynamicStockService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        return this.resultMsg;
    }

    private void prepareData() {
        this.ctx.setEffectiveOrg(EntityVersioningUtil.filterEffectiveOrgByMergeStruct(new FilterOrgStructParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyNum(), this.ctx.getPeriodId()), new ArrayList<Long>(MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (String)this.ctx.getModelNum()).keySet())).keySet());
        this.ctx.addTag(ResManager.loadKDString((String)"\u6709\u6548\u7ec4\u7ec7\u6811\u83b7\u53d6", (String)"InvDynamicStockService_4", (String)"fi-bcm-business", (Object[])new Object[0]), () -> this.ctx.getEffectiveOrg().size());
        this.scale = Integer.parseInt(InvRelationSetHelper.queryAccuracy(this.ctx.getModelId()));
        this.ctx.addTag(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7cbe\u5ea6", (String)"InvDynamicStockService_5", (String)"fi-bcm-business", (Object[])new Object[0]), () -> this.scale);
    }

    private void buildDynamicStockResult() {
        ArrayList<AbstractDynamicStockCalculate> calculateChainList = new ArrayList<AbstractDynamicStockCalculate>(2);
        calculateChainList.add(new MinParentDynamicStockCalculate(this.ctx, this.param));
        DynamicObject config = InvRelationSetHelper.queryRelationSet(this.ctx.getModelId());
        if (Objects.nonNull(config) && config.getBoolean("includesameparent")) {
            calculateChainList.add(new CommonParentDynamicStockCalculate(this.ctx, this.param));
        }
        Map<String, DynamicObject> modifyDynamicStockMap = this.getModifyDynamicStock();
        ArrayList resultList = new ArrayList(50);
        calculateChainList.forEach(chain -> {
            chain.setScale(this.scale);
            chain.setModifyDynamicStockMap(modifyDynamicStockMap);
            resultList.addAll(chain.calculateResult());
        });
        PlatUtil.executeWithTX(tx -> {
            QFBuilder qf = new QFBuilder();
            qf.add("scenario", "=", (Object)this.ctx.getScenarioId());
            qf.add("year", "=", (Object)this.ctx.getFyId());
            qf.add("period", "=", (Object)this.ctx.getPeriodId());
            qf.add("merge.number", "in", this.param.getOrgUnitNumLists());
            if (modifyDynamicStockMap != null) {
                qf.add("id", "not in", modifyDynamicStockMap.values().stream().filter(stock -> stock.getLong("sharecase") == 0L && 0 == stock.getInt("status")).map(p -> p.getLong("id")).collect(Collectors.toSet()));
            }
            DeleteServiceHelper.delete((String)"bcm_dynamicstockratio", (QFilter[])qf.toArray());
            SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
        });
    }

    private Map<String, DynamicObject> getModifyDynamicStock() {
        if (this.param.calType() != 2) {
            return null;
        }
        HashMap<String, DynamicObject> kvMap = new HashMap<String, DynamicObject>();
        QFBuilder qb = new QFBuilder("scenario", "=", (Object)this.ctx.getScenarioId()).add("year", "=", (Object)this.ctx.getFyId()).add("period", "=", (Object)this.ctx.getPeriodId()).add("merge.number", "in", this.param.getOrgUnitNumLists()).add("level", "=", (Object)InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode());
        QueryServiceHelper.query((String)"bcm_dynamicstockratio", (String)"seqnum,id,sharecase,status,openscale,changescale,confirmopenscale,confirmchangescale,confirmsharescale,merge.number,shareholder.number,investeecompany.number,invchangetype.number", (QFilter[])qb.toArray(), null).forEach(row -> kvMap.put(InvDynamicStockRatioHelper.packKey(row.getString("merge.number"), row.getString("shareholder.number"), row.getString("investeecompany.number"), row.getString("invchangetype.number")), (DynamicObject)row));
        return kvMap;
    }

    public static enum CalcRangeEnum {
        includeSub(3),
        selfOnly(4);

        int code;

        private CalcRangeEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

