/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.invstructuretable.model.InvestStructureTree;
import kd.fi.bcm.business.invest.model.BusinessResult;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class InvStructureTableService {
    private static final int MAX_SHAREHOLDER_LEVEL = 5;
    private static final int MAX_COMPANY_LEVEL = 10;
    private final InvStructureContext ctx;
    private final String calcRange;
    private final Map<String, String> ctrlOrgMap = new HashMap<String, String>();
    private final Map<String, Long> orgNum2IdMap = new HashMap<String, Long>();
    private final HashMap<String, DynamicObject> currPerRelaMap = new HashMap(16);
    private final HashMultimap<String, DynamicObject> num2NoControlDys = HashMultimap.create();
    private final Map<String, List<InvestStructureTree>> invStrRelaTreeMap = new HashMap<String, List<InvestStructureTree>>(100);
    private final BusinessResult resultMsg = new BusinessResult();
    private final List<DynamicObject> result = new ArrayList<DynamicObject>();
    private final Set<String> circularCtrlUtil = new HashSet<String>(16);
    private final Set<String> removingUtil = new HashSet<String>(16);

    public InvStructureTableService(InvStructureContext context, String calcRange) {
        this.ctx = context;
        this.calcRange = calcRange;
    }

    public BusinessResult generate() {
        this.prepareData();
        this.buildInvStructureResult();
        PlatUtil.executeWithTX(tx -> this.saveData());
        return this.resultMsg;
    }

    private void prepareData() {
        QFBuilder orgqf = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
        orgqf.and("cslscheme", "=", (Object)this.ctx.getCslschemeId());
        orgqf.and(new QFilter("id", "=", (Object)this.ctx.getMergeOrgId()).or("longnumber", "like", (Object)(this.ctx.queryMergeOrg().getLongNumber() + "!%")));
        ArrayList<DynamicObject> coll = new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number,ctrlorg.number", (QFilter[])orgqf.toArray()).values());
        FilterOrgStructParam orgParam = new FilterOrgStructParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
        EntityVersioningUtil.filterOrgsByMergeStruct(orgParam, coll);
        coll.forEach(org -> {
            this.orgNum2IdMap.put(org.getString("number"), org.getLong("id"));
            if (StringUtil.isNotEmpty((CharSequence)org.getString("ctrlorg.number"))) {
                this.ctrlOrgMap.put(org.getString("number"), org.getString("ctrlorg.number"));
            }
        });
        long modelId = this.ctx.getModelId();
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)this.ctx.getFyId(), (Long)this.ctx.getPeriodId());
        Map<String, DynamicObject> allRela = InvShareRelaService.getAllRelaByDate(modelId, periodLastDate, this.ctx.getShareCaseId());
        this.currPerRelaMap.putAll(allRela);
    }

    private void buildInvStructureResult() {
        HashSet investOrgNumSet = new HashSet(this.currPerRelaMap.size());
        HashMap<String, DynamicObject> controlRelation = new HashMap<String, DynamicObject>(16);
        this.currPerRelaMap.values().forEach(rela -> this.pickCtrl((Map<String, DynamicObject>)controlRelation, (DynamicObject)rela));
        controlRelation.forEach((investeecompany, rela) -> {
            investOrgNumSet.add(investeecompany);
            String shareholder = rela.getString("shareholder.number");
            this.invStrRelaTreeMap.computeIfAbsent(shareholder, v -> new ArrayList(10)).add(new InvestStructureTree((DynamicObject)rela));
        });
        Set<String> rootOrgSet = new HashSet<String>(this.invStrRelaTreeMap.keySet());
        rootOrgSet.removeAll(investOrgNumSet);
        this.circularCtrl();
        if (!"3".equals(this.calcRange)) {
            String ctrlOrg = this.ctrlOrgMap.get(this.ctx.queryMergeOrg().getNumber());
            if (ctrlOrg == null) {
                this.resultMsg.removeLowLevelMsgAppend(BusinessResult.NotificationEnum.SUCCESS, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u63a7\u80a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvStructureTableService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            if (!this.orgNum2IdMap.containsKey(ctrlOrg)) {
                this.resultMsg.removeLowLevelMsgAppend(BusinessResult.NotificationEnum.SUCCESS, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u63a7\u80a1\u7ec4\u7ec7\u65e0\u6548", (String)"InvStructureTableService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            rootOrgSet = Collections.singleton(ctrlOrg);
        }
        rootOrgSet.forEach(rootOrg -> this.buildInvDynamicObject(new InvestStructureTree(null, (String)rootOrg), 1));
        this.removingUtil.clear();
    }

    private void pickCtrl(Map<String, DynamicObject> controlRelation, DynamicObject rela) {
        String shareholder = rela.getString("shareholder.number");
        String investeecompany = rela.getString("investeecompany.number");
        if (!rela.getBoolean("iscontrol") || !this.orgNum2IdMap.containsKey(shareholder)) {
            this.num2NoControlDys.put((Object)investeecompany, (Object)rela);
            return;
        }
        DynamicObject oldControl = controlRelation.put(investeecompany, rela);
        if (Objects.nonNull(oldControl)) {
            if (oldControl.getDate("investdate").after(rela.getDate("investdate"))) {
                oldControl = controlRelation.put(investeecompany, oldControl);
            }
            this.num2NoControlDys.put((Object)investeecompany, (Object)oldControl);
        }
    }

    private void circularCtrl() {
        Collection<String> ctrlOrgs = this.ctrlOrgMap.values();
        HashSet<String> ctrlRela = new HashSet<String>(this.invStrRelaTreeMap.keySet());
        ctrlRela.retainAll(ctrlOrgs);
        ctrlRela.forEach(ctlOrg -> {
            if (this.circularCtrlUtil.contains(ctlOrg)) {
                return;
            }
            String s1 = this.ctrlOrgMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(ctlOrg)).findFirst().map(Map.Entry::getKey).orElse("");
            StringJoiner msg = new StringJoiner(" -> ");
            this.buildMsg((String)ctlOrg, (String)ctlOrg, msg, () -> msg.add((CharSequence)ctlOrg));
            if (msg.length() > 0) {
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9[%1$s]\u63a7\u80a1\u5173\u7cfb[%2$s]\u5f62\u6210\u5faa\u73af\u63a7\u80a1\uff0c\u8bf7\u4fee\u6b63\uff01", (String)"InvStructureTableService_4", (String)"fi-bcm-business", (Object[])new Object[0]), s1, msg);
                this.resultMsg.removeLowLevelMsgAppend(BusinessResult.NotificationEnum.TIP, tip);
            }
        });
        this.circularCtrlUtil.clear();
    }

    private boolean buildMsg(String rootCtlOrg, String ctlOrg, StringJoiner msg, Supplier<StringJoiner> action) {
        for (InvestStructureTree tree : this.invStrRelaTreeMap.getOrDefault(ctlOrg, Collections.emptyList())) {
            String invest = tree.getInvest();
            this.circularCtrlUtil.add(ctlOrg);
            if (invest.equals(rootCtlOrg) && !rootCtlOrg.equals(ctlOrg)) {
                action.get();
                msg.add(invest);
                return true;
            }
            this.buildMsg(rootCtlOrg, invest, msg, () -> {
                action.get();
                return msg.add(invest);
            });
        }
        return false;
    }

    private void buildInvDynamicObject(InvestStructureTree relaNode, int level) {
        if (!this.removingUtil.add(relaNode.getInvest())) {
            return;
        }
        if (level > InvStructureTableService.getMaxCompanyLevel()) {
            return;
        }
        IDNumberTreeNode orgTree = MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)relaNode.getInvest());
        if (IDNumberTreeNode.NotFoundTreeNode.equals(orgTree)) {
            return;
        }
        if (relaNode.getInvest() != null && relaNode.getHolder() != null) {
            this.setInvTableDy(relaNode);
        }
        ((List)this.invStrRelaTreeMap.getOrDefault(relaNode.getInvest(), new ArrayList(0))).forEach(rela -> this.buildInvDynamicObject((InvestStructureTree)rela, level + 1));
    }

    private void setInvTableDy(InvestStructureTree relaNode) {
        DynamicObject invTableDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invstructuretable");
        this.result.add(invTableDy);
        invTableDy.set("model", (Object)this.ctx.getModelId());
        invTableDy.set("cslscheme", (Object)this.ctx.getCslschemeId());
        invTableDy.set("scenario", (Object)this.ctx.getScenarioId());
        invTableDy.set("year", (Object)this.ctx.getFyId());
        invTableDy.set("period", (Object)this.ctx.getPeriodId());
        invTableDy.set("sharecase", (Object)this.ctx.getShareCaseId());
        invTableDy.set("entity", (Object)this.orgNum2IdMap.get(relaNode.getInvest()));
        invTableDy.set("pentity", (Object)MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)relaNode.getHolder()).getId());
        invTableDy.set("directscale", relaNode.getValue("sharescale"));
        Set noControlDys = this.num2NoControlDys.get((Object)relaNode.getInvest());
        if (noControlDys.size() > 0) {
            DynamicObjectCollection otherholders = invTableDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject relaDy : noControlDys) {
                IDNumberTreeNode shareholder = this.ctx.queryOrg(relaDy.getString("shareholder.number"));
                if (IDNumberTreeNode.NotFoundTreeNode.equals(shareholder)) continue;
                DynamicObject otherholder = otherholders.addNew();
                otherholder.set("shareholder", (Object)shareholder.getId());
                otherholder.set("indirectscale", (Object)relaDy.getBigDecimal("sharescale"));
            }
        }
    }

    private void saveData() {
        String ctrlOrg = this.ctrlOrgMap.get(this.ctx.queryMergeOrg().getNumber());
        this.orgNum2IdMap.remove(ctrlOrg);
        QFBuilder qfBuilder = new QFBuilder("cslscheme", "=", (Object)this.ctx.getCslschemeId());
        qfBuilder.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qfBuilder.add("year", "=", (Object)this.ctx.getFyId());
        qfBuilder.add("period", "=", (Object)this.ctx.getPeriodId());
        qfBuilder.add("entity.number", "in", this.orgNum2IdMap.keySet());
        qfBuilder.add("model", "=", (Object)this.ctx.getModelId());
        qfBuilder.add("sharecase", "=", (Object)this.ctx.getShareCaseId());
        if ("3".equals(this.calcRange)) {
            this.invStrRelaTreeMap.clear();
            DeleteServiceHelper.delete((String)"bcm_invstructuretable", (QFilter[])qfBuilder.toArray());
        } else {
            this.circularCtrlUtil.clear();
            this.removingUtil.clear();
            Map<String, List<DynamicObject>> oldDataMap = QueryServiceHelper.query((String)"bcm_invstructuretable", (String)"id,pentity.number", (QFilter[])qfBuilder.toArray()).parallelStream().collect(Collectors.groupingBy(p -> p.getString("pentity.number")));
            HashSet<Long> toDeeteIds = new HashSet<Long>(100);
            this.findToDeeteIds(ctrlOrg, toDeeteIds, oldDataMap);
            QFBuilder relaIdQf = new QFBuilder("id", "in", toDeeteIds);
            DeleteServiceHelper.delete((String)"bcm_invstructuretable", (QFilter[])relaIdQf.toArray());
            if (!this.removingUtil.isEmpty()) {
                return;
            }
        }
        if (this.result.isEmpty()) {
            this.resultMsg.removeLowLevelMsgAppend(BusinessResult.NotificationEnum.SUCCESS, ResManager.loadKDString((String)"\u751f\u6210\u62a5\u544a\u4e3a\u7a7a\u3002", (String)"InvStructureTableService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        } else {
            SaveServiceHelper.save((DynamicObject[])this.result.toArray(new DynamicObject[0]));
        }
    }

    private void findToDeeteIds(String ctrlOrg, Set<Long> toDeeteIds, Map<String, List<DynamicObject>> oldDataMap) {
        if (!this.circularCtrlUtil.add(ctrlOrg)) {
            this.removingUtil.add(ctrlOrg);
            return;
        }
        ((List)oldDataMap.getOrDefault(ctrlOrg, new ArrayList(0))).forEach(p -> toDeeteIds.add(p.getLong("id")));
        ((List)this.invStrRelaTreeMap.getOrDefault(ctrlOrg, new ArrayList(0))).forEach(p -> this.findToDeeteIds(p.getInvest(), toDeeteIds, oldDataMap));
    }

    public static int getMaxCompanyLevel() {
        return 10;
    }

    public static int getMaxShareholderLevel() {
        return 5;
    }
}

