/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.invstructuretable.AbstractDynamicStockCalculate;
import kd.fi.bcm.business.invest.invstructuretable.model.DynamicStockNode;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgPathNode;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.invest.model.InvDynamicStockParam;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

class MinParentDynamicStockCalculate
extends AbstractDynamicStockCalculate {
    private final Map<String, Table<String, String, DynamicStockNode>> merge2relaKey2NodeMap = new HashMap<String, Table<String, String, DynamicStockNode>>(16);

    public MinParentDynamicStockCalculate(InvStructureContext ctx, InvDynamicStockParam param) {
        super(ctx, param);
    }

    @Override
    public List<DynamicObject> calculateResult() {
        this.getCtx().addTag(ResManager.loadKDString((String)"\u6700\u5c0f\u5171\u540c\u7236\u7ea7\u5f00\u59cb\u8ba1\u7b97", (String)"InvDynamicStockService_6", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "start");
        Set<String> leafChildrenNumSet = TreeStructureServiceHelper.getNumbers(this.getCtx().queryMergeOrg().getAllChildren(0));
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.getCtx().getModelId());
        qf.add("sharecase", "=", (Object)this.getCtx().getShareCaseId());
        qf.add("shareholder.number", "in", leafChildrenNumSet);
        qf.add("investeecompany.number", "in", leafChildrenNumSet);
        qf.add("invchangetype.number", "!=", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
        qf.add("investdate", "<=", (Object)this.getCtx().getEndDate());
        qf.add("investdate", ">=", (Object)this.getCtx().getStartDate());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_invsharerela", (String)String.join((CharSequence)",", InvDynamicStockRatioHelper.getInvShareRelaSelectField()), (QFilter[])qf.toArray(), null).orderBy(new String[]{"investdate asc", "invchangetype.change desc"});
        DynamicObjectCollection shareRelaDyList = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"bcm_invsharerela");
        HashSet<Long> orgPathScope = new HashSet<Long>();
        for (DynamicObject shareRela : shareRelaDyList) {
            orgPathScope.addAll(this.getCtx().queryOrgPathNode(shareRela.getString("shareholder.number")).allIdPath());
            orgPathScope.addAll(this.getCtx().queryOrgPathNode(shareRela.getString("investeecompany.number")).allIdPath());
        }
        this.getCtx().addTag(ResManager.loadKDString((String)"\u52a0\u8f7d\u7ec4\u7ec7\u8303\u56f4", (String)"InvDynamicStockService_7", (String)"fi-bcm-business", (Object[])new Object[0]), () -> orgPathScope);
        String[] lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)this.getCtx().getModelNum(), (String)this.getCtx().getFyNum(), (String)this.getCtx().getPeriodNum(), (boolean)true);
        Long lastYear = MemberReader.findFyMemberByNum((String)this.getCtx().getModelNum(), (String)lastPeriodIncludeYear[0]).getId();
        Long lastPeriod = MemberReader.findPeriodMemberByNum((String)this.getCtx().getModelNum(), (String)lastPeriodIncludeYear[1]).getId();
        Table<String, Long, IDNumberTreeNode> effectiveOrgList = this.queryEffectiveOrgList(lastYear, lastPeriod, null, orgPathScope);
        Map<String, ChangeTypeModel> invChangeTypeModel = InvestServiceHelper.getInvChangetypeModel(this.getCtx().getModelId());
        HashMap<String, OrgPathNode> tempMap = new HashMap<String, OrgPathNode>();
        this.getCtx().addTag(ResManager.loadKDString((String)"\u5f00\u59cb\u904d\u5386\u6743\u76ca\u6295\u8d44\u5bf9", (String)"InvDynamicStockService_8", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "start");
        for (DynamicObject shareRela : shareRelaDyList) {
            Collection investeecompanyIds;
            Collection shareholderIds;
            ChangeTypeModel changeType = invChangeTypeModel.get(shareRela.getString("invchangetype.number"));
            String shareholderNum = shareRela.getString("shareholder.number");
            String investeecompanyNum = shareRela.getString("investeecompany.number");
            if (StringUtils.isNotEmpty((CharSequence)changeType.relatedChangeType())) {
                changeType = invChangeTypeModel.get(changeType.relatedChangeType());
            }
            this.getCtx().addTag(ResManager.loadKDString((String)"\u904d\u5386\u6743\u76ca\u6295\u8d44\u5bf9 : ", (String)"InvDynamicStockService_9", (String)"fi-bcm-business", (Object[])new Object[0]), () -> String.format(ResManager.loadKDString((String)"\u6295\u8d44\u65e5\u671f%s\u7684\u6295\u8d44\u5bf9(%1$s->%2$s)\u53d8\u66f4\u7c7b\u578b\u4e3a%3$s\u3002", (String)"InvDynamicStockService_10", (String)"fi-bcm-business", (Object[])new Object[0]), shareRela.getDate("investdate"), shareholderNum, investeecompanyNum, shareRela.getString("invchangetype.number")));
            if ("1".equals(changeType.change())) {
                effectiveOrgList = this.queryEffectiveOrgList(this.getCtx().getFyId(), this.getCtx().getPeriodId(), shareRela.getDate("investdate"), orgPathScope);
                tempMap.clear();
            }
            if (!(shareholderIds = effectiveOrgList.row((Object)shareholderNum).values()).isEmpty()) {
                this.getCtx().addTag(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u6392\u5e8f\u6295\u8d44\u5355\u4f4d\u96c6\u5408", (String)"InvDynamicStockService_11", (String)"fi-bcm-business", (Object[])new Object[0]), () -> shareholderIds.stream().map(p -> String.format("%s(%s)", p.getProperty("cslscheme.number"), p.getLongNumber())).collect(Collectors.toSet()));
            }
            if (!(investeecompanyIds = effectiveOrgList.row((Object)investeecompanyNum).values()).isEmpty()) {
                this.getCtx().addTag(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u6392\u5e8f\u88ab\u6295\u8d44\u5355\u4f4d\u96c6\u5408", (String)"InvDynamicStockService_12", (String)"fi-bcm-business", (Object[])new Object[0]), () -> investeecompanyIds.stream().map(p -> String.format("%s(%s)", p.getProperty("cslscheme.number"), p.getLongNumber())).collect(Collectors.toSet()));
            }
            OrgPathNode shareHolderPath = tempMap.computeIfAbsent(shareholderNum, a -> new OrgPathNode().mergeAllOrgNode(shareholderIds));
            OrgPathNode investPath = tempMap.computeIfAbsent(investeecompanyNum, a -> new OrgPathNode().mergeAllOrgNode(investeecompanyIds));
            Set<String> commonParSet = shareHolderPath.getCommonPathNode(investPath);
            this.getCtx().addTag(ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u7684\u6700\u5c0f\u5171\u540c\u7236\u7ea7", (String)"InvDynamicStockService_13", (String)"fi-bcm-business", (Object[])new Object[0]), () -> commonParSet);
            commonParSet.stream().filter(mergeNum -> this.getParam().getOrgUnitNumLists().contains(mergeNum)).forEach(mergeNum -> this.queryDynamicStockNode((String)mergeNum, shareholderNum, investeecompanyNum).addChildDynamicStockInfo(shareRela));
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        this.merge2relaKey2NodeMap.forEach((mergeNum, stockNodeTable) -> {
            IDNumberTreeNode mergeNode = MemberReader.findEntityMemberByNum((String)this.getCtx().getModelNum(), (String)mergeNum);
            Long storgeId = mergeNode.getBaseTreeNode().getId();
            if (!this.getParam().shareCaseId().equals(this.getParam().getOrgToCaseMap().get(storgeId))) {
                return;
            }
            for (Table.Cell cell : stockNodeTable.cellSet()) {
                IDNumberTreeNode shareholder = BcmThreadCache.findMemberByNum((String)this.getCtx().getModelNum(), (String)"InternalCompany", (String)((String)cell.getRowKey()));
                IDNumberTreeNode investeecompany = BcmThreadCache.findMemberByNum((String)this.getCtx().getModelNum(), (String)"Entity", (String)((String)cell.getColumnKey()));
                InvDynamicStockRatioHelper.iteratorDynamicStockNode((DynamicStockNode)cell.getValue(), (changeType, tempDy) -> {
                    tempDy.set("model", (Object)this.getCtx().getModelId());
                    tempDy.set("scenario", (Object)this.getCtx().getScenarioId());
                    tempDy.set("year", (Object)this.getCtx().getFyId());
                    tempDy.set("period", (Object)this.getCtx().getPeriodId());
                    tempDy.set("status", (Object)"0");
                    tempDy.set("modifytime", (Object)this.getCtx().curDate());
                    tempDy.set("modifierid", (Object)RequestContext.getOrCreate().getCurrUserId());
                    tempDy.set("sharecase", (Object)this.getCtx().getShareCaseId());
                    tempDy.set("shareholder", (Object)shareholder.getId());
                    tempDy.set("investeecompany", (Object)investeecompany.getId());
                    tempDy.set("merge", (Object)mergeNode.getId());
                    if (this.getParam().calType() == 2 && tempDy.getInt("level") == 2) {
                        this.keepModifyDynamicStock(mergeNode.getNumber(), shareholder.getNumber(), investeecompany.getNumber(), (String)changeType, (DynamicObject)tempDy);
                    }
                    result.add((DynamicObject)tempDy);
                });
            }
        });
        this.getCtx().addTag(ResManager.loadKDString((String)"\u6700\u5c0f\u5171\u540c\u7236\u7ea7\u7ed3\u675f\u8ba1\u7b97", (String)"InvDynamicStockService_14", (String)"fi-bcm-business", (Object[])new Object[0]), () -> "end");
        return result;
    }

    public Table<String, Long, IDNumberTreeNode> queryEffectiveOrgList(Long fyId, Long period, Date specialLastDate, Collection<Long> orgIds) {
        return (Table)BcmThreadCache.get((Object)"queryEffectiveOrgList", (Object)fyId, (Object)period, (Object)specialLastDate, () -> {
            this.getCtx().addTag(String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u65e5[%s]", (String)"InvDynamicStockService_15", (String)"fi-bcm-business", (Object[])new Object[0]), specialLastDate), () -> ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u67b6\u6784", (String)"InvDynamicStockService_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            FilterOrgStructParam orgParam = new FilterOrgStructParam(this.getCtx().getModelId(), this.getCtx().getScenarioId(), fyId, (long)period).setOpenSortedDictionary(true).setCheckStructInfo(ConfigServiceHelper.getBoolParam(this.getCtx().getModelId(), "isMergeInfoStruct")).setSpecialLastDate(specialLastDate);
            Set<Long> effOrgIds = EntityVersioningUtil.filterOrgsByVersionNew(orgParam, MemberReader.getEntChangeRecs((String)this.getCtx().getModelNum(), (Collection)orgIds)).keySet();
            Map<String, Set<Long>> sorted = EntityVersioningUtil.sortOrgByChangeType(this.getCtx().getModelNum(), null, effOrgIds, orgParam.getSortedDictionary());
            HashBasedTable effTable = HashBasedTable.create();
            sorted.forEach((arg_0, arg_1) -> this.lambda$null$17((Table)effTable, arg_0, arg_1));
            return effTable;
        });
    }

    private DynamicStockNode queryDynamicStockNode(String mergeNum, String shareholder, String investeecompany) {
        Table table = this.merge2relaKey2NodeMap.computeIfAbsent(mergeNum, a -> HashBasedTable.create());
        DynamicStockNode stockNode = (DynamicStockNode)table.get((Object)shareholder, (Object)investeecompany);
        if (stockNode == null) {
            stockNode = new DynamicStockNode(this.getCtx(), this.scale());
            table.put((Object)shareholder, (Object)investeecompany, (Object)stockNode);
        }
        return stockNode;
    }

    private /* synthetic */ void lambda$null$17(Table effTable, String childNum, Set sortedOrgList) {
        for (Long sortedOrgId : sortedOrgList) {
            IDNumberTreeNode sortedOrgNode = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)"Entity", (long)sortedOrgId);
            Long cslId = (Long)sortedOrgNode.getProperty("cslscheme.id");
            if (effTable.contains((Object)childNum, (Object)cslId)) continue;
            effTable.put((Object)childNum, (Object)cslId, (Object)sortedOrgNode);
        }
    }
}

