/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;

public class DynamicStockNode {
    private final InvStructureContext ctx;
    private boolean isInit = true;
    private Integer scale = 2;
    private BigDecimal openScale;
    private BigDecimal changeScale = BigDecimal.ZERO;
    private BigDecimal shareScale;
    private String invChangeType;
    private final Map<String, DynamicStockNode> childStockNodeMap = new HashMap<String, DynamicStockNode>(16);
    private final List<DynamicObject> detailRecordList = new ArrayList<DynamicObject>(3);

    public DynamicStockNode(InvStructureContext ctx, int scale) {
        this.ctx = ctx;
        this.scale = scale;
    }

    public void addChildDynamicStockInfo(DynamicObject shareRelaDy) {
        this.addChildDynamicStockInfo(shareRelaDy, null);
    }

    public void addChildDynamicStockInfo(DynamicObject shareRelaDy, String specInvChangeType) {
        this.setInvestScale(shareRelaDy.getBigDecimal("changescale"), shareRelaDy.getBigDecimal("sharescale"));
        if (this.invChangeType == null) {
            String invChangeTypeStr = specInvChangeType == null ? shareRelaDy.getString("invchangetype.number") : specInvChangeType;
            this.childStockNodeMap.computeIfAbsent(invChangeTypeStr, a -> new DynamicStockNode(this.ctx, this.scale)).setInvChangeType(invChangeTypeStr).addChildDynamicStockInfo(shareRelaDy);
        } else {
            this.detailRecordList.add(shareRelaDy);
        }
    }

    public List<DynamicObject> genDynamicObject() {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (this.invChangeType == null) {
            this.childStockNodeMap.values().forEach(node -> result.addAll(node.genDynamicObject()));
        } else {
            DynamicObject recordDyna = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dynamicstockratio");
            recordDyna.set("openscale", (Object)this.openScale);
            recordDyna.set("changescale", (Object)this.changeScale);
            recordDyna.set("sharescale", (Object)this.shareScale);
            recordDyna.set("confirmopenscale", (Object)this.openScale);
            recordDyna.set("confirmchangescale", (Object)this.changeScale);
            recordDyna.set("confirmsharescale", (Object)this.shareScale);
            recordDyna.set("invchangetype", (Object)this.ctx.queryChangeTypeModel(this.invChangeType).getId());
            recordDyna.set("level", (Object)2);
            result.add(recordDyna);
            for (DynamicObject detailRecord : this.detailRecordList) {
                DynamicObject investStockDyna = AdjustOperationHelper.copyDynamicObject(recordDyna, false);
                investStockDyna.set("level", (Object)3);
                BigDecimal sharescale = this.setScale(detailRecord.getBigDecimal("sharescale"));
                BigDecimal changescale = this.setScale(detailRecord.getBigDecimal("changescale"));
                investStockDyna.set("openscale", (Object)sharescale.subtract(changescale));
                investStockDyna.set("changescale", (Object)changescale);
                investStockDyna.set("sharescale", (Object)sharescale);
                investStockDyna.set("confirmopenscale", (Object)sharescale.subtract(changescale));
                investStockDyna.set("confirmchangescale", (Object)changescale);
                investStockDyna.set("confirmsharescale", (Object)sharescale);
                investStockDyna.set("investdate", detailRecord.get("investdate"));
                investStockDyna.set("investammount", detailRecord.get("investamount"));
                result.add(investStockDyna);
            }
        }
        return result;
    }

    protected void setInvestScale(BigDecimal changeScale, BigDecimal sharescale) {
        changeScale = this.setScale(changeScale);
        sharescale = this.setScale(sharescale);
        if (this.isInit) {
            this.openScale = sharescale.subtract(changeScale);
            this.isInit = false;
        }
        this.changeScale = this.changeScale.add(changeScale);
        this.shareScale = sharescale;
    }

    public DynamicStockNode setInvChangeType(String invChangeType) {
        this.invChangeType = invChangeType;
        return this;
    }

    private BigDecimal setScale(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value.setScale(this.scale == null ? 2 : this.scale, RoundingMode.HALF_UP);
    }

    public Map<String, DynamicStockNode> getChildStockNodeMap() {
        return this.childStockNodeMap;
    }
}

