/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable.model;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.adjust.trace.TraceLog;
import kd.fi.bcm.business.adjust.trace.TraceLogUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgPathNode;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.PeriodUtils;

public class InvStructureContext
extends AbstractContext {
    private Long cslschemeId;
    private Long mergeOrgId;
    private Long shareCaseId;
    private Date[] rangeDate;
    private IDNumberTreeNode mergeNode = null;
    private Set<Long> effectiveOrg;
    private Map<String, Object> properties = null;
    private Map<String, ChangeTypeModel> invChangetypeModel;
    private final TraceLog traceLog = TraceLogUtil.getLogInstance("redis");

    public InvStructureContext(long modelId, long scenarioId, long fyId, long periodId) {
        super(modelId, scenarioId, fyId, periodId);
    }

    public <T> void addTag(String key, CacheLoader<T> loader) {
        this.traceLog.addTag(key, loader);
    }

    public Set<Long> getEffectiveOrg() {
        return this.effectiveOrg;
    }

    public void setEffectiveOrg(Set<Long> effectiveOrg) {
        this.effectiveOrg = effectiveOrg;
    }

    public ChangeTypeModel queryChangeTypeModel(String num) {
        return this.invChangetypeModel().get(num);
    }

    public Map<String, ChangeTypeModel> invChangetypeModel() {
        if (this.invChangetypeModel == null) {
            this.invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(this.getModelId());
        }
        return this.invChangetypeModel;
    }

    public Long getCslschemeId() {
        return this.cslschemeId;
    }

    public void setCslschemeId(Long cslschemeId) {
        this.cslschemeId = cslschemeId;
    }

    public Long getMergeOrgId() {
        return this.mergeOrgId;
    }

    public void setMergeOrgId(Long mergeOrgId) {
        this.mergeOrgId = mergeOrgId;
    }

    public Long getShareCaseId() {
        return this.shareCaseId;
    }

    public void setShareCaseId(Long shareCaseId) {
        this.shareCaseId = shareCaseId;
    }

    public IDNumberTreeNode queryMergeOrg() {
        if (this.mergeNode == null) {
            this.mergeNode = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)this.getMergeOrgId());
        }
        return this.mergeNode;
    }

    public IDNumberTreeNode queryOrg(String orgNum) {
        return MemberReader.findEntityMemberByNum((String)this.getModelNum(), (String)orgNum);
    }

    @Override
    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>(2);
        }
        this.properties.put(key, value);
    }

    @Override
    public <T> T getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return (T)this.properties.get(key);
    }

    public OrgPathNode queryOrgPathNode(String shareholder) {
        return (OrgPathNode)BcmThreadCache.get((Object)"queryOrgPathNode", (Object)this.getModelId(), (Object)shareholder, () -> {
            List patchNodeList = MemberReader.findEntityMemberByPredicate((String)this.getModelNum(), (String)shareholder, node -> this.effectiveOrg == null || this.effectiveOrg.contains(node.getId()));
            if (CollectionUtil.isEmpty((Collection)patchNodeList)) {
                return OrgPathNode.emptyOrgPathNode;
            }
            OrgPathNode pathNode = new OrgPathNode();
            patchNodeList.forEach(pathNode::mergeOrgNode);
            return pathNode;
        });
    }

    private Date[] getRangeDate() {
        if (this.rangeDate == null) {
            this.rangeDate = PeriodUtils.calcStartAndEndDate((long)this.getModelId(), (long)this.getFyId(), (long)this.getPeriodId());
        }
        return this.rangeDate;
    }

    public Date getStartDate() {
        return this.getRangeDate()[0];
    }

    public Date getEndDate() {
        return this.getRangeDate()[1];
    }
}

