/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.util.CollectionUtil;

public class OrgPathNode {
    public static final OrgPathNode emptyOrgPathNode = new OrgPathNode();
    private static final Comparator<IDNumberTreeNode> comparator = Comparator.comparingInt(IDNumberTreeNode::getLevel).reversed();
    private final Map<Long, Set<IDNumberTreeNode>> allPathMap = new HashMap<Long, Set<IDNumberTreeNode>>(3);
    private final Set<Long> allIdPath = new HashSet<Long>(16);

    public OrgPathNode mergeOrgNode(IDNumberTreeNode orgNode) {
        this.initParentOrgs(orgNode, this.allPathMap.computeIfAbsent((Long)orgNode.getProperty("cslscheme.id"), csl -> new HashSet(2)));
        return this;
    }

    public OrgPathNode mergeAllOrgNode(Collection<IDNumberTreeNode> orgNodeList) {
        orgNodeList.forEach(orgNode -> this.initParentOrgs((IDNumberTreeNode)orgNode, this.allPathMap.computeIfAbsent((Long)orgNode.getProperty("cslscheme.id"), csl -> new HashSet(2))));
        return this;
    }

    private void initParentOrgs(IDNumberTreeNode orgNode, Set<IDNumberTreeNode> orgNodes) {
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode || "Entity".equals(orgNode.getNumber())) {
            return;
        }
        orgNodes.add(orgNode);
        this.allIdPath.add(orgNode.getId());
        if (orgNode.getParent() != null && IDNumberTreeNode.NotFoundTreeNode != orgNode.getParent()) {
            this.initParentOrgs(orgNode.getParent(), orgNodes);
        }
    }

    public static Set<IDNumberTreeNode> initParentOrgsStatic(IDNumberTreeNode orgNode, Set<IDNumberTreeNode> orgNodes) {
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode || "Entity".equals(orgNode.getNumber())) {
            return orgNodes;
        }
        orgNodes.add(orgNode);
        if (orgNode.getParent() != null && IDNumberTreeNode.NotFoundTreeNode != orgNode.getParent()) {
            OrgPathNode.initParentOrgsStatic(orgNode.getParent(), orgNodes);
        }
        return orgNodes;
    }

    public Set<String> getCommonPathNode(OrgPathNode otherOrgPathNode) {
        if (!this.isEmpty() && !otherOrgPathNode.isEmpty()) {
            Map<Long, List<IDNumberTreeNode>> commonPathList = this.getCommonPathList(otherOrgPathNode);
            HashSet result = new HashSet(2);
            commonPathList.forEach((clsId, patchList) -> result.addAll(InvDynamicStockRatioHelper.findHighLevel(patchList)));
            return result.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
        }
        return Collections.EMPTY_SET;
    }

    public Map<Long, List<IDNumberTreeNode>> getCommonPathList(OrgPathNode otherOrgPathNode) {
        if (!this.isEmpty() && !otherOrgPathNode.isEmpty()) {
            HashMap<Long, List<IDNumberTreeNode>> result = new HashMap<Long, List<IDNumberTreeNode>>(6);
            HashSet<IDNumberTreeNode> cslTempResult = new HashSet<IDNumberTreeNode>(16);
            for (Map.Entry<Long, Set<IDNumberTreeNode>> cell : this.allPathMap.entrySet()) {
                Long cslId = cell.getKey();
                Set<IDNumberTreeNode> v = otherOrgPathNode.allPathMap.get(cslId);
                if (v == null) continue;
                cslTempResult.addAll(v);
                cslTempResult.retainAll((Collection)cell.getValue());
                if (!CollectionUtil.isEmpty(cslTempResult)) {
                    result.computeIfAbsent(cslId, a -> cslTempResult.stream().sorted(comparator).collect(Collectors.toList()));
                }
                cslTempResult.clear();
            }
            return result;
        }
        return Collections.EMPTY_MAP;
    }

    public boolean isEmpty() {
        return this.allPathMap.isEmpty();
    }

    public Set<Long> allIdPath() {
        return this.allIdPath;
    }
}

