/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.invstructuretable.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgBizTypeSameControlPairModel;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgPathNode;
import kd.fi.bcm.business.invest.invstructuretable.model.SameControlPairArrayStack;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.util.CollectionUtil;

public class ShareRelaPair {
    private final InvStructureContext ctx;
    private final Map<Long, DynamicObject> recordMap = new HashMap<Long, DynamicObject>(5);
    private final SameControlPairArrayStack shareRelaStack = new SameControlPairArrayStack();
    private final List<OrgBizTypeSameControlPairModel> orgBizTypePairList = new ArrayList<OrgBizTypeSameControlPairModel>(1);

    public ShareRelaPair(InvStructureContext ctx) {
        this.ctx = ctx;
    }

    public void addShareRelaDy(DynamicObject shareRela, String bizType, boolean isCurPeriod) {
        Long shareRelaId = shareRela.getLong("id");
        if (this.shareRelaStack.push(shareRelaId, bizType, isCurPeriod)) {
            this.recordMap.put(shareRelaId, shareRela);
            this.ctx.addTag(ResManager.loadKDString((String)"\u6743\u76ca\u53d8\u66f4\u8bb0\u5f55\u5bf9 - \u914d\u5bf9\u6210\u529f", (String)"ShareRelaPair_1", (String)"fi-bcm-business", (Object[])new Object[0]), () -> shareRelaId);
        }
    }

    public void addOrgBizTypePair(OrgBizTypeSameControlPairModel orgBizTypePair) {
        if (orgBizTypePair == null) {
            return;
        }
        this.orgBizTypePairList.add(orgBizTypePair);
    }

    public void forEach(BiConsumer<Pair<DynamicObject, DynamicObject>, String> action) {
        if (this.shareRelaStack.isEmpty()) {
            return;
        }
        HashSet mergeNumSet = new HashSet(3);
        HashMap commonPathMap = new HashMap(3);
        for (OrgBizTypeSameControlPairModel orgBizTypePair : this.orgBizTypePairList) {
            orgBizTypePair.getCommonPathList().forEach((? super K cslId, ? super V commonPathList) -> commonPathMap.computeIfAbsent(cslId, a -> Lists.newArrayList()).addAll(commonPathList));
        }
        while (!this.shareRelaStack.isEmpty()) {
            Pair<Long, Long> sharePair = this.shareRelaStack.pop();
            DynamicObject disposalDy = this.recordMap.get(sharePair.p1);
            DynamicObject newlyAddDy = this.recordMap.get(sharePair.p2);
            OrgPathNode disposalOrgPathNode = this.ctx.queryOrgPathNode(disposalDy.getString("shareholder.number"));
            OrgPathNode newlyAddOrgPathNode = this.ctx.queryOrgPathNode(newlyAddDy.getString("shareholder.number"));
            disposalOrgPathNode.getCommonPathList(newlyAddOrgPathNode).forEach((? super K cslId, ? super V pathList) -> {
                List pathCslList = (List)commonPathMap.get(cslId);
                if (!CollectionUtil.isEmpty((Collection)pathCslList)) {
                    pathList.retainAll(pathCslList);
                    for (IDNumberTreeNode mergeNode : InvDynamicStockRatioHelper.findHighLevel(pathList)) {
                        mergeNumSet.add(mergeNode.getNumber());
                    }
                }
            });
            this.ctx.addTag(ResManager.loadKDString((String)"\u904d\u5386\u6295\u8d44\u5bf9\u548c\u6700\u5c0f\u5171\u540c\u7236\u7ea7", (String)"ShareRelaPair_2", (String)"fi-bcm-business", (Object[])new Object[0]), () -> mergeNumSet);
            Pair shareDyPair = Pair.onePair((Object)disposalDy, (Object)newlyAddDy);
            for (String mergeNum : mergeNumSet) {
                action.accept((Pair<DynamicObject, DynamicObject>)shareDyPair, mergeNum);
            }
            mergeNumSet.clear();
        }
    }
}

