/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.model;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ChangeTypeModel
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ChangeTypeModel.class);
    private long id;
    private int seq;
    private String number;
    private ILocaleString name;
    private boolean isdefault;
    private String change;
    private String relatedChangeType;

    public ChangeTypeModel(DynamicObject changeTypeDy) {
        if (changeTypeDy == null) {
            return;
        }
        this.id = changeTypeDy.getLong("id");
        this.number = changeTypeDy.getString("number");
        this.name = changeTypeDy.getLocaleString("name");
        this.change = changeTypeDy.getString("change");
        this.seq = changeTypeDy.getInt("dseq");
        OrgBizChangeTypeEnum orgBizTypeEnum = OrgBizChangeTypeEnum.getEnumByValue4Rule((String)this.number);
        this.isdefault = changeTypeDy.getBoolean("isdefault");
        if (this.seq == 0 && this.isdefault && orgBizTypeEnum != null) {
            this.seq = orgBizTypeEnum.getDefaultDseq();
        }
        try {
            this.relatedChangeType = changeTypeDy.getString("relatedchangetype.number");
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    public long getId() {
        return this.id;
    }

    public String name() {
        return this.name.getLocaleValue();
    }

    public boolean isdefault() {
        return this.isdefault;
    }

    public String change() {
        return StringUtil.isEmptyString((String)this.change) ? "0" : this.change;
    }

    public int seq() {
        return this.seq;
    }

    public String number() {
        return this.number;
    }

    public String relatedChangeType() {
        return this.relatedChangeType;
    }

    public String getRealChangeType() {
        return this.relatedChangeType == null ? this.number : this.relatedChangeType;
    }

    public boolean GetIsdefault() {
        return this.isdefault;
    }

    public ChangeTypeModel setSeq(int seq) {
        this.seq = seq;
        return this;
    }

    public int compareTo(@NotNull Object o) {
        if (o instanceof ChangeTypeModel) {
            return this.relatedChangeType.compareTo(((ChangeTypeModel)o).getRealChangeType());
        }
        throw new KDBizException("the method param type is error of ChangeTypeModel class");
    }
}

