/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.invest.model.CtrlOrgPeekPool;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.util.QFBuilder;

public class CtrlHoldingCompanyScheme {
    private final AdjustOperationContext ctx;
    private final long cslscheme;
    private Long yearId;
    private Long periodId;
    private Long scenarioId;
    private Map<String, CtrlOrgPeekPool> ctrl2MergePoolMap = null;
    private final Map<String, String> holdingCompanyMap = new HashMap<String, String>(16);

    public CtrlHoldingCompanyScheme(Long modelId, Long cslscheme, Long scenario, Long yearId, Long periodId) {
        this.yearId = yearId;
        this.periodId = periodId;
        this.cslscheme = cslscheme;
        this.scenarioId = scenario;
        this.ctx = new AdjustOperationContext(modelId, scenario, yearId, periodId);
    }

    public CtrlHoldingCompanyScheme(Long modelId, Long cslscheme) {
        this.ctx = new AdjustOperationContext(modelId);
        this.cslscheme = cslscheme;
    }

    public String searchCtrlHoldingCompany(String ctrlOrg) {
        return this.holdingCompanyMap.computeIfAbsent(ctrlOrg, r -> {
            CtrlOrgPeekPool merge2peekPool = this.getCtrlPeekConfigSetting().get(ctrlOrg);
            if (merge2peekPool == null) {
                return null;
            }
            long modelId = this.ctx.getModelId();
            return merge2peekPool.findLegitimacyMergeOrg(InvRelationSetHelper.isTotalScore(modelId));
        });
    }

    public Map<String, CtrlOrgPeekPool> getCtrlPeekConfigSetting() {
        if (this.ctrl2MergePoolMap == null) {
            this.ctrl2MergePoolMap = (Map)BcmThreadCache.get((Object)"CtrlPeekConfigSetting", (Object)this.ctx.getModelId(), (Object)this.cslscheme, () -> {
                HashMap<String, CtrlOrgPeekPool> result = new HashMap<String, CtrlOrgPeekPool>();
                QFBuilder ctrlOrgQb = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
                if (this.cslscheme != 0L) {
                    ctrlOrgQb.add("cslscheme", "=", (Object)this.cslscheme);
                }
                ctrlOrgQb.add("ctrlorg", "!=", (Object)0L);
                DynamicObjectCollection orgCols = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"longnumber,id,parent.number,number,ctrlorg.number,level,createtime", (QFilter[])ctrlOrgQb.toArray());
                if (this.yearId != null && this.periodId != null && this.scenarioId != null) {
                    FilterOrgStructParam orgParam = new FilterOrgStructParam(this.ctx.getModelId(), (long)this.scenarioId, this.yearId, (long)this.periodId);
                    EntityVersioningUtil.filterOrgsByMergeStruct(orgParam, (List<DynamicObject>)orgCols);
                }
                for (DynamicObject org : orgCols) {
                    CtrlOrgPeekPool tempCtrlOrgPeekPool = result.computeIfAbsent(org.getString("ctrlorg.number"), r -> CtrlOrgPeekPool.getInstance());
                    tempCtrlOrgPeekPool.addMergeOrgNode(org);
                }
                QFBuilder configQb = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
                if (this.cslscheme != 0L) {
                    ctrlOrgQb.add("cslscheme", "=", (Object)this.cslscheme);
                }
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bcm_ctrlorgsetting", (String)"bcm_ctrlorgsetting", (String)"ctrlorg,mergeorg,ispeek", (QFilter[])configQb.toArray(), null);){
                    dataSet.forEachRemaining(config -> {
                        CtrlOrgPeekPool ctrlOrgPeekPool = (CtrlOrgPeekPool)result.get(config.getString("ctrlorg"));
                        if (ctrlOrgPeekPool != null && ctrlOrgPeekPool.containMergeNum(config.getString("mergeorg"))) {
                            ctrlOrgPeekPool.setMergeIsPeek(config.getString("mergeorg"), config.getBoolean("ispeek"));
                        }
                    });
                }
                return result;
            });
        }
        return this.ctrl2MergePoolMap;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }
}

