/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.invest.model.MergeOrgNode;

public class CtrlOrgPeekPool {
    private static final Comparator<MergeOrgNode> createDateComparator = Comparator.comparing(MergeOrgNode::getCreatedate).reversed();
    private final Map<String, Boolean> num2peekMap = new HashMap<String, Boolean>(16);
    private List<MergeOrgNode> mergeOrgNodeList;

    public static CtrlOrgPeekPool getInstance() {
        return new CtrlOrgPeekPool();
    }

    public void setMergeIsPeek(String mergeNum, Boolean isPeek) {
        this.getNum2peekMap().put(mergeNum, isPeek);
    }

    public boolean containMergeNum(String mergeNum) {
        return this.getNum2peekMap().containsKey(mergeNum);
    }

    public void addMergeOrgNode(DynamicObject mergeOrg) {
        this.setMergeIsPeek(mergeOrg.getString("number"), Boolean.FALSE);
        this.getMergeOrgNodeList().add(new MergeOrgNode(mergeOrg.getString("number"), mergeOrg.getInt("level"), mergeOrg.getDate("createtime")));
    }

    public Map<String, Boolean> getNum2peekMap() {
        return this.num2peekMap;
    }

    public List<MergeOrgNode> getMergeOrgNodeList() {
        if (this.mergeOrgNodeList == null) {
            this.mergeOrgNodeList = new ArrayList<MergeOrgNode>(3);
        }
        return this.mergeOrgNodeList;
    }

    public String findLegitimacyMergeOrg(Boolean totalscore) {
        if (this.getMergeOrgNodeList().size() == 1) {
            return this.getMergeOrgNodeList().get(0).getNumber();
        }
        List openPeekMergeNode = this.getMergeOrgNodeList().stream().filter(p -> this.num2peekMap.getOrDefault(p.getNumber(), Boolean.FALSE)).collect(Collectors.toList());
        if (openPeekMergeNode.isEmpty()) {
            openPeekMergeNode.addAll(this.getMergeOrgNodeList());
        }
        if (totalscore.booleanValue()) {
            Comparator<MergeOrgNode> levelComparator = Comparator.comparing(MergeOrgNode::getLevel);
            openPeekMergeNode.sort(levelComparator.thenComparing(createDateComparator));
        } else {
            openPeekMergeNode.sort(createDateComparator);
        }
        return ((MergeOrgNode)openPeekMergeNode.get(0)).getNumber();
    }
}

