/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.model;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.PermEnum;

public class InvShareCase {
    public static final String ENTITY_ID = "bcm_invsharecase";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "Name";
    private static final String REMARK = "remark";
    public static final String SCOPE = "scope";
    private static final String CREATOR = "creator";
    private static final String CREATE_DATE = "createdate";
    public static final String MODIFIER = "modifier";
    private static final String MODIFY_DATE = "modifydate";
    public static final String MODEL = "model";
    public static final String PERM_CLASS = "permclass";
    public static String[] ALL_FIELD = new String[]{"id", "number", "Name", "remark", "scope", "creator", "createdate", "model", "modifier", "modifydate"};
    public static final String DEFAULT_INVEST = "defaultInvest";
    private Map<String, DynamicObject> delegate;
    private String number;
    private PermEnum permEnum;
    private ScopeEnum scopeEnum;

    public static String genCommSelectFields() {
        return "id,number,name";
    }

    public static InvShareCase genEntityBy(DynamicObject dynamicObject) {
        return new InvShareCase(dynamicObject);
    }

    public static List<InvShareCase> genEntityBy(Collection<DynamicObject> dynamicObjects) {
        Map<String, DynamicObject> delegate = dynamicObjects.stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy));
        return delegate.keySet().stream().map(number -> new InvShareCase((String)number, delegate)).collect(Collectors.toList());
    }

    public InvShareCase(DynamicObject dynamicObject) {
        this.number = dynamicObject.getString(NUMBER);
        this.delegate = new HashMap<String, DynamicObject>(1);
        this.delegate.put(this.number, dynamicObject);
    }

    public InvShareCase(String number, Map<String, DynamicObject> delegate) {
        this.number = number;
        this.delegate = delegate;
    }

    public Long getId() {
        return this.delegate.get(this.number).getLong(ID);
    }

    public ScopeEnum getScopeEnum() {
        return Optional.ofNullable(this.scopeEnum).orElseGet(() -> {
            this.scopeEnum = ScopeEnum.getScopeEnumByValue(this.delegate.get(this.number).getString(SCOPE));
            return this.scopeEnum;
        });
    }

    public long getModelId() {
        DynamicObject dy;
        IDataEntityProperty property;
        DynamicObject dynamicObject = this.delegate.get(this.number);
        if (!dynamicObject.getDataEntityType().getProperties().containsKey((Object)MODEL)) {
            this.reBuildDelegate();
        }
        if ((property = (IDataEntityProperty)(dy = this.delegate.get(this.number)).getDataEntityType().getProperties().get((Object)MODEL)) instanceof DynamicSimpleProperty) {
            return dy.getLong(MODEL);
        }
        return dy.getLong("model_id");
    }

    public PermEnum getPermEnum() {
        return Optional.ofNullable(this.permEnum).orElseGet(() -> {
            this.setPermEnum();
            return this.permEnum;
        });
    }

    public DynamicObject getDynamicObject() {
        return this.delegate.get(this.number);
    }

    private void setPermEnum() {
        Set<Long> limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser();
        this.permEnum = PermEnum.READWRITE;
        if (limitedModelListByUser.contains(this.getModelId()) || this.getScopeEnum() != ScopeEnum.PERM_CLASS) {
            return;
        }
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(ENTITY_ID, String.valueOf(this.getModelId()), String.valueOf(currentUserId));
        Set strings = map.keySet();
        for (String permValue : strings) {
            if (!map.get((Object)permValue).contains(this.getId())) continue;
            int val = Math.abs(Integer.parseInt(permValue) - 4);
            this.permEnum = PermEnum.getPermTypeByVal((int)val);
            break;
        }
    }

    private void reBuildDelegate() {
        List<Long> ids = this.delegate.entrySet().stream().map(Map.Entry::getValue).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = InvShareCaseHelper.queryBy(ids);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String number = dynamicObject.getString(NUMBER);
            this.delegate.put(number, dynamicObject);
        }
    }

    public static enum ScopeEnum {
        ALL_USER("0", new MultiLangEnumBridge("\u6240\u6709\u4eba", "InvShareCase_0", "fi-bcm-business")),
        SELF("1", new MultiLangEnumBridge("\u4ec5\u81ea\u5df1", "InvShareCase_1", "fi-bcm-business")),
        PERM_CLASS("2", new MultiLangEnumBridge("\u6309\u6743\u9650\u7c7b", "InvShareCase_2", "fi-bcm-business"));

        private String value;
        private MultiLangEnumBridge nameBridge;

        private ScopeEnum(String value, MultiLangEnumBridge nameBridge) {
            this.value = value;
            this.nameBridge = nameBridge;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.nameBridge.loadKDString();
        }

        public static ScopeEnum getScopeEnumByValue(String value) {
            ScopeEnum[] values;
            for (ScopeEnum scopeEnum : values = ScopeEnum.values()) {
                if (!scopeEnum.getValue().equals(value)) continue;
                return scopeEnum;
            }
            return null;
        }
    }
}

