/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.common.enums.DataCollectLogEnum;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import org.apache.commons.compress.utils.Lists;

public class InvestFormulaLog
implements AutoCloseable {
    private static final ThreadLocal<InvestFormulaLog> tl = new ThreadLocal();
    private String logType;
    private Long modelId;
    private Long sceneId;
    private Long yearId;
    private Long periodId;
    private Long entityId;
    private long tempId;
    private final List<Map<String, Object>> detailLogMsgList = Lists.newArrayList();

    private static InvestFormulaLog get() {
        return tl.get();
    }

    private static InvestFormulaLog getInstance() {
        return new InvestFormulaLog();
    }

    public static void createLogPoint(String logType, long modelId, Long sceneId, long yearId, long periodId, long entityId, long tempId) {
        InvestFormulaLog newLog = InvestFormulaLog.exist() ? InvestFormulaLog.get() : InvestFormulaLog.getInstance();
        newLog.logType = logType;
        newLog.modelId = modelId;
        newLog.sceneId = sceneId;
        newLog.yearId = yearId;
        newLog.periodId = periodId;
        newLog.entityId = entityId;
        newLog.tempId = tempId;
        newLog.detailLogMsgList.clear();
        tl.set(newLog);
    }

    public static void removeLogPoint() {
        InvestFormulaLog.publish();
        tl.remove();
    }

    public static boolean exist() {
        return InvestFormulaLog.get() != null;
    }

    public static void addErrorLog(String categorized, String relationtype, String shareholder, String investeecompany, String account, String pos, String formula, String errorMsg) {
        if (InvestFormulaLog.exist()) {
            InvestFormulaLog.get().addChildFormulaLog(DataCollectLogEnum.ERROR, categorized, relationtype, shareholder, investeecompany, account, pos, formula, errorMsg);
        }
    }

    public static void addTipLog(String categorized, String relationtype, String shareholder, String investeecompany, String account, String pos, String formula, String errorMsg) {
        if (InvestFormulaLog.exist()) {
            InvestFormulaLog.get().addChildFormulaLog(DataCollectLogEnum.TIP, categorized, relationtype, shareholder, investeecompany, account, pos, formula, errorMsg);
        }
    }

    public static void publish() {
        InvestFormulaLog curLogInfo = InvestFormulaLog.get();
        if (curLogInfo != null) {
            MQCommonPublisher.publishInvFormulaTraceLog((String)curLogInfo.logType, (long)curLogInfo.modelId, (long)curLogInfo.sceneId, (long)curLogInfo.yearId, (long)curLogInfo.periodId, (long)curLogInfo.entityId, (long)curLogInfo.tempId, curLogInfo.detailLogMsgList);
            curLogInfo.detailLogMsgList.clear();
        }
    }

    private void addChildFormulaLog(DataCollectLogEnum logMsgType, String categorized, String relationtype, String shareholder, String investeecompany, String account, String pos, String formula, String errorMsg) {
        HashMap<String, Object> logMap = new HashMap<String, Object>(8);
        logMap.put("logMsgType", Character.valueOf(logMsgType.index));
        logMap.put("categorized", categorized);
        logMap.put("relationtype", relationtype);
        logMap.put("shareholder", shareholder);
        logMap.put("investeecompany", investeecompany);
        logMap.put("account", account);
        logMap.put("pos", pos);
        logMap.put("formula", formula);
        logMap.put("error", errorMsg);
        this.detailLogMsgList.add(logMap);
    }

    public static List<Map<String, Object>> getDetailLogMsgList() {
        return InvestFormulaLog.exist() ? InvestFormulaLog.get().detailLogMsgList : Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
        InvestFormulaLog.publish();
    }
}

