/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.invest.model.PChildFormulaLogInfo;
import kd.fi.bcm.common.util.CollectionUtil;

public class PFormulaLogInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<PFormulaLogInfo> tl = new ThreadLocal();
    private int index = 1;
    private PFormulaLogInfo parent;
    private final Map<String, PChildFormulaLogInfo> childExpressMap = new LinkedHashMap<String, PChildFormulaLogInfo>();
    private final Set<PFormulaLogInfo> childPFormulaLogList = new LinkedHashSet<PFormulaLogInfo>();

    PFormulaLogInfo(PFormulaLogInfo parent) {
        if (parent != null) {
            this.parent = parent;
            this.parent.childPFormulaLogList.add(this);
        }
    }

    public static PFormulaLogInfo get() {
        return tl.get();
    }

    public static PFormulaLogInfo createLogPoint() {
        tl.set(new PFormulaLogInfo(tl.get()));
        return tl.get();
    }

    public static PFormulaLogInfo removeLogPoint() {
        PFormulaLogInfo curLogInfo = tl.get();
        tl.set(curLogInfo.getParent());
        return curLogInfo;
    }

    public void addChildFormulaLog(String periodNum, String childFormula) {
        this.getChildExpressMap().put(String.format("%s(%s)", this.getKey(), periodNum), new PChildFormulaLogInfo().setFormula(childFormula));
    }

    public Map<String, PChildFormulaLogInfo> getChildExpressMap() {
        return this.childExpressMap;
    }

    public PFormulaLogInfo getParent() {
        return this.parent;
    }

    public static void setIndex(int index) {
        if (PFormulaLogInfo.get() != null) {
            PFormulaLogInfo.get().index = index;
        }
    }

    public String getKey() {
        return String.format("p%s", this.index);
    }

    public String toString() {
        StringBuilder sj = new StringBuilder();
        sj.append(String.format(ResManager.loadKDString((String)"%s\u5206\u6bb5\u56e0\u5b50", (String)"PFormulaLogInfo_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.getKey())).append("\n");
        this.childExpressMap.forEach((k, childLogInfo) -> {
            sj.append("=").append(Optional.ofNullable(k).orElseGet(() -> "null")).append("\n");
            sj.append("=").append(Optional.ofNullable(childLogInfo.getFormula()).orElseGet(() -> "null")).append("\n");
            sj.append("=").append(Optional.ofNullable(childLogInfo.getEvalExpress()).orElseGet(() -> "null")).append("=").append(Optional.ofNullable(childLogInfo.getVal()).orElseGet(() -> "null")).append("\n");
        });
        if (!CollectionUtil.isEmpty(this.childPFormulaLogList)) {
            for (PFormulaLogInfo pFormulaLogInfo : this.childPFormulaLogList) {
                sj.append(pFormulaLogInfo.toString()).append("\n");
            }
        }
        return sj.toString();
    }

    public String getSpecialShowStyle() {
        StringJoiner sj = new StringJoiner("+", "(", ")");
        for (String periodNum : this.getChildExpressMap().keySet()) {
            sj.add(periodNum);
        }
        return sj.toString();
    }
}

