/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.orgchart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.invest.orgchart.NodeModel;
import kd.fi.bcm.business.invest.orgchart.OrganizationChartData;

public class OrganizationChartService {
    private Map<String, List<DynamicObject>> holders;
    private Set<String> treeNodeSet = new HashSet<String>(16);
    private Map<String, NodeModel> minHolderMap = new HashMap<String, NodeModel>(16);

    public OrganizationChartService(Map<String, List<DynamicObject>> structureTableMapList) {
        this.holders = Optional.ofNullable(structureTableMapList).orElseGet(Collections::emptyMap);
    }

    public OrganizationChartData buildData(DynamicObject rootEntityMember) {
        String rootNumber;
        String ctrlOrgNumber = "ctrlorg.number";
        if (rootEntityMember != null && this.holders.containsKey(rootNumber = rootEntityMember.getString(ctrlOrgNumber))) {
            NodeModel rootNode = new NodeModel();
            rootNode.setId(rootNumber);
            rootNode.setName(rootEntityMember.getString("ctrlorg.name"));
            this.treeNodeSet.add(rootNumber);
            rootNode.setChildren(this.buildChildNodes(rootNode));
            rootNode.setParents(this.minHolderMap.values().isEmpty() ? null : this.minHolderMap.values());
            OrganizationChartData chartData = new OrganizationChartData();
            chartData.setRootNode(rootNode);
            return chartData;
        }
        OrganizationChartData chartData = new OrganizationChartData();
        chartData.setRootNode(new NodeModel());
        return chartData;
    }

    private List<NodeModel> buildChildNodes(NodeModel nodeModel) {
        List<DynamicObject> childDy = this.holders.get(nodeModel.getId());
        if (childDy == null) {
            return null;
        }
        ArrayList<NodeModel> children = new ArrayList<NodeModel>(childDy.size());
        childDy.forEach(holder -> {
            String number = holder.getString("entity.number");
            if (this.treeNodeSet.contains(number)) {
                return;
            }
            this.treeNodeSet.add(number);
            NodeModel child = this.minHolderMap.containsKey(number) ? this.minHolderMap.remove(number) : new NodeModel();
            child.setId(number);
            child.setName(holder.getString("entity.name"));
            child.setPercent(this.getDirectScale((DynamicObject)holder, "directscale"));
            child.setChildren(this.buildChildNodes(child));
            children.add(child);
            String indirectScale = "indirectscale";
            List<DynamicObject> otherHolders = holder.getDynamicObjectCollection("entryentity").parallelStream().sorted((c1, c2) -> c2.getBigDecimal(indirectScale).compareTo(c1.getBigDecimal(indirectScale))).collect(Collectors.toList());
            HashMap<String, String> minHolders = new HashMap<String, String>(otherHolders.size());
            otherHolders.forEach(otherHolder -> {
                String minNumber = otherHolder.getString("shareholder.number");
                minHolders.put(minNumber, this.getDirectScale((DynamicObject)otherHolder, "indirectscale"));
                if (!this.treeNodeSet.contains(minNumber) && !this.minHolderMap.containsKey(minNumber)) {
                    NodeModel minNode = new NodeModel();
                    minNode.setId(minNumber);
                    minNode.setName(otherHolder.getString("shareholder.name"));
                    this.minHolderMap.put(minNumber, minNode);
                }
            });
            child.setMinHolders(minHolders);
        });
        return children;
    }

    private String getDirectScale(DynamicObject holder, String fieldName) {
        return holder.getBigDecimal(fieldName).setScale(2, 4).toString() + "%";
    }
}

