/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.relation;

import com.google.common.collect.HashMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.invest.relation.InvRelationLogContext;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.invest.InvCopyModuleEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;

public class InvRelationLogService {
    private static final int NEW_ADD = 1;
    private static final int MODIFY = 2;
    private static final int DELETE = 3;
    private static final int OTHER_OP = 4;
    private final Map<String, String> rowNameMap;
    private final Map<Integer, String> changeTypeMap;
    private final Map<String, String> number2NameMap;
    private final Map<Long, Map<String, HashMultimap<Integer, String>>> logs;
    private final InvRelationLogContext ctx;

    public static InvRelationLogService logWithStaticChange(InvRelationLogContext ctx) {
        InvRelationLogService invRelationLogService = new InvRelationLogService(ctx);
        invRelationLogService.rowNameMap.put(InvRelaTypeEnum.INDirectRelaType.getType(), ResManager.loadKDString((String)"\u786e\u8ba4\u7b49\u6548\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        invRelationLogService.rowNameMap.put(InvRelaTypeEnum.DirectRelaType.getType(), ResManager.loadKDString((String)"\u786e\u8ba4\u76f4\u63a5\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        invRelationLogService.rowNameMap.put(InvRelaTypeEnum.MultiRelaType.getType(), ResManager.loadKDString((String)"\u786e\u8ba4\u7b49\u6548\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        invRelationLogService.rowNameMap.put(InvRelaTypeEnum.MinRelaType.getType(), ResManager.loadKDString((String)"\u8054\u5408\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        invRelationLogService.rowNameMap.put(InvRelaTypeEnum.SameLevelRelaType.getType(), ResManager.loadKDString((String)"\u8054\u5408\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        InvRelationTypeHelper.consumeStaticRelationsType(ctx.getModelId(), (number, name, isUse) -> invRelationLogService.number2NameMap.put((String)number, name.getLocaleValue()));
        return invRelationLogService;
    }

    public static InvRelationLogService logWithoutStaticChange(InvRelationLogContext ctx) {
        return new InvRelationLogService(ctx);
    }

    private InvRelationLogService(InvRelationLogContext ctx) {
        this.ctx = ctx;
        this.logs = new HashMap<Long, Map<String, HashMultimap<Integer, String>>>(16);
        this.rowNameMap = new HashMap<String, String>(16);
        this.changeTypeMap = new HashMap<Integer, String>(16);
        this.number2NameMap = new HashMap<String, String>(16);
        this.changeTypeMap.put(1, ResManager.loadKDString((String)"\u65b0\u589e", (String)"InvRelationLogService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.changeTypeMap.put(2, ResManager.loadKDString((String)"\u4fee\u6539", (String)"InvRelationLogService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.changeTypeMap.put(3, ResManager.loadKDString((String)"\u5220\u9664", (String)"InvRelationLogService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.changeTypeMap.put(4, ResManager.loadKDString((String)"\u5176\u4ed6\u8bb0\u5f55\u8303\u56f4\u7684\u64cd\u4f5c", (String)"InvRelationLogService_7", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public void logDynamicAddNew(DynamicObject dy, DynamicObject changeTypeDy) {
        String shareholderNumber = this.getShareNumber(dy);
        String investedCompanyNumber = this.getCompanyNumber(dy);
        String changeTypeName = this.getChangeTypeName(changeTypeDy);
        String changeTypeNumber = changeTypeDy.getString("number");
        BigDecimal confirmScale = dy.getBigDecimal("confirmopenscale").stripTrailingZeros();
        BigDecimal confirmChangeScale = dy.getBigDecimal("confirmchangescale").stripTrailingZeros();
        String newAdd = String.format("%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s%8$s%% %9$s%10$s%%", this.changeTypeMap.get(1), ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4", (String)"InvRelationLogService_8", (String)"fi-bcm-business", (Object[])new Object[0]), changeTypeNumber, changeTypeName, shareholderNumber, investedCompanyNumber, ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\u4e3a", (String)"InvRelationLogService_9", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScale.toPlainString(), ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_10", (String)"fi-bcm-business", (Object[])new Object[0]), confirmChangeScale.toPlainString());
        long unitOrgId = this.getUnitOrgNumber(dy, "merge");
        this.put2LogCache(unitOrgId, changeTypeNumber, 1, newAdd);
    }

    public void logDynamicModify(DynamicObject dy, DynamicObject dyOld, DynamicObject changeTypeDy) {
        String shareholderNumber = this.getShareNumber(dy);
        String investedCompanyNumber = this.getCompanyNumber(dy);
        String changeTypeNumber = changeTypeDy.getString("number");
        String changeTypeName = this.getChangeTypeName(changeTypeDy);
        BigDecimal confirmScale = dy.getBigDecimal("confirmopenscale").stripTrailingZeros();
        BigDecimal confirmChangeScale = dy.getBigDecimal("confirmchangescale").stripTrailingZeros();
        String shareholderNumberOld = dyOld.getString("shareholder.number");
        String investedCompanyNumberOld = dyOld.getString("investeecompany.number");
        String changeTypeNumberOld = dyOld.getString("invchangetype.number");
        String changeTypeNameOld = Optional.ofNullable(dyOld.getLocaleString("invchangetype.name")).map(ILocaleString::getLocaleValue).orElseGet(() -> "");
        BigDecimal confirmScaleOld = dyOld.getBigDecimal("confirmopenscale").stripTrailingZeros();
        BigDecimal confirmChangeScaleOld = dyOld.getBigDecimal("confirmchangescale").stripTrailingZeros();
        if (!(StringUtils.equals((CharSequence)shareholderNumber, (CharSequence)shareholderNumberOld) && StringUtils.equals((CharSequence)investedCompanyNumber, (CharSequence)investedCompanyNumberOld) && StringUtils.equals((CharSequence)changeTypeNumber, (CharSequence)changeTypeNumberOld))) {
            String delete = String.format("%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s%8$s%% %9$s%10$s%%", this.changeTypeMap.get(3), ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4", (String)"InvRelationLogService_8", (String)"fi-bcm-business", (Object[])new Object[0]), changeTypeNumberOld, changeTypeNameOld, shareholderNumberOld, investedCompanyNumberOld, ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\u4e3a", (String)"InvRelationLogService_9", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScaleOld.toPlainString(), ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_10", (String)"fi-bcm-business", (Object[])new Object[0]), confirmChangeScaleOld.toPlainString());
            long unitOrgId = this.getUnitOrgNumber(dy, "merge");
            this.put2LogCache(unitOrgId, changeTypeNumberOld, 3, delete);
            String newAdd = String.format("%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s%8$s%% %9$s%10$s%%", this.changeTypeMap.get(1), ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4", (String)"InvRelationLogService_8", (String)"fi-bcm-business", (Object[])new Object[0]), changeTypeNumber, changeTypeName, shareholderNumber, investedCompanyNumber, ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\u4e3a", (String)"InvRelationLogService_9", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScale.toPlainString(), ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_10", (String)"fi-bcm-business", (Object[])new Object[0]), confirmChangeScale.toPlainString());
            this.put2LogCache(unitOrgId, changeTypeNumber, 1, newAdd);
        } else if (confirmScaleOld.compareTo(confirmScale) != 0 || confirmChangeScale.compareTo(confirmChangeScaleOld) != 0) {
            String modify = String.format("%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s%8$s%% %9$s%10$s%%", this.changeTypeMap.get(2), ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4", (String)"InvRelationLogService_8", (String)"fi-bcm-business", (Object[])new Object[0]), changeTypeNumber, changeTypeName, shareholderNumber, investedCompanyNumber, ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\u4e3a", (String)"InvRelationLogService_9", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScale.toPlainString(), ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_10", (String)"fi-bcm-business", (Object[])new Object[0]), confirmChangeScale.toPlainString());
            long unitOrgId = this.getUnitOrgNumber(dy, "merge");
            this.put2LogCache(unitOrgId, changeTypeNumber, 2, modify);
        }
    }

    public void logDynamicDelete(DynamicObject dy) {
        String shareholderNumber = dy.getString("shareholder.number");
        String investedCompanyNumber = dy.getString("investeecompany.number");
        String changeTypeName = dy.getLocaleString("invchangetype.name").getLocaleValue();
        String changeTypeNumber = dy.getString("invchangetype.number");
        BigDecimal confirmScale = dy.getBigDecimal("confirmopenscale").stripTrailingZeros();
        BigDecimal confirmChangeScale = dy.getBigDecimal("confirmchangescale").stripTrailingZeros();
        String delete = String.format("%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s%8$s%% %9$s%10$s%%", this.changeTypeMap.get(3), ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4", (String)"InvRelationLogService_8", (String)"fi-bcm-business", (Object[])new Object[0]), changeTypeNumber, changeTypeName, shareholderNumber, investedCompanyNumber, ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\u4e3a", (String)"InvRelationLogService_9", (String)"fi-bcm-business", (Object[])new Object[0]), confirmScale.toPlainString(), ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_10", (String)"fi-bcm-business", (Object[])new Object[0]), confirmChangeScale.toPlainString());
        long unitOrgId = this.getUnitOrgNumber(dy, "merge");
        this.put2LogCache(unitOrgId, changeTypeNumber, 3, delete);
    }

    public void collectStaticChange(DynamicObject dy, List<DynamicObject> dynamicObjects) {
        String shareholderNumber = this.getShareholderNumber(dy);
        String investedCompanyNumber = this.getInvestedCompanyNumber(dy);
        BigDecimal confirmScale = dy.getBigDecimal("confirmscale").stripTrailingZeros();
        String relationType = dy.getString("invrelatype");
        String name = this.number2NameMap.get(relationType);
        String propName = this.rowNameMap.getOrDefault(relationType, ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (dynamicObjects.isEmpty()) {
            String newAdd = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s \u4e3a%8$s%%", (String)"InvRelationLogService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.changeTypeMap.get(1), ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4", (String)"InvRelationLogService_13", (String)"fi-bcm-business", (Object[])new Object[0]), relationType, name, shareholderNumber, investedCompanyNumber, propName, confirmScale.toPlainString());
            long unitOrgId = this.getUnitOrgNumber(dy, "orgunit");
            this.put2LogCache(unitOrgId, relationType, 1, newAdd);
        } else {
            DynamicObject dynamicObject = dynamicObjects.get(0);
            String shareholderNumberOld = dynamicObject.getString("shareholder.number");
            String investedCompanyNumberOld = dynamicObject.getString("investeecompany.number");
            BigDecimal confirmScaleOld = dynamicObject.getBigDecimal("confirmscale").stripTrailingZeros();
            if (!StringUtils.equals((CharSequence)shareholderNumber, (CharSequence)shareholderNumberOld) || !StringUtils.equals((CharSequence)investedCompanyNumber, (CharSequence)investedCompanyNumberOld)) {
                long unitOrgId = this.getUnitOrgNumber(dy, "orgunit");
                String delete = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s \u4e3a%8$s%%", (String)"InvRelationLogService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.changeTypeMap.get(3), ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4", (String)"InvRelationLogService_13", (String)"fi-bcm-business", (Object[])new Object[0]), relationType, name, shareholderNumberOld, investedCompanyNumberOld, propName, confirmScaleOld.toPlainString());
                this.put2LogCache(unitOrgId, relationType, 3, delete);
                String newAdd = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s \u4e3a%8$s%%", (String)"InvRelationLogService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.changeTypeMap.get(1), ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4", (String)"InvRelationLogService_13", (String)"fi-bcm-business", (Object[])new Object[0]), relationType, name, shareholderNumber, investedCompanyNumber, propName, confirmScale.toPlainString());
                this.put2LogCache(unitOrgId, relationType, 1, newAdd);
            } else if (confirmScaleOld.compareTo(confirmScale) != 0) {
                String modify = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s \u4e3a%8$s%%", (String)"InvRelationLogService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.changeTypeMap.get(2), ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4", (String)"InvRelationLogService_13", (String)"fi-bcm-business", (Object[])new Object[0]), relationType, name, shareholderNumber, investedCompanyNumber, propName, confirmScale.toPlainString());
                long unitOrgId = this.getUnitOrgNumber(dy, "orgunit");
                this.put2LogCache(unitOrgId, relationType, 2, modify);
            }
        }
    }

    public void collectStaticDelete(DynamicObject dy) {
        String shareholderNumber = this.getShareholderNumber(dy);
        String investedCompanyNumber = this.getInvestedCompanyNumber(dy);
        BigDecimal confirmScale = dy.getBigDecimal("confirmscale").stripTrailingZeros();
        String relationType = dy.getString("invrelatype");
        long unitOrgId = this.getUnitOrgNumber(dy, "orgunit");
        String name = this.number2NameMap.get(relationType);
        String propName = this.rowNameMap.getOrDefault(relationType, ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationLogService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        String delete = String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s-%4$s %5$s->%6$s %7$s \u4e3a%8$s%%", (String)"InvRelationLogService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.changeTypeMap.get(3), ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4", (String)"InvRelationLogService_13", (String)"fi-bcm-business", (Object[])new Object[0]), relationType, name, shareholderNumber, investedCompanyNumber, propName, confirmScale.toPlainString());
        this.put2LogCache(unitOrgId, relationType, 3, delete);
    }

    public void logCopy(Map<String, Object> config) {
        long srcSceneId = (Long)config.get("sceneId");
        long srcYearId = (Long)config.get("yearId");
        long srcPeriodId = (Long)config.get("periodId");
        String copyWay = (String)config.get("copyway");
        HashMap<String, String> copyWayMap = new HashMap<String, String>(16);
        copyWayMap.put("1", ResManager.loadKDString((String)"\u4ec5\u5f53\u524d\u5408\u5e76\u8282\u70b9", (String)"InvRelationLogService_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        copyWayMap.put("2", ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u53ca\u6240\u6709\u4e0b\u7ea7", (String)"InvRelationLogService_15", (String)"fi-bcm-business", (Object[])new Object[0]));
        copyWayMap.put("3", ResManager.loadKDString((String)"Entity\u53ca\u6240\u6709\u4e0b\u7ea7", (String)"InvRelationLogService_16", (String)"fi-bcm-business", (Object[])new Object[0]));
        boolean mergeNode = (Boolean)config.get("mergenode");
        boolean mergeStruct = (Boolean)config.get("mergestruct");
        boolean copyAllStruct = config.get(InvCopyModuleEnum.COPY_ALL_STRUCT.type()) == null ? false : (Boolean)config.get(InvCopyModuleEnum.COPY_ALL_STRUCT.type());
        StringJoiner includeMerge = new StringJoiner(";");
        if (mergeNode) {
            includeMerge.add(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u4fe1\u606f", (String)"InvRelationLogService_17", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        StringJoiner includeStruct = new StringJoiner(";");
        if (mergeStruct) {
            includeStruct.add(ResManager.loadKDString((String)"\u6709\u6548\u67b6\u6784\u4fe1\u606f", (String)"InvRelationLogService_18", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (copyAllStruct) {
            includeStruct.add(ResManager.loadKDString((String)"\u5168\u91cf\u67b6\u6784\u4fe1\u606f", (String)"InvRelationLogService_19", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        boolean investRef = (Boolean)config.get("investref");
        boolean dynamicType = (Boolean)config.get("dynamictype");
        StringJoiner includeRelaType = new StringJoiner(";");
        if (investRef) {
            includeRelaType.add(ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4\u4fe1\u606f", (String)"InvRelationLogService_20", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (dynamicType) {
            includeRelaType.add(ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4\u4fe1\u606f", (String)"InvRelationLogService_21", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String srcSceneNumber = MemberReader.findScenaMemberById((Long)this.ctx.getModelId(), (Long)srcSceneId).getNumber();
        String srcYearNumber = MemberReader.findFyMemberById((Long)this.ctx.getModelId(), (Long)srcYearId).getNumber();
        String srcPeriodNumber = MemberReader.findPeriodMemberById((Long)this.ctx.getModelId(), (Long)srcPeriodId).getNumber();
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\uff1a%1$s\u60c5\u666f %2$s\u8d22\u5e74 %3$s\u671f\u95f4;\u5408\u5e76\u8282\u70b9\uff1a%4$s;\u5408\u5e76\u67b6\u6784:%5$s;\u6301\u80a1\u6bd4\u4f8b\uff1a%6$s;\u751f\u6548\u8303\u56f4\uff1a%7$s;\u5408\u5e76\u8282\u70b9\uff1a%4$s;\u5408\u5e76\u67b6\u6784:%5$s;\u6301\u80a1\u6bd4\u4f8b\uff1a%6$s;\u751f\u6548\u8303\u56f4\uff1a%7$s", (String)"InvRelationLogService_22", (String)"fi-bcm-business", (Object[])new Object[0]);
        this.put2LogCache(this.ctx.getBaseMergeOrgId(), "D", 4, String.format(msg, srcSceneNumber, srcYearNumber, srcPeriodNumber, includeMerge, includeStruct, includeRelaType, copyWayMap.get(copyWay)));
    }

    public void logReCalculate(boolean isCalcStaticStock, boolean isCalcDynamicStock, int calcType, int calcRange, boolean supportRuleExc) {
        StringJoiner includeRelaType = new StringJoiner(";");
        if (isCalcStaticStock) {
            includeRelaType.add(ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4", (String)"InvRelationLogService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (isCalcDynamicStock) {
            includeRelaType.add(ResManager.loadKDString((String)"\u52a8\u6001\u80a1\u6bd4", (String)"InvRelationLogService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>(16);
        map.put(1, ResManager.loadKDString((String)"\u5168\u90e8\u91cd\u7b97", (String)"InvRelationLogService_23", (String)"fi-bcm-business", (Object[])new Object[0]));
        map.put(2, ResManager.loadKDString((String)"\u4fdd\u7559\u624b\u52a8\u4fee\u6539", (String)"InvRelationLogService_24", (String)"fi-bcm-business", (Object[])new Object[0]));
        map.put(3, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u53ca\u5176\u6240\u6709\u4e0b\u7ea7", (String)"InvRelationLogService_25", (String)"fi-bcm-business", (Object[])new Object[0]));
        map.put(4, ResManager.loadKDString((String)"\u4ec5\u5f53\u524d\u5408\u5e76\u8282\u70b9", (String)"InvRelationLogService_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        String msg = ResManager.loadKDString((String)"\u91cd\u7b97\u5185\u5bb9\uff1a%1$s;\u91cd\u7b97\u65b9\u5f0f\uff1a%2$s;\u91cd\u7b97\u8303\u56f4\uff1a%3$s;\u662f\u5426\u6267\u884c\u89c4\u5219\uff1a%4$s", (String)"InvRelationLogService_26", (String)"fi-bcm-business", (Object[])new Object[0]);
        this.put2LogCache(this.ctx.getBaseMergeOrgId(), "D", 4, String.format(msg, includeRelaType, map.get(calcType), map.get(calcRange), supportRuleExc ? ResManager.loadKDString((String)"\u662f", (String)"InvRelationLogService_27", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"InvRelationLogService_28", (String)"fi-bcm-business", (Object[])new Object[0])));
    }

    public void saveLogs(OperationEnum logType) {
        if (this.logs.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        this.logs.forEach((mergeId, typeMap) -> {
            if (typeMap.isEmpty()) {
                return;
            }
            StringJoiner stringJoiner = new StringJoiner("\n");
            DynamicObject dy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_invrelationlog"));
            dy.set("model", (Object)this.ctx.getModelId());
            dy.set("scenario", (Object)this.ctx.getScenarioId());
            dy.set("year", (Object)this.ctx.getFyId());
            dy.set("period", (Object)this.ctx.getPeriodId());
            dy.set("orgunit", (Object)MemberReader.findEntityMemberById((Long)this.ctx.getModelId(), (Long)mergeId).getId());
            dy.set("operation", (Object)logType.getCode());
            dy.set("creator", (Object)currUserId);
            dy.set("createtime", (Object)now);
            typeMap.forEach((relationType, map) -> {
                if (map.isEmpty()) {
                    return;
                }
                for (int i = this.changeTypeMap.size() + 1; i > 0; --i) {
                    Set strings = map.get((Object)i);
                    if (strings.isEmpty()) continue;
                    String join = String.join((CharSequence)"\n", strings);
                    stringJoiner.add(join);
                }
            });
            dy.set("opcontent", (Object)stringJoiner);
            list.add(dy);
        });
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private String getChangeTypeName(DynamicObject changeTypeDy) {
        Object name = changeTypeDy.get("name");
        if (name instanceof OrmLocaleValue) {
            return changeTypeDy.getLocaleString("name").getLocaleValue();
        }
        return changeTypeDy.getString("name");
    }

    private String getInvestedCompanyNumber(DynamicObject dy) {
        if (dy.get("investeecompany") instanceof DynamicObject) {
            return dy.getDynamicObject("investeecompany").getString("number");
        }
        return MemberReader.findEntityMemberById((Long)this.ctx.getModelId(), (Long)dy.getLong("investeecompany")).getNumber();
    }

    private String getShareholderNumber(DynamicObject dy) {
        if (dy.get("shareholder") instanceof DynamicObject) {
            return dy.getDynamicObject("shareholder").getString("number");
        }
        return MemberReader.findMemberById((long)this.ctx.getModelId(), (String)"bcm_icmembertree", (Long)dy.getLong("shareholder")).getNumber();
    }

    private String getCompanyNumber(DynamicObject dy) {
        Iterator iterator = dy.getDataEntityType().getProperties().iterator();
        while (iterator.hasNext()) {
            if (!((IDataEntityProperty)iterator.next()).getName().equals("investeecompany100")) continue;
            return dy.getString("investeecompany100.number");
        }
        return this.getInvestedCompanyNumber(dy);
    }

    private long getUnitOrgNumber(DynamicObject dy, String unitOrgKey) {
        Iterator iterator = dy.getDataEntityType().getProperties().iterator();
        while (iterator.hasNext()) {
            if (!((IDataEntityProperty)iterator.next()).getName().equals(unitOrgKey)) continue;
            Object merge = dy.get(unitOrgKey);
            if (merge instanceof Long) {
                return (Long)merge;
            }
            return ((DynamicObject)merge).getLong("id");
        }
        return this.ctx.getBaseMergeOrgId();
    }

    private String getShareNumber(DynamicObject dy) {
        for (IDataEntityProperty next : dy.getDataEntityType().getProperties()) {
            if (!next.getName().equals("shareholder100")) continue;
            return dy.getString("shareholder100.number");
        }
        return this.getShareholderNumber(dy);
    }

    private void put2LogCache(long unitOrgId, String changeTypeNumber, Integer logKey, String logMsg) {
        Map typeMap = this.logs.computeIfAbsent(unitOrgId, key -> new HashMap(16));
        HashMultimap map = typeMap.computeIfAbsent(changeTypeNumber, key -> HashMultimap.create());
        map.put((Object)logKey, (Object)logMsg);
    }

    public static enum OperationEnum {
        PAGE_SAVE(1, new MultiLangEnumBridge("\u9875\u9762\u4fdd\u5b58", "InvRelationLogService_29", "fi-bcm-business")),
        IMPORT_STATIC(2, new MultiLangEnumBridge("\u5bfc\u5165\u9759\u6001\u80a1\u6bd4", "InvRelationLogService_30", "fi-bcm-business")),
        IMPORT_DYNAMIC(3, new MultiLangEnumBridge("\u5bfc\u5165\u52a8\u6001\u80a1\u6bd4", "InvRelationLogService_31", "fi-bcm-business")),
        COPY(4, new MultiLangEnumBridge("\u671f\u95f4\u590d\u5236", "InvRelationLogService_32", "fi-bcm-business")),
        CALCULATE(5, new MultiLangEnumBridge("\u80a1\u6743\u91cd\u7b97", "InvRelationLogService_33", "fi-bcm-business")),
        DISPATCH_COPY(6, new MultiLangEnumBridge("\u667a\u80fd\u8c03\u5ea6\u671f\u95f4\u590d\u5236", "InvRelationLogService_34", "fi-bcm-business")),
        DISPATCH_CALCULATE(7, new MultiLangEnumBridge("\u667a\u80fd\u8c03\u5ea6\u91cd\u7b97", "InvRelationLogService_35", "fi-bcm-business")),
        MS_API_COPY(8, new MultiLangEnumBridge("\u4e8c\u5f00\u63a5\u53e3\u671f\u95f4\u590d\u5236", "InvRelationLogService_36", "fi-bcm-business")),
        MS_API_CALCULATE(9, new MultiLangEnumBridge("\u4e8c\u5f00\u63a5\u53e3\u80a1\u6743\u91cd\u7b97", "InvRelationLogService_37", "fi-bcm-business")),
        MS_API_ADDRELATION(0, new MultiLangEnumBridge("\u4e8c\u5f00\u6dfb\u52a0\u80a1\u6bd4\u5173\u7cfb", "InvRelationLogService_38", "fi-bcm-business"));

        private int code;
        private MultiLangEnumBridge desc;

        private OperationEnum(int code, MultiLangEnumBridge desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }
    }
}

