/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseSetHelper;
import kd.fi.bcm.business.invest.model.InvShareCase;

public class InvShareCaseF7Com {
    private IFormView view;
    private String sign;

    public InvShareCaseF7Com(IFormView view) {
        this.view = view;
        this.sign = "sharecase";
    }

    public void registerF7Filter(long modelId) {
        BasedataEdit shareCase = (BasedataEdit)this.view.getControl(this.sign);
        QFilter modelFilter = InvShareCaseHelper.getScopeFilter(modelId);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{modelFilter});
        shareCase.setQFilters((List)filters);
    }

    public void registerModelFilter(long modelId) {
        QFilter model = InvShareCaseSetHelper.getModelFilter(modelId);
        BasedataEdit shareCase = (BasedataEdit)this.view.getControl(this.sign);
        shareCase.setQFilter(model);
    }

    public void resetDefaultShareCase(String modelSign) {
        Object value = this.view.getModel().getValue(modelSign);
        if (value == null) {
            return;
        }
        DynamicObject modelDy = (DynamicObject)value;
        InvShareCase invShareCase = InvShareCaseHelper.getDefaultCaseBy(modelDy.getLong("id"));
        this.view.getModel().beginInit();
        this.view.getModel().setValue(this.sign, (Object)invShareCase.getId());
        this.view.getModel().endInit();
        this.view.updateView(this.sign);
    }

    public void registerActionAfterModelChange(String modelSign) {
        BasedataEdit modelEdit = (BasedataEdit)this.view.getControl(modelSign);
        modelEdit.addAfterF7SelectListener(afterF7SelectEvent -> this.resetDefaultShareCase(modelSign));
    }

    public void propertyChanged(PropertyChangedArgs e, Consumer<DynamicObject> func) {
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
        if (newValue == null) {
            this.view.getModel().setValue(this.sign, changeSet[0].getOldValue());
        } else {
            func.accept((Object)newValue);
        }
    }

    public long getShareCaseId() {
        DynamicObject shareCase = (DynamicObject)this.view.getModel().getValue(this.sign);
        return shareCase == null ? 0L : shareCase.getLong("id");
    }
}

